/***************************************************************************
                          previewer.h  -  description                              
                             -------------------                                         
    begin                : Thu Jun 22 2000                                           
    copyright            : (C) 2000 by Klaas Freitag                         
    email                : freitag@suse.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PREVIEWER_H
#define PREVIEWER_H

#include <qwidget.h>
#include <qlayout.h>
#include <qimage.h>
#include <qrect.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpoint.h>

#include <kruler.h>

/**
  *@author Klaas Freitag
  */
class ImageCanvas;

class Previewer : public QWidget
{
   Q_OBJECT
public: 
   Previewer(QWidget *parent=0, const char *name=0);
   ~Previewer();
	
   ImageCanvas *getImageCanvas( void ){ return( img_canvas ); }

   bool loadPreviewImage( const QString forScanner );

   /**
    * Static function that returns the image gallery base dir.
    */
   static QString galleryRoot();
   static QString previewFile( const QString& scanner );
      
public slots:
   void newImage( QImage* );
   void slFormatChange( int id );
   void slOrientChange(int);
   void slSetDisplayUnit( KRuler::MetricStyle unit );
   void setScanSize( int w, int h, KRuler::MetricStyle unit );
   void slCustomChange( void );
   void slNewDimen(QRect r);
   void slNewScanResolutions( int, int );
   void recalcFileSize( void );

protected slots:
   void slScaleToWidth();
   void slScaleToHeight();
   
signals:
   void newRect( QRect );
   void noRect( void );
   void setScanWidth(const QString&);
   void setScanHeight(const QString&);
   void setSelectionSize( long );
   
private:
   QPoint calcPercent( int, int );
	
   QHBoxLayout *layout;
   ImageCanvas *img_canvas;
   QComboBox   *pre_format_combo;
   QMemArray<QCString> format_ids;
   QButtonGroup * bgroup;
   QRadioButton * rb1;
   QRadioButton * rb2;	
   QImage       m_previewImage;
   
   int landscape_id, portrait_id;
   double overallWidth, overallHeight;
   KRuler::MetricStyle sizeUnit;
   KRuler::MetricStyle displayUnit;
   bool isCustom;

   int  scanResX, scanResY;
   int  pix_per_byte;
   double selectionWidthMm;
   double selectionHeightMm;
   
   class PreviewerPrivate;
   PreviewerPrivate *d;
};

#endif
