#include "InputBox.moc"
#include <qlayout.h>
#include <qhbox.h>
#include <qwhatsthis.h>
#include <ui.h>

InputBox::InputBox(entries e, QWidget *parent, const char *name, bool hasCancel, WFlags f):QDialog(parent, name, true, f)
{
	QVBoxLayout *layout=new QVBoxLayout(this);
	layout->setMargin(SPACE_MARGIN);
	layout->setSpacing(SPACE_INSIDE);
	for(entries::iterator it=e.begin(); it!=e.end(); it++) {
		EditWidget *ed=new EditWidget((*it).label, (*it).dflt, (*it).isFile, this);
		QWhatsThis::add(ed, (*it).help);
		layout->addWidget(ed);
		edit.insert(edit.end(), ed);
	}
	if(hasCancel) {
		QHBox *btns=new QHBox(this);
		ok=new QPushButton(_("&OK"), btns);
		cancel=new QPushButton(_("&Cancel"), btns);
		layout->addWidget(btns);
		connect(cancel, SIGNAL(clicked()), SLOT(reject()));
	} else {
		ok=new QPushButton(_("&OK"), this);
		layout->addWidget(ok);
	}
	connect(ok, SIGNAL(clicked()), SLOT(accept()));
}
