#include "Directories.moc"
#include <qlabel.h>
#include <kapplication.h>
#include <klocale.h>
#include <qwhatsthis.h>

Directories::Directories(QWidget *parent, const char *name): QWidget(parent,name)
{
	int x=5, y=5;
	int w=640;
	ftpxs=0;
	anonRoot=new InputFileCtl(i18n("Root directory for &anonymous users:"),0,true,0,this);
	anonRoot->setGeometry(x,y,w-10,anonRoot->height());
	QWhatsThis::add(anonRoot, i18n("Anonymous users (username <i>ftp</i> or <i>anonymous</i>) will see the directory entered here as their / directory."));
	y+=anonRoot->height()+5;
	guestRoot=new InputFileCtl(i18n("Root directory for &guest users:"),0,true,i18n("S&elect"),this);
	guestRoot->setGeometry(x,y,w-10,guestRoot->height());
	QWhatsThis::add(guestRoot, i18n("Guest users (real users with restricted access) will see the directory entered here as their / directory."));
	y+=guestRoot->height()+5;
	passwd=new InputFileCtl(i18n("&Passwd file:"),0,false,i18n("Se&lect"),this);
	passwd->setGeometry(x,y,w-10,passwd->height());
	QWhatsThis::add(passwd, i18n("Use the alternate passwd file specified here for authenticating users.<br>If this is left blank, the system passwd file will be used.<br>This setting can be overridden for virtual hosts."));
	y+=passwd->height()+5;
	shadow=new InputFileCtl(i18n("&Shadow passwd file:"),0,false,i18n("Sele&ct"),this);
	shadow->setGeometry(x,y,w-10,passwd->height());
	QWhatsThis::add(shadow, i18n("Use the alternate shadow password file specified here for authenticating users.<br>If this is left blank, the system shadow file will be used.<br>This setting can be overridden for virtual hosts."));
}
Directories::~Directories()
{
}
void Directories::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	anonRoot->setText(ftpxs->getAnonRoot());
	guestRoot->setText(ftpxs->getGuestRoot());
	passwd->setText(ftpxs->getPasswd());
	shadow->setText(ftpxs->getShadow());
}
void Directories::update()
{
	ftpxs->setAnonRoot(anonRoot->text());
	ftpxs->setGuestRoot(guestRoot->text());
	ftpxs->setPasswd(passwd->text());
	ftpxs->setShadow(shadow->text());
}
