/* vi:set ts=8 sts=0 sw=8:
 * $Id: prjbar.h,v 1.8 1999/12/10 18:05:55 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PRJBAR_H__
#define __PRJBAR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <stdarg.h>
#include <gtk/gtk.h>
#include "main.h"
#ifdef WANT_PROJECT
#include "win.h"

extern void	prjbar_init(win_t *w);
extern void	prjbar_update(win_t *w);
extern void	prjbar_redraw(void *);
extern void	prjbar_toggle(GtkWidget *wgt, gpointer cbdata);

#else

#define prjbar_init(w)
#define prjbar_update(w)
#define prjbar_redraw(data)
#define prjbar_toggle(wgt, cbd)

#endif	/* WANT_PROJECT */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PRJBAR_H__ */
