/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;

public class MinimalHTMLWriter
extends AbstractWriter {
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int UNDERLINE = 4;
    private static final CSS css = new CSS();
    private int fontMask = 0;
    int startOffset = 0;
    int endOffset = 0;
    private AttributeSet fontAttributes;
    private Hashtable styleNameMapping;

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument) {
        super(writer, styledDocument);
    }

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument, int n2, int n3) {
        super(writer, styledDocument, n2, n3);
    }

    public void write() throws IOException, BadLocationException {
        this.styleNameMapping = new Hashtable();
        this.writeStartTag("<html>");
        this.writeHeader();
        this.writeBody();
        this.writeEndTag("</html>");
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof StyleConstants.ParagraphConstants) && !(object instanceof StyleConstants.CharacterConstants) && !(object instanceof StyleConstants.FontConstants) && !(object instanceof StyleConstants.ColorConstants)) continue;
            this.indent();
            this.write(object.toString());
            this.write(':');
            this.write(css.styleConstantsValueToCSSValue((StyleConstants)object, attributeSet.getAttribute(object)).toString());
            this.write(';');
            this.write('\n');
        }
    }

    protected void text(Element element) throws IOException, BadLocationException {
        String string = this.getText(element);
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            this.write(string);
        }
    }

    protected void writeStartTag(String string) throws IOException {
        this.indent();
        this.write(string);
        this.write('\n');
        this.incrIndent();
    }

    protected void writeEndTag(String string) throws IOException {
        this.decrIndent();
        this.indent();
        this.write(string);
        this.write('\n');
    }

    protected void writeHeader() throws IOException {
        this.writeStartTag("<head>");
        this.writeStartTag("<style>");
        this.writeStartTag("<!--");
        this.writeStyles();
        this.writeEndTag("-->");
        this.writeEndTag("</style>");
        this.writeEndTag("</head>");
    }

    protected void writeStyles() throws IOException {
        DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)this.getDocument();
        Enumeration enumeration = defaultStyledDocument.getStyleNames();
        while (enumeration.hasMoreElements()) {
            Style style = defaultStyledDocument.getStyle((String)enumeration.nextElement());
            if (style.getAttributeCount() == 1 && style.isDefined(StyleConstants.NameAttribute)) continue;
            this.indent();
            this.write("p." + this.addStyleName(style.getName()));
            this.write(" {\n");
            this.incrIndent();
            this.writeAttributes(style);
            this.decrIndent();
            this.indent();
            this.write("}\n");
        }
    }

    protected void writeBody() throws IOException, BadLocationException {
        ElementIterator elementIterator = this.getElementIterator();
        elementIterator.current();
        Element element = null;
        this.writeStartTag("<body>");
        boolean bl2 = false;
        while ((element = elementIterator.next()) != null) {
            if (!this.inRange(element)) continue;
            if (element instanceof AbstractDocument.BranchElement) {
                if (bl2) {
                    this.writeEndParagraph();
                    bl2 = false;
                    this.fontMask = 0;
                }
                this.writeStartParagraph(element);
                continue;
            }
            if (this.isText(element)) {
                this.writeContent(element, !bl2);
                bl2 = true;
                continue;
            }
            this.writeLeaf(element);
            bl2 = true;
        }
        if (bl2) {
            this.writeEndParagraph();
        }
        this.writeEndTag("</body>");
    }

    protected void writeEndParagraph() throws IOException {
        this.writeEndMask(this.fontMask);
        if (this.inFontTag()) {
            this.endSpanTag();
        } else {
            this.write('\n');
        }
        this.writeEndTag("</p>");
    }

    protected void writeStartParagraph(Element element) throws IOException {
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.ResolveAttribute);
        if (object instanceof StyleContext.NamedStyle) {
            this.writeStartTag("<p class=" + this.mapStyleName(((StyleContext.NamedStyle)object).getName()) + ">");
        } else {
            this.writeStartTag("<p>");
        }
    }

    protected void writeLeaf(Element element) throws IOException {
        this.indent();
        if (element.getName() == "icon") {
            this.writeImage(element);
        } else if (element.getName() == "component") {
            this.writeComponent(element);
        }
    }

    protected void writeImage(Element element) throws IOException {
    }

    protected void writeComponent(Element element) throws IOException {
    }

    protected boolean isText(Element element) {
        return element.getName() == "content";
    }

    protected void writeContent(Element element, boolean bl2) throws IOException, BadLocationException {
        AttributeSet attributeSet = element.getAttributes();
        this.writeNonHTMLAttributes(attributeSet);
        if (bl2) {
            this.indent();
        }
        this.writeHTMLTags(attributeSet);
        this.text(element);
    }

    protected void writeHTMLTags(AttributeSet attributeSet) throws IOException {
        int n2 = this.fontMask;
        this.setFontMask(attributeSet);
        int n3 = 0;
        int n4 = 0;
        if ((n2 & 1) != 0) {
            if ((this.fontMask & 1) == 0) {
                n3 |= 1;
            }
        } else if ((this.fontMask & 1) != 0) {
            n4 |= 1;
        }
        if ((n2 & 2) != 0) {
            if ((this.fontMask & 2) == 0) {
                n3 |= 2;
            }
        } else if ((this.fontMask & 2) != 0) {
            n4 |= 2;
        }
        if ((n2 & 4) != 0) {
            if ((this.fontMask & 4) == 0) {
                n3 |= 4;
            }
        } else if ((this.fontMask & 4) != 0) {
            n4 |= 4;
        }
        this.writeEndMask(n3);
        this.writeStartMask(n4);
    }

    private void setFontMask(AttributeSet attributeSet) {
        if (StyleConstants.isBold(attributeSet)) {
            this.fontMask |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            this.fontMask |= 2;
        }
        if (StyleConstants.isUnderline(attributeSet)) {
            this.fontMask |= 4;
        }
    }

    private void writeStartMask(int n2) throws IOException {
        if (n2 != 0) {
            if ((n2 & 4) != 0) {
                this.write("<u>");
            }
            if ((n2 & 2) != 0) {
                this.write("<i>");
            }
            if ((n2 & 1) != 0) {
                this.write("<b>");
            }
        }
    }

    private void writeEndMask(int n2) throws IOException {
        if (n2 != 0) {
            if ((n2 & 1) != 0) {
                this.write("</b>");
            }
            if ((n2 & 2) != 0) {
                this.write("</i>");
            }
            if ((n2 & 4) != 0) {
                this.write("</u>");
            }
        }
    }

    protected void writeNonHTMLAttributes(AttributeSet attributeSet) throws IOException {
        String string;
        Integer n2;
        String string2 = "";
        String string3 = "; ";
        if (this.inFontTag() && this.fontAttributes.isEqual(attributeSet)) {
            return;
        }
        boolean bl2 = true;
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        if (color != null) {
            string2 = string2 + "color: " + css.styleConstantsValueToCSSValue((StyleConstants)StyleConstants.Foreground, color);
            bl2 = false;
        }
        if ((n2 = (Integer)attributeSet.getAttribute(StyleConstants.FontSize)) != null) {
            if (!bl2) {
                string2 = string2 + string3;
            }
            string2 = string2 + "font-size: " + n2 + "pt";
            bl2 = false;
        }
        if ((string = (String)attributeSet.getAttribute(StyleConstants.FontFamily)) != null) {
            if (!bl2) {
                string2 = string2 + string3;
            }
            string2 = string2 + "font-family: " + string;
            bl2 = false;
        }
        if (string2.length() > 0) {
            if (this.fontMask != 0) {
                this.writeEndMask(this.fontMask);
                this.fontMask = 0;
            }
            this.startSpanTag(string2);
            this.fontAttributes = attributeSet;
        } else if (this.fontAttributes != null) {
            this.writeEndMask(this.fontMask);
            this.fontMask = 0;
            this.endSpanTag();
        }
    }

    protected boolean inFontTag() {
        return this.fontAttributes != null;
    }

    protected void endFontTag() throws IOException {
        this.write('\n');
        this.writeEndTag("</font>");
        this.fontAttributes = null;
    }

    protected void startFontTag(String string) throws IOException {
        boolean bl2 = false;
        if (this.inFontTag()) {
            this.endFontTag();
            bl2 = true;
        }
        this.writeStartTag("<font style=\"" + string + "\">");
        if (bl2) {
            this.indent();
        }
    }

    private void startSpanTag(String string) throws IOException {
        boolean bl2 = false;
        if (this.inFontTag()) {
            this.endSpanTag();
            bl2 = true;
        }
        this.writeStartTag("<span style=\"" + string + "\">");
        if (bl2) {
            this.indent();
        }
    }

    private void endSpanTag() throws IOException {
        this.write('\n');
        this.writeEndTag("</span>");
        this.fontAttributes = null;
    }

    private String addStyleName(String string) {
        if (this.styleNameMapping == null) {
            return string;
        }
        StringBuffer stringBuffer = null;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (!this.isValidCharacter(string.charAt(n2))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string);
                }
                stringBuffer.setCharAt(n2, 'a');
            }
            --n2;
        }
        String string2 = stringBuffer != null ? stringBuffer.toString() : string;
        while (this.styleNameMapping.get(string2) != null) {
            string2 = string2 + 'x';
        }
        this.styleNameMapping.put(string, string2);
        return string2;
    }

    private String mapStyleName(String string) {
        if (this.styleNameMapping == null) {
            return string;
        }
        String string2 = (String)this.styleNameMapping.get(string);
        return string2 == null ? string : string2;
    }

    private boolean isValidCharacter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }
}

