/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Accessible {
    Vector menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int n2 = this.getMenuCount();
            int n3 = 0;
            while (n3 < n2) {
                this.getMenu(n3).addNotify();
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getMenuCount();
            int n3 = 0;
            while (n3 < n2) {
                this.getMenu(n3).removeNotify();
                ++n3;
            }
            super.removeNotify();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpMenu(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == menu) {
                return;
            }
            if (this.helpMenu != null) {
                this.remove(this.helpMenu);
            }
            if (menu.parent != this) {
                this.add(menu);
            }
            this.helpMenu = menu;
            if (menu != null) {
                menu.isHelpMenu = true;
                menu.parent = this;
                MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
                if (menuBarPeer != null) {
                    if (menu.peer == null) {
                        menu.addNotify();
                    }
                    menuBarPeer.addHelpMenu(menu);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menu.parent != null) {
                menu.parent.remove(menu);
            }
            this.menus.addElement(menu);
            menu.parent = this;
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                if (menu.peer == null) {
                    menu.addNotify();
                }
                menuBarPeer.addMenu(menu);
            }
            Menu menu2 = menu;
            return menu2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Menu menu = this.getMenu(n2);
            this.menus.removeElementAt(n2);
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                menu.removeNotify();
                menu.parent = null;
                menuBarPeer.delMenu(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.menus.indexOf(menuComponent);
            if (n2 >= 0) {
                this.remove(n2);
            }
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.getMenuCountImpl();
    }

    final int getMenuCountImpl() {
        return this.menus.size();
    }

    public Menu getMenu(int n2) {
        return this.getMenuImpl(n2);
    }

    final Menu getMenuImpl(int n2) {
        return (Menu)this.menus.elementAt(n2);
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n2 = this.getMenuCount();
        int n3 = 0;
        while (n3 < n2) {
            Enumeration enumeration = this.getMenu(n3).shortcuts();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            ++n3;
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n2 = this.getMenuCount();
        int n3 = 0;
        while (n3 < n2) {
            MenuItem menuItem = this.getMenu(n3).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n3;
        }
        return null;
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        if (n2 != 401 && n2 != 402) {
            return false;
        }
        int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((keyEvent.getModifiers() & n3) == 0) {
            return false;
        }
        int n4 = this.getMenuCount();
        int n5 = 0;
        while (n5 < n4) {
            Menu menu = this.getMenu(n5);
            if (menu.handleShortcut(keyEvent)) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        int n2 = this.getMenuCount();
        int n3 = 0;
        while (n3 < n2) {
            this.getMenu(n3).deleteShortcut(menuShortcut);
            ++n3;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        objectInputStream.defaultReadObject();
        int n2 = 0;
        while (n2 < this.menus.size()) {
            Menu menu = (Menu)this.menus.elementAt(n2);
            menu.parent = this;
            ++n2;
        }
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuBar.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        protected AccessibleAWTMenuBar() {
            super(MenuBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

