/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Activation;

import com.sun.corba.se.ActivationIDL.EndPointInfo;
import com.sun.corba.se.ActivationIDL.InvalidORBid;
import com.sun.corba.se.ActivationIDL.ORBAlreadyRegistered;
import com.sun.corba.se.ActivationIDL.ORBPortInfo;
import com.sun.corba.se.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.se.ActivationIDL.Server;
import com.sun.corba.se.ActivationIDL.ServerHeldDown;
import com.sun.corba.se.internal.Activation.ServerMain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public class ServerTableEntry {
    private static final int DE_ACTIVATED = 0;
    private static final int ACTIVATING = 1;
    private static final int ACTIVATED = 2;
    private static final int RUNNING = 3;
    private static final int HELD_DOWN = 4;
    private static final long waitTime = 2000L;
    private static final int ActivationRetryMax = 5;
    private int state;
    private int serverId;
    private HashMap orbAndPortInfo;
    private Server serverObj;
    private ServerDef serverDef;
    private Process process;
    private int activateRetryCount = 0;
    private String activationCmd;
    private String orbIdFile;
    private static String javaHome = System.getProperty("java.home");
    private static String classPath = System.getProperty("java.class.path");
    private static String fileSep = System.getProperty("file.separator");
    private static String pathSep = System.getProperty("path.separator");
    private boolean debug = false;

    private String printState() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "DE_ACTIVATED";
                break;
            }
            case 1: {
                string = "ACTIVATING  ";
                break;
            }
            case 2: {
                string = "ACTIVATED   ";
                break;
            }
            case 3: {
                string = "RUNNING     ";
                break;
            }
            case 4: {
                string = "HELD_DOWN   ";
                break;
            }
        }
        return string;
    }

    public String toString() {
        return "ServerTableEntry[state=" + this.printState() + " serverId=" + this.serverId + " activateRetryCount=" + this.activateRetryCount + "]";
    }

    ServerTableEntry(int n2, ServerDef serverDef, int n3, String string, boolean bl2, boolean bl3) {
        this.serverId = n2;
        this.serverDef = serverDef;
        this.debug = bl3;
        this.orbAndPortInfo = new HashMap(255);
        this.activateRetryCount = 0;
        this.state = 1;
        this.activationCmd = javaHome + fileSep + "bin" + fileSep + "java " + serverDef.serverVmArgs + " " + "-Dioser=" + System.getProperty("ioser") + " " + "-D" + "org.omg.CORBA.ORBInitialPort" + "=" + n3 + " " + "-D" + "com.sun.CORBA.activation.DbDir" + "=" + string + " " + "-D" + "com.sun.CORBA.POA.ORBActivated" + "=true " + "-D" + "com.sun.CORBA.POA.ORBServerId" + "=" + n2 + " " + "-D" + "com.sun.CORBA.POA.ORBServerName" + "=" + serverDef.serverName + " " + (bl2 ? "-Dcom.sun.CORBA.activation.ORBServerVerify=true " : "") + "-classpath " + classPath + (serverDef.serverClassPath.equals("") ? "" : pathSep) + serverDef.serverClassPath + " com.sun.corba.se.internal.Activation.ServerMain " + serverDef.serverArgs + (bl3 ? " -debug" : "");
        if (bl3) {
            System.out.println("ServerTableEntry constructed with activation command " + this.activationCmd);
        }
    }

    public int verify() {
        try {
            if (this.debug) {
                System.out.println("Server being verified w/" + this.activationCmd);
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
            int n2 = this.process.waitFor();
            if (this.debug) {
                this.printDebug("verify", "returns " + ServerMain.printResult(n2));
            }
            return n2;
        }
        catch (Exception exception) {
            if (this.debug) {
                this.printDebug("verify", "returns unknown error because of exception " + exception);
            }
            return 4;
        }
    }

    private void printDebug(String string, String string2) {
        System.out.println("ServerTableEntry: method  =" + string);
        System.out.println("ServerTableEntry: server  =" + this.serverId);
        System.out.println("ServerTableEntry: state   =" + this.printState());
        System.out.println("ServerTableEntry: message =" + string2);
        System.out.println();
    }

    synchronized void activate() throws SystemException {
        this.state = 2;
        try {
            if (this.debug) {
                this.printDebug("activate", "activating server");
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
        }
        catch (Exception exception) {
            this.deActivate();
            if (this.debug) {
                this.printDebug("activate", "throwing premature process exit");
            }
            throw new INTERNAL(1398079892, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void register(Server server) {
        if (this.state == 2) {
            this.serverObj = server;
            if (this.debug) {
                this.printDebug("register", "process registered back");
            }
        } else {
            if (this.debug) {
                this.printDebug("register", "throwing premature process exit");
            }
            throw new INTERNAL(1398079891, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void registerPorts(String string, EndPointInfo[] endPointInfoArray) throws ORBAlreadyRegistered {
        if (this.orbAndPortInfo.containsKey(string)) {
            throw new ORBAlreadyRegistered(string);
        }
        int n2 = endPointInfoArray.length;
        EndPointInfo[] endPointInfoArray2 = new EndPointInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            endPointInfoArray2[n3] = new EndPointInfo(endPointInfoArray[n3].endpointType, endPointInfoArray[n3].port);
            if (this.debug) {
                System.out.println("registering type: " + endPointInfoArray2[n3].endpointType + "  port  " + endPointInfoArray2[n3].port);
            }
            ++n3;
        }
        this.orbAndPortInfo.put(string, endPointInfoArray2);
        if (this.state == 2) {
            this.state = 3;
            this.notifyAll();
        }
        if (this.debug) {
            this.printDebug("registerPorts", "process registered Ports");
        }
    }

    synchronized void install() {
        if (this.state != 3) {
            throw new INTERNAL(1398079894, CompletionStatus.COMPLETED_NO);
        }
        this.serverObj.install();
    }

    synchronized void uninstall() {
        if (this.state == 3) {
            this.deActivate();
            try {
                if (this.serverObj != null) {
                    this.serverObj.shutdown();
                    this.serverObj.uninstall();
                }
                if (this.process != null) {
                    this.process.destroy();
                }
            }
            catch (Exception exception) {}
        } else {
            throw new INTERNAL(1398079894, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void holdDown() {
        this.state = 4;
        if (this.debug) {
            this.printDebug("holdDown", "server held down");
        }
        this.notifyAll();
    }

    synchronized void deActivate() {
        this.state = 0;
        if (this.debug) {
            this.printDebug("deActivate", "server deactivated");
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkProcessHealth() {
        if (this.state == 3) {
            try {
                int n2 = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            ServerTableEntry serverTableEntry = this;
            synchronized (serverTableEntry) {
                this.orbAndPortInfo.clear();
                this.deActivate();
            }
        }
    }

    synchronized boolean isValid() {
        if (this.state == 1 || this.state == 4) {
            if (this.debug) {
                this.printDebug("isValid", "returns true");
            }
            return true;
        }
        try {
            int n2 = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        if (this.state == 2) {
            if (this.activateRetryCount < 5) {
                if (this.debug) {
                    this.printDebug("isValid", "reactivating server");
                }
                ++this.activateRetryCount;
                this.activate();
                return true;
            }
            if (this.debug) {
                this.printDebug("isValid", "holding server down");
            }
            this.holdDown();
            return true;
        }
        this.deActivate();
        return false;
    }

    synchronized ORBPortInfo[] lookup(String string) throws ServerHeldDown {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ORBPortInfo[] oRBPortInfoArray = null;
        if (this.state == 3) {
            oRBPortInfoArray = new ORBPortInfo[this.orbAndPortInfo.size()];
            Iterator iterator = this.orbAndPortInfo.keySet().iterator();
            try {
                int n2 = 0;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    EndPointInfo[] endPointInfoArray = (EndPointInfo[])this.orbAndPortInfo.get(string2);
                    int n3 = -1;
                    int n4 = 0;
                    while (n4 < endPointInfoArray.length) {
                        if (this.debug) {
                            System.out.println("lookup num-ports " + endPointInfoArray.length + "   " + endPointInfoArray[n4].endpointType + "   " + endPointInfoArray[n4].port);
                        }
                        if (endPointInfoArray[n4].endpointType.equals(string)) {
                            n3 = endPointInfoArray[n4].port;
                            break;
                        }
                        ++n4;
                    }
                    oRBPortInfoArray[n2] = new ORBPortInfo(string2, n3);
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return oRBPortInfoArray;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized EndPointInfo[] lookupForORB(String string) throws ServerHeldDown, InvalidORBid {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EndPointInfo[] endPointInfoArray = null;
        if (this.state == 3) {
            try {
                EndPointInfo[] endPointInfoArray2 = (EndPointInfo[])this.orbAndPortInfo.get(string);
                endPointInfoArray = new EndPointInfo[endPointInfoArray2.length];
                int n2 = 0;
                while (n2 < endPointInfoArray2.length) {
                    if (this.debug) {
                        System.out.println("lookup num-ports " + endPointInfoArray2.length + "   " + endPointInfoArray2[n2].endpointType + "   " + endPointInfoArray2[n2].port);
                    }
                    endPointInfoArray[n2] = new EndPointInfo(endPointInfoArray2[n2].endpointType, endPointInfoArray2[n2].port);
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new InvalidORBid();
            }
            return endPointInfoArray;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized String[] getORBList() {
        String[] stringArray = new String[this.orbAndPortInfo.size()];
        Iterator iterator = this.orbAndPortInfo.keySet().iterator();
        try {
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringArray[n2++] = string;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stringArray;
    }

    int getServerId() {
        return this.serverId;
    }

    boolean isActive() {
        return this.state == 3 || this.state == 2;
    }

    synchronized void destroy() {
        block9: {
            block8: {
                this.deActivate();
                try {
                    if (this.serverObj != null) {
                        this.serverObj.shutdown();
                    }
                    if (this.debug) {
                        this.printDebug("destroy", "server shutdown successfully");
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block8;
                    this.printDebug("destroy", "server shutdown threw exception" + exception);
                }
            }
            try {
                if (this.process != null) {
                    this.process.destroy();
                }
                if (this.debug) {
                    this.printDebug("destroy", "process destroyed successfully");
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block9;
                this.printDebug("destroy", "process destroy threw exception" + exception);
            }
        }
    }
}

