/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public class AlgorithmParameterGenerator {
    private AlgorithmParameterGeneratorSpi paramGenSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi paramGenSpi, Provider provider, String algorithm) {
        this.paramGenSpi = paramGenSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty("AlgorithmParameterGenerator." + algorithm);
            if (classname == null) continue;
            return AlgorithmParameterGenerator.getInstance(classname, algorithm, p[i]);
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return AlgorithmParameterGenerator.getInstance(p.getProperty("AlgorithmParameterGenerator." + algorithm), algorithm, p);
    }

    private static AlgorithmParameterGenerator getInstance(String classname, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)Class.forName(classname).newInstance(), provider, algorithm);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoSuchAlgorithmException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new NoSuchAlgorithmException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchAlgorithmException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int size) {
        this.init(size, new SecureRandom());
    }

    public final void init(int size, SecureRandom random) {
        this.paramGenSpi.engineInit(size, random);
    }

    public final void init(AlgorithmParameterSpec genParamSpec) throws InvalidAlgorithmParameterException {
        this.init(genParamSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.paramGenSpi.engineInit(genParamSpec, random);
    }

    public final AlgorithmParameters generateParameters() {
        return this.paramGenSpi.engineGenerateParameters();
    }
}

