/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.Serializable;

public class TextComponent
extends Component
implements Serializable {
    private static final long serialVersionUID = -2214773872412987419L;
    private boolean editable;
    private int selectionStart;
    private int selectionEnd;
    private String text;
    protected transient TextListener textListener;

    TextComponent(String text) {
        this.text = text;
    }

    public synchronized String getText() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.text = tcp.getText();
        }
        return this.text;
    }

    public synchronized void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setText(text);
        }
    }

    public synchronized String getSelectedText() {
        String alltext = this.getText();
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        return alltext.substring(start, end);
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.selectionStart = tcp.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.selectionEnd = tcp.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int selectionEnd) {
        this.select(this.getSelectionStart(), selectionEnd);
    }

    public synchronized void select(int selectionStart, int endSelection) {
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > this.getText().length()) {
            selectionStart = this.text.length();
        }
        if (this.selectionEnd > this.text.length()) {
            this.selectionEnd = this.text.length();
        }
        if (selectionStart > this.getSelectionEnd()) {
            selectionStart = this.selectionEnd;
        }
        this.selectionStart = selectionStart;
        this.selectionEnd = this.selectionEnd;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.select(selectionStart, this.selectionEnd);
        }
    }

    public synchronized void selectAll() {
        this.select(0, this.getText().length());
    }

    public synchronized int getCaretPosition() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            return tcp.getCaretPosition();
        }
        return 0;
    }

    public synchronized void setCaretPosition(int caretPosition) {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setCaretPosition(caretPosition);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean editable) {
        this.editable = editable;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setEditable(editable);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, listener);
        this.enableEvents(1024);
    }

    public synchronized void removeTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof TextEvent) {
            this.processTextEvent((TextEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processTextEvent(TextEvent event) {
        if (this.textListener != null) {
            this.textListener.textValueChanged(event);
        }
    }

    protected String paramString() {
        return this.getClass().getName() + "(text=" + this.getText() + ")";
    }
}

