/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color white = new Color(255, 255, 255, 255);
    public static final Color lightGray = new Color(192, 192, 192, 255);
    public static final Color gray = new Color(128, 128, 128, 255);
    public static final Color darkGray = new Color(64, 64, 64, 255);
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color red = new Color(255, 0, 0, 255);
    public static final Color pink = new Color(255, 175, 175, 255);
    public static final Color orange = new Color(255, 200, 0, 255);
    public static final Color yellow = new Color(255, 255, 0, 255);
    public static final Color green = new Color(0, 255, 0, 255);
    public static final Color magenta = new Color(255, 0, 255, 255);
    public static final Color cyan = new Color(0, 255, 255, 255);
    public static final Color blue = new Color(0, 0, 255, 255);
    private static final long serialVersionUID = 118526816881161077L;
    private static final int redmask = 0xFF0000;
    private static final int greenmask = 65280;
    private static final int bluemask = 255;
    private static final int alphamask = -16777216;
    private static final int BRIGHT_STEP = 48;
    private int value;

    private /* synthetic */ void finit$() {
        this.value = -1;
    }

    public static Color decode(String str) throws NumberFormatException {
        Integer i = Integer.decode(str);
        return new Color(i);
    }

    public static Color getColor(String prop) {
        return Color.getColor(prop, null);
    }

    public static Color getColor(String prop, int defrgb) {
        return Color.getColor(prop, new Color(defrgb));
    }

    public static Color getColor(String prop, Color defcolor) {
        String val = System.getProperty(prop);
        if (val == null) {
            return defcolor;
        }
        try {
            return Color.decode(val);
        }
        catch (NumberFormatException e) {
            return defcolor;
        }
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        throw new RuntimeException("Not implemented yet");
    }

    public static float[] RGBtoHSB(int red, int green, int blue, float[] hsbvals) {
        throw new RuntimeException("Not implemented yet");
    }

    public static Color getHSBColor(float hue, float saturation, float brightness) {
        return new Color(Color.HSBtoRGB(hue, saturation, brightness));
    }

    public Color(int red, int green, int blue) {
        this.finit$();
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        this.value = blue + (green << 8) + (red << 16);
    }

    public Color(int red, int green, int blue, int alpha) {
        this.finit$();
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        this.value = blue + (green << 8) + (red << 16) + (alpha << 24);
    }

    public Color(int value) {
        this.finit$();
        this.value = value;
    }

    public Color(int value, boolean hasalpha) {
        this.finit$();
        this.value = value;
        if (!hasalpha) {
            this.value |= 0xFF000000;
        }
    }

    public Color(float red, float green, float blue) {
        this.finit$();
        if ((double)red < 0.0 || (double)red > 1.0 || (double)green < 0.0 || (double)green > 1.0 || (double)blue < 0.0 || (double)blue > 1.0) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        int redval = (int)(255.0f * red);
        int greenval = (int)(255.0f * green);
        int blueval = (int)(255.0f * blue);
        this.value = blueval + (greenval << 8) + (redval << 16);
    }

    public int getRed() {
        int redval = (this.value & 0xFF0000) >> 16;
        return redval;
    }

    public int getGreen() {
        int greenval = (this.value & 0xFF00) >> 8;
        return greenval;
    }

    public int getBlue() {
        int blueval = this.value & 0xFF;
        return blueval;
    }

    public int getAlpha() {
        int alphaval = this.value & 0xFF000000;
        return alphaval;
    }

    public int getTransparency() {
        if (this.getAlpha() == 255) {
            return 1;
        }
        return 3;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        return new Color(Math.min(255, this.getRed() + 48), Math.min(255, this.getGreen() + 48), Math.min(255, this.getBlue() + 48), this.getAlpha());
    }

    public Color darker() {
        return new Color(Math.max(0, this.getRed() - 48), Math.max(0, this.getGreen() - 48), Math.max(0, this.getBlue() - 48), this.getAlpha());
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) {
            return false;
        }
        Color c = (Color)obj;
        return this.value == c.value;
    }

    public String toString() {
        return this.getClass().getName() + "(red=" + this.getRed() + ",green=" + this.getGreen() + ",blue=" + this.getBlue() + ")";
    }
}

