/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"

#ifdef linux
#include <sys/vfs.h>
#endif

/*
 * Global variables
 */

#define	DEV_TYPE_MSDOS	1
#define	DEV_TYPE_EXT	2
#define	DEV_TYPE_EXT2	4
#define	DEV_TYPE_MINIX	8
#define	DEV_TYPE_ISO	16
#define	DEV_TYPE_XIAFS	32

#define	DEV_FLAG_RO		1

typedef struct {
	char	*name;
	char	*dev_file;
	char	*mnt_file;
	u_int	types;
	u_int	flags;
	u_int	mounted;
	u_long	free;
	u_long	total;
	Pixmap	pmap;
	char	*pmap_file;
} Dev_Glyph;

static	unsigned char	dev_list_count;		/* Anzahl der mountbaren devices */
static	Dev_Glyph	**dev_list;	/* feld mit den mountbaren devices */

Widget	CreateDeviceBox (Widget bar, Widget ref);
void	ReadDeviceFile (void);
void	LoadDeviceIcons (Widget toplevel);

static	char	*fs_names[] = {"MS-Dos Fs","Extended Fs",
				"Extended2 Filesystem","Minix Fs",
				"ISO9660 Fs","Xia Fs","Unknown"};
static	char	*fs_mtab[] = {"msdos","ext","ext2","minix","iso9660","xia"};


/*********************************************************
 * name:	CreateDeviceBox
 * description:	Erzeugt eine Box mit allen gemounteten und
 *		mountbaren Devices -> Configurationsfile
 * input:	Widget bar	- Widget auf dem das Box-Widget
 *				  erzeugt wird.
 * output:	none
 * author:	Ove Kalkan
 * date:	7.8.1993
 *********************************************************/
Widget	CreateDeviceBox(Widget bar, Widget ref)
{
	Widget	box = NULL;
	int	i;
	Widget	but;
	FILE	*fp;

	dev_list_count = 0;
	dev_list = NULL;


	ReadDeviceFile();

	if (!dev_list_count)
		return;

	/*
	 * Feststellen ob Device schon gemountet ist
	 */
#ifdef linux
	/*
	 * Gemountete devices stehen in /etc/mtab
	 */
	if ((fp = fopen("/etc/mtab","r"))) {
		char	s[100];

		while (fgets(s,99,fp)) {
			char	*ss;

			ss = strchr(s,' ');
			*ss = '\0';	/* Das erste Wort ist das Device_file */
			for (i = 0; i < dev_list_count; i++)
				if (!strcmp(dev_list[i]->dev_file,s)) {
					int	j = 0;
					struct statfs	buf;
					char	tmp[100];

					dev_list[i]->mounted = 6;
					ss++;
					sscanf(ss,"%s",&tmp);
					if (statfs(tmp,&buf) == 0) {
						dev_list[i]->total = buf.f_blocks*buf.f_bsize/1024;
						dev_list[i]->free = buf.f_bavail*buf.f_bsize/1024;
					}
					ss = strchr(ss,' ');
					ss + 1;
					sscanf(ss,"%s",&s);
					while (j < 6) {
						if (!strcmp(fs_mtab[j],s))
							dev_list[i]->mounted = j + 1;
						j++;
					}
				}
		}
		fclose(fp);
	}
#endif

	box = XtVaCreateManagedWidget("device_area",simpleWidgetClass,bar,
					XtNwidth, (defaults.multi_window ? 400 : 300),
					XtNheight, DIR_Y_STEP*dev_list_count,
					XtNborderWidth,0,
					XtNfromVert,ref,
					XtNleft,XawChainLeft,
					XtNright,XawChainRight,
					XtNtop,XawChainBottom,
					XtNbottom,XawChainBottom,
					NULL);
	XtOverrideTranslations(box,XtParseTranslationTable(
					"<Expose>:	refresh-devices()"));
	return(box);
}


/*********************************************************
 * name:	ReadDeviceFile
 * description:	Einlesen des Files in dem die mountbaren
 *		devices fuer die Deviceliste stehen
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	7.8.1993
 *********************************************************/
void	ReadDeviceFile(void)
{
	FILE	*fp;
	char	s[1024];

	/* Versuchen, das File zu oeffnen */
	if (!(fp = fopen(DEVICE_LIST,"r")))
		return;

	/* File einlesen */
	s[1023] = '\0';
	while (fgets(s,1023,fp)) {
		char	*sss,*ss;
		char	*dev_file,*mnt_file,*name,*pmap_file;
		int	type,flag;

		ss = s;
		/*
		 * Devicefile lesen
		 */
		mnt_file = NULL;
		dev_file = NULL;
		pmap_file = NULL;
		name = NULL;
		if ((sss = strchr(ss,':')) != NULL) {
			*sss = '\0';
			if (!(dev_file = (char *) malloc(strlen(ss) + 1)))
				FATAL_ERROR("ReadDeviceFile: malloc failed");
			sprintf(dev_file,"%s\0",ss);
			ss = sss + 1;	/* Zeiger weiterschieben */

			/*
			 * Mount-file holen
			 */
			if (strlen(dev_file) && (sss = strchr(ss,':')) != NULL) {
				*sss = '\0';
				if (!(mnt_file = (char *) malloc(strlen(ss) + 1)))
					FATAL_ERROR("ReadDeviceFile: malloc failed");
				sprintf(mnt_file,"%s\0",ss);
				ss = sss + 1;	/* Zeiger weiterschieben */

				/*
				 * Type und Flag lesen
				 */
				sscanf(ss,"%d %d",&type,&flag);
				ss = strchr(ss,':') + 1;

				/*
				 * pmap-file holen
				 */
				if (strlen(mnt_file) && (sss = strchr(ss,':')) != NULL) {
					*sss = '\0';
					if (strlen(ss)) {
						if (!(pmap_file = (char *) malloc(strlen(ss) + 1)))
							FATAL_ERROR("ReadDeviceFile: malloc failed");
						sprintf(pmap_file,"%s\0",ss);
					}
					ss = sss + 1;	/* Zeiger weiterschieben */

					/*
					 * Label holen
					 */
					if (!strlen(ss))
						name = dev_file;
					else {
						if (!(name = (char *) malloc(strlen(ss) + 2)))
							FATAL_ERROR("ReadDeviceFile: malloc failed");
						sprintf(name,"%s\0",ss);
						name[strlen(name)-1] = '\0';	/* Newline loeschen */
					}

					/*
					 * Deviceliste erweitern
					 */
					if (!dev_list)
						if (!(dev_list = (Dev_Glyph **) malloc(sizeof(Dev_Glyph *))))
							FATAL_ERROR("ReadDeviceFile: malloc failed");
					else
						if (!(dev_list = (Dev_Glyph **) realloc((void *) dev_list,
											sizeof(Dev_Glyph *) * (dev_list_count + 1))))
							FATAL_ERROR("ReadDeviceFile: malloc failed");
					if (!(dev_list[dev_list_count] = (Dev_Glyph *) malloc(sizeof(Dev_Glyph))))
						FATAL_ERROR("ReadDeviceFile: amlloc failed.");
					dev_list[dev_list_count]->dev_file = dev_file;
					dev_list[dev_list_count]->mnt_file = mnt_file;
					dev_list[dev_list_count]->pmap_file = pmap_file;
					dev_list[dev_list_count]->name = name;
					dev_list[dev_list_count]->types = type;
					dev_list[dev_list_count]->flags = flag;
					dev_list[dev_list_count]->mounted = 0;
					dev_list[dev_list_count]->free = 0;
					dev_list[dev_list_count]->total = 0;
					dev_list[dev_list_count]->pmap = (Pixmap) NULL;
					dev_list_count++;
				}
				else {
					if (mnt_file)	free(mnt_file);
					if (dev_file)	free(dev_file);
				}
			}
			else
				if (dev_file)	free(dev_file);
				
		}
	}

	/* File wieder schliessen */
	fclose(fp);
}

/*********************************************************
 * name:	LoadDeviceIcons
 * description:	laedt alle Icons fuer die Devices
 * input:	Widget toplevel
 * output:	none
 * author:	Ove Kalkan
 * date:	7.8.1993
 *********************************************************/
void	LoadDeviceIcons (Widget toplevel)
{
	int	i;

	for (i = 0; i < dev_list_count; i++)
		if (dev_list[i]->pmap_file) {
			int	w,h;

			dev_list[i]->pmap = ReadPixmapFromFile(dev_list[i]->pmap_file,&w,&h);
		}
}


/*********************************************************
 * name:	RefreshDevices
 * description:	Grafiche Erneuerung des Device-liste
 * input:	Das Uebliche fuer ActionProcs
 * output:	none
 * author:	Ove Kalkan
 * date:	7.8.1993
 *********************************************************/
XtActionProc	RefreshDevices (Widget w, XExposeEvent *e, String *s, Cardinal *c)
{
	int	i;

	for (i = 0; i < dev_list_count; i++) {
		if (!dev_list[i]->mounted) {
			char	s[200];

			sprintf(s,"%s (unmounted)",
					dev_list[i]->name);
			XDrawString(XtDisplay(w),XtWindow(w),line_gc,DIR_X_STEP + 20,
					i*DIR_Y_STEP + 14,s,strlen(s));
		}
		else {
			char	s[200];

			sprintf(s,"%s (%s  F/T: %d/%d)",
					dev_list[i]->name,fs_names[dev_list[i]->mounted - 1],
					dev_list[i]->free,dev_list[i]->total);
			XDrawString(XtDisplay(w),XtWindow(w),line_gc,DIR_X_STEP + 20,
					i*DIR_Y_STEP + 14,s,strlen(s));
		}
		if (dev_list[i]->pmap)
			XCopyArea(XtDisplay(w),dev_list[i]->pmap,XtWindow(w),line_gc,
				  0,0,16,16,DIR_X_STEP,i*DIR_Y_STEP+2);
	}
}
