#line 2 "mswin.h"
/*
 *
 * Program:	Operating system dependent routines - Microsoft Windows 3.1
 *
 *
 * Thomas Unger
 * Networks and Distributed Computing
 * Computing and Communications
 * University of Washington
 * Administration Builiding, AG-44
 * Seattle, Washington, 98195, USA
 * Internet: tunger@cac.washington.edu
 *
 * Please address all bugs and comments to "pine-bugs@cac.washington.edu"
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 */


#ifndef MSWIN_H
#define MSWIN_H


/*
 * Def's to help Win32 port...
 */
#ifdef	WIN32
#define	__far
#define	_far
#define	__export
#define	signal	mswin_signal
#endif


/*
 * Equivalent to a windows handle.
 */
#ifdef	WIN32
typedef void	       *WINHAND;
#else
typedef unsigned int	WINHAND;
#endif

/*
 * Mouse input events. 
 */
typedef struct {
	int		event;
	int		button;
	int		nRow;
	int		nColumn;
	int		keys;
	int		flags;
} MEvent;


/*
 * These define how mouse events get queued.
 */
#define MSWIN_MF_REPLACING	0x1000
#define MSWIN_MF_REPEATING	0x2000


typedef struct {
	int		ch;
	int		rval;
	char		*name;
	char		*label;
	int		id;
} MDlgButton;



/*
 * Type of function expected by mswin_allowcopy and mswin_allowcopycut
 * and used in EditDoCopyData
 */
typedef	int (*getc_t)(int pos);

/*
 * Type used by line up/down event handlers to move the body of the
 * displayed text.
 */
typedef int (*scroll_t)(int action, long count);

/*
 * Callback used to fetch text for display in alternate window.  Text
 * can be returned as either a pointer to a null terminated block of
 * text (a string), with CRLF deliminating lines.  OR as a pointer to
 * an array of pointers to lines, each line being a null terminated
 * string. 
 */
typedef int (*gettext_t)(char *title, void **text, long *len, int *format);


/*
 * Callback used for periodic callback.
 */
typedef void (*callback_t)(void);

#define GETTEXT_TITLELEN	128
#define GETTEXT_TEXT		1	/* 'text' is pointer to text. */
#define GETTEXT_LINES		2	/* 'text' is pointer to array of
					 *   pointers to lines. */


#define PATH_MAX		128	/* Max size of a directory path. */


#define MSWIN_RANGE_START	0x7001
#define MSWIN_KEY_UP		0x7001
#define MSWIN_KEY_DOWN		0x7002
#define MSWIN_KEY_RIGHT		0x7003
#define MSWIN_KEY_LEFT		0x7004
#define MSWIN_KEY_PREVPAGE	0x7005
#define MSWIN_KEY_NEXTPAGE	0x7006
#define MSWIN_KEY_HOME		0x7007
#define MSWIN_KEY_END		0x7008
#define MSWIN_KEY_DELETE	0x7009
#define MSWIN_KEY_F1		0x700a
#define MSWIN_KEY_F2		0x700b
#define MSWIN_KEY_F3		0x700c
#define MSWIN_KEY_F4		0x700d
#define MSWIN_KEY_F5		0x700e
#define MSWIN_KEY_F6		0x700f
#define MSWIN_KEY_F7		0x7010
#define MSWIN_KEY_F8		0x7011
#define MSWIN_KEY_F9		0x7012
#define MSWIN_KEY_F10		0x7013
#define MSWIN_KEY_F11		0x7014
#define MSWIN_KEY_F12		0x7015
#define MSWIN_KEY_NODATA	0x7016
#define MSWIN_KEY_SCROLLUPLINE		0x7017
#define MSWIN_KEY_SCROLLDOWNLINE	0x7018
#define MSWIN_KEY_SCROLLUPPAGE		0x7019
#define MSWIN_KEY_SCROLLDOWNPAGE	0x701a
#define MSWIN_KEY_SCROLLTO		0x701b

#define MSWIN_RANGE_END		0x701b

#define	MSWIN_PASTE_DISABLE	0
#define	MSWIN_PASTE_FULL	1
#define	MSWIN_PASTE_LINE	2


#define MSWIN_CURSOR_ARROW	0
#define MSWIN_CURSOR_BUSY	1

/*
 * Flags for mswin_displaytext
 */
#define MSWIN_DT_NODELETE	0x0001	/* Don't delete text when 
					 * window closes. */



/*
 * functions from mswin.c
 */

#define assert(x)	if (!(x)) AssertFail (#x, __FILE__, __LINE__, 1);
void			AssertFail	(char *str, char *file, int line, int msgbox);


WINHAND		mswin_gethinstance();
WINHAND		mswin_gethwnd ();
int		mswin_getmouseevent (MEvent * pMouse);
int		mswin_setdebug (int debug, FILE *debugfile);
int		mswin_setdndcallback (int (*cb)());
int		mswin_cleardndcallback (void);
int		mswin_setresizecallback (int (*cb)());
int		mswin_clearresizecallback (int (*cb)());
int		mswin_sethelptext (char *title, char *pHelpText, 
			size_t len, char **pHelpLines);
int		mswin_setclosetext (char *pCloseText);
int		mswin_setwindow (char *fontName, char *fontSize, 
			char *fontStyle, char *windowPosition);
int		mswin_getwindow (char *fontName, char *fontSize, 
			char *fontStyle, char *windowPosition);
void		mswin_setscrollrange (long max);
void		mswin_setscrollpos (long pos);
long		mswin_getscrollpos (void);
long		mswin_getscrollto (void);
void		mswin_setscrolcallback (scroll_t);
int		mswin_setprintfont (char *fontName, char *fontSize, 
			char *fontStyle);
int		mswin_getprintfont (char *fontName, char *fontSize, 
			char *fontStyle);
int		mswin_yeild (void);
int		mswin_charavail (void);
int		mswin_getc (void);
int		mswin_getc_fast (void);
int		mswin_open (void);
int		mswin_close (void);
int		mswin_showcursor (int show);
int		mswin_move (int row, int column);
int		mswin_getpos (int *row, int *column);
int		mswin_getscreensize (int *row, int *column);
int		mswin_putblock (char *str, int strLen);
int		mswin_puts (char *str);
int		mswin_putc (int c);
int		mswin_outc (char c);
int		mswin_delchar (void);
int		mswin_inschar (int c);
int		mswin_rev (int state);
int		mswin_getrevstate (void);
int		mswin_eeol (void);
int		mswin_eeop (void);
int		mswin_beep (void);
int		mswin_pause (int);
int		mswin_flush (void);
void		mswin_setcursor (int);
int		mswin_messagebox (char *msg, int);
int		mswin_allowpaste (int);
int		mswin_allowcopycut (getc_t);
int		mswin_allowcopy (getc_t);
int		mswin_newmailicon (void);
void		mswin_newmailtext (char *t);
void		mswin_newmaildone (void);
void		mswin_menuitemclear (void);
void		mswin_menuitemadd (int key, char *label, int menuitem, 
			int flags);
int		mswin_setwindowmenu (int menu);
int		mswin_print_ready (WINHAND hWnd, char *docDesc);
int		mswin_print_done (void);
char *		mswin_print_error (int errorcode);
int		mswin_print_char (int c);
int		mswin_print_text (char *text);
int		mswin_savefile (char *dir, char *fName, int nMaxFName);
int		mswin_openfile (char *dir, char *fName, int nMaxFName);
void		mswin_killbuftoclip (getc_t copyfunc);
int		pico_nfcolor(char *);
int		pico_nbcolor(char *);
int		pico_rfcolor(char *);
int		pico_rbcolor(char *);
int		mswin_fflush (FILE *f);
void		mswin_setperiodiccallback (callback_t periodiccb, 
					long period);
WINHAND		mswin_inst2task (WINHAND hInst);
int		mswin_ontask_del (WINHAND hTask, char *path);
int		mswin_exec_and_wait (char *whatsit, char *command);
void		mswin_exec_err_msg (char *what, int status, char *buf, 
			int buflen);
int		mswin_onexit_del (char *path);
int		mswin_set_quit_confirm (int);
void		mswin_showhelpmsg (WINHAND hWnd, char **helplines);
int		mswin_displaytext (char *title, char *pText, size_t textLen, 
			char **pLines, int windRef, int flags);

int		mswin_majorver();
int		mswin_minorver();
char	       *mswin_compilation_date();


int		mswin_usedialog (void);
int		mswin_dialog (char *prompt, char *string, int field_len, 
			int append_current, int passwd, 
			MDlgButton *button_list, char **help, unsigned flags);
int		mswin_select (char *prompt, MDlgButton *button_list, 
			int dflt, int on_ctrl_C, char **help, unsigned flags);
int		mswin_yesno (char *prompt);


#ifdef	MSC_MALLOC
/*
 * These definitions will disable the SEGHEAP allocation routines, in
 * favor of the compliler libraries usual allocators.  This is useful
 * when external debugging tools and the SEGHEAP debugging routines step
 * on each other...
 */
#define MemAlloc(X) malloc(X)
#define MemFree(X) free(X)
#define MemRealloc(X,Y) realloc(X,Y)
#define MemFreeAll()
#define	MemDebug(X,Y)
#else
/*
 * Memory management stuff, from msmem.c
 */
typedef unsigned long		MemSize;
typedef void __far	      *	MemPtr;

#define MemAlloc(s)		_MemAlloc (s, __FILE__, __LINE__)
#define malloc(s)		_MemAlloc (s, __FILE__, __LINE__)
#define MemFree(b)		_MemFree (b, __FILE__, __LINE__)
#define free(b)			_MemFree (b, __FILE__, __LINE__)
#define MemRealloc(b,s)		_MemRealloc (b, s, __FILE__, __LINE__)
#define realloc(b,s)		_MemRealloc (b, s, __FILE__, __LINE__)
#define MEM_BLOCK_SIZE_MAX	0xff00

void		MemDebug (int debug, FILE *debugFile);
void __far *	_MemAlloc (MemSize size, char __far * file, int line);
int		_MemFree (void __far *block, char __far *file, int line);
void __far *	_MemRealloc (void __far *block, MemSize size, 
					char __far * file, int line);
MemSize		MemBlkSize (MemPtr block);
void		MemFreeAll (void);
void            MemFailSoon (MemSize);
#endif



/*
 * Signals that are not defined by MS C
 */
#define SIGHUP	    1	/* Terminal hangup. */
#define SIGINT      2   /* Ctrl-C sequence */
#define SIGILL      4   /* illegal instruction - invalid function image */
#define SIGSEGV     11  /* segment violation */
#define SIGALRM     14  /* alarm clock */
#define SIGTERM     15  /* Software termination signal from kill */
#define SIGABRT     22  /* abnormal termination triggered by abort call */
#define SIGWINCH    28	/* Change in window size. */


#define fflush	mswin_fflush

#endif /* MSWIN_H */
