/* list.c: PnP config tool device list handler module */
/*
 * $Header: /root/pnp/tools/RCS/list.c,v 1.1 1996/06/24 23:31:22 root Exp $
 *
 * $Log: list.c,v $
 * Revision 1.1  1996/06/24  23:31:22  root
 * Initial revision
 *
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#include <signal.h>
#include "tools.h"

int index_current = 0;
static int index_top = 0, scroll_top = 0;

/*****************************************************************************/
/* draw the list of pnp devices */
void draw_device_list()
{
    int tmp, loop, stop, top, mtop, scrx;

    /* display the scroll bar with arrows at each end */
    scrx = getmaxx(listwin) - 1;
    tmp = getmaxy(listwin) - 2;
    wattrset(listwin,COLOR_PAIR(4));
    for (loop=2; loop<tmp; loop++)
	mvwaddch(listwin,loop,scrx,ACS_CKBOARD);
    wattrset(listwin,COLOR_PAIR(2));
    mvwaddch(listwin,1,scrx,ACS_UARROW);
    mvwaddch(listwin,LINES-4,scrx,ACS_DARROW);

    if (index_count<=0) {
	wrefresh(listwin);
	return;
    }

    /*=======================================================================*/
    /* work out how many we can display */
    tmp = getmaxy(listwin) - 2;
    stop = tmp>index_count-index_top ? index_count-index_top : tmp;
    stop += index_top;

    /* display them */
    wattrset(listwin,COLOR_PAIR(2));
    top = 1;
    for (loop=index_top; loop<stop; loop++) {
	/* highlight the current one */
	if (loop==index_current)
	    wattrset(listwin,COLOR_PAIR(3));
	if (loop==index_current+1)
	    wattrset(listwin,COLOR_PAIR(2));
	mvwprintw(listwin,top++,1,index_list[loop]->pi_ident);
    }

    /*=======================================================================*/
    /* work out how many can hold top position */
    mtop = index_count - (getmaxy(listwin)-2);
    if (mtop<=0)
	mtop = 1;

    /* work out the scroll slider size */
    tmp = getmaxy(listwin) - 4;
    stop = index_count>tmp+2 ? tmp+2 : index_count;
    stop = tmp*stop/index_count;
    if (stop==0) stop++;

    /* work out scroll slider origin */
    tmp = tmp - stop;			/* range of origins */
    top = tmp*(index_top)/mtop + 2;
    scroll_top = top;

    stop += top;

    wattrset(listwin,COLOR_PAIR(2));
    for (loop=top; loop<stop; loop++)
	mvwaddch(listwin,loop,scrx,ACS_BLOCK);

    wrefresh(listwin);
} /* end draw_device_list() */

/*****************************************************************************/
/* move the list down one (return true if was possible) */
int down_device_list()
{
    int top;

    /* can't fall off bottom */
    if (index_current+1>=index_count)
	return 0;

    index_current++;

    /* unhighlight the old current one */
    wattrset(listwin,COLOR_PAIR(2));
    mvwprintw(listwin,
	      index_current-index_top,1,
	      index_list[index_current-1]->pi_ident);

    top = index_count - (getmaxy(listwin) - 2);
    if (top<0) top = 0;

    /* jump-scroll the list down if need be */
    if (index_current >= index_top+getmaxy(listwin)-2) {

	index_top += (getmaxy(listwin)-2) / 2;
	if (index_top>top)
	    index_top = top;
	draw_device_list();
	
	return 1;
    }

    /* highlight the new current one */
    wattrset(listwin,COLOR_PAIR(3));
    mvwprintw(listwin,
	      index_current-index_top+1,1,
	      index_list[index_current]->pi_ident);
    wrefresh(listwin);

    return 1;

} /* end down_device_list() */

/*****************************************************************************/
/* move the list up one (return true if was possible) */
int up_device_list()
{
    /* can't fall off top */
    if (index_current<=0)
	return 0;

    /* unhighlight the old current one */
    wattrset(listwin,COLOR_PAIR(2));
    mvwprintw(listwin,
	      index_current-index_top+1,1,
	      index_list[index_current]->pi_ident);

    index_current--;

    /* jump-scroll the list up if need be */
    if (index_current < index_top) {
	index_top -= (getmaxy(listwin)-2) / 2;
	if (index_top<0)
	    index_top = 0;
	draw_device_list();
	return 1;
    }

    /* highlight the new current one */
    wattrset(listwin,COLOR_PAIR(3));
    mvwprintw(listwin,
	      index_current-index_top+1,1,
	      index_list[index_current]->pi_ident);
    wrefresh(listwin);

    return 1;

} /* end up_device_list() */
