#if !defined(XGRABSC_H)
#define XGRABSC_H
/*========================================================================
 *
 * Name - xgrabsc.h
 *
 * ccs version:	1.1
 *
 * ccsid:	@(#)xgrabsc.h	1.1 - 08/16/95 08:46:55
 * from: 	ccs/s.xgrabsc.h
 * date: 	11/07/95 11:31:41
 *
 * Copyright (c) 1990-95 Bruce Schuchardt.
 * Read the file cpyright.h for full copyright information.
 *
 * xgrabsc.h - include file for xgrabsc
 *
 *========================================================================
 */

#if defined(XGRABSC_C)
#define EXT
#define SZ(x) x
#define INIT(x) = x
#else
#define EXT extern
#define SZ(x)
#define INIT(x)
#endif


#if defined(__hpux) || defined(nec_ews) || defined(sgi)
/* the folks at HP have decided to make things more difficult
 */
#define XLIB_ILLEGAL_ACCESS
#endif


#include "cpyright.h"
#include "patchlevel.h"
#include "config.h"
#include "checkvm.h"
#include "cmdopts.h"

#include <stdio.h>

#include <X11/Xos.h>
#include <X11/Xlib.h>

#if defined(__osf__)  /* Alpha OSF/1 v1.2  X11R5 */
/* Scott McCoy     30 Sept 1993
 * Xlibint.h is needed for X11R5 to get at internals of the Display
 * structure.
 */
#include <X11/Xlibint.h>
#endif

#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>

#ifdef VMS
#include "XWDFile.h"
#else
#include <X11/XWDFile.h>
#endif /* VMS */

#ifndef CARD32
#include <X11/Xmd.h>
#endif


#ifndef NO_VIRTUAL_WINDOW
#include "virtual.h"
#endif


#define MAX_CELLS  256
#define TRUE  1
#define FALSE 0


typedef enum {
  NO_DITHER=0,
  FS_DITHER,
  MATRIX_DITHER,
  MATRIX_HALFTONE,
  MAP_BW
} ditherType;


typedef unsigned char byte;
typedef unsigned long dw;
typedef unsigned int  word;



typedef struct {
  XImage   *ximage;
  Visual   *visual;
  int       depth;
  Colormap  colormap;
  word      numcells;
  word      red[MAX_CELLS],
            green[MAX_CELLS],
	    blue[MAX_CELLS];
  byte      used[MAX_CELLS];
} imageInfo;


typedef enum {
  sourceRect,
  sourceRoot,
  sourceId,
  sourceWd,
  sourceKey,
  sourceCoords
} sourceType;

typedef enum {
  puzzleFormat,
  psFormat,
  simpleFormat,
  xwdFormat,
  pixmapFormat,
  ppmFormat
} formatType;




#if defined(MEMCPY)
char *memcpy();
char *memset();
#endif


#if defined(VMS) || defined(nec_ews)
#define rindex strrchr
#endif

EXT Display *hDisplay;
EXT int      hScreen;
EXT Window   hRoot, vRoot;
EXT int      displayCells;
EXT char    *programName;
EXT char    imageName[SZ(64)];

EXT char    *version    INIT(XGRABSC_FULL_VERSION_INFO);
EXT int      patchLevel INIT(XGRABSC_PATCHLEVEL);
EXT int      verbose;

EXT word nr[SZ(MAX_CELLS)], ng[SZ(MAX_CELLS)], nb[SZ(MAX_CELLS)];

EXT char   hexdigits[] INIT("0123456789abcdef");

EXT double pageWidth   INIT(PAPER_WIDTH);
EXT double pageHeight  INIT(PAPER_HEIGHT);
EXT double horizMargin INIT(HORIZ_MARGIN);
EXT double vertMargin  INIT(VERT_MARGIN);
EXT double horizInset  INIT(PAPER_WIDTH - HORIZ_MARGIN - HORIZ_MARGIN);
EXT double vertInset   INIT(PAPER_HEIGHT - VERT_MARGIN - VERT_MARGIN);

EXT char        *outfileName;

ditherType  DitherKind;
int         Halftone;
int         ForceBitmap;

EXT int needColorImageProc;

#undef EXT
#undef SZ
#undef INIT
#endif
