#line 5 "../../../texk/detex/detex-src/detex.l"
/*
 * Copyright (c) 1986-2007 Purdue University
 * All rights reserved.
 * 
 * Developed by:  Daniel Trinkle
 *                Department of Computer Science, Purdue University
 *                http://www.cs.purdue.edu/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * o Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimers.
 * 
 * o Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimers in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * o Neither the names of Daniel Trinkle, Purdue University, nor the
 *   names of its contributors may be used to endorse or promote products
 *   derived from this Software without specific prior written
 *   permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
 */


/*
 * detex [-e environment-list] [-c] [-l] [-n] [-s] [-t] [-w] [-1] [file[.tex] ]
 *
 *	This program is used to remove TeX or LaTeX constructs from a text
 *	file.
 */

#include "detex.h"

#ifdef KPATHSEA

#include <c-auto.h>
#include <kpathsea/c-auto.h>
#include <kpathsea/config.h>
#include <kpathsea/c-memstr.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/c-std.h>
#include <kpathsea/tex-file.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#else /* KPATHSEA */

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#define	strrchr rindex
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#include <sys/param.h>
#ifndef PATH_MAX /* for old BSD */
#define PATH_MAX MAXPATHLEN
#endif
#endif /* HAVE_LIMITS_H */

#ifdef OS2
#include <stdlib.h>
#endif

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#endif

#endif /* KPATHSEA */



#line 95 "../../../texk/detex/detex-src/detex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 174
#define YY_END_OF_BUFFER 175
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[1362] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  145,  145,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  167,  167,    0,    0,    0,    0,    0,    0,
      140,  140,    0,    0,  175,  174,   92,   91,   90,  107,
      105,  107,  106,  107,  107,  119,  122,  121,  120,  128,
      130,  129,  113,  110,  109,  112,  113,  113,  159,  159,
      160,  159,  159,  108,    1,  159,  159,  159,  158,  159,
      147,  152,  155,  147,  156,  149,  146,  145,  143,  142,
      146,  146,  144,   12,   12,  174,   11,   12,  102,  100,

      101,  102,  102,   18,   16,   17,   15,   14,   15,   97,
       95,   96,   97,   97,  115,  117,  116,  124,  126,  125,
      165,  162,  163,  164,  167,  166,  171,  168,  169,  170,
      173,  172,    6,    6,    7,  140,   44,   43,   46,  104,
        0,    0,    0,    0,    0,    0,    0,  119,  121,  128,
      129,  111,    0,    0,    0,    0,    0,    0,    0,  161,
        0,  148,  103,    1,  153,  154,  150,  158,    0,  157,
      139,  137,  132,   93,  136,  136,  136,  136,   98,  138,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  151,    0,

        0,    0,  145,  144,  142,  142,    0,  141,    0,    0,
       11,    0,    0,    0,    0,    0,   99,    0,    0,    0,
        0,    0,    0,    0,   16,   14,    0,   94,    0,    0,
        0,    0,    0,    0,    0,  115,  116,  124,  125,  164,
      167,    6,    0,   44,    0,   45,    0,  106,    0,    0,
        0,    0,    0,    0,    0,  112,    0,    0,    0,    0,
        0,    0,    0,  150,  157,  136,  136,  134,  134,  138,
        0,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,

      136,  136,  136,  136,  136,  136,    0,    0,    0,    0,
        0,    0,    0,    0,  101,    0,    0,    0,    0,    0,
        0,    0,    0,   96,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      133,  133,    0,  138,  136,  136,  136,  136,  136,  136,
       89,  136,   71,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,   78,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   13,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  136,  136,  136,  136,  136,  136,
      136,  136,  136,   67,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,   57,  136,
      136,  136,  136,  136,  136,   33,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
       85,  136,  136,   25,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   67,  136,  136,  136,

      136,    3,  136,  136,  136,  136,   48,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,   73,  127,    0,
        0,    0,    0,    0,   74,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,   57,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  131,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  106,    0,  112,    0,  136,  136,
      136,  136,  136,    0,    0,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,    0,    0,    0,    0,

        0,  136,  136,  136,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   19,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,   37,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,   35,  136,
        0,    0,    0,    0,    0,  136,    0,    0,    0,    0,
        0,  101,    0,   96,    0,    0,    0,    0,  136,  136,
      136,  136,  136,    0,    0,   64,  136,  136,   58,  136,
      136,  136,  136,  136,  136,  136,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   22,    0,    0,

        0,  136,  114,    0,   19,   19,  136,   75,  136,  136,
      136,  136,  136,  136,   76,  136,  136,  136,  136,  136,
      136,  136,   34,  136,   59,  136,  136,  136,  136,  136,
      136,  123,  136,  136,  136,  136,  136,  136,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   20,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  136,  136,  136,  136,  136,    0,  136,   66,
       58,   50,  136,  136,  136,   53,   83,  136,    0,   22,
       22,   22,   22,    0,    0,    0,    0,    0,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,  136,

       36,  136,  136,  136,  136,   38,   59,  136,  136,  136,
      136,  136,  136,  136,  136,  136,  136,  136,  136,    0,
       20,   20,   20,   20,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  136,  136,  136,  136,  136,
        0,  136,  136,  136,  136,   51,    0,   84,    0,    0,
       22,   22,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  136,  136,  136,  135,  136,  136,
      136,   26,  136,   52,   77,   62,  136,  136,   39,   41,
      136,   27,  136,  136,  136,  136,  136,  136,  136,   49,
      136,  136,    0,    0,   20,   20,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        8,    9,    0,    4,    0,  136,  136,  136,  136,    0,
        0,    0,  136,  136,  136,  136,    0,    0,    0,   22,
       22,    0,    0,    0,    0,    0,   23,   72,  136,  136,
        0,   86,   81,  136,   32,   62,   40,  136,   39,   79,
       31,  136,   29,  136,  136,   60,  136,  136,   70,    0,
        0,   20,   20,    0,    0,    0,    0,    0,   21,   10,
        0,  136,  136,  136,   28,    0,    0,    0,    0,    0,
        0,  136,   47,  136,  136,    0,    0,    0,   22,   22,
        0,    0,    0,    0,  136,  118,    0,  136,  136,   30,

       82,  136,   60,  136,  136,    0,    0,   20,   20,    0,
        0,    0,    0,    0,  136,  136,   80,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       65,  136,  136,    0,    0,   22,   22,    0,    0,    0,
        0,    0,    0,    0,    0,  136,  135,  136,   87,   63,
      136,  136,    0,    0,   20,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  136,  136,    0,    0,    0,
        0,    0,   24,    0,   69,   68,    0,    0,   22,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   22,    0,    0,    0,    0,  136,

      136,   63,   61,   55,    0,    0,   20,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   20,    0,    0,    0,    0,    0,    5,  136,
       54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   22,    0,
       22,   22,   22,    0,    0,    0,    0,    0,    0,    0,
        0,  136,   88,   61,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   20,    0,   20,   20,
       20,    0,    0,    0,    0,    0,    0,    0,    0,   56,
        0,    0,    0,    0,    0,    2,    0,   22,   22,   22,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   42,
        0,   20,   20,   20,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    2,   22,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   42,   42,   20,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   22,    0,    0,    0,    0,   20,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   22,    0,   20,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    1,    1,    6,    7,    1,    8,    9,
       10,   11,   12,   13,   14,   15,    1,   16,   16,   16,
       16,   16,   17,   17,   17,   17,   17,    1,    1,   18,
       19,   20,   21,   22,   23,   24,   24,   24,   25,   24,
       24,   24,   24,   24,   24,   26,   24,   24,   27,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       28,   29,   30,    1,    1,   31,   32,   33,   34,   35,

       36,   37,   38,   39,   40,   26,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   59,   60,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[61] =
    {   0,
        1,    2,    3,    2,    4,    1,    1,    5,    1,    1,
        1,    1,    6,    7,    1,    7,    7,    1,    7,    1,
        1,    8,    9,    9,    9,    9,    9,    1,   10,   11,
        7,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,   12,    1,   13,    1
    } ;

static yyconst flex_uint16_t yy_base[1416] =
    {   0,
        0,    0,    0,    1,    2,    6,   14,   26,   11,   30,
       43,   47,   96,    0,  156,    0,  216,    0,  274,  277,
      326,    0,    7,    8,  384,  387,  389,  392,  395,  406,
       20,  386, 3340, 3339,  398,  409,   39,   44,   16,   35,
     3352, 3351,   21,   25, 3366, 3371, 3371, 3371, 3371, 3371,
     3371, 3359, 3371,  241, 3313,    0, 3371, 3360, 3371,    0,
     3371, 3359, 3371, 3371, 3371, 3371,  272, 3310, 3371, 3358,
     3371, 3330, 3327, 3351,    0, 3348, 3342, 3340,   24, 3345,
      468, 3321,  403, 3371, 3371, 3371, 3371,  527, 3371,    0,
      294,    0, 3294, 3371,  530,  533,    0,  536, 3371, 3371,

     3371,  511, 3299, 3371,    0, 3371, 3371, 3346, 3312, 3371,
     3371, 3371,  418, 3296,    0, 3371, 3343,    0, 3371, 3342,
     3371, 3371, 3371, 3341,    0, 3371, 3371, 3371, 3371, 3371,
     3371, 3371,    0,    0, 3307, 3371,    0, 3371,   91, 3371,
     3306, 3297, 3304, 3307, 3302,    3, 3304,    0, 3333,    0,
     3332, 3371, 3298, 3289, 3296, 3299, 3294,   35, 3296, 3326,
     3293, 3371, 3371,    0, 3371, 3371, 3312,   43, 3317, 3316,
     3371, 3371, 3371, 3371,    0,   65,  540,  543, 3371,  271,
      269,   16,  279,  253, 3279,  266,  372,  554, 3286,  560,
      255,  567, 3289,  393,  572,  281, 3271,  273, 3371,  407,

      414,  425,  563, 3262,    0,    0,  558,    0,  572,  591,
        0,  607, 3278, 3277, 3284, 3279, 3371, 3278, 3269, 3276,
     3279, 3274,  360, 3276,    0, 3305, 3263, 3371, 3270, 3261,
     3268, 3271, 3266,  399, 3268,    0, 3297,    0, 3296, 3371,
        0,    0, 3254,    0,  578,  613, 3250, 3371, 3249, 3249,
     3247, 3250,  401, 3243, 3244, 3371, 3243, 3243, 3241, 3244,
      515, 3237, 3245, 3371, 3276,    0,  628,  633, 3371, 3255,
     3252, 3246, 3242, 3246, 3246, 3227, 3234, 3238, 3240, 3238,
     3227,  602,  418, 3225,  605, 3222, 3236, 3224, 3224, 3213,
       43, 3225,  611, 3214, 3211, 3217, 3229,  551, 3228, 3223,

     3225, 3203, 3216, 3219, 3206,  537,  608,  580, 3203, 3214,
     3207, 3217, 3201, 3201, 3371, 3200, 3200, 3198, 3201,  612,
     3194, 3207, 3194, 3371, 3193, 3193, 3191, 3194,  616, 3187,
     3200, 3185, 3184, 3183, 3195, 3181, 3180, 3179, 3191, 3176,
      661, 3371, 3195, 3371,  619, 3184,  510, 3177, 3186, 3176,
     3180, 3168,    0, 3176, 3175, 3166, 3165, 3174, 3181, 3176,
     3169, 3174, 3158, 3164, 3171, 3170, 3169,  632, 3168,  640,
     3154, 3160, 3165, 3160, 3167, 3162, 3143, 3154, 3145,  633,
     3145, 3147,  633, 3142, 3142,  643, 3157, 3149, 3156,  661,
     3128, 3134, 3131, 3117, 3125, 3108, 3107, 3104, 3116, 3371,

     3102, 3101, 3083, 3095,  682, 3080, 3078, 3066, 3033, 3032,
     3036, 3035, 3014, 3025, 3007, 3006, 3003, 2998, 3002, 2984,
     2983, 2972, 2965,    0, 2964, 2967, 2744, 2741, 2746, 2735,
     2739, 2736, 2747, 2732, 2728, 2724, 2727,  694, 2734, 2742,
     2726, 2728, 2727, 2734, 2737,  646, 2730, 2722, 2755, 2729,
     2728, 2710, 2706, 2711, 2727,    0, 2723, 2717, 2711, 2719,
     2709, 2714, 2718, 2711, 2718,  576, 2715, 2702, 2702, 2710,
        0, 2694, 2705, 3371, 2690, 2691, 2700, 2703, 2684, 2693,
     2692, 2677, 2676, 2689, 2688, 2673,  697,  700, 2677, 2671,
     2670, 2683, 2673, 2667, 2666, 2679, 3371, 2669, 2668,  671,

     2665,  712, 2674, 2664, 2653, 2671, 2673, 2669, 2668, 2655,
     2666, 2655, 2654,  715, 2662, 2648, 2661,    0,    0,  731,
      709,  705,  768,    0,    0, 2647, 2658,  685, 2641, 2648,
     2639, 2645, 2653, 2634, 2634, 2627, 3371, 2647, 2645, 2644,
     2641, 2640, 2626, 2637, 2624, 2617, 2623,  702,    0, 2621,
     2623, 2616, 2629, 2629, 2616, 2628, 2605, 2624,  747, 2621,
     2619, 2622,  754, 2603, 2607, 2601, 2600, 2613, 2603, 2597,
     2596, 2609,  763, 2608, 2607, 2594, 2604, 2592, 2588, 2587,
     2591, 2599, 2602,  771,  775, 2590, 2594, 2589, 2578, 2579,
     2589, 2578, 2588, 2588, 2583, 2568,  778,  771,  780,  827,

        0,  821, 2577, 2576,  783,  789,  802, 2565,  401, 2575,
     2566, 2564, 2564,  557, 2560,  818, 2569, 2567, 2560, 2558,
     2561, 2562, 2563, 2555, 2559, 2540, 2562,    0, 2548, 2542,
     2546, 2557, 2556, 2534, 2542, 2542, 2541, 2545, 2546, 2545,
     2540, 2528, 2542, 2545, 2526, 2526, 2532, 2535,    0, 2527,
      835,  818,  810,  877,    0,  880,  855, 2528,  883,  893,
     2525, 2528, 2516, 2526, 2514, 2512, 2508, 2506, 2516, 2514,
     2499, 2505, 2514,  896, 2502,    0, 2498, 2509, 2532, 2487,
     2495, 2489, 2492, 2501, 2501, 2498,  838,  824,  829, 2487,
      618, 2497, 2488, 2482, 2481,  822, 2477,  886,  899,  902,

      931, 2472,  771,  849,  905,  936, 2488,    0, 2487, 2468,
     2465, 2461, 2477, 2463,    0, 2465, 2460, 2449, 2469, 2458,
     2446, 2445,    0, 2435, 2470, 2430, 2428, 2431, 2431, 2435,
     2424,    0, 2424, 2421, 2424, 2414, 2413, 2415,  934,  852,
      858, 2396,  881, 2391, 2366, 2375, 2375,  891, 2369,  950,
      959,  962,  965,  968,  971, 2372,  981,    0, 2364, 2353,
     2350, 2363, 2343, 2350, 2340, 2345, 2345, 2346, 2346,    0,
     3371,    0, 2335,  584, 2322,    0,    0,  820,  902,  985,
      998, 1002, 1008,    0,  975,  911, 1053,    0, 2320, 2315,
     2309, 2311, 2303, 2310, 2300, 2305, 2294, 2290, 2300, 2296,

        0, 2288, 2287, 2275, 2274,    0, 3371, 2290, 2286, 2273,
     2278, 2264, 2263,  238,  243,  273,  340,  383,  415,  941,
     1018, 1030, 1034, 1063,    0,  998,  981, 1108,    0, 1021,
        0, 1056,  500, 1079,  606,  638,  659,  643,  662, 1088,
      687,  694,  697,  711,  718,    0,    0, 3371,  749,  749,
     1115, 1124, 1105,  991, 1001,  766,  952,  801,  828,  872,
      879,  996,  884, 1128,  890,  912,  913,  948,  943,  955,
      982,    0,  975,    0,    0, 1024,  985, 1008, 1032,    0,
      999,    0, 1013, 1014, 1023, 1027, 1039, 1028, 1025,    0,
     1028, 1043, 1044, 1043, 1133, 1160, 1165, 1078, 1081, 1054,

     1070, 1066, 1049, 1063, 1065, 1099, 1068, 1181, 1086, 1186,
     3371, 3371, 1189, 3371, 1079, 1085, 1089, 1104, 1107, 1192,
     1205, 1104, 1111, 1104, 1121, 1100, 1126, 1116, 1114, 1195,
     1210, 1152, 1226, 1233, 1240, 1160, 3371,    0, 1120, 1117,
     1157,    0,    0, 1135,    0, 3371,    0, 1142, 3371,    0,
        0, 1151,    0, 1156, 1159, 1199, 1175, 1161,    0, 1174,
     1172, 1258, 1248, 1209, 1262, 1271, 1285, 1191, 3371, 3371,
     1192, 1197, 1196, 1206,    0,    0, 1295, 1241, 1343,    0,
     1219, 1208,    0, 1218, 1226, 1213, 1220, 1228, 1320, 1391,
     1238, 1239, 1256, 1242, 1245,    0, 1260, 1259, 1263,    0,

        0, 1263, 3371, 1258, 1264, 1256, 1264, 1338, 1436, 1275,
     1274, 1289, 1286, 1275, 1279, 1272,    0, 1319, 1322, 1332,
     1281, 1309, 1297, 1296, 1307, 1310, 1320, 1309, 1369, 1312,
        0, 1308, 1325, 1313, 1407, 1429, 1414, 1381, 1348, 1481,
        0, 1323, 1317, 1334, 1342, 1335, 3371, 1336,    0, 1377,
     1346, 1363, 1351, 1452, 1459, 1488, 1410, 1385, 1533,    0,
     1360, 1362, 1419, 1437, 1497, 1370, 1393, 1477, 1500, 1537,
     1549, 1407, 3371, 1380,    0,    0, 1595,    0, 1558, 1490,
     1492, 1623,    0, 1495, 1502, 1506, 1389, 1444, 1407, 1429,
     1436, 1446, 1479, 1449, 1611, 1469, 1476, 1493, 1671, 1492,

     1478, 3371, 1521,    0, 1616,    0, 1619, 1548, 1528, 1710,
        0, 1555, 1538, 1541, 1492, 1541, 1512, 1520, 1533, 1535,
     1552, 1535, 1633, 1534, 1538, 1551, 1758, 1639, 3371, 1552,
        0, 1550, 1551, 1604, 1554, 1647,    0, 1662, 1600, 1630,
     1557, 1618, 1571, 1586, 1590, 1610, 1621, 1614, 1678, 1651,
     1687, 1690, 1699, 1615, 1693, 1764, 1745, 1700, 1702, 1803,
        0, 1621,    0, 3371,    0, 1719, 1704, 1707, 1638, 1694,
     1664, 1650, 1685, 1688, 1704, 1686, 1761, 1724, 1780, 1792,
     1807, 1702, 1812, 1851, 1799, 1815, 1741, 1879,    0,    0,
     1708, 1704, 1746, 1750, 1857, 1766, 1796, 1867, 1870, 1874,

     1927,    0, 1889, 1869, 1805, 1955,    0, 1872, 1817, 1840,
     1725, 1774, 1742, 1742, 1745, 1749, 1814, 1754, 1895, 2004,
     1884, 1900, 1903, 1906, 1949,    0, 2063, 1930, 1904, 2121,
        0, 1952, 1907, 1910, 1779, 1939, 1805, 1790, 1807, 1819,
     1926, 1829, 2067, 1828, 1841, 1934, 2169, 1908, 2070,    0,
     1964, 1917, 1920, 1894, 1941, 1920, 1919, 1933, 1942, 1952,
     1941, 2073, 1976, 2076, 2084, 2088,    0,    0, 2091,    0,
     2066, 1980, 1983, 1948, 2055, 1968, 2007, 2024, 2041, 2051,
     2050, 2100, 2083, 2137, 2146, 2172, 2048, 2204, 2220, 2197,
     2099, 2091, 2255,    0, 2224, 2095, 2188, 2191, 2249, 2260,

     2101, 2272, 2275, 2278, 2303,    0, 2281, 2129, 2113, 2339,
        0, 2136, 2146, 2149, 2059, 2126, 2085, 2079, 2114, 2125,
     2153, 2131, 2308, 2387, 2355, 2429, 2362,    0, 2229, 2162,
     2194, 2136, 2154, 2167, 2150, 2169, 2171, 2191, 2171, 2358,
     2213, 2366, 2391, 2408, 2471, 2420, 2513, 2433, 2222, 2425,
     2436, 2450, 2555, 2613, 2453, 2671, 2462, 2495, 2729, 2346,
     3371, 2788, 2801, 2814, 2827, 2840, 2853, 2866, 2879, 2892,
     2905, 2918, 2931, 2944, 2957, 2970, 2983, 2996, 3009, 3020,
     3031, 3040, 3049, 3058, 3060, 2233, 2239, 3069, 3080, 3091,
     3104, 3117, 3124, 3126, 3135, 2245, 2246, 2251, 3145, 2252,

     2256, 3151, 3160, 2257, 2259, 2260, 2277, 2278, 2285, 2287,
     2288, 2290, 3173, 2291, 2293
    } ;

static yyconst flex_int16_t yy_def[1416] =
    {   0,
     1362, 1362, 1363, 1363, 1364, 1364, 1365, 1365, 1366, 1366,
     1367, 1367, 1361,   13, 1361,   15, 1361,   17, 1368, 1368,
     1361,   21, 1369, 1369, 1370, 1370, 1371, 1371, 1372, 1372,
     1373, 1373, 1374, 1374, 1375, 1375, 1376, 1376, 1377, 1377,
     1362, 1362, 1378, 1378, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1379, 1361, 1361, 1361, 1380,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1381, 1361, 1361, 1361, 1361, 1382,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1383,
     1384, 1385, 1361, 1361, 1361, 1361, 1386, 1361, 1361, 1361,

     1361, 1361, 1361, 1361, 1387, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1388, 1361, 1361, 1389, 1361, 1361,
     1361, 1361, 1361, 1361, 1390, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1391, 1391, 1361, 1361, 1392, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1379, 1361, 1380,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1381, 1361, 1361, 1361, 1361, 1393, 1382,
     1361, 1361, 1361, 1361, 1394, 1394, 1394, 1394, 1361, 1361,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1361, 1361,

     1361, 1361, 1361, 1361, 1383, 1383, 1384, 1385, 1361, 1361,
     1386, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1387, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1388, 1361, 1389, 1361, 1361,
     1390, 1391, 1361, 1392, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1393, 1394, 1394, 1361, 1361, 1361,
     1395, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,

     1394, 1394, 1394, 1394, 1394, 1394, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1395, 1361, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,

     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1394, 1394, 1394,

     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1361,
     1361, 1361, 1361, 1396, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1361, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1394, 1394,
     1394, 1394, 1394, 1361, 1361, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1361, 1361, 1361, 1361,

     1397, 1394, 1394, 1394,  523,  605, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1396, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1361, 1361, 1361, 1361, 1398, 1394, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1394, 1394,
     1394, 1394, 1394, 1361, 1361, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394,  600,  687, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1397, 1361, 1361,

     1361, 1394, 1394,  605, 1361, 1361, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,  654,  739,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1398,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1399, 1361, 1361,
     1361, 1361, 1394, 1394, 1394, 1394, 1394, 1361, 1394, 1394,
     1361, 1394, 1394, 1394, 1394, 1394, 1394, 1394,  687, 1361,
     1361, 1397, 1397,  701, 1361, 1361, 1361, 1400, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,

     1394, 1394, 1394, 1394, 1394, 1394, 1361, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,  739,
     1361, 1361, 1398, 1398,  753, 1361, 1361, 1361, 1401, 1361,
     1402, 1361, 1399, 1361, 1361, 1394, 1394, 1394, 1394, 1394,
     1361, 1394, 1394, 1394, 1394, 1394, 1403, 1361, 1361, 1361,
     1397, 1397,  787,  853, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1400, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1361, 1361, 1398, 1398,  828,  897, 1361, 1361,

     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1401, 1402, 1361,
     1361, 1361, 1361, 1361, 1361, 1394, 1394, 1394, 1394, 1361,
     1361, 1361, 1394, 1394, 1394, 1394, 1403, 1361, 1361, 1397,
     1397,  853, 1361, 1361, 1400,  935, 1361, 1394, 1394, 1394,
     1361, 1394, 1394, 1394, 1394, 1361, 1394, 1394, 1361, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1361,
     1361, 1398, 1398,  897, 1361, 1361, 1401,  967, 1361, 1361,
     1361, 1394, 1394, 1394, 1394,  921, 1361, 1361, 1361, 1404,
     1361, 1394, 1394, 1394, 1394, 1361, 1361, 1361, 1397, 1397,
     1361, 1361,  935,  935, 1394, 1394, 1361, 1394, 1394, 1394,

     1394, 1394, 1361, 1394, 1394, 1361, 1361, 1398, 1398, 1361,
     1361,  967,  967, 1361, 1394, 1394, 1394,  979, 1018, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1404, 1361,
     1394, 1394, 1394, 1361, 1361,  990, 1035, 1361, 1361, 1361,
     1405, 1361, 1361,  935,  935, 1394, 1361, 1394, 1394, 1394,
     1394, 1394, 1361, 1361, 1009, 1054, 1361, 1361, 1361, 1406,
     1361, 1361,  967,  967, 1361, 1394, 1394, 1018, 1361, 1361,
     1404, 1071, 1361, 1361, 1394, 1394, 1361, 1035, 1077, 1361,
     1361, 1361, 1407, 1040, 1084, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1405, 1361, 1361,  935,  935, 1394,

     1394, 1361, 1394, 1394, 1361, 1054, 1105, 1361, 1361, 1361,
     1408, 1059, 1112, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1406, 1361, 1361,  967,  967, 1361, 1361, 1394,
     1394, 1361, 1361, 1071, 1071, 1361, 1077, 1082, 1138, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1407, 1084,
     1361, 1361, 1405, 1361, 1361, 1099, 1155, 1361, 1361, 1361,
     1409, 1394, 1394, 1361, 1105, 1110, 1166, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1408, 1112, 1361, 1361,
     1406, 1361, 1361, 1127, 1183, 1361, 1361, 1361, 1410, 1394,
     1361, 1361, 1071, 1071, 1361, 1361, 1138, 1361, 1361, 1405,

     1361, 1155, 1201, 1361, 1361, 1361, 1411, 1160, 1208, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1409, 1361,
     1166, 1361, 1361, 1406, 1361, 1183, 1225, 1361, 1361, 1361,
     1412, 1188, 1232, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1410, 1361, 1361, 1071, 1071, 1361, 1405, 1201,
     1206, 1251, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1411, 1208, 1361, 1361, 1409, 1413, 1220, 1406, 1225,
     1230, 1271, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1412, 1232, 1361, 1361, 1410, 1361, 1361, 1247, 1288,
     1361, 1361, 1361, 1414, 1405, 1251, 1361, 1361, 1409, 1406,

     1271, 1361, 1361, 1410, 1361, 1288, 1305, 1361, 1361, 1361,
     1415, 1293, 1312, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1414, 1405, 1409, 1406, 1410, 1305, 1310, 1329,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1415,
     1312, 1361, 1361, 1414, 1361, 1409, 1361, 1410, 1329, 1361,
     1361, 1414, 1409, 1410, 1414, 1361, 1225, 1414, 1414, 1307,
        0, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,

     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361
    } ;

static yyconst flex_uint16_t yy_nxt[3432] =
    {   0,
     1361, 1361,   48,   48,   51, 1361, 1361,   52,   51,  108,
      108,   52,   61,   62,   61,   57,   58,   57,  134,   53,
       53,   53,   46,   53,   53,   53,   57,   57,   58,   57,
       54,   61,   62,   61,   54,  109,  109,  134,   57,  168,
      168,   46,  252, 1361,  135,   64,   46,  122,   65,   64,
       55,  273,   65,  253,   55,  274,   49,   49,  168,  168,
       66,   66,   66,  135,   66,   66,   66,   61,  132,   61,
       57,   67,   59,  132,  260,   67,  123,  138,  124,  139,
      369,  138,   57,  139,   59,  261,   61,  267,   61,  267,
      370,   68,  245,  246,  245,   68,   69,   70,   71,   72,

       73,   74,   75,   76,   69,   69,   69,   69,   77,   78,
       69,   79,   79,   69,   69,   69,   73,   69,   80,   80,
       80,   80,   80,   69,   81,   69,   82,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   83,   84,   85,   86,   87,   88,   89,   88,
       87,   87,   87,   90,   87,   87,   87,   87,   87,   90,
       87,   91,   91,   87,   90,   87,   87,   91,   91,   91,
       91,   91,   91,   87,   92,   87,   90,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,

       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   93,   87,   87,   87,   94,   95,   96,   95,
       94,   94,   94,   94,   94,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   97,   97,
       97,   97,   97,   94,   94,   94,   94,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   98,   94,   94,   94,  100,  152,  141,  100,
      142,  270,  143,  144,  145,  887,  289,  888,  278,  146,
      290,  101,  101,  101,  101,  101,  101,  279,  271,  281,

      267,  206,  102,  272,  267,  102,  889,  206,  305,  153,
      282,  154,  206,  155,  156,  157,  302,  275,  276,  303,
      158,  306,  103,  277,  206,  103,  104,  104,   46,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  105,  105,
      105,  105,  105,  104,  104,  104,  104,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  104,  104,  106,  104,  111,  890,   46,  111,
      116,  117,  116,  116,  117,  116,  119,  120,  119,  319,

       46,  112,  112,  112,  112,  112,  112,  119,  120,  119,
      320,   46,  113,  122,  200,  113,  200,  201,  202,  202,
      283,  201,  202,  202,  292,  128,  284,  228,  293,  307,
      307,  891,  114,  333,  705,  114,  128,  294,  328,  308,
      202,  202,  123,  705,  124,  116,  334,  116,  116,  329,
      116,  119,  892,  119,  129,  229,  130,  230,  358,  231,
      232,  233,  119,  359,  119,  129,  234,  130,  171,  171,
      309,  172,  171,  171,  173,  171,  174,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  175,
      176,  175,  175,  177,  178,  179,  180,  171,  171,  181,

      182,  183,  184,  185,  186,  175,  187,  188,  189,  190,
      175,  191,  192,  193,  175,  194,  195,  196,  197,  198,
      175,  175,  175,  175,  171,  171,  171,  171,  203,  912,
      203,  209,  209,  209,  209,  209,  209,  212,  212,  212,
      217,  268,  269,  268,  268,  269,  268,  337,  218,  420,
      219,  421,  220,  221,  222,  268,  269,  268,  422,  223,
      338,  268,  269,  268,  203,  206,  203,  267,  268,  269,
      268,  206,  213,  209,  209,  209,  206,  388,  214,  245,
      246,  245,  389,  204,  379,  215,  210,  216,  206,  210,
      705,  287,  212,  212,  212,  390,  390,  285,  269,  288,

      380,  269,  267,  295,  296,  297,  705,  298,  212,  212,
      212,  553,  269,  299,  245,  246,  245,  844,  269,  204,
      267,  300,  301,  307,  307,  269,  554,  213,  210,  341,
      342,  341,  845,  214,  268,  269,  268,  915,  361,  362,
      215,  355,  216,  213,  397,  356,  357,  372,  402,  214,
      363,  780,  415,  309,  373,  416,  215,  398,  216,  374,
      780,  403,  341,  342,  341,  442,  459,  443,  417,  464,
      418,  447,  448,  444,  460,  469,  390,  390,  465,  532,
      445,  466,  461,  487,  487,  487,  342,  916,  470,  449,
      917,  269,  918,  533,  534,  520,  520,  520,  487,  487,

      487,  573,  573,  573,  581,  521,  309,  521,  522,  523,
      523,  919,  582,  584,  584,  584,  597,  597,  597,  342,
      605,  605,  524,  522,  523,  523,  598,  619,  598,  599,
      600,  600,  520,  520,  520,  620,  639,  922,  488,  923,
      640,  924,  521,  601,  521,  522,  523,  523,  651,  651,
      651,  574,  925,  488,  641,  659,  659,  659,  652,  524,
      652,  653,  654,  654,  573,  573,  573,  926,  585,  606,
      606,  606,  584,  584,  584,  655,  674,  674,  674,  597,
      597,  597,  607,  523,  523,  599,  600,  600,  928,  598,
      929,  598,  599,  600,  600,  687,  687, 1361,  605,  605,

      608,  609,  610,  611, 1361, 1361,  601,  612,  790,  675,
      613,  933,  660,  614,  574,  791,  615,  704,  704,  706,
      706,  706,  699,  699,  699,  739,  739,  585,  688,  688,
      688,  700,  653,  654,  654,  933,  651,  651,  651, 1361,
     1361,  689,  600,  600,  779,  779,  652,  847,  652,  653,
      654,  654, 1361,  687,  687,  780,  754,  754,  754,  690,
      691,  692,  693,  655,  704,  704,  694, 1361, 1361,  695,
      933,  780,  696,  820,  820,  697,  848,  701,  740,  740,
      740,  751,  751,  751,  659,  659,  659,  781,  781,  781,
      752,  741,  654,  654,  757,  757,  757,  674,  674,  674,

      699,  699,  699,  699,  699,  699,  706,  706,  706,  742,
      743,  744,  745,  755,  821,  933,  746,  779,  779,  747,
      758,  933,  748,  821,  821,  749,  853,  853,  782,  933,
      675,  783,  784,  784,  784,  938,  753,  706,  706,  706,
      821,  660,  785,  939,  785,  786,  787,  787, 1361,  739,
      739,  822,  822,  822,  940,  701,  820,  820,  701,  788,
      751,  751,  751,  751,  751,  751,  825,  825,  825,  754,
      754,  754,  830,  830,  830,  941,  826,  942,  826,  827,
      828,  828,  757,  757,  757,  933,  781,  781,  781,  786,
      787,  787,  823,  829,  933,  824,  897,  897,  831,  781,

      781,  781,  943,  781,  781,  781, 1361, 1361,  758,  781,
      781,  781,  827,  828,  828,  753,  932,  932,  753,  822,
      822,  822,  830,  830,  830,  944,  755,  849,  945,  933,
      850,  822,  822,  822,  946,  822,  822,  822,  947,  948,
      849,  851,  949,  850,  782,  933,  950,  783,  831,  852,
      782,  951,  952,  783,  854,  854,  854,  910,  910,  910,
      893,  953,  954,  894,  822,  822,  822,  855,  787,  787,
      955,  956,  893,  895,  957,  894,  823,  958,  959,  824,
      913,  913,  913,  960,  961,  856,  857,  858,  859,  920,
      920,  920,  860, 1361, 1361,  861,  964,  964,  862,  965,

      965,  863,  965,  965,  896,  823,  965,  965,  824,  898,
      898,  898,  965,  965,  911,  970,  781,  781,  781, 1361,
      853,  853,  899,  828,  828,  781,  781,  781,  971,  934,
      934,  934,  965,  972,  822,  822,  822,  914,  973,  974,
      900,  901,  902,  903,  921,  975,  981,  904,  965,  982,
      905,  983,  984,  906,  985,  986,  907,  782,  930,  987,
      783,  822,  822,  822,  988,  995,  782,  932,  932,  783,
      935,  996,  997,  936,  931,  823,  962,  998,  824, 1361,
      897,  897,  966,  966,  966,  999,  937,  910,  910,  910,
      913,  913,  913,  920,  920,  920,  781,  781,  781,  864,

     1000,  994,  823, 1001, 1002,  824,  976,  976,  976, 1003,
      963,  781,  781,  781, 1004, 1005,  977, 1006,  977,  978,
      979,  979, 1007,  967,  964,  964,  968,  934,  934,  934,
      908, 1014, 1013,  980,  934,  934,  934,  782, 1015,  969,
      783,  934,  934,  934,  911,  989, 1016,  914,  921,  822,
      822,  822,  782, 1017, 1030,  783, 1018, 1018,  990,  822,
      822,  822, 1031,  966,  966,  966, 1032, 1033,  991,  848,
     1034,  992,  966,  966,  966,  991, 1035, 1042,  992,  993,
     1043,  864,  935, 1046,  937,  936,  966,  966,  966, 1047,
      823,  937, 1045,  824, 1048,  864, 1009, 1049,  937, 1044,

      823, 1050, 1051,  824, 1010, 1052, 1053, 1011, 1008,  978,
      979,  979, 1054, 1010, 1061, 1062, 1011, 1065, 1066, 1067,
      969,  781,  781,  781, 1012,  908, 1069,  967,  908,  969,
      968, 1069, 1063, 1361, 1018, 1018, 1064, 1361, 1361,  822,
      822,  822, 1069,  969, 1019, 1019, 1019, 1068, 1068, 1069,
     1069, 1069, 1069, 1069, 1069, 1074, 1075, 1020,  979,  979,
     1076, 1077,  782, 1084, 1084,  783, 1096, 1097, 1036, 1069,
     1070, 1070, 1070,  864, 1100, 1021, 1022, 1023, 1024, 1101,
      823,  864, 1025,  824, 1098, 1026, 1055, 1102, 1027, 1103,
     1099, 1028, 1037, 1037, 1037, 1039, 1040, 1040, 1104, 1105,

     1112, 1112, 1038, 1124, 1038, 1039, 1040, 1040, 1078, 1078,
     1078, 1071, 1125, 1130, 1072, 1037, 1037, 1037, 1038, 1041,
     1038, 1039, 1040, 1040, 1058, 1059, 1059, 1073, 1131, 1136,
     1079, 1079, 1079,  782, 1151, 1041,  783, 1056, 1056, 1056,
     1080, 1151, 1080, 1081, 1082, 1082, 1029, 1057, 1135, 1057,
     1058, 1059, 1059, 1106, 1106, 1106,  849, 1083,  908,  850,
     1107, 1107, 1107, 1057, 1060, 1057, 1058, 1059, 1059, 1126,
     1108, 1151, 1108, 1109, 1110, 1110,  908, 1151,  823, 1151,
     1060,  824, 1085, 1085, 1085, 1127, 1151, 1111, 1151, 1056,
     1056, 1056, 1068, 1068, 1151, 1086, 1040, 1040, 1128, 1128,

     1128, 1070, 1070, 1070, 1081, 1082, 1082, 1138, 1138, 1361,
     1084, 1084, 1151, 1087, 1088, 1089, 1090, 1361, 1361, 1154,
     1091, 1150, 1150, 1092, 1155, 1162, 1093, 1163, 1151, 1094,
      893, 1164,  864,  894, 1113, 1113, 1113, 1179, 1070, 1070,
     1070, 1156, 1132, 1166, 1166, 1133, 1179, 1114, 1059, 1059,
     1070, 1070, 1070, 1361, 1361, 1129, 1178, 1178, 1073, 1079,
     1079, 1079, 1109, 1110, 1110, 1115, 1116, 1117, 1118, 1361,
     1112, 1112, 1119, 1179, 1179, 1120, 1179, 1179, 1121, 1132,
     1179, 1122, 1133, 1179, 1182, 1179, 1183, 1190, 1134, 1191,
      908, 1071, 1192, 1029, 1072, 1073, 1137, 1137, 1137, 1184,

      849, 1179, 1198,  850, 1194, 1198, 1080, 1073, 1080, 1081,
     1082, 1082, 1152, 1152, 1152, 1361, 1361, 1165, 1165, 1165,
     1107, 1107, 1107, 1083, 1139, 1139, 1139, 1108, 1198, 1108,
     1109, 1110, 1110, 1198, 1180, 1180, 1180, 1140, 1082, 1082,
     1128, 1128, 1128, 1029, 1111, 1197, 1197, 1193, 1195, 1195,
     1195, 1198, 1198, 1153, 1198, 1141, 1142, 1143, 1144, 1198,
     1198,  893, 1145, 1201,  894, 1146, 1150, 1150, 1147, 1220,
     1198, 1148, 1157, 1157, 1157, 1181, 1361, 1138, 1138, 1199,
     1199, 1199, 1158, 1222, 1158, 1159, 1160, 1160, 1152, 1152,
     1152, 1152, 1152, 1152, 1202, 1202, 1202, 1129, 1222, 1161,

     1152, 1152, 1152, 1222, 1158, 1196, 1158, 1159, 1160, 1160,
      864, 1167, 1167, 1167, 1159, 1160, 1160, 1208, 1208, 1361,
     1361, 1161, 1221, 1221, 1168, 1110, 1110, 1222, 1222,  849,
     1222, 1222,  849, 1361, 1166, 1166, 1222, 1222, 1200, 1178,
     1178, 1153, 1169, 1170, 1171, 1172, 1157, 1157, 1157, 1173,
     1225, 1244, 1174, 1222, 1245, 1175, 1232, 1232, 1176, 1185,
     1185, 1185, 1223, 1223, 1223, 1203, 1203, 1203, 1248, 1186,
     1264, 1186, 1187, 1188, 1188, 1204, 1264, 1204, 1205, 1206,
     1206, 1180, 1180, 1180, 1264, 1029, 1189,  991, 1264, 1029,
      992, 1264, 1207, 1180, 1180, 1180, 1246,  908, 1247, 1264,

     1185, 1185, 1185,  937, 1209, 1209, 1209, 1264, 1180, 1180,
     1180, 1197, 1197, 1226, 1226, 1226, 1264, 1210, 1160, 1160,
     1251, 1251,  893, 1186, 1284, 1186, 1187, 1188, 1188, 1187,
     1188, 1188, 1361, 1361,  893, 1211, 1212, 1213, 1214, 1284,
     1189, 1010, 1215, 1284, 1011, 1216, 1224, 1264, 1217, 1181,
     1284, 1218, 1227, 1227, 1227, 1263, 1263,  969, 1195, 1195,
     1195, 1284, 1228, 1264, 1228, 1229, 1230, 1230, 1199, 1199,
     1199, 1199, 1199, 1199, 1284, 1152, 1152, 1152, 1287, 1231,
     1233, 1233, 1233, 1205, 1206, 1206, 1361, 1208, 1208, 1288,
     1203, 1203, 1203, 1234, 1188, 1188, 1265, 1265, 1265, 1221,

     1221, 1223, 1223, 1223, 1223, 1223, 1223, 1180, 1180, 1180,
     1248, 1235, 1236, 1237, 1238, 1196, 1153, 1249, 1239, 1271,
     1271, 1240, 1361, 1361, 1241, 1283, 1283, 1242, 1250, 1250,
     1250,  991, 1361, 1361,  992, 1296, 1296, 1266, 1204, 1297,
     1204, 1205, 1206, 1206, 1229, 1230, 1230,  937, 1181, 1269,
     1270, 1270, 1270,  937, 1297, 1207, 1252, 1252, 1252, 1284,
     1228, 1297, 1228, 1229, 1230, 1230, 1361, 1232, 1232, 1253,
     1206, 1206, 1284, 1029, 1297, 1284, 1297, 1231, 1361, 1251,
     1251, 1284, 1289, 1297, 1297, 1297, 1297, 1254, 1255, 1256,
     1257, 1263, 1263, 1302, 1258, 1361, 1361, 1259, 1301, 1301,

     1260, 1297, 1302, 1261, 1267, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1268, 1268, 1268, 1268, 1268,
     1268, 1267, 1267, 1267, 1267, 1268, 1268, 1268, 1268, 1268,
     1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
     1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268,
     1302, 1267, 1267, 1267, 1227, 1227, 1227, 1302, 1285, 1285,
     1285, 1152, 1152, 1152, 1298, 1298, 1298, 1265, 1265, 1265,
     1361, 1271, 1271, 1302, 1302, 1265, 1265, 1265, 1302, 1265,
     1265, 1265, 1180, 1180, 1180, 1302, 1305, 1302, 1283, 1283,

     1302, 1303, 1303, 1303, 1342, 1010, 1312, 1312, 1011, 1286,
     1296, 1296, 1153, 1292, 1293, 1293, 1301, 1301,  991, 1342,
     1295,  969, 1272, 1272, 1272,  969,  991, 1299, 1329, 1329,
     1266,  937, 1342, 1181,  937, 1273, 1230, 1230, 1285, 1285,
     1285, 1300,  937, 1309, 1310, 1310,  937, 1285, 1285, 1285,
     1361, 1312, 1312, 1274, 1275, 1276, 1277, 1342,  969, 1342,
     1278, 1361, 1361, 1279, 1341, 1341, 1280, 1342, 1342, 1281,
     1290, 1290, 1290, 1285, 1285, 1285, 1342, 1361, 1361, 1010,
     1291, 1350, 1291, 1292, 1293, 1293, 1342, 1350, 1010, 1298,
     1298, 1298, 1298, 1298, 1298,  969, 1350, 1294, 1290, 1290,

     1290, 1350, 1342, 1350,  969, 1306, 1306, 1306, 1029, 1349,
     1349, 1304, 1350, 1350, 1286, 1291, 1350, 1291, 1292, 1293,
     1293, 1307, 1307, 1307, 1350, 1152, 1152, 1152, 1341, 1341,
      969, 1308, 1294, 1308, 1309, 1310, 1310, 1349, 1349, 1132,
     1350,  211, 1133, 1361, 1329, 1329,  937,  225, 1311,  937,
     1265, 1265, 1265,  616,  698, 1073, 1313, 1313, 1313,  750,
      864, 1180, 1180, 1180,  908, 1029, 1153, 1095, 1123, 1314,
     1293, 1293, 1324, 1303, 1303, 1303, 1303, 1303, 1303, 1285,
     1285, 1285, 1307, 1307, 1307, 1149, 1177, 1315, 1316, 1317,
     1318, 1266, 1325, 1219, 1319, 1243, 1262, 1320, 1282, 1323,

     1321, 1340, 1181, 1322, 1328, 1328, 1328,  937, 1326, 1343,
     1343, 1343,  886,  885, 1308,  884, 1308, 1309, 1310, 1310,
     1286, 1327,  883, 1132,  882,  881, 1133,  880,  879,  878,
      969, 1311,  877,  969,  876,  875,  969,  874,  873, 1073,
     1330, 1330, 1330,  872,  871,  870,  869, 1360, 1360, 1360,
     1344,  868,  867, 1331, 1310, 1310, 1265, 1265, 1265, 1351,
     1351, 1351,  866, 1285, 1285, 1285, 1073, 1343, 1343, 1343,
      865, 1332, 1333, 1334, 1335,  846,  843,  842, 1336,  841,
      840, 1337,  839,  838, 1338,  837,  836, 1339, 1345, 1345,
     1345, 1361, 1343, 1343, 1343,  835,  324, 1266, 1080,  315,

     1080, 1081, 1082, 1082, 1286, 1346,  834,  832, 1132, 1343,
     1343, 1343, 1348,  937,  821, 1083, 1073,  821,  821,  821,
      969, 1265, 1265, 1265, 1073,  821, 1351, 1351, 1351, 1153,
     1347, 1347, 1347, 1132, 1285, 1285, 1285, 1351, 1351, 1351,
     1108,  821, 1108, 1109, 1110, 1110,  819, 1352,  818, 1073,
     1344, 1343, 1343, 1343, 1343, 1343, 1343, 1111,  817,  816,
      815,  814, 1266, 1357, 1357, 1357, 1073,  813, 1353,  812,
      811, 1181, 1345, 1345, 1345, 1286,  810,  809,  937,  808,
      807, 1354, 1080, 1073, 1080, 1081, 1082, 1082,  806,  805,
      804,  969, 1344, 1355, 1073, 1344, 1343, 1343, 1343, 1083,

      803,  802,  801, 1358, 1010,  800,  799,  798, 1073,  797,
      796, 1073,  795,  849, 1347, 1347, 1347,  794,  793,  792,
      969,  789,  780,  780, 1108,  780, 1108, 1109, 1110, 1110,
      780,  780,  780,  778,  777,  776,  775, 1344,  774,  773,
      772, 1111,  771, 1359,  770,  769,  768,  767,  766,  765,
      764,  763,  256, 1073,  248,  893, 1356, 1356, 1356,  762,
      324,  761,  315,  760,  759,  756, 1204,  738, 1204, 1205,
     1206, 1206,  737,  736,  735,  734,  733,  732,  731,  730,
      729,  728,  727, 1207,  726,  725,  724,  723,  722,  721,
      720,  719,  718,  717,  716,  715,  714, 1266,  713,  712,

      711,  710,  709,  708,  707,  705,  705,  705,  705,  705,
      705,  703,  702,  937, 1357, 1357, 1357,  686,  685,  684,
      683,  682,  681,  680, 1228,  679, 1228, 1229, 1230, 1230,
      678,  677,  676,  673,  672,  671,  670,  669,  256,  668,
      248, 1231,  667,  666,  665,  324,  664,  324,  663,  315,
      662,  315,  661,  658,  657, 1286,  656,  650,  649,  648,
      647,  646,  645,  644,  643,  642,  638,  637,  636,  635,
      634,  969, 1356, 1356, 1356,  633,  632,  631,  630,  629,
      628,  627, 1204,  626, 1204, 1205, 1206, 1206,  625,  624,
      623,  622,  621,  618,  617,  604,  603,  602,  596, 1207,

      595,  594,  593,  592,  591,  590,  589,  588,  587,  586,
      583,  580,  579,  991,  578,  256,  577,  256,  576,  248,
      575,  248,  572,  571,  570,  569,  568,  567,  566,  937,
     1360, 1360, 1360,  565,  564,  563,  562,  561,  560,  559,
     1308,  558, 1308, 1309, 1310, 1310,  557,  556,  555,  552,
      551,  550,  549,  548,  547,  546,  545, 1311,  544,  543,
      542,  541,  540,  539,  538,  537,  536,  535,  531,  530,
      529, 1344,  528,  527,  526,  525,  519,  518,  517,  516,
      515,  514,  513,  512,  511,  510,  509, 1073,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,

       46,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   50,   50,   50,   50,   50,   50,
       50,   50,   50,   50,   50,   50,   50,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  110,  110,  110,  110,  110,  110,  110,  110,

      110,  110,  110,  110,  110,  115,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  118,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
      118,  121,  121,  121,  121,  121,  121,  121,  121,  121,
      121,  121,  121,  121,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  127,  127,  127,
      127,  127,  127,  127,  127,  127,  127,  127,  127,  127,
      131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
      131,  131,  131,  133,  133,  133,  133,  133,  133,  133,
      133,  133,  133,  133,  133,  133,  137,  137,  137,  137,

      137,  137,  137,  137,  137,  137,  137,  137,  137,  148,
      508,  507,  148,  148,  506,  148,  148,  148,  148,  148,
      150,  505,  504,  150,  150,  150,  150,  150,  150,  150,
      150,  164,  164,  503,  164,  164,  164,  164,  164,  164,
      164,  164,  164,  164,  170,  502,  501,  500,  170,  205,
      499,  498,  205,  205,  205,  205,  205,  205,  205,  205,
      497,  205,  207,  496,  207,  207,  207,  208,  208,  236,
      495,  494,  236,  236,  236,  236,  236,  236,  236,  236,
      238,  493,  492,  238,  238,  238,  238,  238,  238,  238,
      238,  241,  241,  241,  241,  241,  241,  241,  241,  241,

      241,  491,  241,  241,  242,  242,  242,  242,  242,  242,
      242,  242,  242,  490,  242,  242,  242,  244,  244,  244,
      244,  244,  244,  244,  244,  244,  244,  244,  265,  489,
      486,  485,  265,  266,  266,  343,  343,  343,  343,  343,
      343,  343,  343,  343,  343,  343,  343,  343,  833,  484,
      483,  482,  481,  833,  909,  480,  479,  478,  477,  909,
      927,  927,  927,  927,  927,  927,  927,  927,  927,  927,
      476,  927,  927, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267,  475, 1267,  474,  473,  472,  471,
      468,  467,  463,  462,  458,  457,  456,  455,  454,  453,

      452,  451,  450,  446,  441,  440,  439,  438,  437,  436,
      435,  434,  433,  432,  431,  430,  429,  428,  427,  426,
      425,  424,  423,  419,  344,  414,  413,  412,  411,  410,
      409,  408,  407,  406,  405,  404,  324,  324,  401,  324,
      324,  400,  399,  315,  315,  396,  315,  315,  395,  394,
      393,  392,  391,  387,  386,  385,  384,  383,  382,  381,
      378,  377,  376,  375,  371,  368,  367,  366,  365,  364,
      360,  354,  353,  352,  351,  350,  349,  348,  347,  346,
      345,  344,  271, 1361,  340,  339,  256,  256,  336,  256,
      256,  335,  248,  248,  332,  248,  248,  331,  239,  237,

      330,  327,  326,  325,  324,  323,  322,  226,  321,  318,
      317,  316,  315,  314,  313,  312,  311,  310,  204,  304,
      291,  286,  280,  169,  169,  264,  263,  160,  262,  259,
      258,  257,  256,  255,  151,  149,  254,  251,  250,  249,
      248,  247,  243,  240,  239,  237,  235,  227,  226,  224,
      204,  199,  169,  167,  166,  165,  163,  162,  161,  160,
      159,  151,  149,  147,  140, 1361,  136,  136,  126,  126,
       45, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,

     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361
    } ;

static yyconst flex_int16_t yy_chk[3432] =
    {   0,
        0,    0,    3,    4,    5,    0,    0,    5,    6,   23,
       24,    6,    9,    9,    9,    7,    7,    7,   39,    5,
        5,    5,   31,    6,    6,    6,    7,    8,    8,    8,
        5,   10,   10,   10,    6,   23,   24,   40,    8,   79,
       79,   37,  146,    0,   39,   11,   38,   31,   11,   12,
        5,  182,   12,  146,    6,  182,    3,    4,  168,  168,
       11,   11,   11,   40,   12,   12,   12,    9,   37,    9,
        7,   11,    7,   38,  158,   12,   31,   43,   31,   43,
      291,   44,    8,   44,    8,  158,   10,  176,   10,  176,
      291,   11,  139,  139,  139,   12,   13,   13,   13,   13,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,

       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   19,   67,   54,   20,
       54,  180,   54,   54,   54,  814,  191,  815,  184,   54,
      191,   19,   19,   19,   20,   20,   20,  184,  180,  186,

      181,   91,   19,  181,  181,   20,  816,   91,  198,   67,
      186,   67,   91,   67,   67,   67,  196,  183,  183,  196,
       67,  198,   19,  183,   91,   20,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   25,  817,   32,   26,
       27,   27,   27,   28,   28,   28,   29,   29,   29,  223,

       35,   25,   25,   25,   26,   26,   26,   30,   30,   30,
      223,   36,   25,   32,   83,   26,   83,   83,   83,   83,
      187,  200,  200,  200,  194,   35,  187,  113,  194,  201,
      201,  818,   25,  253,  609,   26,   36,  194,  234,  202,
      202,  202,   32,  609,   32,   27,  253,   27,   28,  234,
       28,   29,  819,   29,   35,  113,   35,  113,  283,  113,
      113,  113,   30,  283,   30,   36,  113,   36,   81,   81,
      202,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,

       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   88,  833,
       88,   95,   95,   95,   96,   96,   96,   98,   98,   98,
      102,  177,  177,  177,  178,  178,  178,  261,  102,  347,
      102,  347,  102,  102,  102,  188,  188,  188,  347,  102,
      261,  190,  190,  190,  203,  207,  203,  178,  192,  192,
      192,  207,   98,  209,  209,  209,  207,  306,   98,  245,
      245,  245,  306,   88,  298,   98,   95,   98,  207,   96,
      614,  190,  210,  210,  210,  308,  308,  188,  177,  190,

      298,  178,  192,  195,  195,  195,  614,  195,  212,  212,
      212,  466,  188,  195,  246,  246,  246,  774,  190,  203,
      195,  195,  195,  307,  307,  192,  466,  210,  209,  267,
      267,  267,  774,  210,  268,  268,  268,  835,  285,  285,
      210,  282,  210,  212,  320,  282,  282,  293,  329,  212,
      285,  691,  345,  307,  293,  345,  212,  320,  212,  293,
      691,  329,  341,  341,  341,  368,  380,  368,  345,  383,
      345,  370,  370,  368,  380,  386,  390,  390,  383,  446,
      368,  383,  380,  405,  405,  405,  267,  836,  386,  370,
      837,  268,  838,  446,  446,  438,  438,  438,  487,  487,

      487,  488,  488,  488,  500,  438,  390,  438,  438,  438,
      438,  839,  500,  502,  502,  502,  514,  514,  514,  341,
      522,  522,  438,  521,  521,  521,  514,  528,  514,  514,
      514,  514,  520,  520,  520,  528,  548,  841,  405,  842,
      548,  843,  520,  514,  520,  520,  520,  520,  559,  559,
      559,  488,  844,  487,  548,  563,  563,  563,  559,  520,
      559,  559,  559,  559,  573,  573,  573,  845,  502,  523,
      523,  523,  584,  584,  584,  559,  585,  585,  585,  597,
      597,  597,  523,  523,  523,  598,  598,  598,  849,  597,
      850,  597,  597,  597,  597,  599,  599,  605,  605,  605,

      523,  523,  523,  523,  606,  606,  597,  523,  703,  585,
      523,  856,  563,  523,  573,  703,  523,  607,  607,  616,
      616,  616,  602,  602,  602,  653,  653,  584,  600,  600,
      600,  602,  652,  652,  652,  858,  651,  651,  651,  688,
      688,  600,  600,  600,  689,  689,  651,  778,  651,  651,
      651,  651,  687,  687,  687,  696,  657,  657,  657,  600,
      600,  600,  600,  651,  704,  704,  600,  740,  740,  600,
      859,  696,  600,  741,  741,  600,  778,  602,  654,  654,
      654,  656,  656,  656,  659,  659,  659,  698,  698,  698,
      656,  654,  654,  654,  660,  660,  660,  674,  674,  674,

      699,  699,  699,  700,  700,  700,  705,  705,  705,  654,
      654,  654,  654,  657,  743,  860,  654,  779,  779,  654,
      660,  861,  654,  743,  748,  654,  786,  786,  698,  863,
      674,  698,  701,  701,  701,  865,  656,  706,  706,  706,
      748,  659,  701,  866,  701,  701,  701,  701,  739,  739,
      739,  750,  750,  750,  867,  699,  820,  820,  700,  701,
      751,  751,  751,  752,  752,  752,  753,  753,  753,  754,
      754,  754,  755,  755,  755,  868,  753,  869,  753,  753,
      753,  753,  757,  757,  757,  857,  780,  780,  780,  785,
      785,  785,  750,  753,  857,  750,  827,  827,  755,  781,

      781,  781,  870,  782,  782,  782,  854,  854,  757,  783,
      783,  783,  826,  826,  826,  751,  855,  855,  752,  821,
      821,  821,  830,  830,  830,  871,  754,  780,  873,  862,
      780,  822,  822,  822,  876,  823,  823,  823,  877,  878,
      781,  782,  879,  781,  782,  862,  881,  782,  830,  783,
      783,  883,  884,  783,  787,  787,  787,  832,  832,  832,
      821,  885,  886,  821,  824,  824,  824,  787,  787,  787,
      887,  888,  822,  823,  889,  822,  823,  891,  892,  823,
      834,  834,  834,  893,  894,  787,  787,  787,  787,  840,
      840,  840,  787,  898,  898,  787,  899,  899,  787,  900,

      902,  787,  903,  901,  824,  824,  904,  905,  824,  828,
      828,  828,  901,  907,  832,  909,  851,  851,  851,  853,
      853,  853,  828,  828,  828,  852,  852,  852,  915,  864,
      864,  864,  906,  916,  895,  895,  895,  834,  917,  918,
      828,  828,  828,  828,  840,  919,  922,  828,  906,  923,
      828,  924,  925,  828,  926,  927,  828,  851,  851,  928,
      851,  896,  896,  896,  929,  939,  852,  932,  932,  852,
      864,  940,  941,  864,  852,  895,  895,  944,  895,  897,
      897,  897,  908,  908,  908,  948,  864,  910,  910,  910,
      913,  913,  913,  920,  920,  920,  930,  930,  930,  936,

      952,  936,  896,  954,  955,  896,  921,  921,  921,  956,
      896,  931,  931,  931,  957,  958,  921,  960,  921,  921,
      921,  921,  961,  908,  964,  964,  908,  933,  933,  933,
      968,  971,  968,  921,  934,  934,  934,  930,  972,  908,
      930,  935,  935,  935,  910,  930,  973,  913,  920,  963,
      963,  963,  931,  974,  981,  931,  978,  978,  931,  962,
      962,  962,  982,  965,  965,  965,  984,  985,  933,  986,
      987,  933,  966,  966,  966,  934,  988,  991,  934,  935,
      992,  994,  935,  995,  933,  935,  967,  967,  967,  997,
      963,  934,  994,  963,  998,  993,  963,  999,  935,  993,

      962, 1002, 1004,  962,  965, 1005, 1006,  965,  962,  977,
      977,  977, 1007,  966, 1010, 1011,  966, 1014, 1015, 1016,
      965,  989,  989,  989,  967, 1013, 1021,  967, 1012,  966,
      967, 1023, 1012, 1018, 1018, 1018, 1013, 1019, 1019, 1008,
     1008, 1008, 1022,  967,  979,  979,  979, 1020, 1020, 1024,
     1025, 1022, 1026, 1027, 1028, 1030, 1032,  979,  979,  979,
     1033, 1034,  989, 1039, 1039,  989, 1042, 1043,  989, 1027,
     1029, 1029, 1029, 1044, 1046,  979,  979,  979,  979, 1048,
     1008, 1045,  979, 1008, 1044,  979, 1008, 1050,  979, 1051,
     1045,  979,  990,  990,  990, 1038, 1038, 1038, 1052, 1053,

     1058, 1058,  990, 1061,  990,  990,  990,  990, 1035, 1035,
     1035, 1029, 1062, 1066, 1029, 1037, 1037, 1037, 1035,  990,
     1035, 1035, 1035, 1035, 1057, 1057, 1057, 1029, 1067, 1074,
     1036, 1036, 1036,  990, 1087, 1035,  990, 1009, 1009, 1009,
     1036, 1089, 1036, 1036, 1036, 1036, 1072, 1009, 1072, 1009,
     1009, 1009, 1009, 1054, 1054, 1054, 1037, 1036, 1063, 1037,
     1055, 1055, 1055, 1054, 1009, 1054, 1054, 1054, 1054, 1063,
     1055, 1090, 1055, 1055, 1055, 1055, 1064, 1088, 1009, 1091,
     1054, 1009, 1040, 1040, 1040, 1064, 1088, 1055, 1092, 1056,
     1056, 1056, 1068, 1068, 1094, 1040, 1040, 1040, 1065, 1065,

     1065, 1069, 1069, 1069, 1080, 1080, 1080, 1081, 1081, 1084,
     1084, 1084, 1093, 1040, 1040, 1040, 1040, 1085, 1085, 1096,
     1040, 1086, 1086, 1040, 1097, 1100, 1040, 1101, 1093, 1040,
     1056, 1103, 1098, 1056, 1059, 1059, 1059, 1115, 1070, 1070,
     1070, 1098, 1069, 1109, 1109, 1069, 1117, 1059, 1059, 1059,
     1071, 1071, 1071, 1113, 1113, 1065, 1114, 1114, 1069, 1079,
     1079, 1079, 1108, 1108, 1108, 1059, 1059, 1059, 1059, 1112,
     1112, 1112, 1059, 1118, 1116, 1059, 1119, 1120, 1059, 1070,
     1122, 1059, 1070, 1116, 1124, 1121, 1125, 1130, 1071, 1132,
     1126, 1071, 1133, 1135, 1071, 1070, 1077, 1077, 1077, 1126,

     1079, 1121, 1141, 1079, 1135, 1143, 1077, 1071, 1077, 1077,
     1077, 1077, 1095, 1095, 1095, 1139, 1139, 1105, 1105, 1105,
     1107, 1107, 1107, 1077, 1082, 1082, 1082, 1105, 1144, 1105,
     1105, 1105, 1105, 1145, 1123, 1123, 1123, 1082, 1082, 1082,
     1128, 1128, 1128, 1134, 1105, 1140, 1140, 1134, 1136, 1136,
     1136, 1142, 1146, 1095, 1147, 1082, 1082, 1082, 1082, 1148,
     1142, 1107, 1082, 1154, 1107, 1082, 1150, 1150, 1082, 1162,
     1147, 1082, 1099, 1099, 1099, 1123, 1138, 1138, 1138, 1149,
     1149, 1149, 1099, 1169, 1099, 1099, 1099, 1099, 1151, 1151,
     1151, 1152, 1152, 1152, 1155, 1155, 1155, 1128, 1171, 1099,

     1153, 1153, 1153, 1172, 1155, 1136, 1155, 1155, 1155, 1155,
     1099, 1110, 1110, 1110, 1158, 1158, 1158, 1159, 1159, 1167,
     1167, 1155, 1168, 1168, 1110, 1110, 1110, 1170, 1173, 1151,
     1174, 1176, 1152, 1166, 1166, 1166, 1170, 1175, 1153, 1178,
     1178, 1153, 1110, 1110, 1110, 1110, 1157, 1157, 1157, 1110,
     1182, 1191, 1110, 1175, 1192, 1110, 1187, 1187, 1110, 1127,
     1127, 1127, 1177, 1177, 1177, 1156, 1156, 1156, 1196, 1127,
     1211, 1127, 1127, 1127, 1127, 1156, 1213, 1156, 1156, 1156,
     1156, 1179, 1179, 1179, 1214, 1193, 1127, 1157, 1215, 1194,
     1157, 1216, 1156, 1180, 1180, 1180, 1193, 1127, 1194, 1218,

     1185, 1185, 1185, 1157, 1160, 1160, 1160, 1212, 1181, 1181,
     1181, 1197, 1197, 1183, 1183, 1183, 1212, 1160, 1160, 1160,
     1205, 1205, 1179, 1183, 1235, 1183, 1183, 1183, 1183, 1186,
     1186, 1186, 1209, 1209, 1180, 1160, 1160, 1160, 1160, 1237,
     1183, 1185, 1160, 1238, 1185, 1160, 1181, 1217, 1160, 1181,
     1239, 1160, 1184, 1184, 1184, 1210, 1210, 1185, 1195, 1195,
     1195, 1240, 1184, 1217, 1184, 1184, 1184, 1184, 1198, 1198,
     1198, 1199, 1199, 1199, 1242, 1200, 1200, 1200, 1244, 1184,
     1188, 1188, 1188, 1204, 1204, 1204, 1208, 1208, 1208, 1245,
     1203, 1203, 1203, 1188, 1188, 1188, 1219, 1219, 1219, 1221,

     1221, 1222, 1222, 1222, 1223, 1223, 1223, 1224, 1224, 1224,
     1248, 1188, 1188, 1188, 1188, 1195, 1200, 1200, 1188, 1229,
     1229, 1188, 1233, 1233, 1188, 1234, 1234, 1188, 1201, 1201,
     1201, 1203, 1252, 1252, 1203, 1253, 1253, 1219, 1201, 1254,
     1201, 1201, 1201, 1201, 1228, 1228, 1228, 1203, 1224, 1224,
     1225, 1225, 1225, 1219, 1256, 1201, 1206, 1206, 1206, 1241,
     1225, 1257, 1225, 1225, 1225, 1225, 1232, 1232, 1232, 1206,
     1206, 1206, 1236, 1246, 1255, 1241, 1258, 1225, 1251, 1251,
     1251, 1236, 1246, 1255, 1259, 1260, 1261, 1206, 1206, 1206,
     1206, 1263, 1263, 1274, 1206, 1272, 1272, 1206, 1273, 1273,

     1206, 1260, 1276, 1206, 1220, 1220, 1220, 1220, 1220, 1220,
     1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220,
     1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220,
     1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220,
     1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220,
     1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220,
     1277, 1220, 1220, 1220, 1227, 1227, 1227, 1278, 1243, 1243,
     1243, 1249, 1249, 1249, 1262, 1262, 1262, 1264, 1264, 1264,
     1271, 1271, 1271, 1279, 1280, 1265, 1265, 1265, 1275, 1266,
     1266, 1266, 1269, 1269, 1269, 1281, 1287, 1275, 1283, 1283,

     1280, 1282, 1282, 1282, 1315, 1227, 1292, 1292, 1227, 1243,
     1296, 1296, 1249, 1291, 1291, 1291, 1301, 1301, 1264, 1317,
     1249, 1227, 1230, 1230, 1230, 1243, 1265, 1266, 1309, 1309,
     1266, 1262, 1318, 1269, 1264, 1230, 1230, 1230, 1284, 1284,
     1284, 1269, 1265, 1308, 1308, 1308, 1266, 1285, 1285, 1285,
     1312, 1312, 1312, 1230, 1230, 1230, 1230, 1319, 1282, 1316,
     1230, 1313, 1313, 1230, 1314, 1314, 1230, 1320, 1316, 1230,
     1247, 1247, 1247, 1286, 1286, 1286, 1322, 1330, 1330, 1284,
     1247, 1332, 1247, 1247, 1247, 1247, 1321, 1333, 1285, 1297,
     1297, 1297, 1298, 1298, 1298, 1284, 1333, 1247, 1290, 1290,

     1290, 1334, 1321, 1335, 1285, 1288, 1288, 1288, 1247, 1331,
     1331, 1286, 1336, 1337, 1286, 1288, 1339, 1288, 1288, 1288,
     1288, 1289, 1289, 1289, 1338, 1295, 1295, 1295, 1341, 1341,
     1286, 1289, 1288, 1289, 1289, 1289, 1289, 1349, 1349, 1290,
     1338, 1386, 1290, 1329, 1329, 1329, 1297, 1387, 1289, 1298,
     1299, 1299, 1299, 1396, 1397, 1290, 1293, 1293, 1293, 1398,
     1400, 1300, 1300, 1300, 1401, 1404, 1295, 1405, 1406, 1293,
     1293, 1293, 1295, 1302, 1302, 1302, 1303, 1303, 1303, 1304,
     1304, 1304, 1307, 1307, 1307, 1407, 1408, 1293, 1293, 1293,
     1293, 1299, 1299, 1409, 1293, 1410, 1411, 1293, 1412, 1414,

     1293, 1415, 1300, 1293, 1305, 1305, 1305, 1299, 1300, 1323,
     1323, 1323,  813,  812, 1305,  811, 1305, 1305, 1305, 1305,
     1304, 1304,  810, 1307,  809,  808, 1307,  805,  804,  803,
     1302, 1305,  802, 1303,  800,  799, 1304,  798,  797, 1307,
     1310, 1310, 1310,  796,  795,  794,  793, 1360, 1360, 1360,
     1323,  792,  791, 1310, 1310, 1310, 1325, 1325, 1325, 1340,
     1340, 1340,  790, 1327, 1327, 1327, 1323, 1342, 1342, 1342,
      789, 1310, 1310, 1310, 1310,  775,  773,  769, 1310,  768,
      767, 1310,  766,  765, 1310,  764,  763, 1310, 1324, 1324,
     1324, 1360, 1343, 1343, 1343,  762,  761, 1325, 1324,  760,

     1324, 1324, 1324, 1324, 1327, 1325,  759,  756, 1342, 1344,
     1344, 1344, 1327, 1325,  749, 1324, 1340,  747,  746,  745,
     1327, 1346, 1346, 1346, 1342,  744, 1350, 1350, 1350, 1324,
     1326, 1326, 1326, 1343, 1348, 1348, 1348, 1351, 1351, 1351,
     1326,  742, 1326, 1326, 1326, 1326,  738, 1344,  737, 1343,
     1344, 1352, 1352, 1352, 1355, 1355, 1355, 1326,  736,  735,
      734,  733, 1346, 1357, 1357, 1357, 1344,  731, 1346,  730,
      729, 1326, 1345, 1345, 1345, 1348,  728,  727, 1346,  726,
      725, 1348, 1345, 1350, 1345, 1345, 1345, 1345,  724,  722,
      721, 1348, 1352, 1352, 1351, 1355, 1358, 1358, 1358, 1345,

      720,  719,  718, 1355, 1357,  717,  716,  714, 1352,  713,
      712, 1355,  711, 1345, 1347, 1347, 1347,  710,  709,  707,
     1357,  702,  697,  695, 1347,  694, 1347, 1347, 1347, 1347,
      693,  692,  690,  686,  685,  684,  683, 1358,  682,  681,
      680, 1347,  679, 1358,  678,  677,  675,  673,  672,  671,
      670,  669,  668, 1358,  667, 1347, 1353, 1353, 1353,  666,
      665,  664,  663,  662,  661,  658, 1353,  650, 1353, 1353,
     1353, 1353,  648,  647,  646,  645,  644,  643,  642,  641,
      640,  639,  638, 1353,  637,  636,  635,  634,  633,  632,
      631,  630,  629,  627,  626,  625,  624, 1353,  623,  622,

      621,  620,  619,  618,  617,  615,  613,  612,  611,  610,
      608,  604,  603, 1353, 1354, 1354, 1354,  596,  595,  594,
      593,  592,  591,  590, 1354,  589, 1354, 1354, 1354, 1354,
      588,  587,  586,  583,  582,  581,  580,  579,  578,  577,
      576, 1354,  575,  574,  572,  571,  570,  569,  568,  567,
      566,  565,  564,  562,  561, 1354,  560,  558,  557,  556,
      555,  554,  553,  552,  551,  550,  547,  546,  545,  544,
      543, 1354, 1356, 1356, 1356,  542,  541,  540,  539,  538,
      536,  535, 1356,  534, 1356, 1356, 1356, 1356,  533,  532,
      531,  530,  529,  527,  526,  517,  516,  515,  513, 1356,

      512,  511,  510,  509,  508,  507,  506,  505,  504,  503,
      501,  499,  498, 1356,  496,  495,  494,  493,  492,  491,
      490,  489,  486,  485,  484,  483,  482,  481,  480, 1356,
     1359, 1359, 1359,  479,  478,  477,  476,  475,  473,  472,
     1359,  470, 1359, 1359, 1359, 1359,  469,  468,  467,  465,
      464,  463,  462,  461,  460,  459,  458, 1359,  457,  455,
      454,  453,  452,  451,  450,  449,  448,  447,  445,  444,
      443, 1359,  442,  441,  440,  439,  437,  436,  435,  434,
      433,  432,  431,  430,  429,  428,  427, 1359, 1362, 1362,
     1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362,

     1362, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363,
     1363, 1363, 1363, 1363, 1364, 1364, 1364, 1364, 1364, 1364,
     1364, 1364, 1364, 1364, 1364, 1364, 1364, 1365, 1365, 1365,
     1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365,
     1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366,
     1366, 1366, 1366, 1367, 1367, 1367, 1367, 1367, 1367, 1367,
     1367, 1367, 1367, 1367, 1367, 1367, 1368, 1368, 1368, 1368,
     1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1369,
     1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369,
     1369, 1369, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370,

     1370, 1370, 1370, 1370, 1370, 1371, 1371, 1371, 1371, 1371,
     1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1372, 1372,
     1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
     1372, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
     1373, 1373, 1373, 1373, 1374, 1374, 1374, 1374, 1374, 1374,
     1374, 1374, 1374, 1374, 1374, 1374, 1374, 1375, 1375, 1375,
     1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
     1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
     1376, 1376, 1376, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
     1377, 1377, 1377, 1377, 1377, 1377, 1378, 1378, 1378, 1378,

     1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378, 1378, 1379,
      426,  425, 1379, 1379,  423, 1379, 1379, 1379, 1379, 1379,
     1380,  422,  421, 1380, 1380, 1380, 1380, 1380, 1380, 1380,
     1380, 1381, 1381,  420, 1381, 1381, 1381, 1381, 1381, 1381,
     1381, 1381, 1381, 1381, 1382,  419,  418,  417, 1382, 1383,
      416,  415, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
      414, 1383, 1384,  413, 1384, 1384, 1384, 1385, 1385, 1388,
      412,  411, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
     1389,  410,  409, 1389, 1389, 1389, 1389, 1389, 1389, 1389,
     1389, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390,

     1390,  408, 1390, 1390, 1391, 1391, 1391, 1391, 1391, 1391,
     1391, 1391, 1391,  407, 1391, 1391, 1391, 1392, 1392, 1392,
     1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1393,  406,
      404,  403, 1393, 1394, 1394, 1395, 1395, 1395, 1395, 1395,
     1395, 1395, 1395, 1395, 1395, 1395, 1395, 1395, 1399,  402,
      401,  399,  398, 1399, 1402,  397,  396,  395,  394, 1402,
     1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
      393, 1403, 1403, 1413, 1413, 1413, 1413, 1413, 1413, 1413,
     1413, 1413, 1413, 1413,  392, 1413,  391,  389,  388,  387,
      385,  384,  382,  381,  379,  378,  377,  376,  375,  374,

      373,  372,  371,  369,  367,  366,  365,  364,  363,  362,
      361,  360,  359,  358,  357,  356,  355,  354,  352,  351,
      350,  349,  348,  346,  343,  340,  339,  338,  337,  336,
      335,  334,  333,  332,  331,  330,  328,  327,  326,  325,
      323,  322,  321,  319,  318,  317,  316,  314,  313,  312,
      311,  310,  309,  305,  304,  303,  302,  301,  300,  299,
      297,  296,  295,  294,  292,  290,  289,  288,  287,  286,
      284,  281,  280,  279,  278,  277,  276,  275,  274,  273,
      272,  271,  270,  265,  263,  262,  260,  259,  258,  257,
      255,  254,  252,  251,  250,  249,  247,  243,  239,  237,

      235,  233,  232,  231,  230,  229,  227,  226,  224,  222,
      221,  220,  219,  218,  216,  215,  214,  213,  204,  197,
      193,  189,  185,  170,  169,  167,  161,  160,  159,  157,
      156,  155,  154,  153,  151,  149,  147,  145,  144,  143,
      142,  141,  135,  124,  120,  117,  114,  109,  108,  103,
       93,   82,   80,   78,   77,   76,   74,   73,   72,   70,
       68,   62,   58,   55,   52,   45,   42,   41,   34,   33,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,

     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "../../../texk/detex/detex-src/detex.l"

#line 97 "../../../texk/detex/detex-src/detex.l"
#undef IGNORE
#undef ECHO

#define	LaBEGIN		if (fLatex) BEGIN
#define	IGNORE		Ignore()
#define INCRLINENO	IncrLineNo()
#define ECHO		Echo()
#define NOUN		if (fSpace && !fWord && !fReplace) putchar(' '); else {if (fReplace) printf("noun");}
#define VERBNOUN		if (fReplace) printf(" verbs noun"); /* puts a verb and a noun to make grammar checking work */
#define	SPACE		if (!fWord) putchar(' ')
#define	NEWLINE		LineBreak()
#define	LATEX		fLatex=!fForcetex
#define KILLARGS(x)	cArgs=x; LaBEGIN LaMacro
#define STRIPARGS(x)	cArgs=x; LaBEGIN LaMacro2
#define	CITE(x)		if (fLatex && !fCite) KILLARGS(x)

/* avoid gratuitous gcc warning from passing -D for this on command line */
#ifndef NO_MALLOC_DECL
#define NO_MALLOC_DECL
#endif

void LineBreak();
void Ignore();
void IncrLineNo();
void Echo();
void AddInclude(char *sbFile);
void ErrorExit(const char *sb1);
void UsageExit(void);
void VersionExit(void);
void IncludeFile(char *sbFile);
void InputFile(char *sbFile);
void SetEnvIgnore(const char *sbEnvList);
#ifndef KPATHSEA
void SetInputPaths(void);
#endif
void Warning(const char *sb1, const char *sb2);
int BeginEnv(const char *sbEnv);
int EndEnv(const char *sbEnv);
int InList(char *sbFile);
int SeparateList(char *sbList, char *rgsbList[] ,char chSep, int csbMax);
FILE *TexOpen(char *sbFile);
char *SafeMalloc(int cch, const char *sbMessage);
#ifndef KPATHSEA
char *getenv();
#ifndef NO_MALLOC_DECL
char	*malloc();
#endif
#ifdef OS2
void	yyless(int);
void	OS2UsageExit(void);
#endif
#endif /* KPATHSEA */

char	*rgsbEnvIgnore[MAXENVS];	/* list of environments ignored */
char	*rgsbIncList[MAXINCLIST];	/* list of includeonly files */
char	*rgsbInputPaths[MAXINPUTPATHS];	/* list of input paths in order */
char	sbCurrentIgnoredEnv[CCHMAXENV];	/* current environment being ignored */
char	*sbProgName;			/* name we were invoked with */
#ifndef NOFILE /* might be defined in <sys/param.h> */
#define NOFILE 256
#endif
FILE	*rgfp[NOFILE+1];		/* stack of input/include files */
int	cfp = 0;			/* count of files in stack */
int	cOpenBrace = 0;			/* count of `{' in <LaMacro> and <LaMacro2> */
int	cArgs = 0;			/* argument connt in <LaArgs> */
int	csbEnvIgnore;			/* count of environments ignored */
int	csbIncList = 0;			/* count of includeonly files */
int	csbInputPaths;			/* count of input paths */
int	fLatex = 0;			/* flag to indicated delatex */
int	fWord = 0;			/* flag for -w option */
int	fFollow = 1;			/* flag to follow input/include */
int	fCite = 0;			/* flag to echo \cite and \ref args */
int	fSpace = 0;			/* flag to replace \cs with space */
int	fForcetex = 0;			/* flag to inhibit latex mode */
int	fSrcLoc = 0;			/* flag to display source location of original file */
int fShowPictures = 0;	/* flag to show picture names */
int fReplace = 0;		/* flag to replace envirnments with "noun" */

int currBracesLevel = 0;
int footnoteLevel = -100;

#ifdef FLEX_SCANNER
/* flex has contexts for buffers that need to be switched when file changes
 * otherwise output contains imported files in reverse order.  Weird, but
 * true.
 */
YY_BUFFER_STATE rgsb[NOFILE + 1];		/* flex context stack */
char*			fFileNames[NOFILE + 1];	/* names of the buffers in context stack */
int				fFileLines[NOFILE + 1];	/* line number in each of the context files */
int				fIsColumn0 = 1;			/* Are we at the begining of a line? */
int				csb = 0;				/* depth of flex context stack */
#endif /* FLEX_SCANNER */



 

#line 1874 "../../../texk/detex/detex-src/detex.c"

#define INITIAL 0
#define Define 1
#define Display 2
#define IncludeOnly 3
#define Input 4
#define Math 5
#define Normal 6
#define Control 7
#define LaBegin 8
#define LaDisplay 9
#define LaEnd 10
#define LaEnv 11
#define LaFormula 12
#define LaInclude 13
#define LaSubfile 14
#define LaMacro 15
#define LaOptArg 16
#define LaMacro2 17
#define LaOptArg2 18
#define LaVerbatim 19
#define LaBreak 20
#define LaPicture 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 211 "../../../texk/detex/detex-src/detex.l"

#line 2113 "../../../texk/detex/detex-src/detex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 1362 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 1361 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 212 "../../../texk/detex/detex-src/detex.l"
/* ignore comments */	{INCRLINENO;}
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 214 "../../../texk/detex/detex-src/detex.l"
{LATEX; IGNORE;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 216 "../../../texk/detex/detex-src/detex.l"
/* environment start */	{LaBEGIN LaBegin; IGNORE;}
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 218 "../../../texk/detex/detex-src/detex.l"
{ if (BeginEnv("verbatim"))
							BEGIN LaEnv;
						    else
							BEGIN LaVerbatim;
						    IGNORE;
						}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 225 "../../../texk/detex/detex-src/detex.l"
/* verbatim mode */	{BEGIN Normal; IGNORE;}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 226 "../../../texk/detex/detex-src/detex.l"
ECHO;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 227 "../../../texk/detex/detex-src/detex.l"
ECHO;
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 229 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1);
						  if (BeginEnv("minipage"))
							BEGIN LaEnv;
						  else
							BEGIN LaMacro; /* Normal; */
						  IGNORE;
						}
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 237 "../../../texk/detex/detex-src/detex.l"
{
						  if (BeginEnv("table"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 245 "../../../texk/detex/detex-src/detex.l"
{
						  if (BeginEnv("figure"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 253 "../../../texk/detex/detex-src/detex.l"
{ if (BeginEnv(yytext))
							BEGIN LaEnv;
						    else
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
/*<LaBegin>"\n"					NEWLINE;*/
case 12:
YY_RULE_SETUP
#line 260 "../../../texk/detex/detex-src/detex.l"
{INCRLINENO;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 262 "../../../texk/detex/detex-src/detex.l"
/* absorb some environments */	{LaBEGIN LaEnd; IGNORE;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 263 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 264 "../../../texk/detex/detex-src/detex.l"
{INCRLINENO;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 266 "../../../texk/detex/detex-src/detex.l"
/* end environment */	{   if (EndEnv(yytext))
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 270 "../../../texk/detex/detex-src/detex.l"
{BEGIN LaEnv; IGNORE;}
	YY_BREAK
/*<LaEnd>"\n"					NEWLINE;*/
case 18:
YY_RULE_SETUP
#line 272 "../../../texk/detex/detex-src/detex.l"
{INCRLINENO;}
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 274 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 275 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 276 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 277 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 278 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 279 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 280 "../../../texk/detex/detex-src/detex.l"
; /* hack to fix \begin{minipage}{300pt} */
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 282 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 283 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 284 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 285 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 286 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 287 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 288 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 289 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 290 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 291 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 292 "../../../texk/detex/detex-src/detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 293 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 294 "../../../texk/detex/detex-src/detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 295 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 296 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 297 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 298 "../../../texk/detex/detex-src/detex.l"
{ LaBEGIN LaPicture; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 300 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 301 "../../../texk/detex/detex-src/detex.l"
{ if(fShowPictures) { printf("<Picture %s>", yytext); } }
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 302 "../../../texk/detex/detex-src/detex.l"
{ BEGIN Normal; INCRLINENO; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 303 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 305 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 306 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 307 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 308 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 309 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 310 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 311 "../../../texk/detex/detex-src/detex.l"
{ STRIPARGS(1); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 312 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 313 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 314 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 316 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 317 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 318 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 319 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 320 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 321 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 322 "../../../texk/detex/detex-src/detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 324 "../../../texk/detex/detex-src/detex.l"
/* ignore args  */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 325 "../../../texk/detex/detex-src/detex.l"
/* of these \cs */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 326 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 327 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1);} /* kill space before */
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 328 "../../../texk/detex/detex-src/detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 329 "../../../texk/detex/detex-src/detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 330 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 331 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 332 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1);}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 333 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1);}
	YY_BREAK
/*<Normal>"\\footnote"				{KILLARGS(1); SPACE;}*/
case 74:
YY_RULE_SETUP
#line 335 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 336 "../../../texk/detex/detex-src/detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 337 "../../../texk/detex/detex-src/detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 338 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 339 "../../../texk/detex/detex-src/detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 340 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 341 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 342 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 343 "../../../texk/detex/detex-src/detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 345 "../../../texk/detex/detex-src/detex.l"
{KILLARGS(1);}
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 347 "../../../texk/detex/detex-src/detex.l"
{
							putchar('(');
							footnoteLevel = currBracesLevel;
							++currBracesLevel;
							}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 352 "../../../texk/detex/detex-src/detex.l"
/* ignore \verb<ch>...<ch> */	{
  /* Sorry to use different formatting, but it seemed better not
     to cram all this code over in the rightmost 20 chars. */
  if (fLatex) {
    char verbchar, c;
    verbchar = input();
    if (verbchar != EOF) {
      while ((c = input()) != verbchar && c != '\n' && c != EOF) {
        putchar(c);
      }
    }
    /* would be nice to include input filenames and line numbers */
    if (verbchar == EOF || c == EOF) {
      /* do this test first in case verbchar is eof */
      ErrorExit("\\verb not complete before eof");
    }
    if (c == '\n') {
      char delim[2];
      delim[0] = verbchar;
      delim[1] = 0;
      Warning("\\verb not terminated before eol, delimiter", delim);
    }
  }
  IGNORE;
						}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 378 "../../../texk/detex/detex-src/detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 379 "../../../texk/detex/detex-src/detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 380 "../../../texk/detex/detex-src/detex.l"
{ LATEX; KILLARGS(3); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 382 "../../../texk/detex/detex-src/detex.l"
/* ignore def begin */	{BEGIN Define; IGNORE;}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 383 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 384 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 385 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 387 "../../../texk/detex/detex-src/detex.l"
/* formula mode */	{LaBEGIN LaFormula; NOUN;}
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 388 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 95:
/* rule 95 can match eol */
YY_RULE_SETUP
#line 389 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 390 "../../../texk/detex/detex-src/detex.l"
VERBNOUN;
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 391 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 393 "../../../texk/detex/detex-src/detex.l"
/* display mode */	{LaBEGIN LaDisplay; NOUN;}
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 394 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 100:
/* rule 100 can match eol */
YY_RULE_SETUP
#line 395 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 396 "../../../texk/detex/detex-src/detex.l"
VERBNOUN;
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 397 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 399 "../../../texk/detex/detex-src/detex.l"
/* display mode */	{BEGIN Display; NOUN;}
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 400 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 105:
/* rule 105 can match eol */
YY_RULE_SETUP
#line 401 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 402 "../../../texk/detex/detex-src/detex.l"
VERBNOUN;
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 403 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 405 "../../../texk/detex/detex-src/detex.l"
/* math mode */		{BEGIN Math; NOUN;}
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 406 "../../../texk/detex/detex-src/detex.l"
BEGIN Normal;
	YY_BREAK
case 110:
/* rule 110 can match eol */
YY_RULE_SETUP
#line 407 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 408 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 409 "../../../texk/detex/detex-src/detex.l"
VERBNOUN;
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 410 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 412 "../../../texk/detex/detex-src/detex.l"
/* process files */	{LaBEGIN LaInclude; IGNORE;}
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 413 "../../../texk/detex/detex-src/detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 416 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 417 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 419 "../../../texk/detex/detex-src/detex.l"
{BEGIN IncludeOnly; IGNORE;}
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 420 "../../../texk/detex/detex-src/detex.l"
AddInclude(yytext);
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 421 "../../../texk/detex/detex-src/detex.l"
{   if (csbIncList == 0)
							rgsbIncList[csbIncList++] = '\0';
						    BEGIN Normal;
						}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 425 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 426 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 428 "../../../texk/detex/detex-src/detex.l"
/* process files */	{LaBEGIN LaSubfile; IGNORE;}
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 429 "../../../texk/detex/detex-src/detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 432 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 433 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 435 "../../../texk/detex/detex-src/detex.l"
{BEGIN Input; IGNORE;}
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 436 "../../../texk/detex/detex-src/detex.l"
{   InputFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 439 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 440 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
/* escaping commands */
case 131:
YY_RULE_SETUP
#line 443 "../../../texk/detex/detex-src/detex.l"
putchar('/');
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 444 "../../../texk/detex/detex-src/detex.l"
putchar('%');
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 446 "../../../texk/detex/detex-src/detex.l"
/* handle ligatures */	{(void)printf("%.2s", yytext+1);}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 447 "../../../texk/detex/detex-src/detex.l"
{(void)printf("%.1s", yytext+1);}
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 448 "../../../texk/detex/detex-src/detex.l"
{NEWLINE;}	/*BEGIN LaBreak;*/
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 450 "../../../texk/detex/detex-src/detex.l"
/* ignore other \cs */	{BEGIN Control; IGNORE;}
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 451 "../../../texk/detex/detex-src/detex.l"
SPACE;
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 452 "../../../texk/detex/detex-src/detex.l"
NEWLINE;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 453 "../../../texk/detex/detex-src/detex.l"
IGNORE;
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 454 "../../../texk/detex/detex-src/detex.l"
{  if (yytext==NULL || strlen(yytext)==0
							|| atoi(yytext)>=0)
							NEWLINE;
						BEGIN Normal;
						}
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 460 "../../../texk/detex/detex-src/detex.l"
IGNORE;
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 461 "../../../texk/detex/detex-src/detex.l"
IGNORE;
	YY_BREAK
case 143:
/* rule 143 can match eol */
YY_RULE_SETUP
#line 462 "../../../texk/detex/detex-src/detex.l"
{BEGIN Normal; /*NEWLINE;*/}
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 463 "../../../texk/detex/detex-src/detex.l"
{++currBracesLevel;BEGIN Normal; IGNORE;}
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 464 "../../../texk/detex/detex-src/detex.l"
{BEGIN Normal; IGNORE;}
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 465 "../../../texk/detex/detex-src/detex.l"
{yyless(0);BEGIN Normal;}
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 467 "../../../texk/detex/detex-src/detex.l"
/* special characters */	IGNORE;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 468 "../../../texk/detex/detex-src/detex.l"
IGNORE;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 469 "../../../texk/detex/detex-src/detex.l"
SPACE;
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 470 "../../../texk/detex/detex-src/detex.l"
putchar('-');
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 471 "../../../texk/detex/detex-src/detex.l"
putchar('"');
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 472 "../../../texk/detex/detex-src/detex.l"
putchar('\'');
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 473 "../../../texk/detex/detex-src/detex.l"
putchar('"');
	YY_BREAK
case 154:
YY_RULE_SETUP
#line 474 "../../../texk/detex/detex-src/detex.l"
putchar('"');
	YY_BREAK
/* braces */
case 155:
YY_RULE_SETUP
#line 477 "../../../texk/detex/detex-src/detex.l"
{ ++currBracesLevel;
							}
	YY_BREAK
case 156:
YY_RULE_SETUP
#line 479 "../../../texk/detex/detex-src/detex.l"
{
							--currBracesLevel;
							if (currBracesLevel == footnoteLevel) {
								putchar(')');
								footnoteLevel = -100;
							}
							}
	YY_BREAK
case 157:
YY_RULE_SETUP
#line 486 "../../../texk/detex/detex-src/detex.l"
{   if (fWord)
							(void)printf("%s\n", yytext);
						    else
							ECHO;
						}
	YY_BREAK
case 158:
YY_RULE_SETUP
#line 491 "../../../texk/detex/detex-src/detex.l"
if (!fWord) ECHO;
	YY_BREAK
case 159:
YY_RULE_SETUP
#line 492 "../../../texk/detex/detex-src/detex.l"
{ INCRLINENO; if (!fWord) ECHO; }
	YY_BREAK
case 160:
/* rule 160 can match eol */
YY_RULE_SETUP
#line 493 "../../../texk/detex/detex-src/detex.l"
{ if (!fWord) NEWLINE; }
	YY_BREAK
case 161:
YY_RULE_SETUP
#line 494 "../../../texk/detex/detex-src/detex.l"
if (!fWord) putchar('\t');
	YY_BREAK
case 162:
YY_RULE_SETUP
#line 496 "../../../texk/detex/detex-src/detex.l"
{ BEGIN LaOptArg; }
	YY_BREAK
case 163:
YY_RULE_SETUP
#line 497 "../../../texk/detex/detex-src/detex.l"
{ cOpenBrace++; }
	YY_BREAK
case 164:
/* rule 164 can match eol */
YY_RULE_SETUP
#line 498 "../../../texk/detex/detex-src/detex.l"
{   cOpenBrace--; INCRLINENO;
						    if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							BEGIN Normal;
						    }
						}
	YY_BREAK
case 165:
YY_RULE_SETUP
#line 505 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 166:
YY_RULE_SETUP
#line 506 "../../../texk/detex/detex-src/detex.l"
BEGIN LaMacro;	
	YY_BREAK
case 167:
/* rule 167 can match eol */
YY_RULE_SETUP
#line 507 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 168:
YY_RULE_SETUP
#line 509 "../../../texk/detex/detex-src/detex.l"
{ BEGIN LaOptArg2; }
	YY_BREAK
case 169:
YY_RULE_SETUP
#line 510 "../../../texk/detex/detex-src/detex.l"
{ if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							{
							    BEGIN Normal;
							    cOpenBrace--;
							}
						    }
						  cOpenBrace++;
						}
	YY_BREAK
case 170:
YY_RULE_SETUP
#line 520 "../../../texk/detex/detex-src/detex.l"
{   cOpenBrace--; }
	YY_BREAK
case 171:
YY_RULE_SETUP
#line 521 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 172:
YY_RULE_SETUP
#line 522 "../../../texk/detex/detex-src/detex.l"
BEGIN LaMacro2;	
	YY_BREAK
case 173:
YY_RULE_SETUP
#line 523 "../../../texk/detex/detex-src/detex.l"
;
	YY_BREAK
case 174:
YY_RULE_SETUP
#line 524 "../../../texk/detex/detex-src/detex.l"
ECHO;
	YY_BREAK
#line 3173 "../../../texk/detex/detex-src/detex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Define):
case YY_STATE_EOF(Display):
case YY_STATE_EOF(IncludeOnly):
case YY_STATE_EOF(Input):
case YY_STATE_EOF(Math):
case YY_STATE_EOF(Normal):
case YY_STATE_EOF(Control):
case YY_STATE_EOF(LaBegin):
case YY_STATE_EOF(LaDisplay):
case YY_STATE_EOF(LaEnd):
case YY_STATE_EOF(LaEnv):
case YY_STATE_EOF(LaFormula):
case YY_STATE_EOF(LaInclude):
case YY_STATE_EOF(LaSubfile):
case YY_STATE_EOF(LaMacro):
case YY_STATE_EOF(LaOptArg):
case YY_STATE_EOF(LaMacro2):
case YY_STATE_EOF(LaOptArg2):
case YY_STATE_EOF(LaVerbatim):
case YY_STATE_EOF(LaBreak):
case YY_STATE_EOF(LaPicture):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 1362 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 1362 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 1361);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; // After all that talk, this was set to 1 anyways...
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 524 "../../../texk/detex/detex-src/detex.l"



/******
** main --
**	Set sbProgName to the base of arg 0.
**	Set the input paths.
**	Check for options
**		-c		echo LaTeX \cite, \ref, and \pageref values
**		-e <env-list>	list of LaTeX environments to ignore
**		-l		force latex mode
**		-n		do not follow \input and \include
**		-s		replace control sequences with space
**		-t		force tex mode
**		-w		word only output
**              -1              output some location information
**	Set the list of LaTeX environments to ignore.
**	Process each input file.
**	If no input files are specified on the command line, process stdin.
******/

int
main(int cArgs, char *rgsbArgs[])
{
	char	*pch, sbBadOpt[2];
	const char *sbEnvList = DEFAULTENV;
	int	fSawFile = 0, iArgs = 1;
	
	/* get base name and decide what we are doing, detex or delatex */
#ifdef OS2
	char drive[_MAX_DRIVE], dir[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
#ifdef __EMX__
	_wildcard(&cArgs, &rgsbArgs);
	_response(&cArgs, &rgsbArgs);
#endif
	_splitpath (rgsbArgs[0], drive, dir, fname, ext);
	sbProgName = strlwr(fname);
#elif defined(KPATHSEA)
	kpse_set_program_name (rgsbArgs[0], NULL);
	sbProgName = kpse_program_name;
#else
	if ((sbProgName = strrchr(rgsbArgs[0], '/')) != NULL)
	    sbProgName++;
	else
	    sbProgName = rgsbArgs[0];
#endif
	if (strcmp("delatex",sbProgName) == 0)
	    fLatex = 1;

#ifndef KPATHSEA
	/* set rgsbInputPaths for use with TexOpen() */
	SetInputPaths();
#endif

	/* process command line options */
	while (iArgs < cArgs && *(pch = rgsbArgs[iArgs]) == CHOPT) {
		while (*++pch)
		    switch (*pch) {
		    case CHCITEOPT:
			fCite = 1;
			break;
		    case CHENVOPT:
			if (++iArgs >= cArgs) {
				ErrorExit("-e option requires an argument");
			}
			sbEnvList = rgsbArgs[iArgs];
			break;
		    case CHLATEXOPT:
			fLatex = 1;
			break;
		    case CHNOFOLLOWOPT:
			fFollow = 0;
			break;
		    case CHSPACEOPT:
			fSpace = 1;
			break;
		    case CHTEXOPT:
			fForcetex = 1;
			break;
		    case CHWORDOPT:
			fWord = 1;
			break;
			case CHREPLACE:
			fReplace = 1;
			break;
			case CHVERSIONOPT:
			VersionExit();
			break;
			case CHSRCLOC:
			fSrcLoc = 1;
			break;
		    default:
			sbBadOpt[0] = *pch;
			sbBadOpt[1] = '\0';
			Warning("unknown option ignored -", sbBadOpt);
			UsageExit();
		    }
		iArgs++;
	}
	SetEnvIgnore(sbEnvList);

#ifdef WIN32
	_setmode(fileno(stdout), _O_BINARY);
#endif

	/* process input files */
	for (; iArgs < cArgs; iArgs++) {
	    fSawFile++;
	    if ((yyin = TexOpen(rgsbArgs[iArgs])) == NULL) {
		Warning("can't open file", rgsbArgs[iArgs]);
		continue;;
	    }
		fFileNames[csb] = rgsbArgs[iArgs];
		fFileLines[csb] = 1;
	    BEGIN Normal;
	    (void)yylex();
	}

	/* if there were no input files, assume stdin */
	if (!fSawFile) {
	    yyin = stdin;
#ifdef OS2
	    if (isatty(fileno(stdin)))
		OS2UsageExit();
#endif
	    BEGIN Normal;
	    (void)yylex();
	}
#ifndef FLEX_SCANNER
	if (YYSTATE != Normal)
	    ErrorExit("input contains an unterminated mode or environment");
#endif
	return(0);
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

/******
** yywrap -- handles EOF for lex.  Check to see if the stack of open files
**	has anything on it.  If it does, set yyin to the to value.  If not
**	return the termination signal for lex.
******/

int
yywrap(void)
{
	(void)fclose(yyin);
#ifdef FLEX_SCANNER
        /* Pop context state */
	if (csb > 0) {
		free(fFileNames[csb]);
		yy_delete_buffer(YY_CURRENT_BUFFER );
		yy_switch_to_buffer(rgsb[--csb] );
	}
#endif /* FLEX_SCANNER */
	if (cfp > 0) {
	    yyin = rgfp[--cfp];
	    return(0);
	}
	return(1);
}

#ifdef OS2

/******
** yyless -- return characters to the input stream.  Some systems don't have
**	a yyless routine
******/

void
yyless(int n)
{
	int 	i = strlen(yytext);

	while (i > n) unput(yytext[--i]);
	yytext[yyleng = n] = '\0';
}
#endif

/******
** PrintPrefix -- In case fSrcLoc is 1 and we are about to
**	print the first column of a line, we want to output the location of
**	that line in the original LaTeX document it came from.
******/

void
PrintPrefix()
{
	if (fSrcLoc && fIsColumn0) {
		printf("%s:%d: ", fFileNames[csb], fFileLines[csb]);
		fIsColumn0 = 0;
	}
}

/******
** LineBreak -- choses the proper way to break a line. If '-1' option is
**	enabled we also want to output some source location information.
******/

void
LineBreak()
{
	if (fWord) return;
	PrintPrefix();
	putchar('\n');
	fFileLines[csb]++; fIsColumn0=1;
}

/******
** Echo -- If we are at column 0 and have specified '-1'; output 
**	the source location information.
******/

void
Echo()
{
	PrintPrefix();
	fprintf(yyout, "%s", yytext);
}

/******
** IncrLineNo -- Increase the correct linenumber counter and
**	reset the the 'fIsColumn0' to true.
******/

void
IncrLineNo()
{
	char *c;
	for (c=yytext; *c != '\0'; c++) {
		if (*c == '\n') {
			fFileLines[csb]++; fIsColumn0=1;
		}
	}
}

/******
** Ignore -- Since we might need to track source location information we
**	cannot just ignore text. We must at least increase the linenumber counter.
******/

void 
Ignore()
{
	IncrLineNo();
	if (fSpace && !fWord) putchar(' ');
}

/******
** SetEnvIgnore -- sets rgsbEnvIgnore to the values indicated by the
**	sbEnvList.
******/

void
SetEnvIgnore(const char *sbEnvList)
{
	char *sb;
	sb = SafeMalloc(strlen(sbEnvList) + 1, "malloc for SetEnvIgnore failed");
	(void) strcpy(sb, sbEnvList);

	
	csbEnvIgnore = SeparateList(sb, rgsbEnvIgnore, CHENVSEP, MAXENVS);
	if (csbEnvIgnore == my_ERROR)
	    ErrorExit("The environment list contains too many environments");
}

/******
** BeginEnv -- checks to see if sbEnv is in the list rgsbEnvIgnore.  If it
**	is, sbCurrentIgnoredEnv is set to sbEnv.
******/

int
BeginEnv(const char *sbEnv)
{
	int	i;

	if (!fLatex) return(0);
	for (i = 0; i < csbEnvIgnore; ++i)
	    if (strcmp(sbEnv, rgsbEnvIgnore[i]) == 0) {
			(void)strcpy(sbCurrentIgnoredEnv, sbEnv);
			return(1);
	    }
	return(0);
}

/******
** EndEnv -- checks to see if sbEnv is the current environment being ignored.
******/

int
EndEnv(const char *sbEnv)
{
	if (!fLatex) return(0);
	if (strcmp(sbEnv, sbCurrentIgnoredEnv) == 0)
	    return(1);
	return(0);
}

/******
** InputFile -- push the current yyin and open sbFile.  If the open fails,
**	the sbFile is ignored.
******/


void
InputFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\input file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	} 
#ifdef FLEX_SCANNER
	rgsb[csb++]     = YY_CURRENT_BUFFER;
	fFileLines[csb] = 1;
	fFileNames[csb] = strdup(sbFile);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** IncludeFile -- if sbFile is not in the rgsbIncList, push current yyin
**	and open sbFile.  If the open fails, the sbFile is ignored.
******/

void
IncludeFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	if (!InList(sbFile))
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\include file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	}
#ifdef FLEX_SCANNER
	rgsb[csb++]     = YY_CURRENT_BUFFER;
	fFileLines[csb] = 1;
	fFileNames[csb] = strdup(sbFile);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** AddInclude -- adds sbFile to the rgsbIncList and increments csbIncList.
**	If the include list is too long, sbFile is ignored.
******/

void
AddInclude(char *sbFile)
{
	if (!fFollow)
	    return;
	if (csbIncList >= MAXINCLIST)
	    Warning("\\includeonly list is too long, ignoring", sbFile);
	rgsbIncList[csbIncList] = SafeMalloc(strlen(sbFile) + 1, "malloc for AddInclude failed");
	(void)strcpy(rgsbIncList[csbIncList++], sbFile);
}

/******
** InList -- checks to see if sbFile is in the rgsbIncList.  If there is
**	no list, all files are assumed to be "in the list".
******/

int
InList(char *sbFile)
{
	char	*pch, sbBase[PATH_MAX];
	int	i;

	if (csbIncList == 0)	/* no list */
	    return(1);
	(void)strcpy(sbBase, sbFile);
	if ((pch = strrchr(sbBase, '.')) != NULL)
	    *pch = '\0';
	i = 0;
	while ((i < csbIncList) && rgsbIncList[i])
	    if (strcmp(rgsbIncList[i++], sbBase) == 0)
	        return(1);
	return(0);
}

#ifndef KPATHSEA
/******
** SetInputPaths -- sets rgsbInputPaths to the values indicated by the
**	TEXINPUTS environment variable if set or else DEFAULTINPUTS.  If
**	the user's TEXINPUTS has a leading ':' prepend the DEFAULTINPUTS
**	to the path, if there is a trailing ':' append the DEFAULTINPUTS.
**	This is consistent with the most recent TeX.  However, this
**	routine does not honor the '//' construct (expand subdirs).
******/

void
SetInputPaths(void)
{
	const char *sb;
	char *sbPaths;
	int cchDefaults, cchPaths;

	cchDefaults = strlen(DEFAULTINPUTS);
#ifdef OS2
	if ((sb = getenv("TEXINPUT")) == NULL)
#endif
	    if ((sb = getenv("TEXINPUTS")) == NULL)
		sb = DEFAULTINPUTS;
	cchPaths = strlen(sb);
	if (sb[0] == CHPATHSEP)
	    cchPaths += cchDefaults;
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    cchPaths += cchDefaults;
	sbPaths = SafeMalloc(cchPaths + 1, "malloc for SetInputPaths failed");
	sbPaths[0] = '\0';
	if (sb[0] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);
	(void)strcat(sbPaths, sb);
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);

	csbInputPaths = SeparateList(sbPaths, rgsbInputPaths, CHPATHSEP, MAXINPUTPATHS);
	if (csbInputPaths == my_ERROR)
#ifdef OS2
	    ErrorExit("TEXINPUT(S) environment variable has too many paths");
#else
	    ErrorExit("TEXINPUTS environment variable has too many paths");
#endif
}
#endif

/******
** SeparateList -- takes a chSep separated list sbList, replaces the
**	chSep's with NULLs and sets rgsbList[i] to the beginning of
**	the ith word in sbList.  The number of words is returned.  A
**	my_ERROR is returned if there are more than csbMax words.
******/

int
SeparateList(char *sbList, char *rgsbList[], char chSep, int csbMax)
{
	int	csbList = 0;

	while (sbList && *sbList && csbList < csbMax) {
	    rgsbList[csbList++] = sbList;
	    if ((sbList = strchr(sbList, chSep))) {
			*sbList++ = '\0';
		}
	}
	return(sbList && *sbList ? my_ERROR : csbList);
}

/******
** TexOpen -- tries to open sbFile in each of the rgsbInputPaths in turn.
**	For each input path the following order is used:
**		file.tex - must be as named, if not there go to the next path
**		file.ext - random extension, try it
**		file     - base name, add .tex and try it
**		file     - try it as is
**	Notice that if file exists in the first path and file.tex exists in
**	one of the other paths, file in the first path is what is opened.
**	If the sbFile begins with a '/', no paths are searched.
******/

FILE *
TexOpen(char *sbFile)
{
	char	*sbNew;
#ifndef KPATHSEA
	char	*pch;
	FILE	*fp;
	int	iPath;
	static char	sbFullPath[PATH_MAX];

	for (iPath = 0; iPath < csbInputPaths; iPath++) {
#ifdef OS2
	    if (*sbFile == '/' || *sbFile == '\\' || strchr(sbFile, ':')) {	/* absolute path */
#else
	    if (*sbFile == '/') {	/* absolute path */
#endif
			(void)snprintf(sbFullPath, PATH_MAX-1, "%s", sbFile);
			iPath = csbInputPaths;	/* only check once */
	    } else {
			(void)snprintf(sbFullPath, PATH_MAX-1, "%s/%s", rgsbInputPaths[iPath], sbFile);
		}
#ifdef OS2
	    pch = sbFullPath;
	    while (pch = strchr(pch, '\\')) {
			*pch = '/';
		}
#endif

	    /* If sbFile ends in .tex then it must be there */
	    if ((pch = strrchr(sbFullPath, '.')) != NULL
			&& (strcmp(pch, ".tex") == 0)) {
			if ((fp = fopen(sbFullPath, "r")) != NULL)
				return(fp);
			else
				continue;
	    }

	    /* if .<ext> then try to open it.  the '.' represents   */
	    /* the beginning of an extension if it is not the first */
	    /* character and it does not follow a '.' or a '/'      */
	    if (pch != NULL && pch > &(sbFullPath[0])
                    && *(pch - 1) != '.' && *(pch - 1) != '/'
		    && (fp = fopen(sbFullPath, "r")) != NULL) {
			return(fp);
		}

	    /* just base name, add .tex to the name */
	    sbNew = SafeMalloc(strlen(sbFullPath) + 5, "malloc for TexOpen failed");
	    (void)strcpy(sbNew, sbFullPath);
	    (void)strcat(sbNew, ".tex");
	    if ((fp = fopen(sbNew, "r")) != NULL) {
			free(sbNew);
			return(fp);
		}
		free(sbNew);

	    /* try sbFile regardless */
	    if ((fp = fopen(sbFullPath, "r")) != NULL)
			return(fp);
	}
	return NULL;
#else
	sbNew = kpse_find_file (sbFile, kpse_tex_format, false);

	if (sbNew == NULL)
	    return NULL;

	return fopen (sbNew, "r");
#endif
}

/******
** SafeMalloc -- wrapper around malloc() to check for failure.
******/

char *
SafeMalloc(int cch, const char *sbMessage)
{
	char *sb;

	if ((sb = (char *)malloc((unsigned)cch)) == NULL)
	    ErrorExit(sbMessage);
	return(sb);
}

/******
** Warning -- print a warning message preceded by the program name.
******/

void
Warning(const char *sb1, const char *sb2)
{
	(void)fprintf(stderr, "%s: warning: %s %s\n", sbProgName, sb1, sb2);
}

/******
** ErrorExit -- print an error message preceded by the program name.
**	Stdout is flushed and detex exits.
******/

void
ErrorExit(const char *sb1)
{
	(void)fflush(stdout);
	(void)fprintf(stderr, "%s: error: %s\n", sbProgName, sb1);
	exit(1);
}

/******
** UsageExit -- print usage message and exit.
******/

void
UsageExit(void)
{
	(void)printf("\n%s [ -clnrstw1 ] [ -e environment-list ] [ filename[.tex] ... ]\n",
		sbProgName);
	puts("Strip (La)TeX commands from the input.\n\n  \
-c  echo LaTeX \\cite, \\ref, and \\pageref values\n  \
-e  <env-list> list of LaTeX environments to ignore\n  \
-l  force latex mode\n  \
-n  do not follow \\input, \\include and \\subfile\n  \
-r  replace math with \"noun\" and \"noun verbs noun\" to preserve grammar\n  \
-s  replace control sequences with space\n  \
-t  force tex mode\n  \
-w  word only output\n  \
-1  outputs the original file name and line number in the beginning of each line\n  \
-v  show program version and exit\n\
\n\
opendetex home page: https://github.com/pkubowicz/opendetex");
	(void)printf("opendetex version %s\n", VERSION);
	exit(0);
}

/******
** VersionExit -- print version and exit.
******/

void
VersionExit(void)
{
	(void)printf("\nopendetex version %s\n", VERSION);
	exit(0);
}

