/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.impl.NamespaceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemNamespaceStore
implements Iterable<NamespaceImpl> {
    private Map<String, NamespaceImpl> namespacesMap = new LinkedHashMap<String, NamespaceImpl>(16);

    public String getNamespace(String prefix) {
        String result = null;
        NamespaceImpl namespace = this.namespacesMap.get(prefix);
        if (namespace != null) {
            result = namespace.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name) {
        NamespaceImpl ns = this.namespacesMap.get(prefix);
        if (ns != null) {
            ns.setName(name);
        } else {
            this.namespacesMap.put(prefix, new NamespaceImpl(prefix, name));
        }
    }

    public void removeNamespace(String prefix) {
        this.namespacesMap.remove(prefix);
    }

    @Override
    public Iterator<NamespaceImpl> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        this.namespacesMap.clear();
    }
}

