/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import org.gnu.pilotlink.Record;

public class MidiRecord
extends Record {
    private byte[] midi;
    private String name;
    private static String id = "PMrc";

    public MidiRecord() {
        this.midi = new byte[1];
        this.name = "";
    }

    @Override
    public byte[] getBuffer() {
        int n = this.name.length() + 1 + 6;
        byte[] byArray = new byte[n + this.midi.length];
        MidiRecord.setStringAt(byArray, id, 0);
        byArray[4] = (byte)n;
        byArray[5] = 0;
        MidiRecord.setStringAt(byArray, this.name, 6);
        for (int i = 0; i < this.midi.length; ++i) {
            byArray[n + i] = this.midi[i];
        }
        return byArray;
    }

    public void setName(String string) {
        this.name = string;
        this.setSize(this.midi.length + 2 + id.length() + this.name.length() + 1);
    }

    public String getName() {
        return this.name;
    }

    public void setMidi(byte[] byArray) {
        this.midi = byArray;
        this.setSize(this.midi.length + 2 + id.length() + this.name.length() + 1);
    }

    public byte[] getMidi() {
        return this.midi;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.name = MidiRecord.getStringAt(byArray, 6);
        byte by = byArray[4];
        this.midi = new byte[byArray.length - by];
        for (int i = 0; i < this.midi.length; ++i) {
            this.midi[i] = byArray[i + by];
        }
        this.setSize(byArray.length);
    }

    public MidiRecord(Record record) {
        super(record);
    }
}

