/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.modify.add;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.webclient.properties.RDFFormatPropertyEditor;
import org.openrdf.http.webclient.repository.modify.add.RDFUpload;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddController
extends SimpleFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.registerCustomEditor(RDFFormat.class, (PropertyEditor)new RDFFormatPropertyEditor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception, IOException {
        ModelAndView result = null;
        this.logger.info("Uploading data...");
        RDFUpload rdfUpload = (RDFUpload)command;
        InputStream in = rdfUpload.getInputStream();
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            conn.add(in, rdfUpload.getBaseUri(), rdfUpload.getFormat(), new Resource[0]);
            conn.commit();
            this.logger.info("Upload committed.");
        }
        catch (RDFParseException e) {
            this.logger.warn("Unable to upload file {}", (Object)e.getMessage());
            errors.rejectValue("contents", "repository.modify.add.error", (Object[])new String[]{e.getMessage()}, "Malformed document");
        }
        catch (RepositoryException e) {
            this.logger.error("Unable to upload file", (Throwable)e);
            errors.reject("repository.error");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                in.close();
            }
        }
        result = errors.hasErrors() ? this.showForm(request, response, errors, errors.getModel()) : new ModelAndView(this.getSuccessView(), "actionResult", (Object)rdfUpload.getI18n());
        return result;
    }

    protected Map<String, Object> referenceData(HttpServletRequest arg0) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TreeMap<String, String> rdfFormats = new TreeMap<String, String>();
        for (RDFParserFactory factory : RDFParserRegistry.getInstance().getAll()) {
            RDFFormat format = factory.getRDFFormat();
            rdfFormats.put(format.getName(), format.getName());
        }
        result.put("formats", rdfFormats);
        return result;
    }
}

