.\" radeonhd.man based on formatting used in the xf86-video-{ati,nv} radeon.man, nv.man
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.\"
.\"
.TH RADEONHD __drivermansuffix__ __vendorversion__
.\"
.\"
.SH NAME
radeonhd \- AMD GPG (ATI) R5xx/R6xx video driver
.\"
.\"
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qradeonhd\*q"
\ \ ...
.B EndSection
.fi
.\"
.\"
.SH DESCRIPTION
.B radeonhd
is an __xservername__ driver for AMD GPG (ATI) R5xx/R6xx/R7xx based video cards.

At the time of this writing,
.B radeonhd
has the following limitations:
.\".TP "\w'\fB\(bu\fR'u+1n"
.TP 2
\(bu
On R6xx and R7xx based cards:
.B NO
support for hardware-based 2D & 3D acceleration, no support for Xvideo.
.TP
\(bu
No TV and Component connector support so far.
.TP
\(bu
After using the
.I fglrx
driver,
.B radeonhd
might fail to work properly. This combination is not and probably will never be
supported.  A reboot fixes problems in most cases, sometimes a powercycle is
necessary.  Unloading the kernel module is typically not enough.
.PP
A more up-to-date list can be found on the wiki page.
.PP
.\"
.SH SUPPORTED HARDWARE
The
.B radeonhd
driver supports video cards based on the following ATI chips:
.PP
.PD 0
.\" This list is generated from the RHDIdentify() function in src/rhd_id.c.
.\" START_DEVICE_LIST marker - do not delete
.TP 8
.B RV505
Radeon X1550, X1550 64bit
.TP 8
.B RV515
Radeon X1300, X1550, X1600; FireGL V3300, V3350
.TP 8
.B RV516
Radeon X1300, X1550, X1550 64-bit, X1600; FireMV 2250
.TP 8
.B R520
Radeon X1800; FireGL V5300, V7200, V7300, V7350
.TP 8
.B RV530
Radeon X1300 XT, X1600, X1600 Pro, X1650; FireGL V3400, V5200
.TP 8
.B RV535
Radeon X1300, X1650
.TP 8
.B RV550
Radeon X2300 HD
.TP 8
.B RV560
Radeon X1650
.TP 8
.B RV570
Radeon X1950, X1950 GT; FireGL V7400
.TP 8
.B R580
Radeon X1900, X1950; AMD Stream Processor
.TP 8
.B R600
Radeon HD 2900 GT/Pro/XT; FireGL V7600/V8600/V8650
.TP 8
.B RV610
Radeon HD 2350, HD 2400 Pro/XT, HD 2400 Pro AGP; FireGL V4000
.TP 8
.B RV620
Radeon HD 3450, HD 3470
.TP 8
.B RV630
Radeon HD 2600 LE/Pro/XT, HD 2600 Pro/XT AGP; Gemini RV630;
FireGL V3600/V5600
.TP 8
.B RV635
Radeon HD 3650, HD 3670
.TP 8
.B RV670
Radeon HD 3690, 3850, HD 3870, FireGL V7700, FireStream 9170
.TP 8
.B R680
Radeon HD 3870 X2
.TP 8
.B M52
Mobility Radeon X1300
.TP 8
.B M54
Mobility Radeon X1400; M54-GL
.TP 8
.B M56
Mobility Radeon X1600; Mobility FireGL V5200
.TP 8
.B M58
Mobility Radeon X1800, X1800 XT; Mobility FireGL V7100, V7200
.TP 8
.B M62
Mobility Radeon X1350
.TP 8
.B M64
Mobility Radeon X1450, X2300
.TP 8
.B M66
Mobility Radeon X1700, X1700 XT; FireGL V5250
.TP 8
.B M68
Mobility Radeon X1900
.TP 8
.B M71
Mobility Radeon HD 2300
.TP 8
.B M72
Mobility Radeon HD 2400; Radeon E2400
.TP 8
.B M74
Mobility Radeon HD 2400 XT
.TP 8
.B M76
Mobility Radeon HD 2600;
(Gemini ATI) Mobility Radeon HD 2600 XT
.TP 8
.B M82
Mobility Radeon HD 3400
.TP 8
.B M86
Mobility Radeon HD 3650, HD 3670, Mobility FireGL V5700
.TP 8
.B M88
Mobility Radeon HD 3850, HD 3850 X2, HD 3870, HD3870 X2
.TP 8
.B RS600
Radeon Xpress 1200, Xpress 1250
.TP 8
.B RS690
Radeon X1200, X1250, X1270
.TP 8
.B RS740
RS740, RS740M
.TP 8
.B RS780
Radeon HD 3100/3200/3300 Series
.TP 8
.B RV770
Radeon HD 4800 Series; Everest, K2, Denali ATI FirePro
.\" END_DEVICE_LIST marker - do not delete
.PD
.\"
.\"
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general
configuration details.
.P
This section only covers configuration options
specific to this driver, for
.BR "Section \*qDevice\*q" .
Some options may be deprecated and considered to be
removed or replaced by better implementations soon.
.\"
.TP
.BI "Option \*qAccelMethod\*q \*q" none|default|shadowfb|xaa|exa \*q
Use the indicated accleration method.
.RS
.TP 9
.PD 0
.B none
does not accelerate anything at all. Discouraged.
.TP
.B shadowfb
is a software-only acceleration technique. Does not work together with
DRI at the moment.
.TP
.B xaa
is the older but stable hardware-based acceleration technique.
.TP
.B exa
is the newer but more experimental hardware-based acceleration technique.
.RE
.RS
.PD
.PP
The default is
.BR "depending on the chipset" ,
driver version, and state of acceleration techniques and tries to give the best
user experience.
.RE
.TP
.BI "Option \*qDRI\*q"
Use this option to enable 3D acceleration using DRI (R5xx and RS6xx chips
only for the moment).
Currently, the default is
.BR off .
.TP
.BI "Option \*qOffscreenSize\*q \*q" <integer>M|<integer>% \*q
Specify the amount of framebuffer memory used for offscreen pixmaps, in
megabytes or percent of available memory. This amount of memory is not
available for DRI. Certain hardware and software limits apply. The default
is
.BR 10% .
.TP
.BI "Option \*qScaleType\*q \*q" none|center|scale|scale_keep_aspect_ratio|default \*q
Sets the scaling mode for laptop flat panels when used together with an external
screen. The scaling engine is capable of scaling both up and down.i
.RS
.TP 9
.PD 0
.B none
means to not scale at all, i.e. the image will be displayed in the top left
corner of the panel if the resolution of the external display is lower than
the panel resolution.
.TP
.B center
means not to scale but center the image on the panel i.e. apply a black frame
around the image on the panel in case the panel resolution is lower than the
one of the external display.
.TP
.B scale
means to always scale to the resolution of the external display filling
the entire panel.
.TP
.B scale_keep_aspect_ratio
scales the panel display but keeps the aspect ratio of the external display,
which means if the external display has a different aspect ratio than the
panel it black borders will be added to the top and bottom or left and right.
.TP
.B default
keeps the aspect ratio, but does not to scale otherwise.
.RE
.RS
.PD
.PP
The
.B default
is to keep the aspect ratio.
.RE
.TP
.BI "Option \*qNoRandr\*q
Disable RandR 1.2 support. This turns the driver back to use standard
modesetting behavior. The default is to
.B enable
RandR 1.2 support.
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Enable or disable the software cursor. The hardware cursor is inactive
when the software cursor is enabled. The default is
.BR off .
.TP
.BI "Option \*qForceReduced\*q \*q" boolean \*q
Force the use of reduced blanking modes. Use this if your LCD monitor does not
provide correct EDID data and you need a reduced blanking mode to drive a high
resolution mode over a single link DVI connection. The default is
.BR off .
.TP
.BI "Option \*qUnverifiedFeatures\*q \*q" boolean \*q
The
.B radeonhd
driver sometimes relies on unverified graphics card features. You can add
.B "Option \*qUnverifiedFeatures\*q \*qoff\*q"
to disable those when you run into difficulties.
.TP
.BI "Option \*qRROutputOrder\*q \*q" "list-of-outputs" \*q
.IR "RandR modesetting only" .
.br
Several legacy application rely on the Xinerama extension to determine the
primary screen. RandR returns the viewport displayed on the first attached
output of the internal table as the first Xinerama screen.
If your outputs are ordered in the wrong way, you can reorder them by adding
their names (separated by spaces or commas) to the
.IR list-of-outputs .
Typically only the first (primary) output has to be listed, remaining
outputs are added automatically. The default is
.BR none .
.TP
.BI "Option \*qIgnoreConnector\*q \*q" string \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Connector to be ignored during non-RandR modesetting. The default is
.BR none .
.TP
.BI "Option \*qUseConfiguredMonitor\*q \*q" boolean \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Use or ignore the monitor section in
.IR xorg.conf .
In standard modesetting
.B radeonhd
ignores the EDID data if a monitor section is configured.  This is different
to what most drivers behave like and a common source of configuration problems.
Thus the default is
.B off
(i.e. ignore).
.TP
.BI "Option \*qNoAccel\*q
Disable all hardware acceleration. The default is to
.B enable
hardware acceleration.
.PP
.RS
.B NOTE:
Use of this option is considered deprecated. The
.B AccelMethod
option is considered to be more flexible.
.RE
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable shadow framebuffer support. This greatly improves the
speed of unaccelerated drivers. The default depends on chipset and
acceleration state.
.PP
.RS
.B NOTE:
Use of this option is considered deprecated. The
.B AccelMethod
option is considered to be more flexible.
.RE
.TP
.BI "Option \*qHPD\*q \*q" "auto|off|normal|swap" \*q
Change the use of the hot plug detection (HPD) pins. On R5xx the according
connector tables are often broken and have to be worked around.
.RS
.TP 8
.PD 0
.B Auto
Select method depending on chipset and board
.TP
.B Off
Don't use HPD pins. Some connectors might not be able to detect connections
at all
.TP
.B Normal
Use connector table information as-is
.TP
.B Swap
Swap HPD pin 1 and 2 in connector table
.RE
.RS
.PD
.PP
.B NOTE:
Use of this option is discouraged. Whenever this option is needed to detect
connected monitors correctly, please report to the mailing list.
The default is
.BR Auto .
.RE
.TP
.BI "Option \*qForceDPI\*q \*q" integer \*q
Force the use of the specified pixel density in Dots Per Inch.
The default is
.BR "to use the monitor supplied values" .
.PP
.RS
.B NOTE:
Use of this option is discouraged. Monitors should return valid DPI values,
and the Xserver should honour them correctly.
.RE
.TP
.BI "Option \*qUseAtomBIOS\*q \*q" boolean \*q
Selects the mode setting path. The default is
.BR "chipset dependent" .
.PP
.RS
.B NOTE:
Use of this option is discouraged. The driver should select the right path. If
this option is needed to get your card working correctly, please report to the
mailing list.
.RE
.TP
.BI "Option \*qTVMode\*q \*q" tv-mode \*q
The TV standard to use on the TV output.
.RS
.TP 8
.PD 0
.B NTSC
.TP
.B NTSCJ
.TP
.B PAL
.TP
.B PALM
.TP
.B PALCN
.TP
.B PALN
.TP
.B PAL60
.TP
.B SECAM
.TP
.B CV
Composite Video
.RE
.RS
.PD
.PP
.B NOTE:
This option isn't implemented yet and has no effect.
.RE
.PP
.PD
.\"
.\"
.SH RANDR OUTPUT PROPERTIES
The following properties can be queried with
.B xrandr --prop
and some of them can be set with
.BR "xrandr --output" " <output> " --set " <property> <value> ."
Those marked with RR13 are probably merged into a RandR 1.3 standard.
Properties marked Read-Only are provided by the driver for informational
purpose only, those marked Static won't change during runtime.
.TP
.BR RANDR_SIGNAL_FORMAT "   Read-Only RR13"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA TMDS LVDS FBAS FBAS-PAL FBAS-NTSC FBAS-SECAM SVideo YPbPr
DisplayPort
.RE
.RS
.PD
.PP
Signal format / physical protocol format that is used for the specified
output.
.br
A driver MAY change this property of an output if the underlying hardware
indicates a protocol change (e.g. TV formats).  Values with dashes
.RI ( FBAS-PAL )
describe more specific versions of the base values
.RI ( FBAS )
and SHOULD be used if known to the driver.
.RE
.TP
.BR RANDR_CONNECTOR_TYPE "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA DVI DVI-I DVI-A DVI-D HDMI PANEL TV TV-FBAS TV-SVideo TV-YPbPr
TV-SCART TV-C4 DisplayPort
.RE
.RS
.PD
.PP
Connector type, as far as known to the driver.
.br
Values with dashes
.RI ( TV-FBAS )
describe more specific versions of the base values
.RI ( TV ).
The former SHOULD be used if the connector is not capable of producing other
signal formats. The later SHOULD be used if the exact connector is unknown, or
the connector is a multi-format connector that is not described otherwise.
.IR DVI ,
for instance, SHOULD be handled like a
.I DVI-I
connector, unless additional information is available to the user agent.
.I PANEL
describes laptop-internal (normally LVDS) displays.
.IR TV ,
.IR TV-SCART ,
.IR TV-YPbPr ,
and
.I TV-C4
with signal format
.I VGA
are valid combinations and describe RGB TV signals.
.RE
.TP
.BR RANDR_CONNECTOR_NUMBER "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
Outputs that route their signal to the same connector MUST have the same
connector number. Outputs with the same connector number MUST route their
signal to the same connector, except if it is 0, which indicates unknown
connectivity. 1 is called the primary connector, 2 the secondary. 3 is often a
TV connector, but that is completely driver / hardware dependent.
.br
Outputs with the same connector number SHOULD have the same connector type.
Meaning and client behavior for mismatching connector types is undefined at
the moment.
.RE
.TP
.BR RANDR_OUTPUT_NUMBER "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
A card may route one internal output to several connectors.  Connectors that
are driven by the same output cannot be driven by different Crtcs and are thus
only allowed to be used in clone mode. The driver SHOULD emit an error message
and continue as gracefully as possible if using different Crtcs for the same
internal output is requested.
.br
Internal outputs are numbered from 1, 0 indicates that output routing is
unknown.
.RE
.TP
.B RANDR_PANNING_AREA
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Format :
.RB <width> x <height>[ + <xoffset> + <yoffset>]
.RE
.RS
.PD
.PP
Specifies the panning area in RandR mode per output.
.br
It actually is a Crtc-specific property, but RandR doesn't support that yet.
As the
.B xrandr
application typically always resets the framebuffer size with every action,
.BR --fb " <width>" x <height>
has to be added on every invocation, unless there is an additional output
configured that is using this size as its resolution.
.\"
.\"
.SH KNOWN BUGS
As the
.B radeonhd
driver is still in development, some non-obvious things might not work yet. A
list of major known bugs is maintained on the wiki.  Other places to check for
known bugs and solutions are the bugtracker at
.br
.nf
\%https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/radeonhd
.br
.fi
and the mailing list archives at
\%http://lists.opensuse.org/radeonhd/
.PP
radeonhd development caused a few bugs in __xservername__ and a number
of bugs in xrandr(__appmansuffix__) to be discovered. If you are using
xrandr(__appmansuffix__) versions older than 2007-11-10, you should try
updating xrandr(__appmansuffix__).
.br
Alternatively, you can try to always specify different CRTCs for
all monitors by explicitly selecting them with
.I --crtc [0|1]
on the xrandr(__appmansuffix__) command line.
.\"
.\"
.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
The official radeonhd wiki
.RS 4
\%http://wiki.x.org/wiki/radeonhd
.RE
.IP " 2." 4
The radeonhd mailing list
.RS 4
\%http://lists.opensuse.org/radeonhd/
.RE
.IP " 3." 4
Overview about radeonhd development code
.RS 4
\%http://gitweb.freedesktop.org/?p=xorg/driver/xf86-video-radeonhd
.RE
.IP " 4." 4
Query the bugtracker for radeonhd bugs
.RS 4
.nf
\%https://bugs.freedesktop.org/query.cgi?\:product=\:xorg&\:component=\:Driver/radeonhd
.fi
.RE
.\"
.\"
.SH AUTHORS
Egbert Eich, Luc Verhaegen, Matthias Hopf, Hans Ulrich Niedermann, and others.
.\" vim: syntax=nroff
