#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2005 Insecure.Com LLC.
#
# Author: Adriano Monteiro Marques <py.adriano@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


from difflib import HtmlDiff, restore
from Diff import Diff
from xml.dom import minidom

from zenmapCore.Name import APP_DISPLAY_NAME, APP_WEB_SITE, NMAP_DISPLAY_NAME
from zenmapCore.I18N import _

class DiffHtml (HtmlDiff):
    style = '''
    table.diff {
        font-family:Courier; 
        font-size:13px; 
        border:medium; 
        border-top:1px solid; 
        border-bottom:1px solid; 
        border-left:1px solid; 
        border-right:1px solid; 
        background: #ececec;
    }
    body {
    background: #b1b1b1;
    }
    .diff_header {
        background-color:#e0e0e0;
        padding-left:2px;
        padding-right:2px;
    }
    td.diff_header {
        text-align:right;
        padding-left:2px;
        padding-right:2px;
    }
    .diff_next {
        background-color:#c0c0c0;
    }
    .diff_add {
        background-color:#aaffaa;
    }
    .diff_chg {
        background-color:#ffff77;
    }
    .diff_sub {
        background-color:#ffaaaa;
    }
    .header {
        background: #4e3f8c;
        font-weight:bold;
        font-family:Helvetica,Arial,sans-serif;
        font-size: 20px;
        color: #ececec;
        width:100%;
        border-top:1px solid;
        border-bottom:1px solid;
        border-left:1px solid;
        border-right:1px solid;
        padding-top:3px;
        padding-bottom:2px;
        padding-left:2px;
        padding-right:2px;
    }
    .normal_text {
        font-size:16px;
    }
    
    a:hover {
        text-decoration:none;
        color: black;
        font-family: Helvetica,Arial,sans-serif;
        font-weight:bold;
    }
    
    a:link {
        text-decoration:none;
        color: black;
        font-family: Helvetica,Arial,sans-serif;
        font-weight:bold;
    }
    
    a:active {
        text-decoration:none;
        color: black;
        font-family: Helvetica,Arial,sans-serif;
        font-weight:bold;
    }
    
    a:visited {
        text-decoration:none;
        color: black;
        font-family: Helvetica,Arial,sans-serif;
        font-weight:bold;
    }
    pre {
        background: white;
        border-top:1px solid;
        border-bottom:1px solid;
        border-left:1px solid;
        border-right:1px solid;
        padding-top:3px;
        padding-bottom:2px;
        padding-left:2px;
        padding-right:2px;
    }
    '''
    
    header = '''
    <center>
        <div class="header" align="center">
            ''' + _("%s - The %s frontend" % (APP_DISPLAY_NAME, NMAP_DISPLAY_NAME)) + '''<br />
            <a href="''' + APP_WEB_SITE + '''">''' + APP_WEB_SITE + '''</a>
            <p class="normal_text">''' + _("This diff was generated by %s" % APP_DISPLAY_NAME) + '''</p>
        </div>
    </center>
    <br /><br />'''
    
    def __init__ (self, result1=[''], result2=[''], \
                  column=4, wrap=50, junk='\n'):
        
        HtmlDiff.__init__ (self, column, wrap, self.line_junk)
        
        self.result1 = result1
        self.result2 = result2
        self.junk = junk
    
    def generate (self):
        self.html_file = self.make_file (self.result1, self.result2)
        self.html_file = ' '.join(self.html_file.split('&nbsp;'))
        
        txt_diff = Diff (self.result1, self.result2, self.junk)
        self.text_file = '''<br /><br />
        <!-- %s -->
        <center><div class="header" align="center">%s</div></center>
        <pre align="center">%s</pre>
        '''% (_("Changes to this file can make %s unable to read it." % APP_DISPLAY_NAME),\
              _('Regular Text Diff: '),\
              ''.join(txt_diff.generate ()))
        
        return self.insert_banner ()
    
    def save(self, file):
        try:
            self.html_file
        except:
            self.generate()

        save_desc = open(file,'w')
        save_desc.write(self.insert_banner())

        save_desc.close()
    
    def open (self, file):
        html_desc = open(file)
        html = html_desc.read()
        html_desc.close()
        
        xml = minidom.parseString(html)
        pre = xml.getElementsByTagName ('pre')[0].firstChild.data
        
        diff = Diff ()
        return diff.restore (pre)
    
    def line_junk (self, junk):
        if junk == self.junk:
            return True
        else:
            return False
    
    def insert_banner (self):
        '''insert_banner ()
        
        Insert style, header and stuff into de html file and return it.
        This methodd must not be called directily, once that the html file must
        be created first, is better to call generate or save methods.
        '''
        xml = minidom.parseString (self.html_file)
        
        xml.getElementsByTagName ('style')[0].firstChild.data = self.style
        tables = xml.getElementsByTagName ('table')
        
        for table in tables[:]:
            if table.getAttribute ('class') == 'diff':
                table.setAttribute ('align', 'center')
            else:
                table.setAttribute ('border', '0')
        
        xml = xml.toxml().split ('\n')
        try:
            xml.insert (xml.index('<body>')+1, self.header)
            xml.insert (xml.index('    </table>')+1, '<br />')
            xml.insert (xml.index('</body>'), self.text_file)
        except:
            xml.insert (1, self.header)
            xml.insert (len(xml), self.text_file)
        
        return '\n'.join(xml)

if __name__ == '__main__':
    r1 = open ('/tmp/tmpaVzZU9').readlines()
    r2 = open ('/tmp/tmpDdUaIU').readlines()
    d = DiffHtml (r1, r2)
    
    d.generate ()
    d.save ('/tmp/teste.html')
    #print '\n'.join(d.open ('/tmp/teste.html')[0])
    #print '\n'.join(d.open ('/tmp/teste.html')[1])
