
from qt import QFrame, QHBoxLayout, QVBoxLayout, QTimer, SIGNAL, QFont, QString
from kdecore import i18n
from kdeui import KPushButton, KFontDialog, KTextEdit

iconName = 'fonts'
labelText = 'KFontDialog'
docParts = ('kdeui', 'KFontDialog')
helpText = ("KDE provides a font dialog box for users to select (can you "
            "guess??) fonts.  The button below displays a font dialog box.  "
            "The font of this widget (the text widget you're reading) is used "
            "as the default.  If the dialog is accepted, the font of this "
            "widget is change to match the selection.")


fontText = """Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Etiam
ante. Nam in mauris. Vestibulum ante velit, condimentum vel, congue
sit amet, lobortis a, dui. Fusce auctor, quam non pretium nonummy, leo
ante imperdiet libero, id lobortis erat erat quis eros. Pellentesque
habitant morbi tristique senectus et netus et malesuada fames ac
turpis egestas. Cras ut metus. Vivamus suscipit, sapien id tempor
elementum, nunc quam malesuada dolor, sit amet luctus sapien odio vel
ligula. Integer scelerisque, risus a interdum vestibulum, felis ipsum
pharetra eros, nec nonummy libero justo quis risus. Vestibulum
tincidunt, augue vitae suscipit congue, sem dui adipiscing nulla, ut
nonummy arcu quam ac sem. Nulla in metus. Phasellus neque.
"""


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Font Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        self.example = KTextEdit(fontText, '', self)
        
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addWidget(self.example, 10)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showFontDialog)


    def showFontDialog(self):
        font = QFont(self.example.font())
        string = QString()
        accepted, other = KFontDialog.getFontAndText(font, string, False, self)
        if accepted:
            self.example.setFont(font)
            self.example.setText(string)
