// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
using System.IO;
using System.Xml;
using System.Collections;

namespace QtCSharp {

	public class ParseAPI {

		XmlTextReader xtr;
		ArrayList qtypes;

		public ParseAPI (string xmlfile)
		{
			xtr = new XmlTextReader (xmlfile);
			qtypes = new ArrayList ();
			Parse ();
		}

		public ArrayList QTypes
		{
			get {return qtypes;}
		}

		public void Parse ()
		{
			Hashtable typehash = new Hashtable();
			while(xtr.Read ()) {
				if (xtr.NodeType != XmlNodeType.EndElement) {
					switch(xtr.Name) {
						case "qtype":
								QType t = AddQType ();
								typehash[t.Name] = t;
							continue;
						default:
							continue;
					}
				}
			}

			foreach (QType t in qtypes) {
				t.IsQObject = IsQObject(t, typehash);
			}
		}

		public QType AddQType ()
		{
			Parser parser = new Parser (xtr.ReadOuterXml ());
			QType type = parser.GetQType ();
			qtypes.Add (type);
			return type;
		}

		private static bool IsQObject(QType t, Hashtable typehash)
		{
			if (t.IsInterface) return false;
			if (t.Name == "QObject") return true;

			foreach (QAncestor a in t.QAncestors) {
				QType at = (QType)typehash[a.Name];
				if (at == null)
					continue;
				else if (at.Name == "QObject")
					return true;
				else if (IsQObject(at, typehash))
					return true;
			}

			return false;
		}
	}
}
