/*
   ata-u.h        ATA RAID user interface for Linux

   Copyright (C) 2003 John R. Coffman  <johninsd@san.rr.com>
   All rights reserved.


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   You should have received a copy of the GNU General Public License
   (for example /usr/src/linux/COPYING); if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
	  
*/

#ifndef ATA_U_H
#define ATA_U_H

/* don't include the kernel RAID header! */
#define _MD_H

typedef unsigned int _u32;
typedef unsigned short _u16;
typedef unsigned char _u8;

#ifdef __KERNEL__
#include <asm/ioctl.h>
#else
#include <sys/ioctl.h>
#endif


#define ATARAID_MAJOR 114
#define MAJOR_ATA ATARAID_MAJOR
#define ATA_MAJOR ATARAID_MAJOR

#define ATA_MAJOR_VERSION 0
#define ATA_MINOR_VERSION 3
#define ATA_PATCHLEVEL    51

/*
 * Different major versions are not compatible.
 * Different minor versions are only downward compatible.
 * Different patchlevel versions are downward and upward compatible.
	>= 50 for beta testing
 */

typedef struct ata_version_s {
	_u32 major;
	_u32 minor;
	_u32 patchlevel;
} ata_version_t;

/* status */
#define ATA_RAID_VERSION            _IOR (ATA_MAJOR, 0x10, ata_version_t)
#define ATA_GET_ARRAY_INFO          _IOR (ATA_MAJOR, 0x11, ata_array_info_t)
#define ATA_GET_DISK_INFO           _IOR (ATA_MAJOR, 0x12, ata_disk_info_t)
#define ATA_PRINT_RAID_DEBUG        _IO (ATA_MAJOR, 0x13)


#if 0
#define RESERVED	  0UL
#define LINEAR            1UL
#define STRIPED           2UL
#define RAID0             STRIPED
#define RAID1             3UL
#define RAID5             4UL
#define TRANSLUCENT       5UL
#define LVM               6UL
#define MAX_PERSONALITY   7UL
#endif


typedef struct ata_disk_info_s {
	/*
	 * configuration/status of one particular disk
	 */
	_u32 number;		/* input - disk [0..3] */
	_u32 major;		/* output	*/
	_u32 minor;		/* output	*/

} ata_disk_info_t;


typedef struct ata_array_info_s {
	/*
	 * information about the array
	 */
	_u32 level;		/* output: 0=striped, 1=mirrored */
	_u32 size;		/* output: in sectors */
	_u32 nr_disks;		/* output: number of disks in array */
	_u32 active_disks;	/* output: number of disks active */

} ata_array_info_t;



#endif
