/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GtkClipboard
extends Clipboard {
    static final int SELECTION_RECEIVED_TIMEOUT = 5000;
    static String selection;
    static Object selectionLock;
    static boolean hasSelection;

    protected GtkClipboard() {
        super("System Clipboard");
        this.initNativeState();
    }

    public Transferable getContents(Object requestor) {
        GtkClipboard gtkClipboard = this;
        synchronized (gtkClipboard) {
            block9: {
                try {
                    if (!hasSelection) break block9;
                    Transferable transferable = this.contents;
                    Object var4_7 = null;
                    return transferable;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    throw throwable;
                }
            }
            Object var4_8 = null;
        }
        Object object = selectionLock;
        synchronized (object) {
            Transferable transferable;
            try {
                GtkClipboard.requestStringConversion();
                try {
                    selectionLock.wait(5000);
                }
                catch (InterruptedException e) {
                    Transferable transferable2 = null;
                    Object var6_12 = null;
                    return transferable2;
                }
                if (selection != null) {
                    StringSelection stringSelection = new StringSelection(selection);
                    Object var6_13 = null;
                    return stringSelection;
                }
                transferable = null;
            }
            catch (Throwable throwable) {
                Object var6_15 = null;
                throw throwable;
            }
            Object var6_14 = null;
            return transferable;
        }
    }

    void stringSelectionReceived(String newSelection) {
        Object object = selectionLock;
        synchronized (object) {
            try {
                selection = newSelection;
                selectionLock.notify();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    synchronized String stringSelectionHandler() throws IOException {
        String selection = null;
        try {
            if (this.contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                selection = (String)this.contents.getTransferData(DataFlavor.stringFlavor);
            } else if (this.contents.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                int numChars;
                StringBuffer sbuf = new StringBuffer();
                char[] readBuf = new char[512];
                InputStreamReader reader = new InputStreamReader((InputStream)this.contents.getTransferData(DataFlavor.plainTextFlavor), "UNICODE");
                while ((numChars = reader.read(readBuf)) != -1) {
                    sbuf.append(readBuf, 0, numChars);
                }
                selection = new String(sbuf);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return selection;
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        GtkClipboard.selectionGet();
        this.contents = contents;
        this.owner = owner;
        hasSelection = true;
    }

    synchronized void selectionClear() {
        hasSelection = false;
        if (this.owner != null) {
            this.owner.lostOwnership(this, this.contents);
            this.owner = null;
            this.contents = null;
        }
    }

    native void initNativeState();

    static native void requestStringConversion();

    static native void selectionGet();

    static {
        selectionLock = new Object();
        hasSelection = false;
    }
}

