/* This file is part of KBabel
   Copyright (C) 2002 Stanislav Visnovsky <visnovsky@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef TOOLSELECTIONWIDGET_H
#define TOOLSELECTIONWIDGET_H

#include "kactionselector.h"

class KDataToolInfo;

class ToolSelectionWidget : public KActionSelector
{
    Q_OBJECT
public:
    ToolSelectionWidget(QWidget* parent=0, const char* name=0 );
	
    QStringList selectedTools();
    
    void loadTools (const QStringList& commands, const QValueList<KDataToolInfo> & tools);

public slots:
    void setSelectedTools( const QStringList& tools );
    
private:
    QValueList<KDataToolInfo> _allTools;
};

#endif
