/***************************************************************************
                          kquestion.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi@asyris.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kquestion.h"
#include "kquestion.moc"

#include <qlayout.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qprogressbar.h>

KQuestion::KQuestion(QWidget *parent, const char *name ) : QFrame(parent,name),
                                                           _countdownTimer(0L)
{
    initGUI();
}

KQuestion::~KQuestion()
{
}

/** Init graphical interface */
void KQuestion::initGUI()
{
    this->setFrameShape( QFrame::Box );
    this->setFrameShadow( QFrame::Plain );
    this->setPalette( QPalette( QColor(255, 255, 255) ) );

    QHBoxLayout *form1Layout = new QHBoxLayout( this );
    form1Layout->setSpacing( 0 );
    form1Layout->setMargin( 5 );

    QVBoxLayout *picLayout=new QVBoxLayout(form1Layout);
    picLayout->setSpacing(0);
    picLayout->setMargin(0);

    _picture = new QLabel( this, "PixmapLabel1" );
    _picture->setScaledContents( FALSE );
    _picture->setPalette( QPalette( QColor(255, 255, 255) ) );
    picLayout->addWidget( _picture );

    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    picLayout->addItem( spacer );

    _countdownWidget = new QProgressBar(this);
    _countdownWidget->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,
                                                QSizePolicy::Preferred));
    picLayout->addWidget(_countdownWidget);

    _view = new QTextView( this, "TextView1" );
    _view->setFrameShape( QTextView::NoFrame );
    _view->setHScrollBarMode( QTextView::AlwaysOff );
    _view->setTextFormat( QTextView::RichText );
    _view->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, true ) );
    form1Layout->addWidget( _view );
}

/** Set text */
void KQuestion::setText( const QString &text)
{
    _view->setText( text );
}

/** Set pixmap */
void KQuestion::setPixmap( const QPixmap pixmap)
{
    _picture->setPixmap( pixmap );
}

void KQuestion::countdown(int starttime)
{
  _totalCount = starttime;
  _currentCount = starttime;
  if (starttime > 0)
  {
    if (!_countdownTimer)
    {
      _countdownTimer = new QTimer(this);
      connect(_countdownTimer, SIGNAL(timeout()),
              this, SLOT(countDownOne()));
    }
    _countdownTimer->start(1000);
    // make one step less than time passes by in seconds
    // so that the user will see when time is up
    _countdownWidget->setTotalSteps(starttime-1);
  }else{
    _countdownTimer->stop();
    _countdownWidget->reset();
  }
}

void KQuestion::countDownOne()
{
  _currentCount--;
  _countdownWidget->setProgress(_totalCount - _currentCount);

  if (_currentCount == 0)
    _countdownTimer->stop();
}

void KQuestion::countdownVisible(bool visible)
{
  if (visible)
    _countdownWidget->show();
  else
    _countdownWidget->hide();
}

/** Get current time */
int KQuestion::getCurrentTime()
{
  return _totalCount - _currentCount;
}
