/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private final LogRecord[] buffer;
    private int position;
    private int numPublished;
    private Level pushLevel;
    private final Handler target;

    public MemoryHandler() {
        this((Handler)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.target", MemoryHandler.class$("java.util.logging.Handler"), null), LogManager.getIntPropertyClamped("java.util.logging.MemoryHandler.size", 1000, 1, Integer.MAX_VALUE), LogManager.getLevelProperty("java.util.logging.MemoryHandler.push", Level.SEVERE));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public MemoryHandler(Handler target, int size, Level pushLevel) {
        if (target == null || size <= 0 || pushLevel == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = new LogRecord[size];
        this.pushLevel = pushLevel;
        this.target = target;
        this.setLevel(LogManager.getLevelProperty("java.util.logging.MemoryHandler.level", Level.ALL));
        this.setFilter((Filter)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.filter", MemoryHandler.class$("java.util.logging.Filter"), null));
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.buffer[this.position] = record;
        this.position = (this.position + 1) % this.buffer.length;
        ++this.numPublished;
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public void push() {
        if (this.numPublished < this.buffer.length) {
            for (int i = 0; i < this.position; ++i) {
                this.target.publish(this.buffer[i]);
            }
        } else {
            int i;
            for (i = this.position; i < this.buffer.length; ++i) {
                this.target.publish(this.buffer[i]);
            }
            for (i = 0; i < this.position; ++i) {
                this.target.publish(this.buffer[i]);
            }
        }
        this.numPublished = 0;
        this.position = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.push();
        this.target.close();
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level pushLevel) {
        LogManager.getLogManager().checkAccess();
        pushLevel.getClass();
        this.pushLevel = pushLevel;
    }
}

