/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public AttributedString(String str) {
        this.sci = new StringCharacterIterator(str);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String str, Map attributes) {
        this(str);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(this, attributes, 0, str.length());
    }

    public AttributedString(AttributedCharacterIterator aci) {
        this(aci, aci.getBeginIndex(), aci.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator aci, int begin_index, int end_index) {
        this(aci, begin_index, end_index, null);
    }

    public AttributedString(AttributedCharacterIterator aci, int begin_index, int end_index, AttributedCharacterIterator.Attribute[] attributes) {
        Object obj;
        Iterator iter;
        if (begin_index < 0 || end_index < begin_index) {
            throw new IllegalArgumentException("Bad index values");
        }
        StringBuffer sb = new StringBuffer("");
        Set all_attribs = aci.getAllAttributeKeys();
        if (attributes != null) {
            HashSet valid_attribs = new HashSet();
            iter = all_attribs.iterator();
            while (iter.hasNext()) {
                int i;
                obj = iter.next();
                for (i = 0; i < attributes.length && !obj.equals(attributes[0]); ++i) {
                }
                if (i == attributes.length) continue;
                valid_attribs.add(obj);
            }
            all_attribs = valid_attribs;
        }
        char c = aci.setIndex(begin_index);
        do {
            sb.append(c);
            iter = all_attribs.iterator();
            while (iter.hasNext()) {
                AttributedCharacterIterator.Attribute attrib;
                int rl;
                obj = iter.next();
                if (!(obj instanceof AttributedCharacterIterator.Attribute) || (rl = aci.getRunLimit(attrib = (AttributedCharacterIterator.Attribute)obj)) == -1) continue;
                if (rl > end_index) {
                    rl = end_index;
                }
                rl -= begin_index;
                int rs = aci.getRunStart(attrib);
                if (rs < aci.getIndex() && aci.getIndex() != begin_index) continue;
                Object attrib_obj = aci.getAttribute(attrib);
                if (rs < begin_index) {
                    if (attrib_obj instanceof Annotation) continue;
                    rs = begin_index;
                } else {
                    rs -= begin_index;
                }
                Hashtable new_map = new Hashtable();
                new_map.put(attrib, attrib_obj);
                AttributeRange[] new_list = new AttributeRange[this.attribs.length + 1];
                System.arraycopy(this.attribs, 0, new_list, 0, this.attribs.length);
                this.attribs = new_list;
                this.attribs[this.attribs.length - 1] = new AttributeRange(this, new_map, rs, rl);
            }
        } while ((c = aci.next()) != '\uffff');
        this.sci = new StringCharacterIterator(sb.toString());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value) {
        this.addAttribute(attrib, value, 0, this.sci.getEndIndex() - 1);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value, int begin_index, int end_index) {
        if (attrib == null) {
            throw new IllegalArgumentException("null attribute");
        }
        Hashtable ht = new Hashtable();
        ht.put(attrib, value);
        this.addAttributes(ht, begin_index, end_index);
    }

    public void addAttributes(Map attributes, int begin_index, int end_index) {
        if (attributes == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (begin_index < 0 || end_index > this.sci.getEndIndex() || end_index < begin_index) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] new_list = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, new_list, 0, this.attribs.length);
        this.attribs = new_list;
        this.attribs[this.attribs.length - 1] = new AttributeRange(this, attributes, begin_index, end_index);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex() - 1, null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return this.getIterator(attributes, 0, this.sci.getEndIndex() - 1);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int begin_index, int end_index) {
        if (begin_index < 0 || end_index > this.sci.getEndIndex() || end_index < begin_index) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, begin_index, end_index, attributes);
    }

    final class AttributeRange {
        private /* synthetic */ AttributedString this$0;
        Map attribs;
        int begin_index;
        int end_index;

        AttributeRange(AttributedString this$0, Map attribs, int begin_index, int end_index) {
            this.this$0 = this$0;
            this.attribs = attribs;
            this.begin_index = begin_index;
            this.end_index = end_index;
        }
    }
}

