
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by: 
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

#ifndef JAVACODEGENERATIONPOLICY_H
#define JAVACODEGENERATIONPOLICY_H

#include <qstring.h>
#include "../codegenerationpolicy.h"

class KConfig;
class CodeGenerationPolicyPage;
class JavaCodeGenerator;

class JavaCodeGenerationPolicy : public CodeGenerationPolicy
{
	Q_OBJECT
public:

	enum AccessorScope { Public=200, Private, Protected, FromParent };
	enum JavaCommentStyle { SlashStar=0, DoubleSlash };

	static const AccessorScope DEFAULT_ACCESSOR_SCOPE;
	static const JavaCommentStyle DEFAULT_COMMENT;
        static const bool DEFAULT_AUTO_GEN_EMPTY_CONSTRUCTORS;
        static const bool DEFAULT_AUTO_GEN_ACCESSORS;

	// Constructors/Destructors
	//  

	/**
	 * Constructors 
	 */
	JavaCodeGenerationPolicy ( JavaCodeGenerator * parent, CodeGenerationPolicy * defaults = 0 );
	JavaCodeGenerationPolicy ( JavaCodeGenerator * parent, KConfig * config = 0 );

	/**
	 * Empty Destructor
	 */
	virtual ~JavaCodeGenerationPolicy ( );

	// Public attributes
	//  


	// Public attribute accessor methods
	//  

	/** Get the default scope for new accessor methods. 
	 */
	AccessorScope getAccessorScope ();

	/** Set the default scope for new accessor methods. 
	*/
	void setAccessorScope (AccessorScope scope);

       /**
         * Set the value of m_autoGenerateAccessors
         * @param new_var the new value
         */
        void setAutoGenerateAccessors ( bool var );

       /**
         * Get the value of m_autoGenerateAccessors
         * @return value the boolean value of m_autoGenerateAccessors
         */
        bool getAutoGenerateAccessors( );

	/**
         * Set the value of m_autoGenerateConstructors
         * @param new_var the new value
         */
	void setAutoGenerateConstructors ( bool var ); 

       /**
         * Get the value of m_autoGenerateConstructors
         * @return value the boolean value of m_autoGenerateConstructors
         */
	bool getAutoGenerateConstructors ( );

	/**
	 * Set the value of m_commentStyle
	 * @param new_var the new value of m_commentStyle
	 */
	void setCommentStyle ( JavaCommentStyle new_var );

	/**
	 * Get the value of m_commentStyle
	 * @return the value of m_commentStyle
	 */
	JavaCommentStyle getCommentStyle ( );

        // a little utiltity method to call getParentGenerator()->getBuildANTCodeDocument()
        bool getBuildANTCodeDocument();

        // a little utility method so we can have our codegenerationpolicy page can change
        // the status of the ANT document build is
        void setBuildANTCodeDocument(bool buildIt);

        /**
         * set the defaults for this code generator from the passed generator.
         */
        virtual void setDefaults (CodeGenerationPolicy * defaults, bool emitUpdateSignal = true);

        /**
         * set the defaults from a config file for this code generator from the passed KConfig pointer.
         */
        virtual void setDefaults(KConfig * config, bool emitUpdateSignal = true);

	/**
         * write Default params to passed KConfig pointer.
         */
        virtual void writeConfig (KConfig * config);

	/**
         * Create a new dialog interface for this object.
         * @return dialog object
         */
        CodeGenerationPolicyPage * createPage ( QWidget *parent = 0, const char * name = 0);

protected:

	/**
	 */
	void init ( );

private:

        JavaCodeGenerator * m_parentCodeGenerator;

	AccessorScope m_defaultAccessorScope;
	JavaCommentStyle m_commentStyle;
	bool m_autoGenerateConstructors;
        bool m_autoGenerateAccessors;

	void initFields( JavaCodeGenerator * parent) ;

};

#endif // JAVACODEGENERATIONPOLICY_H
