#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>
#include <kgamelcd.h>

#include "common/commonprefs.h"
#include "board.h"


FEField::FEField(QWidget *parent)
    : Field(parent)
{
    QWhatsThis::add(removedList,
                    i18n("Display the number of removed groups (\"puyos\")\n"
                         "classified by depth. '-' corresponds to depth\n"
                         "higher than 3."));
    for (uint i=0; i<4; i++) {
        KGameLCD *lcd = new KGameLCD(6, removedList);
        removedList->append(lcd);
        lcd->setLeadingString(i==3 ? "-" : QString::number(i));
    }

    connect(board, SIGNAL(removedUpdated(uint, uint)),
            SLOT(removedUpdated(uint, uint)));
}

void FEField::removedUpdated(uint index, uint removed)
{
    bool detailed = ( removedList->size()==4 );
    uint i = (detailed ? index : 0);
    KGameLCD *lcd = static_cast<KGameLCD *>(removedList->lcd(i));
    uint nb = (detailed ? removed
               : static_cast<const FEBoard *>(board)->nbPuyos());
    lcd->displayInt(nb);
    if (nb) lcd->highlight();
}

void FEField::settingsChanged()
{
    Field::settingsChanged();

    bool b = CommonPrefs::showDetailedRemoved();
    if ( b && removedList->size()!=4 ) {
        removedList->clear();
        QWhatsThis::add(removedList,
                    i18n("Display the number of removed groups (\"puyos\")\n"
                         "classified by depth. '-' corresponds to depth\n"
                         "higher than 3."));
        for (uint i=0; i<4; i++) {
            KGameLCD *lcd = new KGameLCD(6, removedList);
            removedList->append(lcd);
            lcd->setLeadingString(i==3 ? "-" : QString::number(i));
            uint nb = static_cast<const FEBoard *>(board)->nbChainedPuyos(i);
            lcd->displayInt(nb);
            lcd->show();
        }
    }
    if ( !b && removedList->size()!=1 ) {
        removedList->clear();
        QWhatsThis::add(removedList,
                    i18n("Display the number of removed groups (\"puyos\")."));
        KGameLCD *lcd = new KGameLCD(6, removedList);
        removedList->append(lcd);
        uint nb = static_cast<const FEBoard *>(board)->nbPuyos();
        lcd->displayInt(nb);
        lcd->show();
    }
}
