/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FormatUnicodeCallout
extends FormatCallout {
    int unicodeMax = 0;
    int unicodeStart = 0;
    String unicodeFont = "";

    public FormatUnicodeCallout(NamePool nPool, String font, int start, int max, boolean fo) {
        super(nPool, fo);
        this.unicodeFont = font;
        this.unicodeMax = max;
        this.unicodeStart = start;
    }

    public void formatCallout(Emitter rtfEmitter, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "";
        if (userLabel != null) {
            label = userLabel;
        }
        try {
            if (userLabel == null && num <= this.unicodeMax) {
                int inName = 0;
                AttributeCollection inAttr = null;
                int[] namespaces = new int[1];
                if (!this.unicodeFont.equals("")) {
                    if (this.foStylesheet) {
                        inName = this.namePool.allocate("fo", "http://www.w3.org/1999/XSL/Format", "inline");
                        inAttr = new AttributeCollection(this.namePool);
                        inAttr.addAttribute("", "", "font-family", "CDATA", this.unicodeFont);
                    } else {
                        inName = this.namePool.allocate("", "", "font");
                        inAttr = new AttributeCollection(this.namePool);
                        inAttr.addAttribute("", "", "face", "CDATA", this.unicodeFont);
                    }
                    this.startSpan(rtfEmitter);
                    rtfEmitter.startElement(inName, (Attributes)inAttr, namespaces, 0);
                }
                char[] chars = new char[]{(char)(this.unicodeStart + num - 1)};
                rtfEmitter.characters(chars, 0, 1);
                if (!this.unicodeFont.equals("")) {
                    rtfEmitter.endElement(inName);
                    this.endSpan(rtfEmitter);
                }
            } else {
                this.formatTextCallout(rtfEmitter, callout);
            }
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in graphic formatCallout");
        }
    }
}

