#ifndef	_TRX_H
#define	_TRX_H

#include <glib.h>
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif 

typedef enum {
	MODE_MFSK16 = 0,
	MODE_MFSK8,
	MODE_RTTY,
	MODE_THROB1,
	MODE_THROB2,
	MODE_THROB4,
	MODE_BPSK31,
	MODE_QPSK31,
	MODE_MT63,
	MODE_FELD
} trx_mode_t;

extern char *trx_mode_names[];

typedef enum {
	TRX_STATE_RX = 0,
	TRX_STATE_TX,
	TRX_STATE_TUNE,
	TRX_STATE_ABORT,
	TRX_STATE_PAUSE,
	TRX_STATE_FLUSH
} trx_state_t;

extern char *trx_state_names[];

struct trx {
	trx_mode_t mode;
	trx_state_t state;

	gint samplerate;
	gint fragmentsize;

	gint afcon;
	gint squelchon;
	gint stopflag;
	gint tune;
	gint reverse;

	gfloat frequency;
	gfloat bandwidth;
	gfloat metric;
	gfloat syncpos;
	gfloat txoffset;
	gfloat sqval;

	gfloat rtty_shift;
	gfloat rtty_baud;
	gint rtty_bits;
	gint rtty_parity;
	gint rtty_stop;
	gboolean rtty_reverse;
	gboolean rtty_msbfirst;

	gint mt63_bandwidth;
	gint mt63_interleave;
	gboolean mt63_cwid;

	void *modem;

	void (*txinit) (struct trx *trx);
	void (*rxinit) (struct trx *trx);

	gint (*txprocess) (struct trx *trx);
	gint (*rxprocess) (struct trx *trx, gfloat *buf, gint len);

	void (*destructor) (struct trx *trx);
};

extern gint trx_init(void);

extern void trx_set_mode(trx_mode_t);
extern trx_mode_t trx_get_mode(void);
extern char *trx_get_mode_name(void);

extern void trx_set_state(trx_state_t);
extern void trx_set_state_wait(trx_state_t);
extern trx_state_t trx_get_state(void);

extern void trx_set_freq(gfloat);
extern gfloat trx_get_freq(void);

extern void trx_set_metric(gfloat);
extern gfloat trx_get_metric(void);

extern void trx_set_sync(gfloat);
extern gfloat trx_get_sync(void);

extern void trx_set_txoffset(gfloat);
extern gfloat trx_get_txoffset(void);

extern void trx_set_sqval(gfloat);
extern gfloat trx_get_sqval(void);

extern void trx_set_rtty_parms(gfloat, gfloat,
			       gint, gint, gint,
			       gboolean, gboolean);

extern void trx_set_mt63_parms(gint, gint, gboolean);

extern void trx_set_afc(gboolean on);
extern void trx_set_squelch(gboolean on);
extern void trx_set_reverse(gboolean on);

extern gfloat trx_get_bandwidth(void);

extern void trx_set_scope(gfloat *data, gint len, gboolean autoscale);
extern void trx_set_phase(gfloat phase, gboolean highlight);

extern void trx_put_tx_char(gint c);
extern gint trx_get_tx_char(void);

extern void trx_put_echo_char(gint c);
extern gint trx_get_echo_char(void);

extern void trx_put_rx_char(gint c);
extern gint trx_get_rx_char(void);

extern void trx_put_rx_data(gint c);
extern gint trx_get_rx_data(void);

extern gint trx_get_samplerate(void);

#ifdef __cplusplus
}
#endif 

#endif
