#ifndef _FILTER_H
#define _FILTER_H

#include "cmplx.h"

#define BufferLen	1024

/* ---------------------------------------------------------------------- */

#ifdef __i386__
#include "filter-i386.h"
#endif				/* __i386__ */

/* ---------------------------------------------------------------------- */

#ifndef __HAVE_ARCH_MAC
extern __inline__ float mac(const float *a, const float *b, unsigned int size)
{
	float sum = 0;
	unsigned int i;

	for (i = 0; i < size; i++)
		sum += (*a++) * (*b++);
	return sum;
}
#endif				/* __HAVE_ARCH_MAC */

/* ---------------------------------------------------------------------- */

struct filter {
	int length;
	int decimateratio;

	float *ifilter;
	float *qfilter;

	float ibuffer[BufferLen];
	float qbuffer[BufferLen];

	int pointer;
	int counter;
};

extern struct filter *filter_init(int len, int dec, float *ifil, float *qfil);
extern struct filter *filter_init_hilbert(int len);
extern void filter_free(struct filter *f);

extern int filter_run(struct filter *f, complex in, complex *out);
extern int filter_I_run(struct filter *f, float in, float *out);
extern int filter_Q_run(struct filter *f, float in, float *out);

/* ---------------------------------------------------------------------- */
#endif				/* _FILTER_H */
