/*
 *      fm-simple-job.c
 *      
 *      Copyright 2010 Hong Jen Yee (PCMan) <pcman.tw@gmail.com>
 *      
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#include "fm-simple-job.h"

static void fm_simple_job_finalize  			(GObject *object);
static gboolean fm_simple_job_run(FmJob *job);

G_DEFINE_TYPE(FmSimpleJob, fm_simple_job, FM_TYPE_JOB);


static void fm_simple_job_class_init(FmSimpleJobClass *klass)
{
	GObjectClass *g_object_class;
	FmJobClass* job_class = FM_JOB_CLASS(klass);
    g_object_class = G_OBJECT_CLASS(klass);
	g_object_class->finalize = fm_simple_job_finalize;

	job_class->run = fm_simple_job_run;
}


static void fm_simple_job_finalize(GObject *object)
{
	FmSimpleJob *self;

	g_return_if_fail(object != NULL);
	g_return_if_fail(FM_IS_SIMPLE_JOB(object));

	self = FM_SIMPLE_JOB(object);

	G_OBJECT_CLASS(fm_simple_job_parent_class)->finalize(object);
}


static void fm_simple_job_init(FmSimpleJob *self)
{
	
}


FmJob*	fm_simple_job_new(FmSimpleJobFunc func, gpointer user_data)
{
    FmSimpleJob* job = (FmSimpleJob*)g_object_new(FM_TYPE_SIMPLE_JOB, NULL);
    job->func = func;
    job->user_data = user_data;
	return (FmSimpleJob*)job;
}

static gboolean fm_simple_job_run(FmJob *job)
{
    FmSimpleJob* sjob = (FmSimpleJob*)job;
    return sjob->func ? sjob->func(sjob, sjob->user_data) : FALSE;
}
