/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { ErrorAlertView } from "../../components/CurrentAlerts.js";
import { Loading } from "../../components/Loading.js";
import { ErrorAlert } from "../../context/alert.js";
import { ButtonHandler } from "../../mui/handlers.js";
import { StateViewMap, compose } from "../../utils/index.js";
import { useComponentState } from "./state.js";
import { InsertLostView, InsertPendingRefreshView, UnknownView } from "./views.js";

export interface Props {
  talerExperimentUri: string | undefined;
  onCancel: () => Promise<void>;
  onSuccess: () => Promise<void>;
}

export type State = State.Loading | State.LoadingUriError | State.Unknown | State.InsertLost | State.PendingRefresh;

export namespace State {
  export interface Loading {
    status: "loading";
    error: undefined;
  }
  export interface LoadingUriError {
    status: "error";
    error: ErrorAlert;
  }
  export interface InsertLost {
    status: "insertLost";
    error: undefined;
    confirm: ButtonHandler;
    cancel: () => Promise<void>;
  }
  export interface PendingRefresh {
    status: "pendingRefresh";
    error: undefined;
    confirm: ButtonHandler;
    cancel: () => Promise<void>;
  }
  export interface Unknown {
    status: "unknown";
    experimentId: string;
    error: undefined;
  }
}

const viewMapping: StateViewMap<State> = {
  loading: Loading,
  error: ErrorAlertView,
  pendingRefresh: InsertPendingRefreshView,
  insertLost: InsertLostView,
  unknown: UnknownView,
};

export const DevExperimentPage = compose(
  "DevExperiment",
  (p: Props) => useComponentState(p),
  viewMapping,
);
