--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>

BEGIN;

SELECT _v.register_patch('libeufin-ebisync-0001', NULL, NULL);

CREATE SCHEMA libeufin_ebisync;
SET search_path TO libeufin_ebisync;

CREATE TABLE kv (
  key TEXT NOT NULL PRIMARY KEY,
  value JSONB NOT NULL
);
COMMENT ON TYPE kv
  IS 'Store key/value data that do not fit well in a traditional relational table.';

CREATE TABLE pending_ebics_transactions (
    tx_id TEXT NOT NULL UNIQUE PRIMARY KEY
);
COMMENT ON TYPE pending_ebics_transactions
  IS 'Store pending EBICS transactions ids to cleanly close them on failure.';
COMMIT;
