/* swcommon.h - Second lowest level common header file.
  
   Copyright (C) 2003-2004 James H. Lowe, Jr.  <jhlowe@acm.org>
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef swcommon_200212j_h
#define swcommon_200212j_h

#include "swuser_config.h"
#include "swuser_assert_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "usgetopt.h"
#include "swcommon0.h"
#include "swextopt.h"
#include "swverid.h"

   void swc_copyright_info(FILE * fp);

   int initExtendedOption(void);

   void debug_writeBooleanExtendedOptions(int ofd, struct extendedOptions * opta);

 
   char * initialize_options_files_list(char * usethis);

   int swc_do_preview_cmd(char * prefix, FILE * fver, char * targetpath,
			SHCMD * sshcmd, SHCMD * kill_sshcmd, char * cl_target, 
			STRAR * cmdlist, int nhops, int count,
			int opt_no_getconf, char * shellname);

   int swc_form_command_args(char * context, char * targetpath,
			STRAR * target_cmdlist, int opt_preview, int nhops,
			int opt_no_getconf, char * shellname);

   int swc_parse_soc_spec(char * arg, char ** selections, char ** target);

   int swc_open_filename(char * sourcefilename, int * open_errorp);

   char * swc_validate_targetpath(int nhops, char * targetpath,
					char * default_target, char * cwd);

   int swc_pump_line(int ofd, int ifd);

   pid_t swc_run_ssh_command( 
		SHCMD ** sshcmd, 
		STRAR * cmdlist, 
		char * path, 
		int opt_preview, 
		int nhops, 
		int * o_fdar, 
		int * i_fdar, 
		struct termios * login_orig_termiosP, 
		struct winsize * login_sizeP,  
		pid_t * pump_pid, 
		char * fork_type, int make_master_raw, 
		sigset_t * ignoreset,
		int no_fork_ok,
		int verbose_level,
		int * source_file_size,
		int opt_no_getconf,
		int * is_local_seekable_file,
		char * landing_shell,
		int error_fd,
		struct sw_logspec * logspec
		);

   int swc_analyze_status_array(pid_t * pid, int num, int * status, int debug);

   int swc_do_run_kill_cmd(SHCMD * killcmd, SHCMD *, SHCMD *, int verbose_level);

   int swc_checkbasename(char * s);

   void swc_record_pid(pid_t pid, pid_t * p_pid_array, int * p_pid_array_len,
							int verbose_level);

   void swc_handle_blocked_signals(int sig_set[][2], SHCMD * killcmd,
					int verbose_level, void (*)(int));

   char * swc_get_next_target(char ** argvector, int uargc, int * poptind,
				int * targetsfd, char * default_target, int * rem);

   mode_t swc_get_umask(void);

   char * swc_print_umask(char * buf, size_t len);

   int swc_construct_newkill_vector(SHCMD * kmd, int nhops, STRAR * tramp_list,
				 char * script_pid, int verbose_lvel);
   
   char * swc_get_terminal_host(SHCMD * sshcmd, int nhops);

   pid_t swc_fork_logger(STROB *, STROB *, int efd, int ofd, struct sw_logspec *,
			int * s_efd, int * t_efd, int verboselevel, int * pfd_array);

   SWVERID * swc_process_selection_args(char ** argvector, int uargc, int * poptind);

   void swc_flush_logger(STROB * slinebuf, STROB * tlinebuf, int efd,
			int ofd, struct sw_logspec *, int verboselevel);

   char * swc_get_pax_read_command(struct g_pax_read_command g_pax_read_commands[],
			char * keyid, int verbose_level, 
			int keep, char * paxdefault);
   int swc_open_logfile(char * logfile);
   void swc_initialize_logspec(struct sw_logspec * logspec, char * logfile, int log_level);
   

#endif
