/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999-2001 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Computer Science Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/


#include "mavlib_callbacks.h"
#include <stdio.h>

int mav_opt_trans= MAV_FALSE;
int mav_opt_delayTexture= MAV_FALSE;
MAV_list *mav_transObjList;
MAV_list **mav_textureObjList;



/* Routines to initialise the common callbacks module */

char *mav_callbacksModuleID(void)
{
  return "Common callbacks";
}

int mav_callbacksModuleInit(void)
{
  int i;

  /* add the new module */
  mav_moduleNew(mav_callbacksModuleID);

  /* define new callbacks */
  mav_callback_draw= mav_callbackNew();
  mav_callback_BB= mav_callbackNew();
  mav_callback_intersect= mav_callbackNew();
  mav_callback_id= mav_callbackNew();
  mav_callback_dump= mav_callbackNew();
  mav_callback_getUserdef= mav_callbackNew();
  mav_callback_getMatrix= mav_callbackNew();
  mav_callback_getSurfaceParams= mav_callbackNew();

  /* support delayed rendering of textured objects */
  mav_textureObjList= mav_malloc(mav_opt_maxTextures*sizeof(MAV_list *));
  for (i=0; i<mav_opt_maxTextures; i++) mav_textureObjList[i]= mav_listNew();
  mav_frameFn3Add(mav_texturedObjectsRender, NULL);

  /* support for delayed rendering of transparent objects */
  mav_transObjList= mav_listNew();
  mav_frameFn3Add(mav_transparentObjectsRender, NULL);

  return 1;
}
