/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999-2001 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Computer Science Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/

#ifndef MAV_HUD_H
#define MAV_HUD_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int nolines;
  char **line;
  int x;
  int y;
  int w;
  int h;
  float depthfac;
  int textXOffset;
  int textYOffset;
  int textYStep;
  int textFont;
  int textColour;
  int selectable;
  MAV_rectangle rect;
  MAV_object *obj;
  MAV_surfaceParams *sp;
  MAV_matrix matrix;
  void *userdef;
} MAV_hud;

extern MAV_class *mav_class_hud;

int mav_hudDraw(MAV_object *o, MAV_drawInfo *di);
int mav_hudBB(MAV_object *o, MAV_BB *bb);
int mav_hudIntersect(MAV_object *o, MAV_line *ln, MAV_objectIntersection *oi);
int mav_hudID(MAV_object *o, char **id);
int mav_hudGetUserdef(MAV_object *o, void ***ud);
int mav_hudGetMatrix(MAV_object *o, MAV_matrix **m);
int mav_hudGetSurfaceParams(MAV_object *o, MAV_surfaceParams ***sp);
int mav_hudDump(MAV_object *o);

MAV_hud *mav_hudNew(int nolines, int x, int y, int w, int h, MAV_surfaceParams *sp);



/* Module initialise */

char *mav_hudModuleID(void);
int mav_hudModuleInit(void);

#ifdef __cplusplus
}
#endif
#endif /* MAV_HUD_H */
