/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ResolveNames;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.functions.GetModuleClass;
import gnu.kawa.functions.GetNamedPart;
import gnu.kawa.reflect.SingletonType;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeElement;
import gnu.kawa.xml.NodeType;
import gnu.kawa.xml.XDataType;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.WrongArguments;
import gnu.xml.NamespaceBinding;
import gnu.xml.XMLFilter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.NamedCollator;
import gnu.xquery.util.QNameUtils;
import kawa.standard.Scheme;

public class XQResolveNames
extends ResolveNames {
    public XQParser parser;
    public static final int LAST_BUILTIN = -1;
    public static final int POSITION_BUILTIN = -2;
    public static final int HANDLE_EXTENSION_BUILTIN = -3;
    public static final int COMPARE_BUILTIN = -4;
    public static final int DISTINCT_VALUES_BUILTIN = -5;
    public static final int LOCAL_NAME_BUILTIN = -6;
    public static final int NAMESPACE_URI_BUILTIN = -7;
    public static final int COLLECTION_BUILTIN = -8;
    public static final int DOC_BUILTIN = -9;
    public static final int DOC_AVAILABLE_BUILTIN = -10;
    public static final int BASE_URI_BUILTIN = -11;
    public static final int RESOLVE_URI_BUILTIN = -12;
    public static final int RESOLVE_PREFIX_BUILTIN = -13;
    public static final int STATIC_BASE_URI_BUILTIN = -14;
    public static final int INDEX_OF_BUILTIN = -15;
    public static final int STRING_BUILTIN = -16;
    public static final int NORMALIZE_SPACE_BUILTIN = -17;
    public static final int UNORDERED_BUILTIN = -18;
    public static final int LANG_BUILTIN = -23;
    public static final int NAME_BUILTIN = -24;
    public static final int DEEP_EQUAL_BUILTIN = -25;
    public static final int MIN_BUILTIN = -26;
    public static final int MAX_BUILTIN = -27;
    public static final int NUMBER_BUILTIN = -28;
    public static final int DEFAULT_COLLATION_BUILTIN = -29;
    public static final int ID_BUILTIN = -30;
    public static final int IDREF_BUILTIN = -31;
    public static final int ROOT_BUILTIN = -32;
    public static final int CAST_AS_BUILTIN = -33;
    public static final int CASTABLE_AS_BUILTIN = -34;
    public static final int XS_QNAME_BUILTIN = -35;
    public static final int XS_QNAME_IGNORE_DEFAULT_BUILTIN = -36;
    public static final Declaration handleExtensionDecl = XQResolveNames.makeBuiltin("(extension)", -3);
    public static final Declaration castAsDecl = XQResolveNames.makeBuiltin("(cast as)", -33);
    public static final Declaration castableAsDecl = XQResolveNames.makeBuiltin("(castable as)", -34);
    public static final Declaration lastDecl = XQResolveNames.makeBuiltin("last", -1);
    public static final Declaration xsQNameDecl = XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2001/XMLSchema", "QName"), -35);
    public static final Declaration xsQNameIgnoreDefaultDecl = XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2001/XMLSchema", "(QName-ignore-default)"), -36);
    public static final Declaration staticBaseUriDecl = XQResolveNames.makeBuiltin("static-base-uri", -14);
    public static final Declaration resolvePrefixDecl = XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2001/XMLSchema", "(resolve-prefix)"), -13);
    public Namespace[] functionNamespacePath = XQuery.defaultFunctionNamespacePath;
    private Declaration moduleDecl;

    public static Declaration makeBuiltin(String string, int n) {
        return XQResolveNames.makeBuiltin(Symbol.make("http://www.w3.org/2005/xpath-functions", string, "fn"), n);
    }

    public static Declaration makeBuiltin(Symbol symbol, int n) {
        Declaration declaration = new Declaration(symbol);
        declaration.setProcedureDecl(true);
        declaration.setCode(n);
        return declaration;
    }

    public XQResolveNames() {
        this(null);
    }

    void pushBuiltin(String string, int n) {
        this.lookup.push(XQResolveNames.makeBuiltin(string, n));
    }

    public XQResolveNames(Compilation compilation) {
        super(compilation);
        this.lookup.push(lastDecl);
        this.lookup.push(xsQNameDecl);
        this.lookup.push(staticBaseUriDecl);
        this.pushBuiltin("position", -2);
        this.pushBuiltin("compare", -4);
        this.pushBuiltin("distinct-values", -5);
        this.pushBuiltin("local-name", -6);
        this.pushBuiltin("name", -24);
        this.pushBuiltin("namespace-uri", -7);
        this.pushBuiltin("root", -32);
        this.pushBuiltin("base-uri", -11);
        this.pushBuiltin("lang", -23);
        this.pushBuiltin("resolve-uri", -12);
        this.pushBuiltin("collection", -8);
        this.pushBuiltin("doc", -9);
        this.pushBuiltin("document", -9);
        this.pushBuiltin("doc-available", -10);
        this.pushBuiltin("index-of", -15);
        this.pushBuiltin("string", -16);
        this.pushBuiltin("normalize-space", -17);
        this.pushBuiltin("unordered", -18);
        this.pushBuiltin("deep-equal", -25);
        this.pushBuiltin("min", -26);
        this.pushBuiltin("max", -27);
        this.pushBuiltin("number", -28);
        this.pushBuiltin("default-collation", -29);
        this.pushBuiltin("id", -30);
        this.pushBuiltin("idref", -31);
    }

    protected void push(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.push(declaration);
        }
    }

    void push(Declaration declaration) {
        Declaration declaration2;
        Compilation compilation = this.getCompilation();
        Object object2 = declaration.getSymbol();
        boolean bl = declaration.isProcedureDecl();
        if (object2 instanceof String) {
            int n = declaration.getLineNumber();
            if (n > 0 && compilation != null) {
                String string = compilation.getFileName();
                int n2 = compilation.getLineNumber();
                int n3 = compilation.getColumnNumber();
                compilation.setLocation(declaration);
                object2 = this.parser.namespaceResolve((String)object2, bl);
                compilation.setLine(string, n2, n3);
            } else {
                object2 = this.parser.namespaceResolve((String)object2, bl);
            }
            if (object2 == null) {
                return;
            }
            declaration.setName(object2);
        }
        if ((declaration2 = this.lookup.lookup(object2, XQuery.instance.getNamespaceOf(declaration))) != null) {
            if (declaration.context == declaration2.context) {
                ScopeExp.duplicateDeclarationError(declaration2, declaration, compilation);
            } else if (XQParser.warnHidePreviousDeclaration && (!(object2 instanceof Symbol) || ((Symbol)object2).getNamespace() != null)) {
                compilation.error('w', declaration, "declaration ", " hides previous declaration");
            }
        }
        this.lookup.push(declaration);
    }

    Declaration flookup(Symbol symbol) {
        Object object2;
        Environment environment = XQuery.xqEnvironment;
        Location location2 = environment.lookup(symbol, EnvironmentKey.FUNCTION);
        if (location2 == null) {
            return null;
        }
        if ((location2 = location2.getBase()) instanceof StaticFieldLocation && (object2 = ((StaticFieldLocation)location2).getDeclaration()) != null) {
            return object2;
        }
        object2 = location2.get(null);
        if (object2 != null) {
            return XQResolveNames.procToDecl(symbol, object2);
        }
        return null;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        return this.walkReferenceExp(referenceExp, null);
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp, ApplyExp applyExp) {
        if (referenceExp.getBinding() == null) {
            Object object2 = referenceExp.getSymbol();
            boolean bl = referenceExp.isProcedureName();
            boolean bl2 = referenceExp.getFlag(16);
            int n = applyExp == null ? 1 : XQuery.namespaceForFunctions(applyExp.getArgCount());
            Declaration declaration = this.lookup.lookup(object2, n);
            if (declaration == null) {
                Symbol symbol;
                if (object2 instanceof Symbol && "".equals((symbol = (Symbol)object2).getNamespaceURI())) {
                    String string = symbol.getLocalName();
                    Expression expression = "request".equals(string) ? XQParser.makeFunctionExp("gnu.kawa.servlet.GetRequest", "getRequest") : ("response".equals(string) ? XQParser.makeFunctionExp("gnu.kawa.servlet.GetResponse", "getResponse") : null);
                    if (expression != null) {
                        return new ApplyExp(expression, Expression.noExpressions);
                    }
                } else if (object2 instanceof Symbol) {
                    declaration = this.flookup((Symbol)object2);
                } else {
                    String string = (String)object2;
                    if (string.indexOf(58) < 0) {
                        string = string.intern();
                        if (bl) {
                            for (int i = 0; i < this.functionNamespacePath.length && (declaration = this.lookup.lookup((Object)(symbol = this.functionNamespacePath[i].getSymbol(string)), n)) == null && (declaration = this.flookup(symbol)) == null; ++i) {
                            }
                        }
                    }
                    if (declaration == null && (symbol = this.parser.namespaceResolve(string, bl)) != null && (declaration = this.lookup.lookup((Object)symbol, n)) == null && (bl || bl2)) {
                        String string2 = symbol.getNamespaceURI();
                        Type type = null;
                        if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                            type = XQuery.getStandardType(symbol.getName());
                        } else if (bl2 && string2 == "" && !this.getCompilation().isPedantic()) {
                            type = Scheme.string2Type(symbol.getName());
                        }
                        if (type != null) {
                            return new QuoteExp(type).setLine(referenceExp);
                        }
                        if (string2 != null && string2.length() > 6 && string2.startsWith("class:")) {
                            ClassType classType = ClassType.make(string2.substring(6));
                            return GetNamedPart.makeExp(classType, symbol.getName());
                        }
                        declaration = this.flookup(symbol);
                    }
                }
            }
            if (declaration != null) {
                referenceExp.setBinding(declaration);
            } else if (bl) {
                this.error('e', "unknown function " + object2);
            } else if (bl2) {
                this.messages.error('e', referenceExp, "unknown type " + object2, "XPST0051");
            } else {
                this.messages.error('e', referenceExp, "unknown variable $" + object2, "XPST0008");
            }
        }
        return referenceExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Expression expression;
        Object object2;
        Expression expression2 = super.walkSetExp(setExp);
        Declaration declaration = setExp.getBinding();
        if (declaration != null && !this.getCompilation().immediate && (object2 = declaration.getSymbol()) instanceof Symbol && "http://www.w3.org/2005/xquery-local-functions".equals(((Symbol)object2).getNamespaceURI()) && (!((expression = setExp.getNewValue()) instanceof ApplyExp) || ((ApplyExp)expression).getFunction() != XQParser.getExternalFunction)) {
            declaration.setFlag(0x1000000);
            declaration.setPrivate(true);
        }
        return expression2;
    }

    private Expression walkStatements(Expression expression) {
        if (expression instanceof BeginExp) {
            BeginExp beginExp = (BeginExp)expression;
            Expression[] expressionArray = beginExp.getExpressions();
            int n = beginExp.getExpressionCount();
            for (int i = 0; i < n; ++i) {
                expressionArray[i] = this.walkStatements(expressionArray[i]);
            }
        } else if (expression instanceof SetExp) {
            Declaration declaration = this.moduleDecl;
            SetExp setExp = (SetExp)expression;
            expression = this.walkSetExp(setExp);
            if (setExp.isDefining() && setExp.getBinding() == declaration) {
                if (!declaration.isProcedureDecl()) {
                    this.push(declaration);
                }
                declaration = declaration.nextDecl();
            }
            this.moduleDecl = declaration;
        } else {
            expression = this.walk(expression);
        }
        return expression;
    }

    public void resolveModule(ModuleExp moduleExp) {
        Declaration declaration;
        this.currentLambda = moduleExp;
        for (declaration = moduleExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (!declaration.isProcedureDecl()) continue;
            this.push(declaration);
        }
        this.moduleDecl = moduleExp.firstDecl();
        moduleExp.body = this.walkStatements(moduleExp.body);
        for (declaration = moduleExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.getSymbol() == null) continue;
            this.lookup.removeSubsumed(declaration);
        }
    }

    Expression getCollator(Expression[] expressionArray, int n) {
        if (expressionArray != null && expressionArray.length > n) {
            return new ApplyExp(ClassType.make("gnu.xquery.util.NamedCollator").getDeclaredMethod("find", 1), new Expression[]{expressionArray[n]});
        }
        NamedCollator namedCollator = this.parser.defaultCollator;
        return namedCollator == null ? QuoteExp.nullExp : new QuoteExp(namedCollator);
    }

    Expression withCollator(Method method, Expression[] expressionArray, String string, int n) {
        return this.withCollator(new QuoteExp(new PrimProcedure(method)), expressionArray, string, n);
    }

    Expression withCollator(Expression expression, Expression[] expressionArray, String string, int n) {
        String string2 = WrongArguments.checkArgCount(string, n, n + 1, expressionArray.length);
        if (string2 != null) {
            return this.getCompilation().syntaxError(string2);
        }
        Expression[] expressionArray2 = new Expression[n + 1];
        System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
        expressionArray2[n] = this.getCollator(expressionArray, n);
        return new ApplyExp(expression, expressionArray2);
    }

    Expression withContext(Method method, Expression[] expressionArray, String string, int n) {
        String string2 = WrongArguments.checkArgCount(string, n, n + 1, expressionArray.length);
        if (string2 != null) {
            return this.getCompilation().syntaxError(string2);
        }
        if (expressionArray.length == n) {
            Expression[] expressionArray2 = new Expression[n + 1];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
            Declaration declaration = this.lookup.lookup((Object)XQParser.DOT_VARNAME, false);
            if (declaration == null) {
                String string3 = "undefined context for " + string;
                this.messages.error('e', string3, "XPDY0002");
                return new ErrorExp(string3);
            }
            expressionArray2[n] = new ReferenceExp(declaration);
            expressionArray = expressionArray2;
        }
        return new ApplyExp(method, expressionArray);
    }

    private Expression checkArgCount(Expression[] expressionArray, Declaration declaration, int n, int n2) {
        String string = WrongArguments.checkArgCount("fn:" + declaration.getName(), n, n2, expressionArray.length);
        if (string == null) {
            return null;
        }
        return this.getCompilation().syntaxError(string);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        int n;
        NamespaceBinding namespaceBinding;
        Object object2;
        Expression expression = applyExp.getFunction();
        NamespaceBinding namespaceBinding2 = this.parser.constructorNamespaces;
        Object object3 = applyExp.getFunctionValue();
        if (object3 instanceof MakeElement) {
            object2 = (MakeElement)object3;
            namespaceBinding = NamespaceBinding.nconc(((MakeElement)object2).getNamespaceNodes(), namespaceBinding2);
            ((MakeElement)object2).setNamespaceNodes(namespaceBinding);
            this.parser.constructorNamespaces = namespaceBinding;
        }
        expression = expression instanceof ReferenceExp ? this.walkReferenceExp((ReferenceExp)expression, applyExp) : this.walk(expression);
        applyExp.setFunction(expression);
        this.walkExps(applyExp.getArgs());
        this.parser.constructorNamespaces = namespaceBinding2;
        expression = applyExp.getFunction();
        if (expression instanceof ReferenceExp && (object2 = ((ReferenceExp)expression).getBinding()) != null && (n = ((Declaration)object2).getCode()) < 0) {
            switch (n) {
                case -2: 
                case -1: {
                    Symbol symbol = n == -1 ? XQParser.LAST_VARNAME : XQParser.POSITION_VARNAME;
                    object2 = this.lookup.lookup((Object)symbol, false);
                    if (object2 == null) {
                        this.error('e', "undefined context for " + symbol.getName());
                    } else {
                        ((Declaration)object2).setCanRead(true);
                    }
                    return new ReferenceExp(symbol, (Declaration)object2);
                }
                case -34: 
                case -33: {
                    boolean bl;
                    Object object4;
                    Expression expression2;
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression3 = expression2 = expressionArray[n == -33 ? 0 : 1];
                    if (expression2 instanceof ApplyExp && ((ApplyExp)(object4 = (ApplyExp)expression2)).getFunction().valueIfConstant() == XQParser.proc_OccurrenceType_getInstance) {
                        expression3 = ((ApplyExp)object4).getArg(0);
                    }
                    object4 = expression3.valueIfConstant();
                    String string = null;
                    if (object4 == SingletonType.getInstance()) {
                        string = "type to 'cast as' or 'castable as' must be atomic";
                    } else if (object4 == XDataType.anyAtomicType) {
                        string = "type to 'cast as' or 'castable as' cannot be anyAtomicType";
                    } else if (object4 == XDataType.anySimpleType) {
                        string = "type to 'cast as' or 'castable as' cannot be anySimpleType";
                    } else if (object4 == XDataType.untypedType) {
                        string = "type to 'cast as' or 'castable as' cannot be untyped";
                    } else if (object4 == XDataType.NotationType) {
                        string = "type to 'cast as' or 'castable as' cannot be NOTATION";
                    }
                    if (string != null) {
                        this.messages.error('e', expression2, string, "XPST0080");
                    }
                    boolean bl2 = bl = object4 == Compilation.typeSymbol && !(expression2 instanceof ApplyExp);
                    if (n == -33) {
                        if (bl) {
                            return this.walkApplyExp(XQParser.castQName(expressionArray[1], true));
                        }
                        expression = XQParser.makeFunctionExp("gnu.xquery.util.CastAs", "castAs");
                    } else {
                        if (bl && expressionArray[0] instanceof QuoteExp) {
                            object4 = ((QuoteExp)expressionArray[0]).getValue();
                            try {
                                QNameUtils.resolveQName(object4, this.parser.constructorNamespaces, this.parser.prologNamespaces);
                                return XQuery.trueExp;
                            }
                            catch (RuntimeException runtimeException) {
                                return XQuery.falseExp;
                            }
                        }
                        expression = XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "castableAs");
                    }
                    return new ApplyExp(expression, expressionArray).setLine(applyExp);
                }
                case -36: 
                case -35: {
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression4 = this.checkArgCount(expressionArray, (Declaration)object2, 1, 1);
                    if (expression4 != null) {
                        return expression4;
                    }
                    NamespaceBinding namespaceBinding3 = this.parser.constructorNamespaces;
                    if (n == -36) {
                        namespaceBinding3 = new NamespaceBinding(null, "", namespaceBinding3);
                    }
                    if (expressionArray[0] instanceof QuoteExp) {
                        try {
                            Object object5 = ((QuoteExp)expressionArray[0]).getValue();
                            object5 = QNameUtils.resolveQName(object5, namespaceBinding3, this.parser.prologNamespaces);
                            return new QuoteExp(object5);
                        }
                        catch (RuntimeException runtimeException) {
                            return this.getCompilation().syntaxError(runtimeException.getMessage());
                        }
                    }
                    Expression[] expressionArray2 = new Expression[]{expressionArray[0], new QuoteExp(namespaceBinding3), new QuoteExp(this.parser.prologNamespaces)};
                    Method method = ClassType.make("gnu.xquery.util.QNameUtils").getDeclaredMethod("resolveQName", 3);
                    ApplyExp applyExp2 = new ApplyExp(method, expressionArray2);
                    applyExp2.setFlag(2);
                    return applyExp2;
                }
                case -13: {
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression5 = this.checkArgCount(expressionArray, (Declaration)object2, 1, 1);
                    if (expression5 != null) {
                        return expression5;
                    }
                    if (expressionArray[0] instanceof QuoteExp) {
                        Object object6 = ((QuoteExp)expressionArray[0]).getValue();
                        String string = object6 == null ? null : object6.toString();
                        object6 = QNameUtils.lookupPrefix(string, this.parser.constructorNamespaces, this.parser.prologNamespaces);
                        if (object6 == null) {
                            return this.getCompilation().syntaxError("unknown namespace prefix '" + string + "'");
                        }
                        return new QuoteExp(object6);
                    }
                    Expression[] expressionArray3 = new Expression[]{expressionArray[0], new QuoteExp(this.parser.constructorNamespaces), new QuoteExp(this.parser.prologNamespaces)};
                    PrimProcedure primProcedure = new PrimProcedure(ClassType.make("gnu.xquery.util.QNameUtils").getDeclaredMethod("resolvePrefix", 3));
                    ApplyExp applyExp3 = new ApplyExp(primProcedure, expressionArray3);
                    applyExp3.setFlag(2);
                    return applyExp3;
                }
                case -6: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("localName", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:local-name", 0);
                }
                case -24: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("name", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:name", 0);
                }
                case -28: {
                    Method method = ClassType.make("gnu.xquery.util.NumberValue").getDeclaredMethod("numberValue", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:number", 0);
                }
                case -32: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("root", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:root", 0);
                }
                case -11: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("baseUri", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:base-uri", 0);
                }
                case -23: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("lang", 2);
                    return this.withContext(method, applyExp.getArgs(), "fn:lang", 1);
                }
                case -30: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("id$X", 3);
                    return this.withContext(method, applyExp.getArgs(), "fn:id", 1);
                }
                case -31: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("idref", 2);
                    return this.withContext(method, applyExp.getArgs(), "fn:idref", 1);
                }
                case -14: {
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression6 = this.checkArgCount(expressionArray, (Declaration)object2, 0, 0);
                    if (expression6 != null) {
                        return expression6;
                    }
                    return this.getBaseUriExpr();
                }
                case -7: {
                    Method method = ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("namespaceURI", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:namespace-uri", 0);
                }
                case -17: {
                    Method method = ClassType.make("gnu.xquery.util.StringUtils").getDeclaredMethod("normalizeSpace", 1);
                    return this.withContext(method, applyExp.getArgs(), "fn:normalize-space", 0);
                }
                case -18: {
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression7 = this.checkArgCount(expressionArray, (Declaration)object2, 1, 1);
                    if (expression7 != null) {
                        return expression7;
                    }
                    return expressionArray[0];
                }
                case -4: {
                    Method method = ClassType.make("gnu.xquery.util.StringUtils").getDeclaredMethod("compare", 3);
                    return this.withCollator(method, applyExp.getArgs(), "fn:compare", 2);
                }
                case -16: {
                    return this.withContext(ClassType.make("gnu.xml.TextUtils").getDeclaredMethod("asString", 1), applyExp.getArgs(), "fn:string", 0);
                }
                case -15: {
                    Method method = ClassType.make("gnu.xquery.util.SequenceUtils").getDeclaredMethod("indexOf$X", 4);
                    return this.withCollator(method, applyExp.getArgs(), "fn:index-of", 2);
                }
                case -8: {
                    Expression[] expressionArray = applyExp.getArgs();
                    ClassType classType = ClassType.make("gnu.xquery.util.NodeUtils");
                    Method method = classType.getDeclaredMethod("collection", 2);
                    Expression expression8 = this.checkArgCount(expressionArray, (Declaration)object2, 0, 1);
                    if (expression8 != null) {
                        return expression8;
                    }
                    Expression expression9 = this.getBaseUriExpr();
                    QuoteExp quoteExp = expressionArray.length > 0 ? expressionArray[0] : QuoteExp.voidExp;
                    ApplyExp applyExp4 = new ApplyExp(method, new Expression[]{quoteExp, expression9});
                    applyExp4.setType(NodeType.documentNodeTest);
                    return applyExp4;
                }
                case -10: 
                case -9: {
                    String string;
                    Expression[] expressionArray = applyExp.getArgs();
                    ClassType classType = ClassType.make("gnu.xquery.util.NodeUtils");
                    if (n == -9) {
                        string = "docCached";
                        if (XQParser.warnOldVersion && "document".equals(((Declaration)object2).getName())) {
                            this.getCompilation().error('w', "replace 'document' by 'doc'");
                        }
                    } else {
                        string = "availableCached";
                    }
                    Method method = classType.getDeclaredMethod(string, 2);
                    Expression expression10 = this.checkArgCount(expressionArray, (Declaration)object2, 1, 1);
                    if (expression10 != null) {
                        return expression10;
                    }
                    Expression expression11 = this.getBaseUriExpr();
                    ApplyExp applyExp5 = new ApplyExp(method, new Expression[]{expressionArray[0], expression11});
                    if (n == -9) {
                        applyExp5.setType(NodeType.documentNodeTest);
                    } else {
                        applyExp5.setType(XDataType.booleanType);
                    }
                    return applyExp5;
                }
                case -12: {
                    Expression[] expressionArray = applyExp.getArgs();
                    Expression expression12 = this.checkArgCount(expressionArray, (Declaration)object2, 1, 2);
                    if (expression12 != null) {
                        return expression12;
                    }
                    Expression[] expressionArray4 = new Expression[]{expressionArray[0], expressionArray.length == 1 ? this.getBaseUriExpr() : expressionArray[1]};
                    Method method = ClassType.make("gnu.xquery.util.QNameUtils").getDeclaredMethod("resolveURI", 2);
                    return new ApplyExp(method, expressionArray4);
                }
                case -5: {
                    Method method = ClassType.make("gnu.xquery.util.DistinctValues").getDeclaredMethod("distinctValues$X", 3);
                    return this.withCollator(method, applyExp.getArgs(), "fn:distinct-values", 1);
                }
                case -25: {
                    Method method = ClassType.make("gnu.xquery.util.SequenceUtils").getDeclaredMethod("deepEqual", 3);
                    return this.withCollator(method, applyExp.getArgs(), "fn:deep-equal", 2);
                }
                case -26: {
                    Method method = ClassType.make("gnu.xquery.util.MinMax").getDeclaredMethod("min", 2);
                    return this.withCollator(method, applyExp.getArgs(), "fn:min", 1);
                }
                case -27: {
                    Method method = ClassType.make("gnu.xquery.util.MinMax").getDeclaredMethod("max", 2);
                    return this.withCollator(method, applyExp.getArgs(), "fn:max", 1);
                }
                case -29: {
                    Expression expression13 = this.checkArgCount(applyExp.getArgs(), (Declaration)object2, 0, 0);
                    if (expression13 != null) {
                        return expression13;
                    }
                    NamedCollator namedCollator = this.parser.defaultCollator;
                    return QuoteExp.getInstance(namedCollator != null ? namedCollator.getName() : "http://www.w3.org/2005/xpath-functions/collation/codepoint");
                }
                case -3: {
                    Object object7;
                    int n2;
                    Compilation compilation = this.getCompilation();
                    Expression[] expressionArray = applyExp.getArgs();
                    for (n2 = 0; n2 < expressionArray.length - 1; n2 += 2) {
                        object7 = expressionArray[n2];
                        String string = (String)((QuoteExp)object7).getValue();
                        Symbol symbol = this.parser.namespaceResolve(string, false);
                        if (symbol == null) continue;
                        if (symbol.getNamespaceURI().length() == 0) {
                            compilation.error('e', "pragma name cannot be in the empty namespace");
                            continue;
                        }
                        Expression expression14 = this.checkPragma(symbol, expressionArray[n2 + 1]);
                        if (expression14 == null) continue;
                        return expression14;
                    }
                    if (n2 < expressionArray.length) {
                        return expressionArray[expressionArray.length - 1];
                    }
                    object7 = "no recognized pragma or default in extension expression";
                    this.getMessages().error('e', (String)object7, "XQST0079");
                    return new ErrorExp((String)object7);
                }
            }
        }
        if ((object3 = applyExp.getFunctionValue()) instanceof Type) {
            object2 = applyExp.getArgs();
            if (((Expression[])object2).length != 1) {
                this.messages.error('e', "type constructor requires a single argument");
                return applyExp;
            }
            return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.CastAs", "castAs"), new Expression[]{applyExp.getFunction(), object2[0]});
        }
        if (object3 instanceof MakeElement) {
            object2 = (MakeElement)object3;
            namespaceBinding = ((MakeElement)object2).getNamespaceNodes();
            Symbol symbol = ((MakeElement)object2).tag;
            if (symbol == null) {
                symbol = MakeElement.getTagName(applyExp);
            }
            namespaceBinding = XQResolveNames.maybeAddNamespace(symbol, false, namespaceBinding);
            Expression[] expressionArray = applyExp.getArgs();
            Symbol[] symbolArray = new Symbol[expressionArray.length];
            int n3 = 0;
            for (int i = 0; i < expressionArray.length; ++i) {
                Symbol symbol2;
                ApplyExp applyExp6;
                Expression expression15 = expressionArray[i];
                if (!(expression15 instanceof ApplyExp) || (applyExp6 = (ApplyExp)expression15).getFunction() != MakeAttribute.makeAttributeExp || (symbol2 = MakeElement.getTagName(applyExp6)) == null) continue;
                int n4 = 0;
                while (true) {
                    if (n4 == n3) break;
                    if (symbol2.equals(symbolArray[n4])) {
                        this.getCompilation().setLine(applyExp6);
                        Symbol symbol3 = MakeElement.getTagName(applyExp);
                        String string = symbol3 == null ? null : symbol3.toString();
                        this.messages.error('e', XMLFilter.duplicateAttributeMessage(symbol2, string), "XQST0040");
                    }
                    ++n4;
                }
                symbolArray[n3++] = symbol2;
                namespaceBinding = XQResolveNames.maybeAddNamespace(symbol2, true, namespaceBinding);
            }
            if (namespaceBinding != null) {
                ((MakeElement)object2).setNamespaceNodes(namespaceBinding);
            }
        }
        return applyExp;
    }

    public Expression checkPragma(Symbol symbol, Expression expression) {
        return null;
    }

    Expression getBaseUriExpr() {
        Compilation compilation = this.getCompilation();
        String string = this.parser.getStaticBaseUri();
        if (string != null) {
            return QuoteExp.getInstance(string);
        }
        return GetModuleClass.getModuleClassURI(compilation);
    }

    static NamespaceBinding maybeAddNamespace(Symbol symbol, boolean bl, NamespaceBinding namespaceBinding) {
        if (symbol == null) {
            return namespaceBinding;
        }
        String string = symbol.getPrefix();
        String string2 = symbol.getNamespaceURI();
        if (string == "") {
            string = null;
        }
        if (string2 == "") {
            string2 = null;
        }
        if (bl && string == null && string2 == null) {
            return namespaceBinding;
        }
        return NamespaceBinding.maybeAdd(string, string2, namespaceBinding);
    }

    static Declaration procToDecl(Object object2, Object object3) {
        Declaration declaration = new Declaration(object2);
        declaration.setProcedureDecl(true);
        declaration.noteValue(new QuoteExp(object3));
        declaration.setFlag(16384);
        return declaration;
    }
}

