/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.bytecode.Type;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;

public class WrongType
extends WrappedException {
    public int number;
    public static final int ARG_UNKNOWN = -1;
    public static final int ARG_VARNAME = -2;
    public static final int ARG_DESCRIPTION = -3;
    public static final int ARG_CAST = -4;
    public String procname;
    public Procedure proc;
    public Object argValue;
    public Object expectedType;

    public WrongType(String string, int n, String string2) {
        super(null, null);
        this.procname = string;
        this.number = n;
        this.expectedType = string2;
    }

    public WrongType(Procedure procedure, int n, ClassCastException classCastException) {
        super(classCastException);
        this.proc = procedure;
        this.procname = procedure.getName();
        this.number = n;
    }

    public WrongType(Procedure procedure, int n, Object object2) {
        this.proc = procedure;
        this.procname = procedure.getName();
        this.number = n;
        this.argValue = object2;
    }

    public WrongType(Procedure procedure, int n, Object object2, Type type) {
        this.proc = procedure;
        this.procname = procedure.getName();
        this.number = n;
        this.argValue = object2;
        this.expectedType = type;
    }

    public WrongType(Procedure procedure, int n, Object object2, String string) {
        this.proc = procedure;
        this.procname = procedure.getName();
        this.number = n;
        this.argValue = object2;
        this.expectedType = string;
    }

    public WrongType(String string, int n, ClassCastException classCastException) {
        super(classCastException);
        this.procname = string;
        this.number = n;
    }

    public static WrongType make(ClassCastException classCastException, Procedure procedure, int n) {
        return new WrongType(procedure, n, classCastException);
    }

    public static WrongType make(ClassCastException classCastException, String string, int n) {
        return new WrongType(string, n, classCastException);
    }

    public static WrongType make(ClassCastException classCastException, Procedure procedure, int n, Object object2) {
        WrongType wrongType = new WrongType(procedure, n, classCastException);
        wrongType.argValue = object2;
        return wrongType;
    }

    public static WrongType make(ClassCastException classCastException, String string, int n, Object object2) {
        WrongType wrongType = new WrongType(string, n, classCastException);
        wrongType.argValue = object2;
        return wrongType;
    }

    public String getMessage() {
        String string;
        Throwable throwable;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.number == -2) {
            stringBuffer.append("Value for variable '");
            stringBuffer.append(this.procname);
            stringBuffer.append("'");
        } else if (this.number == -3) {
            stringBuffer.append(this.procname);
        } else if (this.number == -4) {
            stringBuffer.append("Value");
        } else {
            stringBuffer.append("Argument ");
            if (this.number > 0) {
                stringBuffer.append('#');
                stringBuffer.append(this.number);
            }
        }
        if (this.argValue != null) {
            stringBuffer.append(" (");
            object2 = this.argValue.toString();
            if (((String)object2).length() > 50) {
                stringBuffer.append(((String)object2).substring(0, 47));
                stringBuffer.append("...");
            } else {
                stringBuffer.append((String)object2);
            }
            stringBuffer.append(")");
        }
        if (this.procname != null) {
            stringBuffer.append(" to '");
            stringBuffer.append(this.procname);
            stringBuffer.append("'");
        }
        stringBuffer.append(" has wrong type");
        if (this.argValue != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.argValue.getClass().getName());
            stringBuffer.append(")");
        }
        if ((object2 = this.expectedType) == null && this.number > 0 && this.proc instanceof MethodProc) {
            object2 = ((MethodProc)this.proc).getParameterType(this.number);
        }
        if (object2 != null && object2 != Type.pointer_type) {
            stringBuffer.append(" (expected: ");
            if (object2 instanceof Type) {
                object2 = ((Type)object2).getName();
            } else if (object2 instanceof Class) {
                object2 = ((Class)object2).getName();
            }
            stringBuffer.append(object2);
            stringBuffer.append(")");
        }
        if ((throwable = this.getCause()) != null && (string = throwable.getMessage()) != null) {
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

