/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.commonlisp.lang.Symbols;
import gnu.jemacs.buffer.BufferLocalConstraint;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EToolkit;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.Signal;
import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import gnu.text.Char;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;

public abstract class Buffer
extends AbstractSequence
implements CharSeq {
    String name;
    String filename;
    String encoding;
    static Buffer current;
    public Marker pointMarker;
    public Marker markMarker;
    Mode modes;
    public static Hashtable buffers;
    public static Hashtable fileBuffers;
    EKeymap localKeymap;
    public EKeymap[] activeKeymaps;
    int activeLength;
    int eliminated = 0;
    int tabWidth = 8;

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String string) {
        if (this.filename != null && fileBuffers.get(this.filename) == this) {
            fileBuffers.remove(this.filename);
        }
        if (this.name != null && buffers.get(this.name) == this) {
            buffers.remove(this.name);
        }
        this.filename = string;
        this.name = Buffer.generateNewBufferName(new File(string).getName());
        buffers.put(this.name, this);
        fileBuffers.put(this.filename, this);
        this.redrawModeline();
    }

    public static Buffer findFile(String string) {
        Buffer buffer = (Buffer)fileBuffers.get(string);
        if (buffer == null) {
            buffer = EToolkit.getInstance().newBuffer(null);
            buffer.setFileName(string);
            buffer.encoding = System.getProperty("file.encoding", "UTF8");
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), buffer.encoding);
                buffer.insertFile(inputStreamReader);
                ((Reader)inputStreamReader).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Signal.message("New file");
            }
            catch (Exception exception) {
                throw new RuntimeException("error reading file \"" + string + "\": " + exception);
            }
        }
        return buffer;
    }

    public static Buffer getBuffer(String string) {
        return (Buffer)buffers.get(string);
    }

    public static Buffer coerceBuffer(Object object2) {
        if (object2 instanceof Buffer) {
            return (Buffer)object2;
        }
        return Buffer.getBuffer(object2.toString());
    }

    public static String generateNewBufferName(String string) {
        Buffer buffer = Buffer.getBuffer(string);
        if (buffer == null) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        stringBuffer.append(string);
        stringBuffer.append('<');
        int n2 = 2;
        while (true) {
            stringBuffer.append(n2);
            stringBuffer.append('>');
            String string2 = stringBuffer.toString();
            buffer = Buffer.getBuffer(string2);
            if (buffer == null) {
                return string2;
            }
            stringBuffer.setLength(n + 1);
            ++n2;
        }
    }

    public abstract void redrawModeline();

    public Buffer(String string) {
        this.name = string;
        this.activeKeymaps = new EKeymap[6];
        this.activeLength = 1;
        this.activeKeymaps[0] = EKeymap.globalKeymap;
    }

    public int checkMark() {
        return this.markMarker.getOffset();
    }

    public static Buffer getCurrent() {
        return current;
    }

    public static void setCurrent(Buffer buffer) {
        current = buffer;
    }

    public int getDot() {
        return this.pointMarker.getOffset();
    }

    public int getPoint() {
        return 1 + this.getDot();
    }

    public void setDot(int n) {
        if (n > this.maxDot()) {
            throw new Error("set dot to " + n + " max:" + this.maxDot());
        }
        this.pointMarker.set(this, n);
    }

    public final void setPoint(int n) {
        this.setDot(n - 1);
    }

    public int minDot() {
        return 0;
    }

    public abstract int getLength();

    public final int length() {
        return this.getLength();
    }

    public abstract int maxDot();

    public void forwardChar(int n) {
        this.pointMarker.forwardChar(n);
    }

    public void backwardChar(int n) {
        this.pointMarker.backwardChar(n);
    }

    public String toString() {
        return "#<buffer \"" + this.name + "\">";
    }

    public abstract void insert(String var1, Object var2, int var3);

    public void insert(char[] cArray, int n, int n2, Object object2, int n3) {
        this.insert(new String(cArray, n, n2), object2, n3);
    }

    public void insertAll(Object[] objectArray, Object object2) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object3 = objectArray[i];
            if (object3 instanceof Char) {
                this.insert(((Char)object3).charValue(), 1, object2);
                continue;
            }
            this.pointMarker.insert(object3.toString(), object2);
        }
    }

    public void insert(String string, Object object2) {
        this.pointMarker.insert(string, object2);
    }

    public void insert(Object object2, Object object3) {
        if (object2 instanceof Char) {
            this.insert(((Char)object2).charValue(), 1, object3);
        } else {
            this.pointMarker.insert(object2.toString(), object3);
        }
    }

    public void insert(char c, int n) {
        this.pointMarker.insert(c, n, null);
    }

    public void insert(char c, int n, Object object2) {
        this.pointMarker.insert(c, n, object2);
    }

    public void removeChar(int n) {
        this.pointMarker.removeChar(n);
    }

    public abstract void removeAll();

    public Marker getPointMarker(boolean bl) {
        return bl ? this.pointMarker : new Marker(this.pointMarker);
    }

    public Marker getMarkMarker(boolean bl) {
        return this.markMarker;
    }

    public int positionToOffset(Object object2) {
        if (object2 instanceof Number) {
            int n = this.minDot();
            int n2 = this.maxDot();
            int n3 = ((Number)object2).intValue() - 1;
            return n3 < n ? n : (n3 > n2 ? n2 : n3);
        }
        return ((Marker)object2).getOffset();
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(0, this.length(), writer);
    }

    public abstract void insertFile(Reader var1) throws Exception;

    public abstract void save(Writer var1) throws Exception;

    public void save() {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), this.encoding);
            this.save(outputStreamWriter);
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("error save-buffer: " + exception);
        }
    }

    public void insertFile(String string) {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), this.encoding);
            this.insertFile(inputStreamReader);
            ((Reader)inputStreamReader).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("error reading file \"" + string + "\": " + exception);
        }
    }

    public int charWidth(char c, int n) {
        if (c < '\u3000') {
            if (c < ' ') {
                if (c == '\t') {
                    return (n + this.tabWidth) / this.tabWidth * this.tabWidth - n;
                }
                return 0;
            }
        } else {
            if (c < '\ud800' || c >= '\uff01' && c <= '\uff5e' || c >= '\uffe0' && c <= '\uffe6') {
                return 2;
            }
            if (c < '\ue000') {
                return 0;
            }
        }
        return 1;
    }

    public int countColumns(char[] cArray, int n, int n2, int n3) {
        while (--n2 >= 0) {
            n3 += this.charWidth(cArray[n++], n3);
        }
        return n3;
    }

    public int currentColumn() {
        return this.currentColumn(this.getDot());
    }

    public int currentColumn(int n) {
        try {
            int n2 = this.lineStartOffset(n);
            InPort inPort = this.openReader(n2, n - n2);
            int n3 = 0;
            while (inPort.read() >= 0) {
                int n4 = inPort.pos - 1;
                n3 = this.countColumns(inPort.buffer, n4, inPort.limit - n4, n3);
                inPort.pos = inPort.limit;
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public int moveToColumn(int n, boolean bl) {
        return this.pointMarker.moveToColumn(n, bl);
    }

    public abstract int lineStartOffset(int var1);

    public int lineStartOffset() {
        return this.lineStartOffset(this.getDot());
    }

    public abstract long scan(char var1, int var2, int var3, int var4, boolean var5);

    public final long forwardLine(int n, int n2) {
        boolean bl = n <= 0;
        long l = this.scan('\n', n2, 0, n - (bl ? 1 : 0), true);
        int n3 = (int)(l >> 32);
        int n4 = (int)l;
        if (n3 > 0 && (bl || this.maxDot() > this.minDot() && n4 != n2 && this.charAt(n4 - 1) != '\n')) {
            --n3;
        }
        return (long)(bl ? -n3 : n3) << 32 | (long)n4;
    }

    public int forwardLine(int n) {
        long l = this.forwardLine(n, this.getDot());
        this.setDot((int)l);
        return (int)(l >> 32);
    }

    public EWindow display(boolean bl, EFrame eFrame) {
        EWindow eWindow;
        EWindow eWindow2;
        if (eFrame == null) {
            eFrame = EFrame.getSelectedFrame();
        }
        if ((eWindow2 = eFrame.getSelectedWindow()) == (eWindow = eFrame.otherWindow(1)) && bl) {
            eWindow = eWindow2.split(-1, false);
        }
        eWindow.setBuffer(this);
        return eWindow;
    }

    public static void makeBufferLocal(Object object2, boolean bl) {
        BufferLocalConstraint.make(Symbols.getSymbol(object2), bl);
    }

    public abstract char charAt(int var1);

    public EKeymap getLocalKeymap() {
        return this.localKeymap;
    }

    public void setLocalKeymap(EKeymap eKeymap) {
        if (this.localKeymap != null) {
            this.activeKeymaps[this.activeLength - 2] = this.activeKeymaps[this.activeLength - 1];
            --this.activeLength;
            this.localKeymap = null;
        }
        if (eKeymap != null) {
            this.activeKeymaps[this.activeLength] = this.activeKeymaps[this.activeLength - 1];
            this.activeKeymaps[this.activeLength - 1] = eKeymap;
            ++this.activeLength;
            this.localKeymap = eKeymap;
        }
    }

    public abstract InPort openReader(int var1, int var2);

    public abstract long savePointMark();

    public abstract void restorePointMark(long var1);

    static {
        buffers = new Hashtable(100);
        fileBuffers = new Hashtable(100);
    }
}

