/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.mapping.BinaryInPort;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.ThreadLocation;
import gnu.mapping.TtyInPort;
import gnu.text.LineBufferedReader;
import gnu.text.Path;
import gnu.text.Printable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InPort
extends LineBufferedReader
implements Printable {
    private static InPort systemInPort = new TtyInPort(System.in, Path.valueOf("/dev/stdin"), OutPort.outInitial);
    public static final ThreadLocation inLocation = new ThreadLocation("in-default");

    public InPort(Reader in) {
        super(in);
    }

    public InPort(Reader in, Path path) {
        this(in);
        this.setPath(path);
    }

    public InPort(InputStream in) {
        super(in);
    }

    public InPort(InputStream in, Path path) {
        this(in);
        this.setPath(path);
    }

    public static InPort inDefault() {
        return (InPort)inLocation.get();
    }

    public static void setInDefault(InPort in) {
        inLocation.set(in);
    }

    public static InPort openFile(Object fname) throws IOException {
        Path path = Path.valueOf(fname);
        return InPort.openFile(path.openInputStream(), path);
    }

    public static InPort openFile(Object fname, Object conv) throws IOException {
        Path path = Path.valueOf(fname);
        return InPort.openFile(path.openInputStream(), path, conv);
    }

    public static InPort openFile(InputStream strm, Path path) throws UnsupportedEncodingException {
        Object conv = Environment.user().get("port-char-encoding");
        return InPort.openFile(strm, path, conv);
    }

    public static InPort openFile(InputStream strm, Path path, Object conv) throws UnsupportedEncodingException {
        InputStreamReader rdr;
        if (conv == Boolean.FALSE) {
            return new BinaryInPort(strm, path);
        }
        if (!(strm instanceof BufferedInputStream)) {
            strm = new BufferedInputStream(strm);
        }
        if (conv != null && conv != Boolean.TRUE) {
            String enc = conv.toString();
            try {
                rdr = new InputStreamReader(strm, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("unknown character encoding: " + enc);
            }
        } else {
            rdr = new InputStreamReader(strm);
        }
        InPort port = new InPort(rdr, path);
        port.setConvertCR(true);
        return port;
    }

    public void print(Consumer out) {
        out.write("#<input-port");
        String name = this.getName();
        if (name != null) {
            out.write(32);
            out.write(name);
        }
        out.write(62);
    }

    static {
        inLocation.setGlobal(systemInPort);
    }
}

