/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Compilation;
import gnu.expr.PrimProcedure;
import gnu.expr.Special;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.MakeXmlElement;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ResolveNamespace;
import gnu.kawa.xml.CommentConstructor;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeCDATA;
import gnu.kawa.xml.MakeProcInst;
import gnu.kawa.xml.MakeText;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import gnu.xml.XName;
import java.io.IOException;

public class ReaderXmlElement
extends ReadTableEntry {
    static final String DEFAULT_ELEMENT_NAMESPACE = "[default-element-namespace]";

    @Override
    public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
        LispReader reader = (LispReader)in;
        return ReaderXmlElement.readXMLConstructor(reader, reader.readUnicodeChar(), false);
    }

    public static Pair quote(Object obj) {
        Symbol q = Namespace.EmptyNamespace.getSymbol("quote");
        return LList.list2(q, obj);
    }

    public static Object readQNameExpression(LispReader reader, int ch, boolean forElement) throws IOException, SyntaxException {
        String file = reader.getName();
        int line = reader.getLineNumber() + 1;
        int column = reader.getColumnNumber();
        reader.tokenBufferLength = 0;
        if (XName.isNameStart(ch)) {
            int colon = -1;
            while (true) {
                reader.tokenBufferAppend(ch);
                ch = reader.readUnicodeChar();
                if (ch == 58 && colon < 0) {
                    colon = reader.tokenBufferLength;
                    continue;
                }
                if (!XName.isNamePart(ch)) break;
            }
            reader.unread(ch);
            if (colon >= 0 || forElement) {
                int llen = reader.tokenBufferLength - colon - 1;
                String local = new String(reader.tokenBuffer, colon + 1, llen).intern();
                String prefix = colon < 0 ? DEFAULT_ELEMENT_NAMESPACE : new String(reader.tokenBuffer, 0, colon).intern();
                Symbol psym = Namespace.EmptyNamespace.getSymbol(prefix);
                return new Pair(ResolveNamespace.resolveQName, PairWithPosition.make(psym, new Pair(local, LList.Empty), reader.getName(), line, column));
            }
            Symbol symbol = Namespace.getDefaultSymbol(reader.tokenBufferString().intern());
            return ReaderXmlElement.quote(symbol);
        }
        if (ch == 123 || ch == 40) {
            return ReaderXmlElement.readEscapedExpression(reader, ch);
        }
        reader.error("missing element name");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object readEscapedExpression(LispReader reader, int ch) throws IOException, SyntaxException {
        if (ch == 40) {
            reader.unread(ch);
            return reader.readObject();
        }
        LineBufferedReader port = reader.getPort();
        char saveReadState = reader.pushNesting('{');
        int startLine = port.getLineNumber();
        int startColumn = port.getColumnNumber();
        try {
            Pair list;
            PrimProcedure valuesMake = new PrimProcedure(Compilation.typeValues.getDeclaredMethod("values", 1));
            Pair last = list = reader.makePair(valuesMake, startLine, startColumn);
            ReadTable readTable = ReadTable.getCurrent();
            while (true) {
                ReadTableEntry entry;
                Object value;
                int line = port.getLineNumber();
                int column = port.getColumnNumber();
                ch = port.read();
                if (ch == 125) break;
                if (ch < 0) {
                    reader.eofError("unexpected EOF in list starting here", startLine + 1, startColumn);
                }
                if ((value = reader.readValues(ch, entry = readTable.lookup(ch), readTable)) == Values.empty) continue;
                value = reader.handlePostfix(value, readTable, line, column);
                Pair pair = reader.makePair(value, line, column);
                reader.setCdr(last, pair);
                last = pair;
            }
            reader.tokenBufferLength = 0;
            if (last == list.getCdr()) {
                Object object2 = last.getCar();
                return object2;
            }
            Pair pair = list;
            return pair;
        }
        finally {
            reader.popNesting(saveReadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object readXMLConstructor(LispReader reader, int next, boolean inElementContent) throws IOException, SyntaxException {
        Object exp;
        int startLine = reader.getLineNumber() + 1;
        int startColumn = reader.getColumnNumber() - 2;
        if (next == 33) {
            next = reader.read();
            if (next == 45 && (next = reader.peek()) == 45) {
                reader.skip();
                if (!reader.readDelimited("-->")) {
                    reader.error('f', reader.getName(), startLine, startColumn, "unexpected end-of-file in XML comment starting here - expected \"-->\"");
                }
                String str = reader.tokenBufferString();
                exp = LList.list2(CommentConstructor.commentConstructor, str);
            } else if (next == 91 && (next = reader.read()) == 67 && (next = reader.read()) == 68 && (next = reader.read()) == 65 && (next = reader.read()) == 84 && (next = reader.read()) == 65 && (next = reader.read()) == 91) {
                if (!reader.readDelimited("]]>")) {
                    reader.error('f', reader.getName(), startLine, startColumn, "unexpected end-of-file in CDATA starting here - expected \"]]>\"");
                }
                String str = reader.tokenBufferString();
                exp = LList.list2(MakeCDATA.makeCDATA, str);
            } else {
                reader.error('f', reader.getName(), startLine, startColumn, "'<!' must be followed by '--' or '[CDATA['");
                while (next >= 0 && next != 62 && next != 10 && next != 13) {
                    next = reader.read();
                }
                exp = null;
            }
        } else if (next == 63) {
            next = reader.readUnicodeChar();
            if (next < 0 || !XName.isNameStart(next)) {
                reader.error("missing target after '<?'");
            }
            do {
                reader.tokenBufferAppend(next);
            } while (XName.isNamePart(next = reader.readUnicodeChar()));
            String target = reader.tokenBufferString();
            int nspaces = 0;
            while (next >= 0 && Character.isWhitespace(next)) {
                ++nspaces;
                next = reader.read();
            }
            reader.unread(next);
            char saveReadState = reader.pushNesting('?');
            try {
                if (!reader.readDelimited("?>")) {
                    reader.error('f', reader.getName(), startLine, startColumn, "unexpected end-of-file looking for \"?>\"");
                }
            }
            finally {
                reader.popNesting(saveReadState);
            }
            if (nspaces == 0 && reader.tokenBufferLength > 0) {
                reader.error("target must be followed by space or '?>'");
            }
            String content = reader.tokenBufferString();
            exp = LList.list3(MakeProcInst.makeProcInst, target, content);
        } else {
            exp = ReaderXmlElement.readElementConstructor(reader, next);
        }
        return exp;
    }

    public static Object readElementConstructor(LispReader reader, int ch) throws IOException, SyntaxException {
        int startLine = reader.getLineNumber() + 1;
        int startColumn = reader.getColumnNumber() - 2;
        Object tag = ReaderXmlElement.readQNameExpression(reader, ch, true);
        String startTag = reader.tokenBufferLength == 0 ? null : reader.tokenBufferString();
        PairWithPosition tagPair = PairWithPosition.make(tag, LList.Empty, reader.getName(), startLine, startColumn);
        Pair resultTail = tagPair;
        LList namespaceList = LList.Empty;
        Object nsBindings = null;
        while (true) {
            PairWithPosition attrList;
            boolean sawSpace = false;
            ch = reader.readUnicodeChar();
            while (ch >= 0 && Character.isWhitespace(ch)) {
                ch = reader.read();
                sawSpace = true;
            }
            if (ch < 0 || ch == 62 || ch == 47) break;
            if (!sawSpace) {
                reader.error("missing space before attribute");
            }
            Object attrName = ReaderXmlElement.readQNameExpression(reader, ch, false);
            int line = reader.getLineNumber() + 1;
            int column = reader.getColumnNumber() + 1 - reader.tokenBufferLength;
            String definingNamespace = null;
            if (reader.tokenBufferLength >= 5 && reader.tokenBuffer[0] == 'x' && reader.tokenBuffer[1] == 'm' && reader.tokenBuffer[2] == 'l' && reader.tokenBuffer[3] == 'n' && reader.tokenBuffer[4] == 's') {
                if (reader.tokenBufferLength == 5) {
                    definingNamespace = "";
                } else if (reader.tokenBuffer[5] == ':') {
                    definingNamespace = new String(reader.tokenBuffer, 6, reader.tokenBufferLength - 6);
                }
            }
            if ((ch = ReaderXmlElement.skipSpace(reader, 32)) != 61) {
                reader.error("missing '=' after attribute");
            }
            ch = ReaderXmlElement.skipSpace(reader, 32);
            Pair attrTail = attrList = PairWithPosition.make(MakeAttribute.makeAttribute, LList.Empty, reader.getName(), startLine, startColumn);
            PairWithPosition attrPair = PairWithPosition.make(attrName, LList.Empty, reader.getName(), startLine, startColumn);
            reader.setCdr(attrTail, attrPair);
            attrTail = attrPair;
            attrTail = ReaderXmlElement.readContent(reader, (char)ch, attrTail);
            if (definingNamespace != null) {
                namespaceList = new PairWithPosition(attrPair, Pair.make(definingNamespace, attrPair.getCdr()), namespaceList);
                continue;
            }
            PairWithPosition pair = PairWithPosition.make(attrList, reader.makeNil(), null, -1, -1);
            resultTail.setCdrBackdoor(pair);
            resultTail = pair;
        }
        boolean empty = false;
        if (ch == 47) {
            ch = reader.read();
            if (ch == 62) {
                empty = true;
            } else {
                reader.unread(ch);
            }
        }
        if (!empty) {
            if (ch != 62) {
                reader.error("missing '>' after start element");
                return Boolean.FALSE;
            }
            resultTail = ReaderXmlElement.readContent(reader, '<', resultTail);
            ch = reader.readUnicodeChar();
            if (XName.isNameStart(ch)) {
                reader.tokenBufferLength = 0;
                do {
                    reader.tokenBufferAppend(ch);
                } while (XName.isNamePart(ch = reader.readUnicodeChar()) || ch == 58);
                String endTag = reader.tokenBufferString();
                if (startTag == null || !endTag.equals(startTag)) {
                    reader.error('e', reader.getName(), reader.getLineNumber() + 1, reader.getColumnNumber() - reader.tokenBufferLength, startTag == null ? "computed start tag closed by '</" + endTag + ">'" : "'<" + startTag + ">' closed by '</" + endTag + ">'");
                }
                reader.tokenBufferLength = 0;
            }
            if ((ch = ReaderXmlElement.skipSpace(reader, ch)) != 62) {
                reader.error("missing '>' after end element");
            }
        }
        namespaceList = LList.reverseInPlace(namespaceList);
        return PairWithPosition.make(MakeXmlElement.makeXml, Pair.make(namespaceList, tagPair), reader.getName(), startLine, startColumn);
    }

    public static Pair readContent(LispReader reader, char delimiter, Pair resultTail) throws IOException, SyntaxException {
        reader.tokenBufferLength = 0;
        boolean prevWasEnclosed = false;
        while (true) {
            Object item = null;
            String text = null;
            int line = reader.getLineNumber() + 1;
            int column = reader.getColumnNumber();
            int next = reader.read();
            if (next < 0) {
                reader.error("unexpected end-of-file");
                item = Special.eof;
            } else if (next == delimiter) {
                if (delimiter == '<') {
                    if (reader.tokenBufferLength > 0) {
                        text = reader.tokenBufferString();
                        reader.tokenBufferLength = 0;
                    }
                    item = (next = reader.read()) == 47 ? Special.eof : ReaderXmlElement.readXMLConstructor(reader, next, true);
                } else if (reader.checkNext(delimiter)) {
                    reader.tokenBufferAppend(delimiter);
                } else {
                    item = Special.eof;
                }
                prevWasEnclosed = false;
            } else if (next == 38) {
                next = reader.read();
                if (next == 35) {
                    ReaderXmlElement.readCharRef(reader);
                } else if (next == 40 || next == 123) {
                    if (reader.tokenBufferLength > 0 || prevWasEnclosed) {
                        text = reader.tokenBufferString();
                    }
                    reader.tokenBufferLength = 0;
                    item = ReaderXmlElement.readEscapedExpression(reader, next);
                } else {
                    item = ReaderXmlElement.readEntity(reader, next);
                    if (prevWasEnclosed && reader.tokenBufferLength == 0) {
                        text = "";
                    }
                }
                prevWasEnclosed = true;
            } else {
                if (delimiter != '<' && (next == 9 || next == 10 || next == 13)) {
                    next = 32;
                }
                if (next == 60) {
                    reader.error('e', "'<' must be quoted in a direct attribute value");
                }
                reader.tokenBufferAppend((char)next);
            }
            if (item != null && reader.tokenBufferLength > 0) {
                text = reader.tokenBufferString();
                reader.tokenBufferLength = 0;
            }
            if (text != null) {
                Pair tnode = Pair.list2(MakeText.makeText, text);
                PairWithPosition pair = PairWithPosition.make(tnode, reader.makeNil(), null, -1, -1);
                resultTail.setCdrBackdoor(pair);
                resultTail = pair;
            }
            if (item == Special.eof) break;
            if (item == null) continue;
            PairWithPosition pair = PairWithPosition.make(item, reader.makeNil(), null, line, column);
            resultTail.setCdrBackdoor(pair);
            resultTail = pair;
        }
        return resultTail;
    }

    static void readCharRef(LispReader reader) throws IOException, SyntaxException {
        int value;
        char ch;
        int digit;
        int base;
        int next = reader.read();
        if (next == 120) {
            base = 16;
            next = reader.read();
        } else {
            base = 10;
        }
        for (value = 0; next >= 0 && (digit = Character.digit(ch = (char)next, base)) >= 0 && value < 0x8000000; value += digit) {
            value *= base;
            next = reader.read();
        }
        if (next != 59) {
            reader.unread(next);
            reader.error("invalid character reference");
        } else if (value > 0 && value <= 55295 || value >= 57344 && value <= 65533 || value >= 65536 && value <= 0x10FFFF) {
            reader.tokenBufferAppend(value);
        } else {
            reader.error("invalid character value " + value);
        }
    }

    static Object readEntity(LispReader reader, int next) throws IOException, SyntaxException {
        char ch;
        String result = "?";
        int saveLength = reader.tokenBufferLength;
        while (next >= 0 && XName.isNamePart(ch = (char)next)) {
            reader.tokenBufferAppend(ch);
            next = reader.read();
        }
        if (next != 59) {
            reader.unread(next);
            reader.error("invalid entity reference");
        } else {
            String ref = new String(reader.tokenBuffer, saveLength, reader.tokenBufferLength - saveLength);
            reader.tokenBufferLength = saveLength;
            ReaderXmlElement.namedEntity(reader, ref);
            result = null;
        }
        return result;
    }

    public static void namedEntity(LispReader reader, String name) {
        name = name.intern();
        int ch = 63;
        if (name == "lt") {
            ch = 60;
        } else if (name == "gt") {
            ch = 62;
        } else if (name == "amp") {
            ch = 38;
        } else if (name == "quot") {
            ch = 34;
        } else if (name == "apos") {
            ch = 39;
        } else {
            reader.error("unknown enity reference: '" + name + "'");
        }
        reader.tokenBufferAppend(ch);
    }

    static int skipSpace(LispReader reader, int ch) throws IOException, SyntaxException {
        while (ch >= 0 && Character.isWhitespace(ch)) {
            ch = reader.readUnicodeChar();
        }
        return ch;
    }
}

