
(defun toggle--add-comments ()
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *BEGIN_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "//BEGIN_FUNCTION();")))

  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *END_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "//END_FUNCTION();"))))

(defun toggle--remove-comments ()
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *//BEGIN_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "BEGIN_FUNCTION();")))
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *//END_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "END_FUNCTION();"))))

(defun toggle-begin-end-function ()
  (interactive)
  (save-excursion
    (if (save-excursion
          (goto-char (point-min))
          (re-search-forward "^ *BEGIN_FUNCTION();" nil t))
        (toggle--add-comments)
      (toggle--remove-comments)))
  (indent-region (point-min) (point-max) nil)
  )

(provide 'toggle-begin-end-function)
;;; toggle-begin-end-function.el ends here
