#include <grub/unicode.h>

struct grub_unicode_compact_range grub_unicode_compact[] = {
{0x0, 0x8, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9, 0x9, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa, 0xa, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb, 0xb, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc, 0xc, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd, 0xd, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe, 0x1b, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c, 0x1e, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f, 0x1f, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x20, 0x20, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x21, 0x22, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x23, 0x25, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26, 0x27, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x28, 0x29, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a, 0x2a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b, 0x2b, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2c, 0x2c, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2d, 0x2d, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e, 0x2f, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30, 0x39, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3a, 0x3a, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3b, 0x3b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3c, 0x3c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3d, 0x3d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3e, 0x3e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3f, 0x40, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5b, 0x5b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x5c, 0x5c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5d, 0x5d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x5e, 0x60, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7b, 0x7b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x7c, 0x7c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7d, 0x7d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x7e, 0x7e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7f, 0x84, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x85, 0x85, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x86, 0x9f, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa0, 0xa0, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa1, 0xa1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa2, 0xa5, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa6, 0xa9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xab, 0xab, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xac, 0xac, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xad, 0xad, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xae, 0xaf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb0, 0xb1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb2, 0xb3, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4, 0xb4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb6, 0xb8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb9, 0xb9, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbb, 0xbb, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xbc, 0xbf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd7, 0xd7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf7, 0xf7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b9, 0x2ba, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2c2, 0x2cf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2d2, 0x2df, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e5, 0x2ed, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ef, 0x2ff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x300, 0x314, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x315, 0x315, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x316, 0x319, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31a, 0x31a, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31b, 0x31b, GRUB_BIDI_TYPE_NSM, 216, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31c, 0x320, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x321, 0x322, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x323, 0x326, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x327, 0x328, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x329, 0x333, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x334, 0x338, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x339, 0x33c, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x33d, 0x344, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x345, 0x345, GRUB_BIDI_TYPE_NSM, 240, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x346, 0x346, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x347, 0x349, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34a, 0x34c, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34d, 0x34e, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34f, 0x34f, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x350, 0x352, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x353, 0x356, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x357, 0x357, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x358, 0x358, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x359, 0x35a, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35b, 0x35b, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35c, 0x35c, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35d, 0x35e, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35f, 0x35f, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x360, 0x361, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x362, 0x362, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x363, 0x36f, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x374, 0x375, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x37e, 0x37e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x384, 0x385, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x387, 0x387, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3f6, 0x3f6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x483, 0x487, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x488, 0x489, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x58a, 0x58a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x591, 0x591, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x592, 0x595, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x596, 0x596, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x597, 0x599, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59a, 0x59a, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59b, 0x59b, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59c, 0x5a1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5a2, 0x5a7, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5a8, 0x5a9, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5aa, 0x5aa, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ab, 0x5ac, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ad, 0x5ad, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ae, 0x5ae, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5af, 0x5af, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b0, 0x5b0, GRUB_BIDI_TYPE_NSM, 10, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b1, 0x5b1, GRUB_BIDI_TYPE_NSM, 11, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b2, 0x5b2, GRUB_BIDI_TYPE_NSM, 12, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b3, 0x5b3, GRUB_BIDI_TYPE_NSM, 13, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b4, 0x5b4, GRUB_BIDI_TYPE_NSM, 14, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b5, 0x5b5, GRUB_BIDI_TYPE_NSM, 15, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b6, 0x5b6, GRUB_BIDI_TYPE_NSM, 16, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b7, 0x5b7, GRUB_BIDI_TYPE_NSM, 17, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b8, 0x5b8, GRUB_BIDI_TYPE_NSM, 18, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b9, 0x5ba, GRUB_BIDI_TYPE_NSM, 19, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bb, 0x5bb, GRUB_BIDI_TYPE_NSM, 20, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bc, 0x5bc, GRUB_BIDI_TYPE_NSM, 21, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bd, 0x5bd, GRUB_BIDI_TYPE_NSM, 22, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5be, 0x5be, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5bf, 0x5bf, GRUB_BIDI_TYPE_NSM, 23, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c0, 0x5c0, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c1, 0x5c1, GRUB_BIDI_TYPE_NSM, 24, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c2, 0x5c2, GRUB_BIDI_TYPE_NSM, 25, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c3, 0x5c3, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c4, 0x5c4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c5, 0x5c5, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c6, 0x5c6, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c7, 0x5c7, GRUB_BIDI_TYPE_NSM, 18, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5d0, 0x5ea, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5f0, 0x5f4, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x600, 0x603, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x606, 0x607, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x608, 0x608, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x609, 0x60a, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60b, 0x60b, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60c, 0x60c, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60d, 0x60d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60e, 0x60f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x610, 0x617, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x618, 0x618, GRUB_BIDI_TYPE_NSM, 30, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x619, 0x619, GRUB_BIDI_TYPE_NSM, 31, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x61a, 0x61a, GRUB_BIDI_TYPE_NSM, 32, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x61b, 0x61b, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x61e, 0x61f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x621, 0x621, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x622, 0x625, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x626, 0x626, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x627, 0x627, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x628, 0x628, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x629, 0x629, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x62a, 0x62e, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x62f, 0x632, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x633, 0x63f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x640, 0x640, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x641, 0x647, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x648, 0x648, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x649, 0x64a, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x64b, 0x64b, GRUB_BIDI_TYPE_NSM, 27, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64c, 0x64c, GRUB_BIDI_TYPE_NSM, 28, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64d, 0x64d, GRUB_BIDI_TYPE_NSM, 29, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64e, 0x64e, GRUB_BIDI_TYPE_NSM, 30, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64f, 0x64f, GRUB_BIDI_TYPE_NSM, 31, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x650, 0x650, GRUB_BIDI_TYPE_NSM, 32, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x651, 0x651, GRUB_BIDI_TYPE_NSM, 33, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x652, 0x652, GRUB_BIDI_TYPE_NSM, 34, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x653, 0x654, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x655, 0x656, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x657, 0x65b, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x65c, 0x65c, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x65d, 0x65e, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x660, 0x669, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66a, 0x66a, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66b, 0x66c, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66d, 0x66d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66e, 0x66f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x670, 0x670, GRUB_BIDI_TYPE_NSM, 35, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x671, 0x673, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x674, 0x674, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x675, 0x677, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x678, 0x687, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x688, 0x699, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x69a, 0x6bf, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6c0, 0x6c0, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6c1, 0x6c2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6c3, 0x6cb, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6cc, 0x6cc, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6cd, 0x6cd, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6ce, 0x6ce, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6cf, 0x6cf, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d0, 0x6d1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6d2, 0x6d3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d4, 0x6d4, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6d5, 0x6d5, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d6, 0x6dc, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6dd, 0x6dd, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6de, 0x6de, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6df, 0x6e2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e3, 0x6e3, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e4, 0x6e4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e5, 0x6e6, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6e7, 0x6e8, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e9, 0x6e9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6ea, 0x6ea, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6eb, 0x6ec, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6ed, 0x6ed, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6ee, 0x6ef, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6f0, 0x6f9, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6fa, 0x6fc, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6fd, 0x6fe, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6ff, 0x6ff, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x700, 0x70d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x70f, 0x70f, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x710, 0x710, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x711, 0x711, GRUB_BIDI_TYPE_NSM, 36, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x712, 0x714, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x715, 0x719, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x71a, 0x71d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x71e, 0x71e, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x71f, 0x727, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x728, 0x728, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x729, 0x729, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72a, 0x72a, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x72b, 0x72b, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72c, 0x72c, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x72d, 0x72e, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72f, 0x72f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x730, 0x730, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x731, 0x731, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x732, 0x733, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x734, 0x734, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x735, 0x736, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x737, 0x739, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73a, 0x73a, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73b, 0x73c, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73d, 0x73d, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73e, 0x73e, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73f, 0x741, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x742, 0x742, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x743, 0x743, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x744, 0x744, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x745, 0x745, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x746, 0x746, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x747, 0x747, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x748, 0x748, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x749, 0x74a, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x74d, 0x74d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x74e, 0x758, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x759, 0x75b, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x75c, 0x76a, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x76b, 0x76c, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x76d, 0x770, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x771, 0x771, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x772, 0x772, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x773, 0x774, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x775, 0x777, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x778, 0x779, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x77a, 0x77f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x780, 0x7a5, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7a6, 0x7b0, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7b1, 0x7b1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7c0, 0x7c9, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7ca, 0x7ea, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x7eb, 0x7f1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f2, 0x7f2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f3, 0x7f3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f4, 0x7f5, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7f6, 0x7f9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7fa, 0x7fa, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x800, 0x815, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x816, 0x819, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x81a, 0x81a, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x81b, 0x823, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x824, 0x824, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x825, 0x827, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x828, 0x828, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x829, 0x82d, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x830, 0x83e, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x900, 0x902, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x903, 0x903, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x93c, 0x93c, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x93e, 0x940, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x941, 0x948, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x949, 0x94c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x94d, 0x94d, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x94e, 0x94e, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x951, 0x951, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x952, 0x952, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x953, 0x954, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x955, 0x955, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x962, 0x963, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x981, 0x981, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x982, 0x983, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9bc, 0x9bc, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9be, 0x9c0, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9c1, 0x9c4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9c7, 0x9c8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9cb, 0x9cc, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9cd, 0x9cd, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9d7, 0x9d7, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9e2, 0x9e3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9f2, 0x9f3, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9fb, 0x9fb, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa01, 0xa02, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa03, 0xa03, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa3c, 0xa3c, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa3e, 0xa40, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa41, 0xa42, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa47, 0xa48, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa4b, 0xa4c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa4d, 0xa4d, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa51, 0xa51, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa70, 0xa71, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa75, 0xa75, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa81, 0xa82, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa83, 0xa83, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabc, 0xabc, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe, 0xac0, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xac1, 0xac5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xac7, 0xac8, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xac9, 0xac9, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xacb, 0xacc, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xacd, 0xacd, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xae2, 0xae3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaf1, 0xaf1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb01, 0xb01, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb02, 0xb03, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb3c, 0xb3c, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb3e, 0xb3e, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb3f, 0xb3f, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb40, 0xb40, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb41, 0xb44, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb47, 0xb48, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4b, 0xb4c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4d, 0xb4d, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb56, 0xb56, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb57, 0xb57, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb62, 0xb63, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb82, 0xb82, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbbe, 0xbbf, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbc0, 0xbc0, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbc1, 0xbc2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbc6, 0xbc8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbca, 0xbcc, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbcd, 0xbcd, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbd7, 0xbd7, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbf3, 0xbf8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbf9, 0xbf9, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbfa, 0xbfa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc01, 0xc03, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc3e, 0xc40, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc41, 0xc44, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc46, 0xc48, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc4a, 0xc4c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc4d, 0xc4d, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc55, 0xc55, GRUB_BIDI_TYPE_NSM, 84, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc56, 0xc56, GRUB_BIDI_TYPE_NSM, 91, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc62, 0xc63, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc78, 0xc7e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc82, 0xc83, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcbc, 0xcbc, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcbe, 0xcbe, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcbf, 0xcbf, GRUB_BIDI_TYPE_L, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcc0, 0xcc4, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcc6, 0xcc6, GRUB_BIDI_TYPE_L, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcc7, 0xcc8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcca, 0xccb, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xccc, 0xccc, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xccd, 0xccd, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcd5, 0xcd6, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xce2, 0xce3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcf1, 0xcf2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd02, 0xd03, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd3e, 0xd40, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd41, 0xd44, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd46, 0xd48, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd4a, 0xd4c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd4d, 0xd4d, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd57, 0xd57, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd62, 0xd63, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd82, 0xd83, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdca, 0xdca, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdcf, 0xdd1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdd2, 0xdd4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdd6, 0xdd6, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdd8, 0xddf, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdf2, 0xdf3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe31, 0xe31, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe34, 0xe37, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe38, 0xe39, GRUB_BIDI_TYPE_NSM, 103, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe3a, 0xe3a, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe3f, 0xe3f, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe47, 0xe47, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe48, 0xe4b, GRUB_BIDI_TYPE_NSM, 107, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe4c, 0xe4e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb1, 0xeb1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb4, 0xeb7, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb8, 0xeb9, GRUB_BIDI_TYPE_NSM, 118, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xebb, 0xebc, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xec8, 0xecb, GRUB_BIDI_TYPE_NSM, 122, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xecc, 0xecd, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf18, 0xf19, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf35, 0xf35, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf37, 0xf37, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf39, 0xf39, GRUB_BIDI_TYPE_NSM, 216, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf3a, 0xf3d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xf3e, 0xf3f, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf71, 0xf71, GRUB_BIDI_TYPE_NSM, 129, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf72, 0xf72, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf73, 0xf73, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf74, 0xf74, GRUB_BIDI_TYPE_NSM, 132, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf75, 0xf79, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7a, 0xf7d, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7e, 0xf7e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7f, 0xf7f, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf80, 0xf80, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf81, 0xf81, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf82, 0xf83, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf84, 0xf84, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf86, 0xf87, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf90, 0xf97, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf99, 0xfbc, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfc6, 0xfc6, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x102b, 0x102c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x102d, 0x1030, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1031, 0x1031, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1032, 0x1036, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1037, 0x1037, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1038, 0x1038, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1039, 0x103a, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x103b, 0x103c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x103d, 0x103e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1056, 0x1057, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1058, 0x1059, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x105e, 0x1060, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1062, 0x1064, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1067, 0x106d, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1071, 0x1074, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1082, 0x1082, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1083, 0x1084, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1085, 0x1086, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1087, 0x108c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x108d, 0x108d, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x108f, 0x108f, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x109a, 0x109c, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x109d, 0x109d, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x135f, 0x135f, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1390, 0x1399, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1400, 0x1400, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1680, 0x1680, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x169b, 0x169c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1712, 0x1713, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1714, 0x1714, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1732, 0x1733, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1734, 0x1734, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1752, 0x1753, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1772, 0x1773, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17b6, 0x17b6, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17b7, 0x17bd, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17be, 0x17c5, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17c6, 0x17c6, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17c7, 0x17c8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17c9, 0x17d1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17d2, 0x17d2, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17d3, 0x17d3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17db, 0x17db, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17dd, 0x17dd, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17f0, 0x17f9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1800, 0x180a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x180b, 0x180d, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x180e, 0x180e, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x18a9, 0x18a9, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1920, 0x1922, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1923, 0x1926, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1927, 0x1928, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1929, 0x192b, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1930, 0x1931, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1932, 0x1932, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1933, 0x1938, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1939, 0x1939, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x193a, 0x193a, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x193b, 0x193b, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1940, 0x1940, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1944, 0x1945, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19b0, 0x19c0, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19c8, 0x19c9, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19de, 0x19ff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a17, 0x1a17, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a18, 0x1a18, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a19, 0x1a1b, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a55, 0x1a55, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a56, 0x1a56, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a57, 0x1a57, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a58, 0x1a5e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a60, 0x1a60, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a61, 0x1a61, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a62, 0x1a62, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a63, 0x1a64, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a65, 0x1a6c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a6d, 0x1a72, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a73, 0x1a74, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a75, 0x1a7c, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a7f, 0x1a7f, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b00, 0x1b03, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b04, 0x1b04, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b34, 0x1b34, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b35, 0x1b35, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b36, 0x1b3a, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b3b, 0x1b3b, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b3c, 0x1b3c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b3d, 0x1b41, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b42, 0x1b42, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b43, 0x1b43, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b44, 0x1b44, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b6b, 0x1b6b, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b6c, 0x1b6c, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b6d, 0x1b73, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b80, 0x1b81, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b82, 0x1b82, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba1, 0x1ba1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba2, 0x1ba5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ba6, 0x1ba7, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba8, 0x1ba9, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1baa, 0x1baa, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c24, 0x1c2b, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c2c, 0x1c33, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1c34, 0x1c35, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c36, 0x1c36, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1c37, 0x1c37, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd0, 0x1cd2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd4, 0x1cd4, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd5, 0x1cd9, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cda, 0x1cdb, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cdc, 0x1cdf, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ce0, 0x1ce0, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ce1, 0x1ce1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ce2, 0x1ce8, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ced, 0x1ced, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cf2, 0x1cf2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1dc0, 0x1dc1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dc2, 0x1dc2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dc3, 0x1dc9, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dca, 0x1dca, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcb, 0x1dcc, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcd, 0x1dcd, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dce, 0x1dce, GRUB_BIDI_TYPE_NSM, 214, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcf, 0x1dcf, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dd0, 0x1dd0, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dd1, 0x1de6, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dfd, 0x1dfd, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dfe, 0x1dfe, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dff, 0x1dff, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1fbd, 0x1fbd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fbf, 0x1fc1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fcd, 0x1fcf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fdd, 0x1fdf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fed, 0x1fef, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ffd, 0x1ffe, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2000, 0x200a, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x200b, 0x200b, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x200c, 0x200c, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x200d, 0x200d, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x200f, 0x200f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2010, 0x2027, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2028, 0x2028, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2029, 0x2029, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x202a, 0x202a, GRUB_BIDI_TYPE_LRE, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202b, 0x202b, GRUB_BIDI_TYPE_RLE, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202c, 0x202c, GRUB_BIDI_TYPE_PDF, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202d, 0x202d, GRUB_BIDI_TYPE_LRO, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202e, 0x202e, GRUB_BIDI_TYPE_RLO, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202f, 0x202f, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2030, 0x2034, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2035, 0x2038, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2039, 0x203a, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x203b, 0x2043, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2044, 0x2044, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2045, 0x2046, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2047, 0x205e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x205f, 0x205f, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2060, 0x2064, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x206a, 0x206f, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2070, 0x2070, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2074, 0x2079, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207a, 0x207b, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207c, 0x207c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207d, 0x207e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2080, 0x2089, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208a, 0x208b, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208c, 0x208c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208d, 0x208e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x20a0, 0x20b8, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x20d0, 0x20d1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d2, 0x20d3, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d4, 0x20d7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d8, 0x20da, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20db, 0x20dc, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20dd, 0x20e0, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e1, 0x20e1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e2, 0x20e4, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e5, 0x20e6, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e7, 0x20e7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e8, 0x20e8, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e9, 0x20e9, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20ea, 0x20eb, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20ec, 0x20ef, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20f0, 0x20f0, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2100, 0x2101, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2103, 0x2106, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2108, 0x2109, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2114, 0x2114, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2116, 0x2118, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x211e, 0x2123, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2125, 0x2125, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2127, 0x2127, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2129, 0x2129, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x212e, 0x212e, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x213a, 0x213b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2140, 0x2140, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2141, 0x2144, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x214a, 0x214d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2150, 0x215f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2189, 0x2189, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2190, 0x2200, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2201, 0x2204, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2205, 0x2207, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2208, 0x220d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x220e, 0x2210, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2211, 0x2211, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2212, 0x2212, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2213, 0x2213, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2214, 0x2214, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2215, 0x2216, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2217, 0x2219, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x221a, 0x221d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x221e, 0x221e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x221f, 0x2222, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2223, 0x2223, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2224, 0x2224, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2225, 0x2225, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2226, 0x2226, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2227, 0x222a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x222b, 0x2233, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2234, 0x2238, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2239, 0x2239, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x223a, 0x223a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x223b, 0x224c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x224d, 0x2251, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2252, 0x2255, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2256, 0x225e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x225f, 0x2260, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2261, 0x2261, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2262, 0x2262, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2263, 0x2263, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2264, 0x226b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x226c, 0x226d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x226e, 0x228c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x228d, 0x228e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x228f, 0x2292, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2293, 0x2297, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2298, 0x2298, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2299, 0x22a1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22a2, 0x22a3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22a4, 0x22a5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22a6, 0x22b8, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22b9, 0x22bd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22be, 0x22bf, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22c0, 0x22c8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22c9, 0x22cd, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22ce, 0x22cf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22d0, 0x22d1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22d2, 0x22d5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22d6, 0x22ed, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22ee, 0x22ef, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22f0, 0x22ff, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2300, 0x2307, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2308, 0x230b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x230c, 0x231f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2320, 0x2321, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2322, 0x2328, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2329, 0x232a, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x232b, 0x2335, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x237b, 0x2394, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2396, 0x23e8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2400, 0x2426, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2440, 0x244a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2460, 0x2487, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2488, 0x249b, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x24ea, 0x26ab, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26ad, 0x26cd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26cf, 0x26e1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26e3, 0x26e3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26e8, 0x26ff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2701, 0x2704, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2706, 0x2709, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x270c, 0x2727, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2729, 0x274b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x274d, 0x274d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x274f, 0x2752, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2756, 0x275e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2761, 0x2767, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2768, 0x2775, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2776, 0x2794, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2798, 0x27af, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27b1, 0x27be, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c0, 0x27c0, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27c1, 0x27c2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c3, 0x27c6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27c7, 0x27c7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c8, 0x27c9, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27ca, 0x27ca, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27cc, 0x27cc, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27d0, 0x27d2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27d3, 0x27d6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27d7, 0x27db, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27dc, 0x27de, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27df, 0x27e1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27e2, 0x27ef, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27f0, 0x27ff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2900, 0x2982, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2983, 0x2998, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2999, 0x299a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x299b, 0x29af, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29b0, 0x29b7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29b8, 0x29b8, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29b9, 0x29bf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29c0, 0x29c5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29c6, 0x29c8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29c9, 0x29c9, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29ca, 0x29cd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29ce, 0x29d2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29d3, 0x29d3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29d4, 0x29d5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29d6, 0x29d7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29d8, 0x29dc, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29dd, 0x29e0, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e1, 0x29e1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29e2, 0x29e2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e3, 0x29e5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29e6, 0x29e7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e8, 0x29e9, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29ea, 0x29f3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29f4, 0x29f9, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29fa, 0x29fb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29fc, 0x29fd, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29fe, 0x2a09, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a0a, 0x2a1c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a1d, 0x2a1d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a1e, 0x2a21, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a22, 0x2a23, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a24, 0x2a24, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a25, 0x2a25, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a26, 0x2a26, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a27, 0x2a28, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a29, 0x2a29, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2a, 0x2a2a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2b, 0x2a2e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2f, 0x2a33, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a34, 0x2a35, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a36, 0x2a3b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a3c, 0x2a3e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a3f, 0x2a56, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a57, 0x2a58, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a59, 0x2a63, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a64, 0x2a65, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a66, 0x2a69, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6a, 0x2a6d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6e, 0x2a6e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6f, 0x2a70, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a71, 0x2a72, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a73, 0x2a74, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a75, 0x2a78, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a79, 0x2aa3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aa4, 0x2aa5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aa6, 0x2aad, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aae, 0x2aae, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aaf, 0x2ad6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2ad7, 0x2adb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2adc, 0x2adc, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2add, 0x2add, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ade, 0x2ade, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2adf, 0x2ae1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ae2, 0x2ae6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2ae7, 0x2aeb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aec, 0x2aee, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aef, 0x2af2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2af3, 0x2af3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2af4, 0x2af6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2af7, 0x2afb, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2afc, 0x2afc, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2afd, 0x2afd, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2afe, 0x2b4c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b50, 0x2b59, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ce5, 0x2cea, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2cef, 0x2cf1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2cf9, 0x2cff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2de0, 0x2dff, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2e00, 0x2e01, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e02, 0x2e05, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e06, 0x2e08, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e09, 0x2e0a, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0b, 0x2e0b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0c, 0x2e0d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0e, 0x2e1b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e1c, 0x2e1d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e1e, 0x2e1f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e20, 0x2e29, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e2a, 0x2e31, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e80, 0x2e99, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e9b, 0x2ef3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2f00, 0x2fd5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ff0, 0x2ffb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3000, 0x3000, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3001, 0x3004, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3008, 0x3011, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3012, 0x3013, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3014, 0x301b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x301c, 0x3020, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x302a, 0x302a, GRUB_BIDI_TYPE_NSM, 218, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302b, 0x302b, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302c, 0x302c, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302d, 0x302d, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302e, 0x302f, GRUB_BIDI_TYPE_NSM, 224, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x3030, 0x3030, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3036, 0x3037, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x303d, 0x303f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3099, 0x309a, GRUB_BIDI_TYPE_NSM, 8, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x309b, 0x309c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30a0, 0x30a0, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30fb, 0x30fb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x31c0, 0x31e3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x321d, 0x321e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3250, 0x325f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x327c, 0x327e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x32b1, 0x32bf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x32cc, 0x32cf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3377, 0x337a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x33de, 0x33df, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x33ff, 0x33ff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x4dc0, 0x4dff, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa490, 0xa4c6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa60d, 0xa60f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa66f, 0xa66f, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa670, 0xa672, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa673, 0xa673, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa67c, 0xa67d, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa67e, 0xa67f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa6f0, 0xa6f1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa700, 0xa721, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa788, 0xa788, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa802, 0xa802, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa806, 0xa806, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa80b, 0xa80b, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa823, 0xa824, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa825, 0xa826, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa827, 0xa827, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa828, 0xa82b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa838, 0xa839, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa874, 0xa877, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa880, 0xa881, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa8b4, 0xa8c3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa8c4, 0xa8c4, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa8e0, 0xa8f1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa926, 0xa92a, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa92b, 0xa92d, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa947, 0xa951, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa952, 0xa952, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa953, 0xa953, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa980, 0xa982, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa983, 0xa983, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9b3, 0xa9b3, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9b4, 0xa9b5, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9b6, 0xa9b9, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9ba, 0xa9bb, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9bc, 0xa9bc, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9bd, 0xa9bf, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9c0, 0xa9c0, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa29, 0xaa2e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa2f, 0xaa30, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa31, 0xaa32, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa33, 0xaa34, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa35, 0xaa36, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa43, 0xaa43, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa4c, 0xaa4c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa4d, 0xaa4d, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa7b, 0xaa7b, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaab0, 0xaab0, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab2, 0xaab3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab4, 0xaab4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab7, 0xaab8, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaabe, 0xaabf, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaac1, 0xaac1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe3, 0xabe4, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabe5, 0xabe5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe6, 0xabe7, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabe8, 0xabe8, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe9, 0xabea, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabec, 0xabec, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabed, 0xabed, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfb1d, 0xfb1d, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb1e, 0xfb1e, GRUB_BIDI_TYPE_NSM, 26, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfb1f, 0xfb28, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb29, 0xfb29, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb2a, 0xfb36, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb38, 0xfb3c, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb3e, 0xfb3e, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb40, 0xfb41, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb43, 0xfb44, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb46, 0xfb4f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb50, 0xfbb1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfbd3, 0xfd3d, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd3e, 0xfd3f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd50, 0xfd8f, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd92, 0xfdc7, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfdf0, 0xfdfc, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfdfd, 0xfdfd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe00, 0xfe0f, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfe10, 0xfe19, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe20, 0xfe26, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfe30, 0xfe4f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe50, 0xfe50, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe51, 0xfe51, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe52, 0xfe52, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe54, 0xfe54, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe55, 0xfe55, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe56, 0xfe58, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe59, 0xfe5e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xfe5f, 0xfe5f, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe60, 0xfe61, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe62, 0xfe63, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe64, 0xfe65, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xfe66, 0xfe66, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe68, 0xfe68, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe69, 0xfe6a, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe6b, 0xfe6b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe70, 0xfe74, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe76, 0xfefc, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfeff, 0xfeff, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xff01, 0xff02, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff03, 0xff05, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff06, 0xff07, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff08, 0xff09, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff0a, 0xff0a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0b, 0xff0b, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0c, 0xff0c, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0d, 0xff0d, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0e, 0xff0f, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff10, 0xff19, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1a, 0xff1a, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1b, 0xff1b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1c, 0xff1c, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff1d, 0xff1d, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1e, 0xff1e, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff1f, 0xff20, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff3b, 0xff3b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff3c, 0xff3c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff3d, 0xff3d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff3e, 0xff40, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5b, 0xff5b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff5c, 0xff5c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5d, 0xff5d, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff5e, 0xff5e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5f, 0xff60, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff61, 0xff61, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff62, 0xff63, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff64, 0xff65, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe0, 0xffe1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe2, 0xffe4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe5, 0xffe6, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe8, 0xffee, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfff9, 0xfffb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfffc, 0xfffd, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10101, 0x10101, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10140, 0x1018a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10190, 0x1019b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x101fd, 0x101fd, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10800, 0x10805, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10808, 0x10808, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1080a, 0x10835, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10837, 0x10838, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1083c, 0x1083c, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1083f, 0x10855, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10857, 0x1085f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10900, 0x1091b, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1091f, 0x1091f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10920, 0x10939, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1093f, 0x1093f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a00, 0x10a00, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a01, 0x10a03, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a05, 0x10a06, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0c, 0x10a0c, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0d, 0x10a0d, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0e, 0x10a0e, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0f, 0x10a0f, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a10, 0x10a13, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a15, 0x10a17, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a19, 0x10a33, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a38, 0x10a38, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a39, 0x10a39, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a3a, 0x10a3a, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a3f, 0x10a3f, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a40, 0x10a47, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a50, 0x10a58, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a60, 0x10a7f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b00, 0x10b35, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b39, 0x10b3f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b40, 0x10b55, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b58, 0x10b72, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b78, 0x10b7f, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10c00, 0x10c48, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10e60, 0x10e7e, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x11080, 0x11081, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x11082, 0x11082, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b0, 0x110b2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b3, 0x110b6, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x110b7, 0x110b8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b9, 0x110b9, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x110ba, 0x110ba, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d165, 0x1d166, GRUB_BIDI_TYPE_L, 216, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d167, 0x1d169, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d16d, 0x1d16d, GRUB_BIDI_TYPE_L, 226, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d16e, 0x1d172, GRUB_BIDI_TYPE_L, 216, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d173, 0x1d17a, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d17b, 0x1d182, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d185, 0x1d189, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d18a, 0x1d18b, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d1aa, 0x1d1ad, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d200, 0x1d241, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d242, 0x1d244, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d245, 0x1d245, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d300, 0x1d356, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d6db, 0x1d6db, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d715, 0x1d715, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d74f, 0x1d74f, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d789, 0x1d789, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d7c3, 0x1d7c3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d7ce, 0x1d7ff, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f000, 0x1f02b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f030, 0x1f093, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f100, 0x1f10a, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe0001, 0xe0001, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe0020, 0xe007f, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe0100, 0xe01ef, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0, 0, 0, 0, 0, 0},
};
struct grub_unicode_bidi_pair grub_unicode_bidi_pairs[] = {
{0x28, 0x29},
{0x29, 0x28},
{0x3c, 0x3e},
{0x3e, 0x3c},
{0x5b, 0x5d},
{0x5d, 0x5b},
{0x7b, 0x7d},
{0x7d, 0x7b},
{0xab, 0xbb},
{0xbb, 0xab},
{0xf3a, 0xf3b},
{0xf3b, 0xf3a},
{0xf3c, 0xf3d},
{0xf3d, 0xf3c},
{0x169b, 0x169c},
{0x169c, 0x169b},
{0x2039, 0x203a},
{0x203a, 0x2039},
{0x2045, 0x2046},
{0x2046, 0x2045},
{0x207d, 0x207e},
{0x207e, 0x207d},
{0x208d, 0x208e},
{0x208e, 0x208d},
{0x2208, 0x220b},
{0x2209, 0x220c},
{0x220a, 0x220d},
{0x220b, 0x2208},
{0x220c, 0x2209},
{0x220d, 0x220a},
{0x2215, 0x29f5},
{0x223c, 0x223d},
{0x223d, 0x223c},
{0x2243, 0x22cd},
{0x2252, 0x2253},
{0x2253, 0x2252},
{0x2254, 0x2255},
{0x2255, 0x2254},
{0x2264, 0x2265},
{0x2265, 0x2264},
{0x2266, 0x2267},
{0x2267, 0x2266},
{0x2268, 0x2269},
{0x2269, 0x2268},
{0x226a, 0x226b},
{0x226b, 0x226a},
{0x226e, 0x226f},
{0x226f, 0x226e},
{0x2270, 0x2271},
{0x2271, 0x2270},
{0x2272, 0x2273},
{0x2273, 0x2272},
{0x2274, 0x2275},
{0x2275, 0x2274},
{0x2276, 0x2277},
{0x2277, 0x2276},
{0x2278, 0x2279},
{0x2279, 0x2278},
{0x227a, 0x227b},
{0x227b, 0x227a},
{0x227c, 0x227d},
{0x227d, 0x227c},
{0x227e, 0x227f},
{0x227f, 0x227e},
{0x2280, 0x2281},
{0x2281, 0x2280},
{0x2282, 0x2283},
{0x2283, 0x2282},
{0x2284, 0x2285},
{0x2285, 0x2284},
{0x2286, 0x2287},
{0x2287, 0x2286},
{0x2288, 0x2289},
{0x2289, 0x2288},
{0x228a, 0x228b},
{0x228b, 0x228a},
{0x228f, 0x2290},
{0x2290, 0x228f},
{0x2291, 0x2292},
{0x2292, 0x2291},
{0x2298, 0x29b8},
{0x22a2, 0x22a3},
{0x22a3, 0x22a2},
{0x22a6, 0x2ade},
{0x22a8, 0x2ae4},
{0x22a9, 0x2ae3},
{0x22ab, 0x2ae5},
{0x22b0, 0x22b1},
{0x22b1, 0x22b0},
{0x22b2, 0x22b3},
{0x22b3, 0x22b2},
{0x22b4, 0x22b5},
{0x22b5, 0x22b4},
{0x22b6, 0x22b7},
{0x22b7, 0x22b6},
{0x22c9, 0x22ca},
{0x22ca, 0x22c9},
{0x22cb, 0x22cc},
{0x22cc, 0x22cb},
{0x22cd, 0x2243},
{0x22d0, 0x22d1},
{0x22d1, 0x22d0},
{0x22d6, 0x22d7},
{0x22d7, 0x22d6},
{0x22d8, 0x22d9},
{0x22d9, 0x22d8},
{0x22da, 0x22db},
{0x22db, 0x22da},
{0x22dc, 0x22dd},
{0x22dd, 0x22dc},
{0x22de, 0x22df},
{0x22df, 0x22de},
{0x22e0, 0x22e1},
{0x22e1, 0x22e0},
{0x22e2, 0x22e3},
{0x22e3, 0x22e2},
{0x22e4, 0x22e5},
{0x22e5, 0x22e4},
{0x22e6, 0x22e7},
{0x22e7, 0x22e6},
{0x22e8, 0x22e9},
{0x22e9, 0x22e8},
{0x22ea, 0x22eb},
{0x22eb, 0x22ea},
{0x22ec, 0x22ed},
{0x22ed, 0x22ec},
{0x22f0, 0x22f1},
{0x22f1, 0x22f0},
{0x22f2, 0x22fa},
{0x22f3, 0x22fb},
{0x22f4, 0x22fc},
{0x22f6, 0x22fd},
{0x22f7, 0x22fe},
{0x22fa, 0x22f2},
{0x22fb, 0x22f3},
{0x22fc, 0x22f4},
{0x22fd, 0x22f6},
{0x22fe, 0x22f7},
{0x2308, 0x2309},
{0x2309, 0x2308},
{0x230a, 0x230b},
{0x230b, 0x230a},
{0x2329, 0x232a},
{0x232a, 0x2329},
{0x2768, 0x2769},
{0x2769, 0x2768},
{0x276a, 0x276b},
{0x276b, 0x276a},
{0x276c, 0x276d},
{0x276d, 0x276c},
{0x276e, 0x276f},
{0x276f, 0x276e},
{0x2770, 0x2771},
{0x2771, 0x2770},
{0x2772, 0x2773},
{0x2773, 0x2772},
{0x2774, 0x2775},
{0x2775, 0x2774},
{0x27c3, 0x27c4},
{0x27c4, 0x27c3},
{0x27c5, 0x27c6},
{0x27c6, 0x27c5},
{0x27c8, 0x27c9},
{0x27c9, 0x27c8},
{0x27d5, 0x27d6},
{0x27d6, 0x27d5},
{0x27dd, 0x27de},
{0x27de, 0x27dd},
{0x27e2, 0x27e3},
{0x27e3, 0x27e2},
{0x27e4, 0x27e5},
{0x27e5, 0x27e4},
{0x27e6, 0x27e7},
{0x27e7, 0x27e6},
{0x27e8, 0x27e9},
{0x27e9, 0x27e8},
{0x27ea, 0x27eb},
{0x27eb, 0x27ea},
{0x27ec, 0x27ed},
{0x27ed, 0x27ec},
{0x27ee, 0x27ef},
{0x27ef, 0x27ee},
{0x2983, 0x2984},
{0x2984, 0x2983},
{0x2985, 0x2986},
{0x2986, 0x2985},
{0x2987, 0x2988},
{0x2988, 0x2987},
{0x2989, 0x298a},
{0x298a, 0x2989},
{0x298b, 0x298c},
{0x298c, 0x298b},
{0x298d, 0x2990},
{0x298e, 0x298f},
{0x298f, 0x298e},
{0x2990, 0x298d},
{0x2991, 0x2992},
{0x2992, 0x2991},
{0x2993, 0x2994},
{0x2994, 0x2993},
{0x2995, 0x2996},
{0x2996, 0x2995},
{0x2997, 0x2998},
{0x2998, 0x2997},
{0x29b8, 0x2298},
{0x29c0, 0x29c1},
{0x29c1, 0x29c0},
{0x29c4, 0x29c5},
{0x29c5, 0x29c4},
{0x29cf, 0x29d0},
{0x29d0, 0x29cf},
{0x29d1, 0x29d2},
{0x29d2, 0x29d1},
{0x29d4, 0x29d5},
{0x29d5, 0x29d4},
{0x29d8, 0x29d9},
{0x29d9, 0x29d8},
{0x29da, 0x29db},
{0x29db, 0x29da},
{0x29f5, 0x2215},
{0x29f8, 0x29f9},
{0x29f9, 0x29f8},
{0x29fc, 0x29fd},
{0x29fd, 0x29fc},
{0x2a2b, 0x2a2c},
{0x2a2c, 0x2a2b},
{0x2a2d, 0x2a2e},
{0x2a2e, 0x2a2d},
{0x2a34, 0x2a35},
{0x2a35, 0x2a34},
{0x2a3c, 0x2a3d},
{0x2a3d, 0x2a3c},
{0x2a64, 0x2a65},
{0x2a65, 0x2a64},
{0x2a79, 0x2a7a},
{0x2a7a, 0x2a79},
{0x2a7d, 0x2a7e},
{0x2a7e, 0x2a7d},
{0x2a7f, 0x2a80},
{0x2a80, 0x2a7f},
{0x2a81, 0x2a82},
{0x2a82, 0x2a81},
{0x2a83, 0x2a84},
{0x2a84, 0x2a83},
{0x2a8b, 0x2a8c},
{0x2a8c, 0x2a8b},
{0x2a91, 0x2a92},
{0x2a92, 0x2a91},
{0x2a93, 0x2a94},
{0x2a94, 0x2a93},
{0x2a95, 0x2a96},
{0x2a96, 0x2a95},
{0x2a97, 0x2a98},
{0x2a98, 0x2a97},
{0x2a99, 0x2a9a},
{0x2a9a, 0x2a99},
{0x2a9b, 0x2a9c},
{0x2a9c, 0x2a9b},
{0x2aa1, 0x2aa2},
{0x2aa2, 0x2aa1},
{0x2aa6, 0x2aa7},
{0x2aa7, 0x2aa6},
{0x2aa8, 0x2aa9},
{0x2aa9, 0x2aa8},
{0x2aaa, 0x2aab},
{0x2aab, 0x2aaa},
{0x2aac, 0x2aad},
{0x2aad, 0x2aac},
{0x2aaf, 0x2ab0},
{0x2ab0, 0x2aaf},
{0x2ab3, 0x2ab4},
{0x2ab4, 0x2ab3},
{0x2abb, 0x2abc},
{0x2abc, 0x2abb},
{0x2abd, 0x2abe},
{0x2abe, 0x2abd},
{0x2abf, 0x2ac0},
{0x2ac0, 0x2abf},
{0x2ac1, 0x2ac2},
{0x2ac2, 0x2ac1},
{0x2ac3, 0x2ac4},
{0x2ac4, 0x2ac3},
{0x2ac5, 0x2ac6},
{0x2ac6, 0x2ac5},
{0x2acd, 0x2ace},
{0x2ace, 0x2acd},
{0x2acf, 0x2ad0},
{0x2ad0, 0x2acf},
{0x2ad1, 0x2ad2},
{0x2ad2, 0x2ad1},
{0x2ad3, 0x2ad4},
{0x2ad4, 0x2ad3},
{0x2ad5, 0x2ad6},
{0x2ad6, 0x2ad5},
{0x2ade, 0x22a6},
{0x2ae3, 0x22a9},
{0x2ae4, 0x22a8},
{0x2ae5, 0x22ab},
{0x2aec, 0x2aed},
{0x2aed, 0x2aec},
{0x2af7, 0x2af8},
{0x2af8, 0x2af7},
{0x2af9, 0x2afa},
{0x2afa, 0x2af9},
{0x2e02, 0x2e03},
{0x2e03, 0x2e02},
{0x2e04, 0x2e05},
{0x2e05, 0x2e04},
{0x2e09, 0x2e0a},
{0x2e0a, 0x2e09},
{0x2e0c, 0x2e0d},
{0x2e0d, 0x2e0c},
{0x2e1c, 0x2e1d},
{0x2e1d, 0x2e1c},
{0x2e20, 0x2e21},
{0x2e21, 0x2e20},
{0x2e22, 0x2e23},
{0x2e23, 0x2e22},
{0x2e24, 0x2e25},
{0x2e25, 0x2e24},
{0x2e26, 0x2e27},
{0x2e27, 0x2e26},
{0x2e28, 0x2e29},
{0x2e29, 0x2e28},
{0x3008, 0x3009},
{0x3009, 0x3008},
{0x300a, 0x300b},
{0x300b, 0x300a},
{0x300c, 0x300d},
{0x300d, 0x300c},
{0x300e, 0x300f},
{0x300f, 0x300e},
{0x3010, 0x3011},
{0x3011, 0x3010},
{0x3014, 0x3015},
{0x3015, 0x3014},
{0x3016, 0x3017},
{0x3017, 0x3016},
{0x3018, 0x3019},
{0x3019, 0x3018},
{0x301a, 0x301b},
{0x301b, 0x301a},
{0xfe59, 0xfe5a},
{0xfe5a, 0xfe59},
{0xfe5b, 0xfe5c},
{0xfe5c, 0xfe5b},
{0xfe5d, 0xfe5e},
{0xfe5e, 0xfe5d},
{0xfe64, 0xfe65},
{0xfe65, 0xfe64},
{0xff08, 0xff09},
{0xff09, 0xff08},
{0xff1c, 0xff1e},
{0xff1e, 0xff1c},
{0xff3b, 0xff3d},
{0xff3d, 0xff3b},
{0xff5b, 0xff5d},
{0xff5d, 0xff5b},
{0xff5f, 0xff60},
{0xff60, 0xff5f},
{0xff62, 0xff63},
{0xff63, 0xff62},
{0, 0},
};
struct grub_unicode_arabic_shape grub_unicode_arabic_shapes[] = {
 {0x6ad, 0xfbd3, 0xfbd4, 0xfbd6, 0xfbd5},
 {0x67f, 0xfb62, 0xfb63, 0xfb65, 0xfb64},
 {0x6c0, 0xfba4, 0xfba5, 0x0, 0x0},
 {0x642, 0xfed5, 0xfed6, 0xfed8, 0xfed7},
 {0x630, 0xfeab, 0xfeac, 0x0, 0x0},
 {0x635, 0xfeb9, 0xfeba, 0xfebc, 0xfebb},
 {0x637, 0xfec1, 0xfec2, 0xfec4, 0xfec3},
 {0x62d, 0xfea1, 0xfea2, 0xfea4, 0xfea3},
 {0x644, 0xfedd, 0xfede, 0xfee0, 0xfedf},
 {0x6a9, 0xfb8e, 0xfb8f, 0xfb91, 0xfb90},
 {0x6c1, 0xfba6, 0xfba7, 0xfba9, 0xfba8},
 {0x68d, 0xfb82, 0xfb83, 0x0, 0x0},
 {0x680, 0xfb5a, 0xfb5b, 0xfb5d, 0xfb5c},
 {0x64a, 0xfef1, 0xfef2, 0xfef4, 0xfef3},
 {0x643, 0xfed9, 0xfeda, 0xfedc, 0xfedb},
 {0x638, 0xfec5, 0xfec6, 0xfec8, 0xfec7},
 {0x6c6, 0xfbd9, 0xfbda, 0x0, 0x0},
 {0x6d2, 0xfbae, 0xfbaf, 0x0, 0x0},
 {0x67e, 0xfb56, 0xfb57, 0xfb59, 0xfb58},
 {0x627, 0xfe8d, 0xfe8e, 0x0, 0x0},
 {0x622, 0xfe81, 0xfe82, 0x0, 0x0},
 {0x628, 0xfe8f, 0xfe90, 0xfe92, 0xfe91},
 {0x688, 0xfb88, 0xfb89, 0x0, 0x0},
 {0x687, 0xfb7e, 0xfb7f, 0xfb81, 0xfb80},
 {0x6b1, 0xfb9a, 0xfb9b, 0xfb9d, 0xfb9c},
 {0x645, 0xfee1, 0xfee2, 0xfee4, 0xfee3},
 {0x62c, 0xfe9d, 0xfe9e, 0xfea0, 0xfe9f},
 {0x6c5, 0xfbe0, 0xfbe1, 0x0, 0x0},
 {0x671, 0xfb50, 0xfb51, 0x0, 0x0},
 {0x634, 0xfeb5, 0xfeb6, 0xfeb8, 0xfeb7},
 {0x625, 0xfe87, 0xfe88, 0x0, 0x0},
 {0x67b, 0xfb52, 0xfb53, 0xfb55, 0xfb54},
 {0x646, 0xfee5, 0xfee6, 0xfee8, 0xfee7},
 {0x68c, 0xfb84, 0xfb85, 0x0, 0x0},
 {0x62b, 0xfe99, 0xfe9a, 0xfe9c, 0xfe9b},
 {0x631, 0xfead, 0xfeae, 0x0, 0x0},
 {0x6b3, 0xfb96, 0xfb97, 0xfb99, 0xfb98},
 {0x683, 0xfb76, 0xfb77, 0xfb79, 0xfb78},
 {0x62a, 0xfe95, 0xfe96, 0xfe98, 0xfe97},
 {0x63a, 0xfecd, 0xfece, 0xfed0, 0xfecf},
 {0x624, 0xfe85, 0xfe86, 0x0, 0x0},
 {0x679, 0xfb66, 0xfb67, 0xfb69, 0xfb68},
 {0x68e, 0xfb86, 0xfb87, 0x0, 0x0},
 {0x623, 0xfe83, 0xfe84, 0x0, 0x0},
 {0x6c9, 0xfbe2, 0xfbe3, 0x0, 0x0},
 {0x641, 0xfed1, 0xfed2, 0xfed4, 0xfed3},
 {0x648, 0xfeed, 0xfeee, 0x0, 0x0},
 {0x698, 0xfb8a, 0xfb8b, 0x0, 0x0},
 {0x647, 0xfee9, 0xfeea, 0xfeec, 0xfeeb},
 {0x6a4, 0xfb6a, 0xfb6b, 0xfb6d, 0xfb6c},
 {0x62e, 0xfea5, 0xfea6, 0xfea8, 0xfea7},
 {0x6bb, 0xfba0, 0xfba1, 0xfba3, 0xfba2},
 {0x686, 0xfb7a, 0xfb7b, 0xfb7d, 0xfb7c},
 {0x6cc, 0xfbfc, 0xfbfd, 0xfbff, 0xfbfe},
 {0x6a6, 0xfb6e, 0xfb6f, 0xfb71, 0xfb70},
 {0x639, 0xfec9, 0xfeca, 0xfecc, 0xfecb},
 {0x633, 0xfeb1, 0xfeb2, 0xfeb4, 0xfeb3},
 {0x6c8, 0xfbdb, 0xfbdc, 0x0, 0x0},
 {0x636, 0xfebd, 0xfebe, 0xfec0, 0xfebf},
 {0x6be, 0xfbaa, 0xfbab, 0xfbad, 0xfbac},
 {0x62f, 0xfea9, 0xfeaa, 0x0, 0x0},
 {0x6af, 0xfb92, 0xfb93, 0xfb95, 0xfb94},
 {0x6d0, 0xfbe4, 0xfbe5, 0xfbe7, 0xfbe6},
 {0x6cb, 0xfbde, 0xfbdf, 0x0, 0x0},
 {0x626, 0xfe89, 0xfe8a, 0xfe8c, 0xfe8b},
 {0x6c7, 0xfbd7, 0xfbd8, 0x0, 0x0},
 {0x684, 0xfb72, 0xfb73, 0xfb75, 0xfb74},
 {0x6d3, 0xfbb0, 0xfbb1, 0x0, 0x0},
 {0x67a, 0xfb5e, 0xfb5f, 0xfb61, 0xfb60},
 {0x632, 0xfeaf, 0xfeb0, 0x0, 0x0},
 {0x691, 0xfb8c, 0xfb8d, 0x0, 0x0},
 {0x629, 0xfe93, 0xfe94, 0x0, 0x0},
 {0, 0, 0, 0, 0},
};
