/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.PrologStream;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BinaryPrologStream
extends PrologStream {
    protected RandomAccessFile file;

    public BinaryPrologStream(AtomTerm fileAtom, AtomTerm mode, PrologStream.OpenOptions options) throws PrologException {
        super(options);
        String of = mode == readAtom ? "r" : "rw";
        try {
            this.file = new RandomAccessFile(fileAtom.value, of);
            if (mode == appendAtom) {
                this.file.seek(this.file.length());
            } else if (mode == writeAtom) {
                this.file.setLength(0L);
            }
        }
        catch (Exception ex) {
            PrologException.systemError(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        if (this.mode == inputAtom) {
            this.getEndOfStreamState();
            if (this.endOfStream == pastAtom) {
                PrologException.permissionError(inputAtom, TermConstants.pastEndOfStreamAtom, streamTerm);
                return -1;
            }
            if (this.endOfStream == atAtom) {
                this.endOfStream = pastAtom;
                return -1;
            }
            try {
                return this.file.read();
            }
            catch (IOException ex) {
                PrologException.systemError(ex);
                return -1;
            }
        }
        PrologException.permissionError(inputAtom, streamAtom, streamTerm);
        return -1;
    }

    @Override
    public int peekByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        if (this.mode == inputAtom) {
            this.getEndOfStreamState();
            if (this.endOfStream == pastAtom) {
                PrologException.permissionError(inputAtom, TermConstants.pastEndOfStreamAtom, streamTerm);
            } else {
                if (this.endOfStream == atAtom) {
                    this.endOfStream = pastAtom;
                    return -1;
                }
                try {
                    long pos = this.file.getFilePointer();
                    int rc = this.file.read();
                    this.file.seek(pos);
                    return rc;
                }
                catch (IOException ex) {
                    PrologException.systemError(ex);
                }
            }
        } else {
            PrologException.permissionError(inputAtom, streamAtom, streamTerm);
        }
        return -1;
    }

    @Override
    public void putByte(Term streamTerm, Interpreter interptreter, int _byte) throws PrologException {
        this.checkExists();
        if (this.mode == outputAtom) {
            try {
                this.file.write(_byte);
            }
            catch (IOException ex) {
                PrologException.systemError(ex);
            }
        } else {
            PrologException.permissionError(outputAtom, streamAtom, streamTerm);
        }
    }

    @Override
    public Term getPosition(Term streamTerm, Interpreter interptreter) throws PrologException {
        try {
            return new JavaObjectTerm(this.file.getFilePointer());
        }
        catch (IOException ex) {
            PrologException.systemError(ex);
            return null;
        }
    }

    @Override
    public void setPosition(Term streamTerm, Interpreter interptreter, Term position) throws PrologException {
        try {
            long pos;
            if (this.reposition == TermConstants.falseAtom) {
                PrologException.permissionError(repositionAtom, streamAtom, this.getStreamTerm());
            }
            if (position instanceof VariableTerm) {
                PrologException.instantiationError();
            } else if (!(position instanceof JavaObjectTerm)) {
                PrologException.domainError(TermConstants.streamPositionAtom, position);
            }
            JavaObjectTerm jt = (JavaObjectTerm)position;
            if (!(jt.value instanceof Long)) {
                PrologException.domainError(TermConstants.streamPositionAtom, position);
            }
            if ((pos = ((Long)jt.value).longValue()) > this.file.length()) {
                PrologException.domainError(TermConstants.streamPositionAtom, position);
            }
            this.file.seek(pos);
        }
        catch (IOException ex) {
            PrologException.systemError(ex);
        }
    }

    @Override
    public int getCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        PrologException.permissionError(inputAtom, TermConstants.binaryStreamAtom, streamTerm);
        return -1;
    }

    @Override
    public int peekCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        PrologException.permissionError(inputAtom, TermConstants.binaryStreamAtom, streamTerm);
        return -1;
    }

    @Override
    public void putCode(Term streamTerm, Interpreter interptreter, int code) throws PrologException {
        PrologException.permissionError(outputAtom, TermConstants.binaryStreamAtom, streamTerm);
    }

    @Override
    public void putCodeSequence(Term streamTerm, Interpreter interptreter, String seq) throws PrologException {
        PrologException.permissionError(outputAtom, TermConstants.binaryStreamAtom, streamTerm);
    }

    @Override
    public Term readTerm(Term streamTerm, Interpreter i, ReadOptions o) throws PrologException {
        PrologException.permissionError(inputAtom, TermConstants.binaryStreamAtom, streamTerm);
        return null;
    }

    @Override
    public void writeTerm(Term streamTerm, Interpreter i, WriteOptions o, Term t) throws PrologException {
        PrologException.permissionError(outputAtom, TermConstants.binaryStreamAtom, streamTerm);
    }

    @Override
    public void flushOutput(Term streamTerm) throws PrologException {
        if (this.mode == inputAtom) {
            this.checkExists();
            PrologException.permissionError(outputAtom, streamAtom, streamTerm);
        }
    }

    @Override
    public void close(boolean force) throws PrologException {
        block2: {
            try {
                this.file.close();
            }
            catch (IOException ex) {
                if (force) break block2;
                return;
            }
        }
        super.close(force);
    }

    @Override
    public Term getEndOfStreamState() throws PrologException {
        try {
            long length = this.file.length();
            long pos = this.file.getFilePointer();
            if (pos < length) {
                this.endOfStream = notAtom;
            } else if (this.endOfStream == pastAtom && (this.eofAction == resetAtom || this.eofAction == eofCodeAtom)) {
                this.endOfStream = atAtom;
            }
        }
        catch (IOException ex) {
            PrologException.systemError(ex);
        }
        return super.getEndOfStreamState();
    }
}

