/* Test for correct rounding of results of strtod and related
   functions.
   Copyright (C) 2012 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <fenv.h>
#include <float.h>
#include <math.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct test_results {
  float f;
  double d;
  long double ld;
};

struct test {
  const char *s;
  bool ld_ok;
  struct test_results rd, rn, rz, ru;
};

#if LDBL_MANT_DIG == 53 && LDBL_MAX_EXP == 1024
# define TEST(s, fd, fn, fz, fu, dd, dn, dz, du, ld53d, ld53n, ld53z, ld53u,  \
	      ld64id, ld64in, ld64iz, ld64iu,				      \
	      ld64md, ld64mn, ld64mz, ld64mu,				      \
	      ld106exact, ld106d, ld106n, ld106z, ld106u,		      \
	      ld113d, ld113n, ld113z, ld113u)				      \
  {									\
    s,									\
    true,								\
    { fd, dd, ld53d },							\
    { fn, dn, ld53n },							\
    { fz, dz, ld53z },							\
    { fu, du, ld53u }							\
  }
#elif LDBL_MANT_DIG == 64 && LDBL_MAX_EXP == 16384 && LDBL_MIN_EXP == -16381
/* This is for the Intel extended float format.  */
# define TEST(s, fd, fn, fz, fu, dd, dn, dz, du, ld53d, ld53n, ld53z, ld53u,  \
	      ld64id, ld64in, ld64iz, ld64iu,				      \
	      ld64md, ld64mn, ld64mz, ld64mu,				      \
	      ld106exact, ld106d, ld106n, ld106z, ld106u,		      \
	      ld113d, ld113n, ld113z, ld113u)				      \
  {									\
    s,									\
    true,								\
    { fd, dd, ld64id },							\
    { fn, dn, ld64in },							\
    { fz, dz, ld64iz },							\
    { fu, du, ld64iu }							\
  }
#elif LDBL_MANT_DIG == 64 && LDBL_MAX_EXP == 16384 && LDBL_MIN_EXP == -16382
/* This is for the Motorola extended float format.  */
# define TEST(s, fd, fn, fz, fu, dd, dn, dz, du, ld53d, ld53n, ld53z, ld53u,  \
	      ld64id, ld64in, ld64iz, ld64iu,				      \
	      ld64md, ld64mn, ld64mz, ld64mu,				      \
	      ld106exact, ld106d, ld106n, ld106z, ld106u,		      \
	      ld113d, ld113n, ld113z, ld113u)				      \
  {									\
    s,									\
    true,								\
    { fd, dd, ld64md },							\
    { fn, dn, ld64mn },							\
    { fz, dz, ld64mz },							\
    { fu, du, ld64mu }							\
  }
#elif LDBL_MANT_DIG == 106 && LDBL_MAX_EXP == 1024
# define TEST(s, fd, fn, fz, fu, dd, dn, dz, du, ld53d, ld53n, ld53z, ld53u,  \
	      ld64id, ld64in, ld64iz, ld64iu,				      \
	      ld64md, ld64mn, ld64mz, ld64mu,				      \
	      ld106exact, ld106d, ld106n, ld106z, ld106u,		      \
	      ld113d, ld113n, ld113z, ld113u)				      \
  {									\
    s,									\
    ld106exact,								\
    { fd, dd, ld106d },							\
    { fn, dn, ld106n },							\
    { fz, dz, ld106z },							\
    { fu, du, ld106u }							\
  }
#elif LDBL_MANT_DIG == 113 && LDBL_MAX_EXP == 16384
# define TEST(s, fd, fn, fz, fu, dd, dn, dz, du, ld53d, ld53n, ld53z, ld53u,  \
	      ld64id, ld64in, ld64iz, ld64iu,				      \
	      ld64md, ld64mn, ld64mz, ld64mu,				      \
	      ld106exact, ld106d, ld106n, ld106z, ld106u,		      \
	      ld113d, ld113n, ld113z, ld113u)				      \
  {									\
    s,									\
    true,								\
    { fd, dd, ld113d },							\
    { fn, dn, ld113n },							\
    { fz, dz, ld113z },							\
    { fu, du, ld113u }							\
  }
#else
# error "unknown long double format"
#endif

/* These tests are generated by gen-tst-strtod-round.c from
   tst-strtod-round-data.  */

static const struct test tests[] = {
  TEST ("3.518437208883201171875E+013",
	0x2p+44f,
	0x2p+44f,
	0x2p+44f,
	0x2.000004p+44f,
	0x2.0000000000002p+44,
	0x2.0000000000004p+44,
	0x2.0000000000002p+44,
	0x2.0000000000004p+44,
	0x2.0000000000002p+44L,
	0x2.0000000000004p+44L,
	0x2.0000000000002p+44L,
	0x2.0000000000004p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	true,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L,
	0x2.0000000000003p+44L),
  TEST ("1.00000005960464477550",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000004p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000004p+0L,
	false,
	0x1.0000010000000002048242f2ffp+0L,
	0x1.0000010000000002048242f2ff8p+0L,
	0x1.0000010000000002048242f2ffp+0L,
	0x1.0000010000000002048242f2ff8p+0L,
	0x1.0000010000000002048242f2ff66p+0L,
	0x1.0000010000000002048242f2ff67p+0L,
	0x1.0000010000000002048242f2ff66p+0L,
	0x1.0000010000000002048242f2ff67p+0L),
  TEST ("1.0000000596046447755",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000004p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000002p+0L,
	0x1.0000010000000004p+0L,
	false,
	0x1.0000010000000002048242f2ffp+0L,
	0x1.0000010000000002048242f2ff8p+0L,
	0x1.0000010000000002048242f2ffp+0L,
	0x1.0000010000000002048242f2ff8p+0L,
	0x1.0000010000000002048242f2ff66p+0L,
	0x1.0000010000000002048242f2ff67p+0L,
	0x1.0000010000000002048242f2ff66p+0L,
	0x1.0000010000000002048242f2ff67p+0L),
  TEST ("1.000000059604644776",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.000001000000000ap+0L,
	0x1.000001000000000cp+0L,
	0x1.000001000000000ap+0L,
	0x1.000001000000000cp+0L,
	0x1.000001000000000ap+0L,
	0x1.000001000000000cp+0L,
	0x1.000001000000000ap+0L,
	0x1.000001000000000cp+0L,
	false,
	0x1.000001000000000b3db12bdc21p+0L,
	0x1.000001000000000b3db12bdc21p+0L,
	0x1.000001000000000b3db12bdc21p+0L,
	0x1.000001000000000b3db12bdc218p+0L,
	0x1.000001000000000b3db12bdc213cp+0L,
	0x1.000001000000000b3db12bdc213dp+0L,
	0x1.000001000000000b3db12bdc213cp+0L,
	0x1.000001000000000b3db12bdc213dp+0L),
  TEST ("1.000000059604644775",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffffffp+0,
	0x1.000001p+0,
	0x1.000000fffffffp+0,
	0x1.000001p+0,
	0x1.000000fffffffp+0L,
	0x1.000001p+0L,
	0x1.000000fffffffp+0L,
	0x1.000001p+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffffap+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffff8p+0L,
	0x1.000000fffffffffap+0L,
	false,
	0x1.000000fffffffff8cb535a09dd8p+0L,
	0x1.000000fffffffff8cb535a09dd8p+0L,
	0x1.000000fffffffff8cb535a09dd8p+0L,
	0x1.000000fffffffff8cb535a09dep+0L,
	0x1.000000fffffffff8cb535a09dd9p+0L,
	0x1.000000fffffffff8cb535a09dd91p+0L,
	0x1.000000fffffffff8cb535a09dd9p+0L,
	0x1.000000fffffffff8cb535a09dd91p+0L),
  TEST ("1.00000005960464478",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.0000010000000054p+0L,
	0x1.0000010000000056p+0L,
	0x1.0000010000000054p+0L,
	0x1.0000010000000056p+0L,
	0x1.0000010000000054p+0L,
	0x1.0000010000000056p+0L,
	0x1.0000010000000054p+0L,
	0x1.0000010000000056p+0L,
	false,
	0x1.0000010000000055072873252f8p+0L,
	0x1.0000010000000055072873253p+0L,
	0x1.0000010000000055072873252f8p+0L,
	0x1.0000010000000055072873253p+0L,
	0x1.0000010000000055072873252febp+0L,
	0x1.0000010000000055072873252febp+0L,
	0x1.0000010000000055072873252febp+0L,
	0x1.0000010000000055072873252fecp+0L),
  TEST ("1.0000000596046448",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.00000100000001c4p+0L,
	0x1.00000100000001c6p+0L,
	0x1.00000100000001c4p+0L,
	0x1.00000100000001c6p+0L,
	0x1.00000100000001c4p+0L,
	0x1.00000100000001c6p+0L,
	0x1.00000100000001c4p+0L,
	0x1.00000100000001c6p+0L,
	false,
	0x1.00000100000001c5f67cd79279p+0L,
	0x1.00000100000001c5f67cd792798p+0L,
	0x1.00000100000001c5f67cd79279p+0L,
	0x1.00000100000001c5f67cd792798p+0L,
	0x1.00000100000001c5f67cd7927953p+0L,
	0x1.00000100000001c5f67cd7927954p+0L,
	0x1.00000100000001c5f67cd7927953p+0L,
	0x1.00000100000001c5f67cd7927954p+0L),
  TEST ("1.000000059604645",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.0000010000001p+0,
	0x1.0000010000001p+0,
	0x1.0000010000001p+0,
	0x1.0000010000002p+0,
	0x1.0000010000001p+0L,
	0x1.0000010000001p+0L,
	0x1.0000010000001p+0L,
	0x1.0000010000002p+0L,
	0x1.000001000000102ep+0L,
	0x1.000001000000103p+0L,
	0x1.000001000000102ep+0L,
	0x1.000001000000103p+0L,
	0x1.000001000000102ep+0L,
	0x1.000001000000103p+0L,
	0x1.000001000000102ep+0L,
	0x1.000001000000103p+0L,
	false,
	0x1.000001000000102f4fc8c3d757p+0L,
	0x1.000001000000102f4fc8c3d7578p+0L,
	0x1.000001000000102f4fc8c3d757p+0L,
	0x1.000001000000102f4fc8c3d7578p+0L,
	0x1.000001000000102f4fc8c3d75769p+0L,
	0x1.000001000000102f4fc8c3d75769p+0L,
	0x1.000001000000102f4fc8c3d75769p+0L,
	0x1.000001000000102f4fc8c3d7576ap+0L),
  TEST ("1.00000005960464",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffffeap+0,
	0x1.000000fffffeap+0,
	0x1.000000fffffeap+0,
	0x1.000000fffffebp+0,
	0x1.000000fffffeap+0L,
	0x1.000000fffffeap+0L,
	0x1.000000fffffeap+0L,
	0x1.000000fffffebp+0L,
	0x1.000000fffffea7e4p+0L,
	0x1.000000fffffea7e6p+0L,
	0x1.000000fffffea7e4p+0L,
	0x1.000000fffffea7e6p+0L,
	0x1.000000fffffea7e4p+0L,
	0x1.000000fffffea7e6p+0L,
	0x1.000000fffffea7e4p+0L,
	0x1.000000fffffea7e6p+0L,
	false,
	0x1.000000fffffea7e5975eb11da7p+0L,
	0x1.000000fffffea7e5975eb11da78p+0L,
	0x1.000000fffffea7e5975eb11da7p+0L,
	0x1.000000fffffea7e5975eb11da78p+0L,
	0x1.000000fffffea7e5975eb11da74ap+0L,
	0x1.000000fffffea7e5975eb11da74bp+0L,
	0x1.000000fffffea7e5975eb11da74ap+0L,
	0x1.000000fffffea7e5975eb11da74bp+0L),
  TEST ("1.0000000596046",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffff36p+0,
	0x1.000000fffff36p+0,
	0x1.000000fffff36p+0,
	0x1.000000fffff37p+0,
	0x1.000000fffff36p+0L,
	0x1.000000fffff36p+0L,
	0x1.000000fffff36p+0L,
	0x1.000000fffff37p+0L,
	0x1.000000fffff36596p+0L,
	0x1.000000fffff36598p+0L,
	0x1.000000fffff36596p+0L,
	0x1.000000fffff36598p+0L,
	0x1.000000fffff36596p+0L,
	0x1.000000fffff36598p+0L,
	0x1.000000fffff36596p+0L,
	0x1.000000fffff36598p+0L,
	false,
	0x1.000000fffff36597d40e1b5026p+0L,
	0x1.000000fffff36597d40e1b50268p+0L,
	0x1.000000fffff36597d40e1b5026p+0L,
	0x1.000000fffff36597d40e1b50268p+0L,
	0x1.000000fffff36597d40e1b502655p+0L,
	0x1.000000fffff36597d40e1b502656p+0L,
	0x1.000000fffff36597d40e1b502655p+0L,
	0x1.000000fffff36597d40e1b502656p+0L),
  TEST ("1.000000059605",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001000063fp+0,
	0x1.000001000064p+0,
	0x1.000001000063fp+0,
	0x1.000001000064p+0,
	0x1.000001000063fp+0L,
	0x1.000001000064p+0L,
	0x1.000001000063fp+0L,
	0x1.000001000064p+0L,
	0x1.000001000063fcap+0L,
	0x1.000001000063fca2p+0L,
	0x1.000001000063fcap+0L,
	0x1.000001000063fca2p+0L,
	0x1.000001000063fcap+0L,
	0x1.000001000063fca2p+0L,
	0x1.000001000063fcap+0L,
	0x1.000001000063fca2p+0L,
	false,
	0x1.000001000063fca17533f5572f8p+0L,
	0x1.000001000063fca17533f5573p+0L,
	0x1.000001000063fca17533f5572f8p+0L,
	0x1.000001000063fca17533f5573p+0L,
	0x1.000001000063fca17533f5572fe9p+0L,
	0x1.000001000063fca17533f5572feap+0L,
	0x1.000001000063fca17533f5572fe9p+0L,
	0x1.000001000063fca17533f5572feap+0L),
  TEST ("1.00000005960",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffae49p+0,
	0x1.000000fffae4ap+0,
	0x1.000000fffae49p+0,
	0x1.000000fffae4ap+0,
	0x1.000000fffae49p+0L,
	0x1.000000fffae4ap+0L,
	0x1.000000fffae49p+0L,
	0x1.000000fffae4ap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	false,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff388p+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382ep+0L),
  TEST ("1.0000000596",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffae49p+0,
	0x1.000000fffae4ap+0,
	0x1.000000fffae49p+0,
	0x1.000000fffae4ap+0,
	0x1.000000fffae49p+0L,
	0x1.000000fffae4ap+0L,
	0x1.000000fffae49p+0L,
	0x1.000000fffae4ap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	0x1.000000fffae49ca8p+0L,
	0x1.000000fffae49caap+0L,
	false,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff38p+0L,
	0x1.000000fffae49ca916dacfff388p+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382dp+0L,
	0x1.000000fffae49ca916dacfff382ep+0L),
  TEST ("1.000000060",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.00000101b2b29p+0,
	0x1.00000101b2b2ap+0,
	0x1.00000101b2b29p+0,
	0x1.00000101b2b2ap+0,
	0x1.00000101b2b29p+0L,
	0x1.00000101b2b2ap+0L,
	0x1.00000101b2b29p+0L,
	0x1.00000101b2b2ap+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a48p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a48p+0L,
	false,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca38p+0L,
	0x1.00000101b2b29a4692b67b7ca313p+0L,
	0x1.00000101b2b29a4692b67b7ca314p+0L,
	0x1.00000101b2b29a4692b67b7ca313p+0L,
	0x1.00000101b2b29a4692b67b7ca314p+0L),
  TEST ("1.00000006",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.00000101b2b29p+0,
	0x1.00000101b2b2ap+0,
	0x1.00000101b2b29p+0,
	0x1.00000101b2b2ap+0,
	0x1.00000101b2b29p+0L,
	0x1.00000101b2b2ap+0L,
	0x1.00000101b2b29p+0L,
	0x1.00000101b2b2ap+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a48p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a46p+0L,
	0x1.00000101b2b29a48p+0L,
	false,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca3p+0L,
	0x1.00000101b2b29a4692b67b7ca38p+0L,
	0x1.00000101b2b29a4692b67b7ca313p+0L,
	0x1.00000101b2b29a4692b67b7ca314p+0L,
	0x1.00000101b2b29a4692b67b7ca313p+0L,
	0x1.00000101b2b29a4692b67b7ca314p+0L),
  TEST ("1.0000001",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001ad7f29ap+0,
	0x1.000001ad7f29bp+0,
	0x1.000001ad7f29ap+0,
	0x1.000001ad7f29bp+0,
	0x1.000001ad7f29ap+0L,
	0x1.000001ad7f29bp+0L,
	0x1.000001ad7f29ap+0L,
	0x1.000001ad7f29bp+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abccp+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abcap+0L,
	0x1.000001ad7f29abccp+0L,
	false,
	0x1.000001ad7f29abcaf485787a65p+0L,
	0x1.000001ad7f29abcaf485787a65p+0L,
	0x1.000001ad7f29abcaf485787a65p+0L,
	0x1.000001ad7f29abcaf485787a658p+0L,
	0x1.000001ad7f29abcaf485787a652p+0L,
	0x1.000001ad7f29abcaf485787a6521p+0L,
	0x1.000001ad7f29abcaf485787a652p+0L,
	0x1.000001ad7f29abcaf485787a6521p+0L),
  TEST ("1.000000",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	true,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L),
  TEST ("1.00000000000000011113",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	false,
	0x1.0000000000000801fc96557232p+0L,
	0x1.0000000000000801fc96557232p+0L,
	0x1.0000000000000801fc96557232p+0L,
	0x1.0000000000000801fc965572328p+0L,
	0x1.0000000000000801fc9655723222p+0L,
	0x1.0000000000000801fc9655723222p+0L,
	0x1.0000000000000801fc9655723222p+0L,
	0x1.0000000000000801fc9655723223p+0L),
  TEST ("1.00000000000000011103",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	false,
	0x1.00000000000008002459c076c48p+0L,
	0x1.00000000000008002459c076c5p+0L,
	0x1.00000000000008002459c076c48p+0L,
	0x1.00000000000008002459c076c5p+0L,
	0x1.00000000000008002459c076c4f7p+0L,
	0x1.00000000000008002459c076c4f8p+0L,
	0x1.00000000000008002459c076c4f7p+0L,
	0x1.00000000000008002459c076c4f8p+0L),
  TEST ("1.00000000000000011102",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	false,
	0x1.00000000000007fff5207e5dap+0L,
	0x1.00000000000007fff5207e5da08p+0L,
	0x1.00000000000007fff5207e5dap+0L,
	0x1.00000000000007fff5207e5da08p+0L,
	0x1.00000000000007fff5207e5da073p+0L,
	0x1.00000000000007fff5207e5da073p+0L,
	0x1.00000000000007fff5207e5da073p+0L,
	0x1.00000000000007fff5207e5da074p+0L),
  TEST ("1.00000000000000011101",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	false,
	0x1.00000000000007ffc5e73c447b8p+0L,
	0x1.00000000000007ffc5e73c447cp+0L,
	0x1.00000000000007ffc5e73c447b8p+0L,
	0x1.00000000000007ffc5e73c447cp+0L,
	0x1.00000000000007ffc5e73c447befp+0L,
	0x1.00000000000007ffc5e73c447befp+0L,
	0x1.00000000000007ffc5e73c447befp+0L,
	0x1.00000000000007ffc5e73c447bfp+0L),
  TEST ("1.0000000000000001111",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	0x1.00000000000008p+0L,
	0x1.0000000000000802p+0L,
	false,
	0x1.00000000000008016eea8f26c48p+0L,
	0x1.00000000000008016eea8f26c48p+0L,
	0x1.00000000000008016eea8f26c48p+0L,
	0x1.00000000000008016eea8f26c5p+0L,
	0x1.00000000000008016eea8f26c495p+0L,
	0x1.00000000000008016eea8f26c496p+0L,
	0x1.00000000000008016eea8f26c495p+0L,
	0x1.00000000000008016eea8f26c496p+0L),
  TEST ("1.000000000000000111",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	0x1.00000000000007fep+0L,
	0x1.00000000000008p+0L,
	false,
	0x1.00000000000007ff96adfa2b57p+0L,
	0x1.00000000000007ff96adfa2b578p+0L,
	0x1.00000000000007ff96adfa2b57p+0L,
	0x1.00000000000007ff96adfa2b578p+0L,
	0x1.00000000000007ff96adfa2b576ap+0L,
	0x1.00000000000007ff96adfa2b576bp+0L,
	0x1.00000000000007ff96adfa2b576ap+0L,
	0x1.00000000000007ff96adfa2b576bp+0L),
  TEST ("1.00000000000000011",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.00000000000007ecp+0L,
	0x1.00000000000007eep+0L,
	0x1.00000000000007ecp+0L,
	0x1.00000000000007eep+0L,
	0x1.00000000000007ecp+0L,
	0x1.00000000000007eep+0L,
	0x1.00000000000007ecp+0L,
	0x1.00000000000007eep+0L,
	false,
	0x1.00000000000007ed24502859138p+0L,
	0x1.00000000000007ed24502859138p+0L,
	0x1.00000000000007ed24502859138p+0L,
	0x1.00000000000007ed2450285914p+0L,
	0x1.00000000000007ed2450285913bfp+0L,
	0x1.00000000000007ed2450285913bfp+0L,
	0x1.00000000000007ed2450285913bfp+0L,
	0x1.00000000000007ed2450285913cp+0L),
  TEST ("1.0000000000000001",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0,
	0x1p+0,
	0x1p+0,
	0x1.0000000000001p+0,
	0x1p+0L,
	0x1p+0L,
	0x1p+0L,
	0x1.0000000000001p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000736p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000734p+0L,
	0x1.0000000000000736p+0L,
	false,
	0x1.0000000000000734aca5f6226fp+0L,
	0x1.0000000000000734aca5f6226fp+0L,
	0x1.0000000000000734aca5f6226fp+0L,
	0x1.0000000000000734aca5f6226f8p+0L,
	0x1.0000000000000734aca5f6226f0ap+0L,
	0x1.0000000000000734aca5f6226f0bp+0L,
	0x1.0000000000000734aca5f6226f0ap+0L,
	0x1.0000000000000734aca5f6226f0bp+0L),
  TEST ("3929201589819414e-25",
	0x1.b0053p-32f,
	0x1.b00532p-32f,
	0x1.b0053p-32f,
	0x1.b00532p-32f,
	0x1.b005314e2421ep-32,
	0x1.b005314e2421ep-32,
	0x1.b005314e2421ep-32,
	0x1.b005314e2421fp-32,
	0x1.b005314e2421ep-32L,
	0x1.b005314e2421ep-32L,
	0x1.b005314e2421ep-32L,
	0x1.b005314e2421fp-32L,
	0x1.b005314e2421e7fep-32L,
	0x1.b005314e2421e8p-32L,
	0x1.b005314e2421e7fep-32L,
	0x1.b005314e2421e8p-32L,
	0x1.b005314e2421e7fep-32L,
	0x1.b005314e2421e8p-32L,
	0x1.b005314e2421e7fep-32L,
	0x1.b005314e2421e8p-32L,
	false,
	0x1.b005314e2421e7ffb472840c5ap-32L,
	0x1.b005314e2421e7ffb472840c5a8p-32L,
	0x1.b005314e2421e7ffb472840c5ap-32L,
	0x1.b005314e2421e7ffb472840c5a8p-32L,
	0x1.b005314e2421e7ffb472840c5a6ep-32L,
	0x1.b005314e2421e7ffb472840c5a6fp-32L,
	0x1.b005314e2421e7ffb472840c5a6ep-32L,
	0x1.b005314e2421e7ffb472840c5a6fp-32L),
  TEST ("0.0000000000000000000000000000000000000000000021019476964872"
	"256063855943749348741969203929128147736576356024258346866240"
	"28790902229957282543182373046875",
	0x8p-152f,
	0x1p-148f,
	0x8p-152f,
	0x1p-148f,
	0xcp-152,
	0xcp-152,
	0xcp-152,
	0xcp-152,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	true,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L),
  TEST ("1.00000005960464477539062499",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000000fffffffp+0,
	0x1.000001p+0,
	0x1.000000fffffffp+0,
	0x1.000001p+0,
	0x1.000000fffffffp+0L,
	0x1.000001p+0L,
	0x1.000000fffffffp+0L,
	0x1.000001p+0L,
	0x1.000000fffffffffep+0L,
	0x1.000001p+0L,
	0x1.000000fffffffffep+0L,
	0x1.000001p+0L,
	0x1.000000fffffffffep+0L,
	0x1.000001p+0L,
	0x1.000000fffffffffep+0L,
	0x1.000001p+0L,
	false,
	0x1.000000fffffffffffffffce7b78p+0L,
	0x1.000000fffffffffffffffce7b8p+0L,
	0x1.000000fffffffffffffffce7b78p+0L,
	0x1.000000fffffffffffffffce7b8p+0L,
	0x1.000000fffffffffffffffce7b7e7p+0L,
	0x1.000000fffffffffffffffce7b7e7p+0L,
	0x1.000000fffffffffffffffce7b7e7p+0L,
	0x1.000000fffffffffffffffce7b7e8p+0L),
  TEST ("1.000000059604644775390625",
	0x1p+0f,
	0x1p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	true,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L),
  TEST ("1.00000005960464477539062501",
	0x1p+0f,
	0x1.000002p+0f,
	0x1p+0f,
	0x1.000002p+0f,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.000001p+0,
	0x1.0000010000001p+0,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000000002p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.000001p+0L,
	0x1.0000010000000002p+0L,
	false,
	0x1.00000100000000000000031848p+0L,
	0x1.00000100000000000000031848p+0L,
	0x1.00000100000000000000031848p+0L,
	0x1.000001000000000000000318488p+0L,
	0x1.0000010000000000000003184818p+0L,
	0x1.0000010000000000000003184819p+0L,
	0x1.0000010000000000000003184818p+0L,
	0x1.0000010000000000000003184819p+0L),
  TEST ("1.00000011920928955078125",
	0x1.000002p+0f,
	0x1.000002p+0f,
	0x1.000002p+0f,
	0x1.000002p+0f,
	0x1.000002p+0,
	0x1.000002p+0,
	0x1.000002p+0,
	0x1.000002p+0,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	true,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L,
	0x1.000002p+0L),
  TEST ("1.00000017881393432617187499",
	0x1.000002p+0f,
	0x1.000002p+0f,
	0x1.000002p+0f,
	0x1.000004p+0f,
	0x1.000002fffffffp+0,
	0x1.000003p+0,
	0x1.000002fffffffp+0,
	0x1.000003p+0,
	0x1.000002fffffffp+0L,
	0x1.000003p+0L,
	0x1.000002fffffffp+0L,
	0x1.000003p+0L,
	0x1.000002fffffffffep+0L,
	0x1.000003p+0L,
	0x1.000002fffffffffep+0L,
	0x1.000003p+0L,
	0x1.000002fffffffffep+0L,
	0x1.000003p+0L,
	0x1.000002fffffffffep+0L,
	0x1.000003p+0L,
	false,
	0x1.000002fffffffffffffffce7b78p+0L,
	0x1.000002fffffffffffffffce7b8p+0L,
	0x1.000002fffffffffffffffce7b78p+0L,
	0x1.000002fffffffffffffffce7b8p+0L,
	0x1.000002fffffffffffffffce7b7e7p+0L,
	0x1.000002fffffffffffffffce7b7e7p+0L,
	0x1.000002fffffffffffffffce7b7e7p+0L,
	0x1.000002fffffffffffffffce7b7e8p+0L),
  TEST ("1.000000178813934326171875",
	0x1.000002p+0f,
	0x1.000004p+0f,
	0x1.000002p+0f,
	0x1.000004p+0f,
	0x1.000003p+0,
	0x1.000003p+0,
	0x1.000003p+0,
	0x1.000003p+0,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	true,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L),
  TEST ("1.00000017881393432617187501",
	0x1.000002p+0f,
	0x1.000004p+0f,
	0x1.000002p+0f,
	0x1.000004p+0f,
	0x1.000003p+0,
	0x1.000003p+0,
	0x1.000003p+0,
	0x1.0000030000001p+0,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.0000030000001p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.0000030000000002p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.000003p+0L,
	0x1.0000030000000002p+0L,
	false,
	0x1.00000300000000000000031848p+0L,
	0x1.00000300000000000000031848p+0L,
	0x1.00000300000000000000031848p+0L,
	0x1.000003000000000000000318488p+0L,
	0x1.0000030000000000000003184818p+0L,
	0x1.0000030000000000000003184819p+0L,
	0x1.0000030000000000000003184818p+0L,
	0x1.0000030000000000000003184819p+0L),
  TEST ("1.0000002384185791015625",
	0x1.000004p+0f,
	0x1.000004p+0f,
	0x1.000004p+0f,
	0x1.000004p+0f,
	0x1.000004p+0,
	0x1.000004p+0,
	0x1.000004p+0,
	0x1.000004p+0,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	true,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L,
	0x1.000004p+0L),
  TEST ("1.08420217248550443400745280086994171142578125e-19",
	0x2p-64f,
	0x2p-64f,
	0x2p-64f,
	0x2p-64f,
	0x2p-64,
	0x2p-64,
	0x2p-64,
	0x2p-64,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	true,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L,
	0x2p-64L),
  TEST ("1.0842022371089897897127399001987457793916291848290711641311"
	"645507812499e-19",
	0x2p-64f,
	0x2p-64f,
	0x2p-64f,
	0x2.000004p-64f,
	0x2.000001ffffffep-64,
	0x2.000002p-64,
	0x2.000001ffffffep-64,
	0x2.000002p-64,
	0x2.000001ffffffep-64L,
	0x2.000002p-64L,
	0x2.000001ffffffep-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffcp-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffcp-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffcp-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffcp-64L,
	0x2.000002p-64L,
	false,
	0x2.000001ffffffffffffffffffffp-64L,
	0x2.000002p-64L,
	0x2.000001ffffffffffffffffffffp-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffffffffffffffep-64L,
	0x2.000002p-64L,
	0x2.000001fffffffffffffffffffffep-64L,
	0x2.000002p-64L),
  TEST ("1.0842022371089897897127399001987457793916291848290711641311"
	"6455078125e-19",
	0x2p-64f,
	0x2p-64f,
	0x2p-64f,
	0x2.000004p-64f,
	0x2.000002p-64,
	0x2.000002p-64,
	0x2.000002p-64,
	0x2.000002p-64,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	true,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L),
  TEST ("1.0842022371089897897127399001987457793916291848290711641311"
	"645507812501e-19",
	0x2p-64f,
	0x2.000004p-64f,
	0x2p-64f,
	0x2.000004p-64f,
	0x2.000002p-64,
	0x2.000002p-64,
	0x2.000002p-64,
	0x2.0000020000002p-64,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.0000020000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.0000020000000004p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.0000020000000004p-64L,
	false,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.00000200000000000000000001p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.000002p-64L,
	0x2.0000020000000000000000000002p-64L),
  TEST ("1.0842023017324751454180269995275498473574771196581423282623"
	"291015625e-19",
	0x2.000004p-64f,
	0x2.000004p-64f,
	0x2.000004p-64f,
	0x2.000004p-64f,
	0x2.000004p-64,
	0x2.000004p-64,
	0x2.000004p-64,
	0x2.000004p-64,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	true,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L,
	0x2.000004p-64L),
  TEST ("1.0842023663559605011233140988563539153233250544872134923934"
	"936523437499e-19",
	0x2.000004p-64f,
	0x2.000004p-64f,
	0x2.000004p-64f,
	0x2.000008p-64f,
	0x2.000005ffffffep-64,
	0x2.000006p-64,
	0x2.000005ffffffep-64,
	0x2.000006p-64,
	0x2.000005ffffffep-64L,
	0x2.000006p-64L,
	0x2.000005ffffffep-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffcp-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffcp-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffcp-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffcp-64L,
	0x2.000006p-64L,
	false,
	0x2.000005ffffffffffffffffffffp-64L,
	0x2.000006p-64L,
	0x2.000005ffffffffffffffffffffp-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffffffffffffffep-64L,
	0x2.000006p-64L,
	0x2.000005fffffffffffffffffffffep-64L,
	0x2.000006p-64L),
  TEST ("1.0842023663559605011233140988563539153233250544872134923934"
	"9365234375e-19",
	0x2.000004p-64f,
	0x2.000008p-64f,
	0x2.000004p-64f,
	0x2.000008p-64f,
	0x2.000006p-64,
	0x2.000006p-64,
	0x2.000006p-64,
	0x2.000006p-64,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	true,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L),
  TEST ("1.0842023663559605011233140988563539153233250544872134923934"
	"936523437501e-19",
	0x2.000004p-64f,
	0x2.000008p-64f,
	0x2.000004p-64f,
	0x2.000008p-64f,
	0x2.000006p-64,
	0x2.000006p-64,
	0x2.000006p-64,
	0x2.0000060000002p-64,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.0000060000002p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.0000060000000004p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.0000060000000004p-64L,
	false,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.00000600000000000000000001p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.000006p-64L,
	0x2.0000060000000000000000000002p-64L),
  TEST ("1.0842024309794458568286011981851579832891729893162846565246"
	"58203125e-19",
	0x2.000008p-64f,
	0x2.000008p-64f,
	0x2.000008p-64f,
	0x2.000008p-64f,
	0x2.000008p-64,
	0x2.000008p-64,
	0x2.000008p-64,
	0x2.000008p-64,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	true,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L,
	0x2.000008p-64L),
  TEST ("7.5231638452626400509999138382223723380394595633413601376560"
	"1092018187046051025390625e-37",
	0x1p-120f,
	0x1p-120f,
	0x1p-120f,
	0x1p-120f,
	0x1p-120,
	0x1p-120,
	0x1p-120,
	0x1p-120,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	true,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L,
	0x1p-120L),
  TEST ("7.5231642936781486349413765338158389908126215730251815381410"
	"578824437213052434003657253924757242202758789062499e-37",
	0x1p-120f,
	0x1p-120f,
	0x1p-120f,
	0x1.000002p-120f,
	0x1.000000fffffffp-120,
	0x1.000001p-120,
	0x1.000000fffffffp-120,
	0x1.000001p-120,
	0x1.000000fffffffp-120L,
	0x1.000001p-120L,
	0x1.000000fffffffp-120L,
	0x1.000001p-120L,
	0x1.000000fffffffffep-120L,
	0x1.000001p-120L,
	0x1.000000fffffffffep-120L,
	0x1.000001p-120L,
	0x1.000000fffffffffep-120L,
	0x1.000001p-120L,
	0x1.000000fffffffffep-120L,
	0x1.000001p-120L,
	false,
	0x1.000000ffffffffffffffffffff8p-120L,
	0x1.000001p-120L,
	0x1.000000ffffffffffffffffffff8p-120L,
	0x1.000001p-120L,
	0x1.000000ffffffffffffffffffffffp-120L,
	0x1.000001p-120L,
	0x1.000000ffffffffffffffffffffffp-120L,
	0x1.000001p-120L),
  TEST ("7.5231642936781486349413765338158389908126215730251815381410"
	"5788244372130524340036572539247572422027587890625e-37",
	0x1p-120f,
	0x1p-120f,
	0x1p-120f,
	0x1.000002p-120f,
	0x1.000001p-120,
	0x1.000001p-120,
	0x1.000001p-120,
	0x1.000001p-120,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	true,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L),
  TEST ("7.5231642936781486349413765338158389908126215730251815381410"
	"578824437213052434003657253924757242202758789062501e-37",
	0x1p-120f,
	0x1.000002p-120f,
	0x1p-120f,
	0x1.000002p-120f,
	0x1.000001p-120,
	0x1.000001p-120,
	0x1.000001p-120,
	0x1.0000010000001p-120,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.0000010000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.0000010000000002p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.0000010000000002p-120L,
	false,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001000000000000000000008p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.000001p-120L,
	0x1.0000010000000000000000000001p-120L),
  TEST ("7.5231647420936572188828392294093056435857835827090029386261"
	"048447055721499765468252007849514484405517578125e-37",
	0x1.000002p-120f,
	0x1.000002p-120f,
	0x1.000002p-120f,
	0x1.000002p-120f,
	0x1.000002p-120,
	0x1.000002p-120,
	0x1.000002p-120,
	0x1.000002p-120,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	true,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L,
	0x1.000002p-120L),
  TEST ("7.5231651905091658028243019250027722963589455923928243391111"
	"518069674229947096932846761774271726608276367187499e-37",
	0x1.000002p-120f,
	0x1.000002p-120f,
	0x1.000002p-120f,
	0x1.000004p-120f,
	0x1.000002fffffffp-120,
	0x1.000003p-120,
	0x1.000002fffffffp-120,
	0x1.000003p-120,
	0x1.000002fffffffp-120L,
	0x1.000003p-120L,
	0x1.000002fffffffp-120L,
	0x1.000003p-120L,
	0x1.000002fffffffffep-120L,
	0x1.000003p-120L,
	0x1.000002fffffffffep-120L,
	0x1.000003p-120L,
	0x1.000002fffffffffep-120L,
	0x1.000003p-120L,
	0x1.000002fffffffffep-120L,
	0x1.000003p-120L,
	false,
	0x1.000002ffffffffffffffffffff8p-120L,
	0x1.000003p-120L,
	0x1.000002ffffffffffffffffffff8p-120L,
	0x1.000003p-120L,
	0x1.000002ffffffffffffffffffffffp-120L,
	0x1.000003p-120L,
	0x1.000002ffffffffffffffffffffffp-120L,
	0x1.000003p-120L),
  TEST ("7.5231651905091658028243019250027722963589455923928243391111"
	"5180696742299470969328467617742717266082763671875e-37",
	0x1.000002p-120f,
	0x1.000004p-120f,
	0x1.000002p-120f,
	0x1.000004p-120f,
	0x1.000003p-120,
	0x1.000003p-120,
	0x1.000003p-120,
	0x1.000003p-120,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	true,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L),
  TEST ("7.5231651905091658028243019250027722963589455923928243391111"
	"518069674229947096932846761774271726608276367187501e-37",
	0x1.000002p-120f,
	0x1.000004p-120f,
	0x1.000002p-120f,
	0x1.000004p-120f,
	0x1.000003p-120,
	0x1.000003p-120,
	0x1.000003p-120,
	0x1.0000030000001p-120,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.0000030000001p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.0000030000000002p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.0000030000000002p-120L,
	false,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003000000000000000000008p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.000003p-120L,
	0x1.0000030000000000000000000001p-120L),
  TEST ("7.5231656389246743867657646205962389491321076020766457395961"
	"98769229273839442839744151569902896881103515625e-37",
	0x1.000004p-120f,
	0x1.000004p-120f,
	0x1.000004p-120f,
	0x1.000004p-120f,
	0x1.000004p-120,
	0x1.000004p-120,
	0x1.000004p-120,
	0x1.000004p-120,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	true,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L,
	0x1.000004p-120L),
  TEST ("340282356779733661637539395458142568447.999",
	0xf.fffffp+124f,
	0xf.fffffp+124f,
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffff7ffffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff7ffffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff7ffffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff7ffffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffp+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffp+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffp+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffp+124L,
	0xf.fffff8p+124L,
	false,
	0xf.fffff7fffffffffffffffffffcp+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffffffffffffcp+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffffffffffffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff7fffffffffffffffffffff8p+124L,
	0xf.fffff8p+124L),
  TEST ("340282356779733661637539395458142568448",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	true,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L),
  TEST ("340282356779733661637539395458142568448.001",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff8p+124,
	0xf.fffff80000008p+124,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff80000008p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8000000001p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8000000001p+124L,
	false,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff800000000000000000004p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff8p+124L,
	0xf.fffff80000000000000000000008p+124L),
  TEST ("-340282356779733661637539395458142568447.999",
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff7ffffff8p+124,
	-0xf.fffff7ffffff8p+124,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff7ffffff8p+124L,
	-0xf.fffff7ffffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff7fffffffffp+124L,
	-0xf.fffff7fffffffffp+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff7fffffffffp+124L,
	-0xf.fffff7fffffffffp+124L,
	false,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff7fffffffffffffffffffcp+124L,
	-0xf.fffff7fffffffffffffffffffcp+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff7fffffffffffffffffffff8p+124L,
	-0xf.fffff7fffffffffffffffffffff8p+124L),
  TEST ("-340282356779733661637539395458142568448",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	true,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L),
  TEST ("-340282356779733661637539395458142568448.001",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-0xf.fffff80000008p+124,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff8p+124,
	-0xf.fffff80000008p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8000000001p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8000000001p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	false,
	-0xf.fffff800000000000000000004p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff80000000000000000000008p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L,
	-0xf.fffff8p+124L),
  TEST ("179769313486231580793728971405303415079934132710037826936173"
	"778980444968292764750946649017977587207096330286416692887910"
	"946555547851940402630657488671505820681908902000708383676273"
	"854845817711531764475730270069855571366959622842914819860834"
	"936475292719074168444365510704342711559699508093042880177904"
	"174497791.999",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	0xf.ffffffffffff8p+1020,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	0xf.ffffffffffff8p+1020L,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffffbffp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffp+1020L,
	0xf.ffffffffffffcp+1020L,
	false,
	0xf.ffffffffffffbffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffffffffffffff8p+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffbffffffffffffff8p+1020L,
	0xf.ffffffffffffcp+1020L),
  TEST ("179769313486231580793728971405303415079934132710037826936173"
	"778980444968292764750946649017977587207096330286416692887910"
	"946555547851940402630657488671505820681908902000708383676273"
	"854845817711531764475730270069855571366959622842914819860834"
	"936475292719074168444365510704342711559699508093042880177904"
	"174497792",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	false,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L),
  TEST ("179769313486231580793728971405303415079934132710037826936173"
	"778980444968292764750946649017977587207096330286416692887910"
	"946555547851940402630657488671505820681908902000708383676273"
	"854845817711531764475730270069855571366959622842914819860834"
	"936475292719074168444365510704342711559699508093042880177904"
	"174497792.001",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffc01p+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffc01p+1020L,
	false,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffc0000000000004p+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffcp+1020L,
	0xf.ffffffffffffc000000000000008p+1020L),
  TEST ("-17976931348623158079372897140530341507993413271003782693617"
	"377898044496829276475094664901797758720709633028641669288791"
	"094655554785194040263065748867150582068190890200070838367627"
	"385484581771153176447573027006985557136695962284291481986083"
	"493647529271907416844436551070434271155969950809304288017790"
	"4174497791.999",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffbffp+1020L,
	-0xf.ffffffffffffbffp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffbffp+1020L,
	-0xf.ffffffffffffbffp+1020L,
	false,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffbffffffffffffcp+1020L,
	-0xf.ffffffffffffbffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffbffffffffffffff8p+1020L,
	-0xf.ffffffffffffbffffffffffffff8p+1020L),
  TEST ("-17976931348623158079372897140530341507993413271003782693617"
	"377898044496829276475094664901797758720709633028641669288791"
	"094655554785194040263065748867150582068190890200070838367627"
	"385484581771153176447573027006985557136695962284291481986083"
	"493647529271907416844436551070434271155969950809304288017790"
	"4174497792",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	false,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L),
  TEST ("-17976931348623158079372897140530341507993413271003782693617"
	"377898044496829276475094664901797758720709633028641669288791"
	"094655554785194040263065748867150582068190890200070838367627"
	"385484581771153176447573027006985557136695962284291481986083"
	"493647529271907416844436551070434271155969950809304288017790"
	"4174497792.001",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffffc01p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffc01p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	false,
	-0xf.ffffffffffffc0000000000004p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffc000000000000008p+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L,
	-0xf.ffffffffffffcp+1020L),
  TEST ("118973149535723176505351158982948866796625400469556721895649"
	"927756249918185172720476044944290457046138433056764616744328"
	"666255526748948793023632513609765434237723241753648908036202"
	"958495124648560574092817813661123067421904850038181180520787"
	"720310726881239888580817051703268776757919551260442611296993"
	"969730906497042135737359373754818979106457807539652027804156"
	"491987771033211787185996492320631117543475322122625353433719"
	"930462950413766867781210335973022293561007134342532563356262"
	"609267460063335819387905541393759243547993474715549691352074"
	"891450084783459970660481689991674771307443551458551137274603"
	"094678907537177579699931235422786658780337099286207273033150"
	"295133847635735008945346069635452157254692607776538304457707"
	"598289220004738023060594798392660507455937428888763514661408"
	"758068906506527143720723156203739676372818578090840614216621"
	"704787774611256823213431325634056809505691175988424606654072"
	"823115950827627377808673574181547198668714142143234447550206"
	"269197545774263993130119778810659043621312707109068433886162"
	"877222844491518930341896313561238988520360803607534987178305"
	"043520937299838173444083502027340452162582038296009574808809"
	"658742434897860755961343752419543802653239216337103370292742"
	"935497502474626454559729017094560234867236701379230234809843"
	"263739640909561388493227725171983531003154799850580375254640"
	"686684370650275318316632539920970969803838872914424760535111"
	"444864748847573042963569291679400178896696862026500700279826"
	"635302471702206627303799047632971460017199544567373231610376"
	"256879987134317934150014443436145710546137924490489525241523"
	"018271239906743645663976778059895127442517397682525944430951"
	"907648109952479454685655581652571021331761401038962049122047"
	"111009185757383743827811254014770944602713378187451095200132"
	"611700632386420792585207954137064426995712656449343534120120"
	"770857498813673742586478583964512406030930704197486727636333"
	"837001863610516286928300891774383071105022919314408502968809"
	"463848377324668014115592383521324785361676372582468085716775"
	"183709078048790084022838728361454734650904480489014369184979"
	"256497738392744524915616501449487520501300124861778269881261"
	"335544037735715125808986359728419859776521586683035924100574"
	"850554368935873803132428446524362913648833348768663733118103"
	"918959060412499201797234385239260504905744357611987327994540"
	"083286019952793692265006211633524675976369938866409689573287"
	"599490442761701229217689614343727392339547174221615984024864"
	"635625680108391566720681134647098412863051374760613506003971"
	"759070209697293081442875903240426975910170967179075646317814"
	"394978762382183679266247724762405284284971833355044962214065"
	"895558105408175131247181971272672247996246595857705695208092"
	"816044125822560989770526261449460733912621692806952140652061"
	"911968824328747339453822511902787546522099225623311147726504"
	"972617425102845212076162056723650625826928778132002074035405"
	"250631109426611640681070927283430486232053929420514345435713"
	"131387967949326001734866894273047449417824913738789829732833"
	"683358900903818016968127085077418070951770702999663693968324"
	"004781728763310108379440442854174041581191669623267749855519"
	"774427387794278666183504498843857475877442235608736818515722"
	"862733587905866015455830953591207040129558473662150426884726"
	"759522376583586317425575669726781893104752341432891868770513"
	"406836036136374264038296610854599454591170582569741798904328"
	"676755131072831974295435585611673171096113833795735888591844"
	"569864166955969416680807491722688418115891753669917660968752"
	"228842669182040018336152355940915579955628386232949747891257"
	"526145783057949776122896048841308261113063674538553146663451"
	"574384023903569848640351704415703922683108552880537081027404"
	"397775617608412295293311763789489900990611859125572525530349"
	"278319943261304784125553748811339225969956465404836696490782"
	"500903694674135036899321686023782466034636817818347651623601"
	"663129318574761269352028560641266614840108083315301260274558"
	"575087296910384815285134460531715154639604115052348665171547"
	"251609075784863196403541944155425166776423403472211742139313"
	"210299896884252707306862499895115691675551238140467142819537"
	"867343414276518703858928008759955391140729958278175965217739"
	"826511218924463113077693598006228365514899236789515147503266"
	"616268809617626228164916917150602464494142485507467876173251"
	"398398846807079309227567538802476335624194115637802439400050"
	"221934368975949846684026462252790745597563393487879954351820"
	"652138303761879543933808642920064500206512003954563931569820"
	"114768348051593629274325149906343853129692245386396887281599"
	"735312588117968646270517005121997466606469447530616465384255"
	"826304380842850779833108567141643769616400809617173972138187"
	"711971431230616321035038259922624655396612597024040812967444"
	"207673594478417900666764580589685104809363813759667069693701"
	"069921295791929938093722225050956280798177934138468414654728"
	"631498256418191041953123619406060363406390776140155709737059"
	"125898120366007955506160309553860446596202876233728025871625"
	"578031503869424406179027994752890226443351619365453243328968"
	"8740976918527.999",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	0xf.fffffffffffffffp+16380L,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	0xf.fffffffffffffffp+16380L,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffff7fffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff7fffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L),
  TEST ("118973149535723176505351158982948866796625400469556721895649"
	"927756249918185172720476044944290457046138433056764616744328"
	"666255526748948793023632513609765434237723241753648908036202"
	"958495124648560574092817813661123067421904850038181180520787"
	"720310726881239888580817051703268776757919551260442611296993"
	"969730906497042135737359373754818979106457807539652027804156"
	"491987771033211787185996492320631117543475322122625353433719"
	"930462950413766867781210335973022293561007134342532563356262"
	"609267460063335819387905541393759243547993474715549691352074"
	"891450084783459970660481689991674771307443551458551137274603"
	"094678907537177579699931235422786658780337099286207273033150"
	"295133847635735008945346069635452157254692607776538304457707"
	"598289220004738023060594798392660507455937428888763514661408"
	"758068906506527143720723156203739676372818578090840614216621"
	"704787774611256823213431325634056809505691175988424606654072"
	"823115950827627377808673574181547198668714142143234447550206"
	"269197545774263993130119778810659043621312707109068433886162"
	"877222844491518930341896313561238988520360803607534987178305"
	"043520937299838173444083502027340452162582038296009574808809"
	"658742434897860755961343752419543802653239216337103370292742"
	"935497502474626454559729017094560234867236701379230234809843"
	"263739640909561388493227725171983531003154799850580375254640"
	"686684370650275318316632539920970969803838872914424760535111"
	"444864748847573042963569291679400178896696862026500700279826"
	"635302471702206627303799047632971460017199544567373231610376"
	"256879987134317934150014443436145710546137924490489525241523"
	"018271239906743645663976778059895127442517397682525944430951"
	"907648109952479454685655581652571021331761401038962049122047"
	"111009185757383743827811254014770944602713378187451095200132"
	"611700632386420792585207954137064426995712656449343534120120"
	"770857498813673742586478583964512406030930704197486727636333"
	"837001863610516286928300891774383071105022919314408502968809"
	"463848377324668014115592383521324785361676372582468085716775"
	"183709078048790084022838728361454734650904480489014369184979"
	"256497738392744524915616501449487520501300124861778269881261"
	"335544037735715125808986359728419859776521586683035924100574"
	"850554368935873803132428446524362913648833348768663733118103"
	"918959060412499201797234385239260504905744357611987327994540"
	"083286019952793692265006211633524675976369938866409689573287"
	"599490442761701229217689614343727392339547174221615984024864"
	"635625680108391566720681134647098412863051374760613506003971"
	"759070209697293081442875903240426975910170967179075646317814"
	"394978762382183679266247724762405284284971833355044962214065"
	"895558105408175131247181971272672247996246595857705695208092"
	"816044125822560989770526261449460733912621692806952140652061"
	"911968824328747339453822511902787546522099225623311147726504"
	"972617425102845212076162056723650625826928778132002074035405"
	"250631109426611640681070927283430486232053929420514345435713"
	"131387967949326001734866894273047449417824913738789829732833"
	"683358900903818016968127085077418070951770702999663693968324"
	"004781728763310108379440442854174041581191669623267749855519"
	"774427387794278666183504498843857475877442235608736818515722"
	"862733587905866015455830953591207040129558473662150426884726"
	"759522376583586317425575669726781893104752341432891868770513"
	"406836036136374264038296610854599454591170582569741798904328"
	"676755131072831974295435585611673171096113833795735888591844"
	"569864166955969416680807491722688418115891753669917660968752"
	"228842669182040018336152355940915579955628386232949747891257"
	"526145783057949776122896048841308261113063674538553146663451"
	"574384023903569848640351704415703922683108552880537081027404"
	"397775617608412295293311763789489900990611859125572525530349"
	"278319943261304784125553748811339225969956465404836696490782"
	"500903694674135036899321686023782466034636817818347651623601"
	"663129318574761269352028560641266614840108083315301260274558"
	"575087296910384815285134460531715154639604115052348665171547"
	"251609075784863196403541944155425166776423403472211742139313"
	"210299896884252707306862499895115691675551238140467142819537"
	"867343414276518703858928008759955391140729958278175965217739"
	"826511218924463113077693598006228365514899236789515147503266"
	"616268809617626228164916917150602464494142485507467876173251"
	"398398846807079309227567538802476335624194115637802439400050"
	"221934368975949846684026462252790745597563393487879954351820"
	"652138303761879543933808642920064500206512003954563931569820"
	"114768348051593629274325149906343853129692245386396887281599"
	"735312588117968646270517005121997466606469447530616465384255"
	"826304380842850779833108567141643769616400809617173972138187"
	"711971431230616321035038259922624655396612597024040812967444"
	"207673594478417900666764580589685104809363813759667069693701"
	"069921295791929938093722225050956280798177934138468414654728"
	"631498256418191041953123619406060363406390776140155709737059"
	"125898120366007955506160309553860446596202876233728025871625"
	"578031503869424406179027994752890226443351619365453243328968"
	"8740976918528",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L),
  TEST ("118973149535723176505351158982948866796625400469556721895649"
	"927756249918185172720476044944290457046138433056764616744328"
	"666255526748948793023632513609765434237723241753648908036202"
	"958495124648560574092817813661123067421904850038181180520787"
	"720310726881239888580817051703268776757919551260442611296993"
	"969730906497042135737359373754818979106457807539652027804156"
	"491987771033211787185996492320631117543475322122625353433719"
	"930462950413766867781210335973022293561007134342532563356262"
	"609267460063335819387905541393759243547993474715549691352074"
	"891450084783459970660481689991674771307443551458551137274603"
	"094678907537177579699931235422786658780337099286207273033150"
	"295133847635735008945346069635452157254692607776538304457707"
	"598289220004738023060594798392660507455937428888763514661408"
	"758068906506527143720723156203739676372818578090840614216621"
	"704787774611256823213431325634056809505691175988424606654072"
	"823115950827627377808673574181547198668714142143234447550206"
	"269197545774263993130119778810659043621312707109068433886162"
	"877222844491518930341896313561238988520360803607534987178305"
	"043520937299838173444083502027340452162582038296009574808809"
	"658742434897860755961343752419543802653239216337103370292742"
	"935497502474626454559729017094560234867236701379230234809843"
	"263739640909561388493227725171983531003154799850580375254640"
	"686684370650275318316632539920970969803838872914424760535111"
	"444864748847573042963569291679400178896696862026500700279826"
	"635302471702206627303799047632971460017199544567373231610376"
	"256879987134317934150014443436145710546137924490489525241523"
	"018271239906743645663976778059895127442517397682525944430951"
	"907648109952479454685655581652571021331761401038962049122047"
	"111009185757383743827811254014770944602713378187451095200132"
	"611700632386420792585207954137064426995712656449343534120120"
	"770857498813673742586478583964512406030930704197486727636333"
	"837001863610516286928300891774383071105022919314408502968809"
	"463848377324668014115592383521324785361676372582468085716775"
	"183709078048790084022838728361454734650904480489014369184979"
	"256497738392744524915616501449487520501300124861778269881261"
	"335544037735715125808986359728419859776521586683035924100574"
	"850554368935873803132428446524362913648833348768663733118103"
	"918959060412499201797234385239260504905744357611987327994540"
	"083286019952793692265006211633524675976369938866409689573287"
	"599490442761701229217689614343727392339547174221615984024864"
	"635625680108391566720681134647098412863051374760613506003971"
	"759070209697293081442875903240426975910170967179075646317814"
	"394978762382183679266247724762405284284971833355044962214065"
	"895558105408175131247181971272672247996246595857705695208092"
	"816044125822560989770526261449460733912621692806952140652061"
	"911968824328747339453822511902787546522099225623311147726504"
	"972617425102845212076162056723650625826928778132002074035405"
	"250631109426611640681070927283430486232053929420514345435713"
	"131387967949326001734866894273047449417824913738789829732833"
	"683358900903818016968127085077418070951770702999663693968324"
	"004781728763310108379440442854174041581191669623267749855519"
	"774427387794278666183504498843857475877442235608736818515722"
	"862733587905866015455830953591207040129558473662150426884726"
	"759522376583586317425575669726781893104752341432891868770513"
	"406836036136374264038296610854599454591170582569741798904328"
	"676755131072831974295435585611673171096113833795735888591844"
	"569864166955969416680807491722688418115891753669917660968752"
	"228842669182040018336152355940915579955628386232949747891257"
	"526145783057949776122896048841308261113063674538553146663451"
	"574384023903569848640351704415703922683108552880537081027404"
	"397775617608412295293311763789489900990611859125572525530349"
	"278319943261304784125553748811339225969956465404836696490782"
	"500903694674135036899321686023782466034636817818347651623601"
	"663129318574761269352028560641266614840108083315301260274558"
	"575087296910384815285134460531715154639604115052348665171547"
	"251609075784863196403541944155425166776423403472211742139313"
	"210299896884252707306862499895115691675551238140467142819537"
	"867343414276518703858928008759955391140729958278175965217739"
	"826511218924463113077693598006228365514899236789515147503266"
	"616268809617626228164916917150602464494142485507467876173251"
	"398398846807079309227567538802476335624194115637802439400050"
	"221934368975949846684026462252790745597563393487879954351820"
	"652138303761879543933808642920064500206512003954563931569820"
	"114768348051593629274325149906343853129692245386396887281599"
	"735312588117968646270517005121997466606469447530616465384255"
	"826304380842850779833108567141643769616400809617173972138187"
	"711971431230616321035038259922624655396612597024040812967444"
	"207673594478417900666764580589685104809363813759667069693701"
	"069921295791929938093722225050956280798177934138468414654728"
	"631498256418191041953123619406060363406390776140155709737059"
	"125898120366007955506160309553860446596202876233728025871625"
	"578031503869424406179027994752890226443351619365453243328968"
	"8740976918528.001",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8p+16380L,
	0xf.fffffffffffffff8000000000008p+16380L),
  TEST ("-11897314953572317650535115898294886679662540046955672189564"
	"992775624991818517272047604494429045704613843305676461674432"
	"866625552674894879302363251360976543423772324175364890803620"
	"295849512464856057409281781366112306742190485003818118052078"
	"772031072688123988858081705170326877675791955126044261129699"
	"396973090649704213573735937375481897910645780753965202780415"
	"649198777103321178718599649232063111754347532212262535343371"
	"993046295041376686778121033597302229356100713434253256335626"
	"260926746006333581938790554139375924354799347471554969135207"
	"489145008478345997066048168999167477130744355145855113727460"
	"309467890753717757969993123542278665878033709928620727303315"
	"029513384763573500894534606963545215725469260777653830445770"
	"759828922000473802306059479839266050745593742888876351466140"
	"875806890650652714372072315620373967637281857809084061421662"
	"170478777461125682321343132563405680950569117598842460665407"
	"282311595082762737780867357418154719866871414214323444755020"
	"626919754577426399313011977881065904362131270710906843388616"
	"287722284449151893034189631356123898852036080360753498717830"
	"504352093729983817344408350202734045216258203829600957480880"
	"965874243489786075596134375241954380265323921633710337029274"
	"293549750247462645455972901709456023486723670137923023480984"
	"326373964090956138849322772517198353100315479985058037525464"
	"068668437065027531831663253992097096980383887291442476053511"
	"144486474884757304296356929167940017889669686202650070027982"
	"663530247170220662730379904763297146001719954456737323161037"
	"625687998713431793415001444343614571054613792449048952524152"
	"301827123990674364566397677805989512744251739768252594443095"
	"190764810995247945468565558165257102133176140103896204912204"
	"711100918575738374382781125401477094460271337818745109520013"
	"261170063238642079258520795413706442699571265644934353412012"
	"077085749881367374258647858396451240603093070419748672763633"
	"383700186361051628692830089177438307110502291931440850296880"
	"946384837732466801411559238352132478536167637258246808571677"
	"518370907804879008402283872836145473465090448048901436918497"
	"925649773839274452491561650144948752050130012486177826988126"
	"133554403773571512580898635972841985977652158668303592410057"
	"485055436893587380313242844652436291364883334876866373311810"
	"391895906041249920179723438523926050490574435761198732799454"
	"008328601995279369226500621163352467597636993886640968957328"
	"759949044276170122921768961434372739233954717422161598402486"
	"463562568010839156672068113464709841286305137476061350600397"
	"175907020969729308144287590324042697591017096717907564631781"
	"439497876238218367926624772476240528428497183335504496221406"
	"589555810540817513124718197127267224799624659585770569520809"
	"281604412582256098977052626144946073391262169280695214065206"
	"191196882432874733945382251190278754652209922562331114772650"
	"497261742510284521207616205672365062582692877813200207403540"
	"525063110942661164068107092728343048623205392942051434543571"
	"313138796794932600173486689427304744941782491373878982973283"
	"368335890090381801696812708507741807095177070299966369396832"
	"400478172876331010837944044285417404158119166962326774985551"
	"977442738779427866618350449884385747587744223560873681851572"
	"286273358790586601545583095359120704012955847366215042688472"
	"675952237658358631742557566972678189310475234143289186877051"
	"340683603613637426403829661085459945459117058256974179890432"
	"867675513107283197429543558561167317109611383379573588859184"
	"456986416695596941668080749172268841811589175366991766096875"
	"222884266918204001833615235594091557995562838623294974789125"
	"752614578305794977612289604884130826111306367453855314666345"
	"157438402390356984864035170441570392268310855288053708102740"
	"439777561760841229529331176378948990099061185912557252553034"
	"927831994326130478412555374881133922596995646540483669649078"
	"250090369467413503689932168602378246603463681781834765162360"
	"166312931857476126935202856064126661484010808331530126027455"
	"857508729691038481528513446053171515463960411505234866517154"
	"725160907578486319640354194415542516677642340347221174213931"
	"321029989688425270730686249989511569167555123814046714281953"
	"786734341427651870385892800875995539114072995827817596521773"
	"982651121892446311307769359800622836551489923678951514750326"
	"661626880961762622816491691715060246449414248550746787617325"
	"139839884680707930922756753880247633562419411563780243940005"
	"022193436897594984668402646225279074559756339348787995435182"
	"065213830376187954393380864292006450020651200395456393156982"
	"011476834805159362927432514990634385312969224538639688728159"
	"973531258811796864627051700512199746660646944753061646538425"
	"582630438084285077983310856714164376961640080961717397213818"
	"771197143123061632103503825992262465539661259702404081296744"
	"420767359447841790066676458058968510480936381375966706969370"
	"106992129579192993809372222505095628079817793413846841465472"
	"863149825641819104195312361940606036340639077614015570973705"
	"912589812036600795550616030955386044659620287623372802587162"
	"557803150386942440617902799475289022644335161936545324332896"
	"88740976918527.999",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff7fffffffffff8p+16380L,
	-0xf.fffffffffffffff7fffffffffff8p+16380L),
  TEST ("-11897314953572317650535115898294886679662540046955672189564"
	"992775624991818517272047604494429045704613843305676461674432"
	"866625552674894879302363251360976543423772324175364890803620"
	"295849512464856057409281781366112306742190485003818118052078"
	"772031072688123988858081705170326877675791955126044261129699"
	"396973090649704213573735937375481897910645780753965202780415"
	"649198777103321178718599649232063111754347532212262535343371"
	"993046295041376686778121033597302229356100713434253256335626"
	"260926746006333581938790554139375924354799347471554969135207"
	"489145008478345997066048168999167477130744355145855113727460"
	"309467890753717757969993123542278665878033709928620727303315"
	"029513384763573500894534606963545215725469260777653830445770"
	"759828922000473802306059479839266050745593742888876351466140"
	"875806890650652714372072315620373967637281857809084061421662"
	"170478777461125682321343132563405680950569117598842460665407"
	"282311595082762737780867357418154719866871414214323444755020"
	"626919754577426399313011977881065904362131270710906843388616"
	"287722284449151893034189631356123898852036080360753498717830"
	"504352093729983817344408350202734045216258203829600957480880"
	"965874243489786075596134375241954380265323921633710337029274"
	"293549750247462645455972901709456023486723670137923023480984"
	"326373964090956138849322772517198353100315479985058037525464"
	"068668437065027531831663253992097096980383887291442476053511"
	"144486474884757304296356929167940017889669686202650070027982"
	"663530247170220662730379904763297146001719954456737323161037"
	"625687998713431793415001444343614571054613792449048952524152"
	"301827123990674364566397677805989512744251739768252594443095"
	"190764810995247945468565558165257102133176140103896204912204"
	"711100918575738374382781125401477094460271337818745109520013"
	"261170063238642079258520795413706442699571265644934353412012"
	"077085749881367374258647858396451240603093070419748672763633"
	"383700186361051628692830089177438307110502291931440850296880"
	"946384837732466801411559238352132478536167637258246808571677"
	"518370907804879008402283872836145473465090448048901436918497"
	"925649773839274452491561650144948752050130012486177826988126"
	"133554403773571512580898635972841985977652158668303592410057"
	"485055436893587380313242844652436291364883334876866373311810"
	"391895906041249920179723438523926050490574435761198732799454"
	"008328601995279369226500621163352467597636993886640968957328"
	"759949044276170122921768961434372739233954717422161598402486"
	"463562568010839156672068113464709841286305137476061350600397"
	"175907020969729308144287590324042697591017096717907564631781"
	"439497876238218367926624772476240528428497183335504496221406"
	"589555810540817513124718197127267224799624659585770569520809"
	"281604412582256098977052626144946073391262169280695214065206"
	"191196882432874733945382251190278754652209922562331114772650"
	"497261742510284521207616205672365062582692877813200207403540"
	"525063110942661164068107092728343048623205392942051434543571"
	"313138796794932600173486689427304744941782491373878982973283"
	"368335890090381801696812708507741807095177070299966369396832"
	"400478172876331010837944044285417404158119166962326774985551"
	"977442738779427866618350449884385747587744223560873681851572"
	"286273358790586601545583095359120704012955847366215042688472"
	"675952237658358631742557566972678189310475234143289186877051"
	"340683603613637426403829661085459945459117058256974179890432"
	"867675513107283197429543558561167317109611383379573588859184"
	"456986416695596941668080749172268841811589175366991766096875"
	"222884266918204001833615235594091557995562838623294974789125"
	"752614578305794977612289604884130826111306367453855314666345"
	"157438402390356984864035170441570392268310855288053708102740"
	"439777561760841229529331176378948990099061185912557252553034"
	"927831994326130478412555374881133922596995646540483669649078"
	"250090369467413503689932168602378246603463681781834765162360"
	"166312931857476126935202856064126661484010808331530126027455"
	"857508729691038481528513446053171515463960411505234866517154"
	"725160907578486319640354194415542516677642340347221174213931"
	"321029989688425270730686249989511569167555123814046714281953"
	"786734341427651870385892800875995539114072995827817596521773"
	"982651121892446311307769359800622836551489923678951514750326"
	"661626880961762622816491691715060246449414248550746787617325"
	"139839884680707930922756753880247633562419411563780243940005"
	"022193436897594984668402646225279074559756339348787995435182"
	"065213830376187954393380864292006450020651200395456393156982"
	"011476834805159362927432514990634385312969224538639688728159"
	"973531258811796864627051700512199746660646944753061646538425"
	"582630438084285077983310856714164376961640080961717397213818"
	"771197143123061632103503825992262465539661259702404081296744"
	"420767359447841790066676458058968510480936381375966706969370"
	"106992129579192993809372222505095628079817793413846841465472"
	"863149825641819104195312361940606036340639077614015570973705"
	"912589812036600795550616030955386044659620287623372802587162"
	"557803150386942440617902799475289022644335161936545324332896"
	"88740976918528",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L),
  TEST ("-11897314953572317650535115898294886679662540046955672189564"
	"992775624991818517272047604494429045704613843305676461674432"
	"866625552674894879302363251360976543423772324175364890803620"
	"295849512464856057409281781366112306742190485003818118052078"
	"772031072688123988858081705170326877675791955126044261129699"
	"396973090649704213573735937375481897910645780753965202780415"
	"649198777103321178718599649232063111754347532212262535343371"
	"993046295041376686778121033597302229356100713434253256335626"
	"260926746006333581938790554139375924354799347471554969135207"
	"489145008478345997066048168999167477130744355145855113727460"
	"309467890753717757969993123542278665878033709928620727303315"
	"029513384763573500894534606963545215725469260777653830445770"
	"759828922000473802306059479839266050745593742888876351466140"
	"875806890650652714372072315620373967637281857809084061421662"
	"170478777461125682321343132563405680950569117598842460665407"
	"282311595082762737780867357418154719866871414214323444755020"
	"626919754577426399313011977881065904362131270710906843388616"
	"287722284449151893034189631356123898852036080360753498717830"
	"504352093729983817344408350202734045216258203829600957480880"
	"965874243489786075596134375241954380265323921633710337029274"
	"293549750247462645455972901709456023486723670137923023480984"
	"326373964090956138849322772517198353100315479985058037525464"
	"068668437065027531831663253992097096980383887291442476053511"
	"144486474884757304296356929167940017889669686202650070027982"
	"663530247170220662730379904763297146001719954456737323161037"
	"625687998713431793415001444343614571054613792449048952524152"
	"301827123990674364566397677805989512744251739768252594443095"
	"190764810995247945468565558165257102133176140103896204912204"
	"711100918575738374382781125401477094460271337818745109520013"
	"261170063238642079258520795413706442699571265644934353412012"
	"077085749881367374258647858396451240603093070419748672763633"
	"383700186361051628692830089177438307110502291931440850296880"
	"946384837732466801411559238352132478536167637258246808571677"
	"518370907804879008402283872836145473465090448048901436918497"
	"925649773839274452491561650144948752050130012486177826988126"
	"133554403773571512580898635972841985977652158668303592410057"
	"485055436893587380313242844652436291364883334876866373311810"
	"391895906041249920179723438523926050490574435761198732799454"
	"008328601995279369226500621163352467597636993886640968957328"
	"759949044276170122921768961434372739233954717422161598402486"
	"463562568010839156672068113464709841286305137476061350600397"
	"175907020969729308144287590324042697591017096717907564631781"
	"439497876238218367926624772476240528428497183335504496221406"
	"589555810540817513124718197127267224799624659585770569520809"
	"281604412582256098977052626144946073391262169280695214065206"
	"191196882432874733945382251190278754652209922562331114772650"
	"497261742510284521207616205672365062582692877813200207403540"
	"525063110942661164068107092728343048623205392942051434543571"
	"313138796794932600173486689427304744941782491373878982973283"
	"368335890090381801696812708507741807095177070299966369396832"
	"400478172876331010837944044285417404158119166962326774985551"
	"977442738779427866618350449884385747587744223560873681851572"
	"286273358790586601545583095359120704012955847366215042688472"
	"675952237658358631742557566972678189310475234143289186877051"
	"340683603613637426403829661085459945459117058256974179890432"
	"867675513107283197429543558561167317109611383379573588859184"
	"456986416695596941668080749172268841811589175366991766096875"
	"222884266918204001833615235594091557995562838623294974789125"
	"752614578305794977612289604884130826111306367453855314666345"
	"157438402390356984864035170441570392268310855288053708102740"
	"439777561760841229529331176378948990099061185912557252553034"
	"927831994326130478412555374881133922596995646540483669649078"
	"250090369467413503689932168602378246603463681781834765162360"
	"166312931857476126935202856064126661484010808331530126027455"
	"857508729691038481528513446053171515463960411505234866517154"
	"725160907578486319640354194415542516677642340347221174213931"
	"321029989688425270730686249989511569167555123814046714281953"
	"786734341427651870385892800875995539114072995827817596521773"
	"982651121892446311307769359800622836551489923678951514750326"
	"661626880961762622816491691715060246449414248550746787617325"
	"139839884680707930922756753880247633562419411563780243940005"
	"022193436897594984668402646225279074559756339348787995435182"
	"065213830376187954393380864292006450020651200395456393156982"
	"011476834805159362927432514990634385312969224538639688728159"
	"973531258811796864627051700512199746660646944753061646538425"
	"582630438084285077983310856714164376961640080961717397213818"
	"771197143123061632103503825992262465539661259702404081296744"
	"420767359447841790066676458058968510480936381375966706969370"
	"106992129579192993809372222505095628079817793413846841465472"
	"863149825641819104195312361940606036340639077614015570973705"
	"912589812036600795550616030955386044659620287623372802587162"
	"557803150386942440617902799475289022644335161936545324332896"
	"88740976918528.001",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffff8000000000008p+16380L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L,
	-0xf.fffffffffffffff8p+16380L),
  TEST ("118973149535723176508575932662800707347995686986910214150118"
	"685272271246896789803961473130416053705672050873552479421805"
	"932646640744124594447361172514341324846716679654551308018400"
	"452551246797021031695590308415421099521962856162050274568841"
	"297915828747574343774874752902176710049525787625138678906010"
	"048638212027057374683542842282633896097240913572043788690878"
	"561421008447838407815393303366617352859876685151925036335142"
	"606462825839541908847139311166770091872983498508632067665424"
	"131663456011801988221011933744533095583591952713287509471572"
	"005635584655570174753698625195967118200265238753375268656404"
	"300638718932246773699829720984119713851462400809295266529707"
	"450603039675996477317034685632764277790214944500590950459817"
	"905458649624723235138950801408157339866516893477731877579183"
	"713595679581558427625325833939652897845282019149923069371763"
	"621014587926698827182969408373803807712292191282429102445352"
	"493434039402290243933941906906661090602900960765874258303002"
	"994639315656152078708796474719793763077934223746582725715380"
	"546621026022818892467551940977566283266498758568504813830755"
	"715585325649227824857891916443381390920079346240984072859876"
	"394789650127468861490822526766717770136680743866932662343305"
	"821821344306240809967537078707691232937387041140557168161956"
	"672595323950666742010786584275766171661791973302251394804664"
	"351065107886557299707326005651230394674710597929211000345040"
	"748992483614253006562424867893567074606589931788062200063807"
	"336740036940230215831403322125165368742446805152078682411506"
	"081843753974005583111391605547148303480887461773984314393817"
	"233328426227146997925421743280885595916487699461777590949432"
	"536021389649845214065322016198143547250143861460313408300535"
	"800647014276175548485543791298383644643679669618879907720347"
	"361578030001247419574448359597988425487829219851305162204925"
	"876422580754230478244492592334149461342828532046897137732862"
	"560405101567370570895662663174689131741739602970845694214086"
	"383402465037069569640956912385125748139813888875258203003486"
	"978747055202810394072908580324008598756993885667142200558137"
	"216665049755676940757442911860295559656788759871904662758651"
	"106796978788783386988295123326864580419821595430891867179378"
	"372968821128698879468814267529461494723425453808822356093436"
	"114567635804621183162768389034017821036515461700163537265334"
	"837042272659885702600247792917728828912373907035369136531164"
	"551871575024551077026080114197652598224677403885378544255851"
	"452142889211152237506343909351748731538683443195842912801950"
	"740929058503113127929421291089844021925400931905939216271347"
	"501989193058654389516377770771439860033940981826669939750630"
	"966060749188986231404992238674933998516958950824840538996637"
	"227947236848099456610159878061379742621311380927234118601003"
	"068752002060437285024623575047782086630607224900910789188204"
	"422115342157245494745974521832782208601602710639261482504706"
	"793704189474198047840288064399210243702202724597107455534275"
	"321401119382263147115748905050195256886082040192083380490209"
	"648570353905656303876661710430922155024620842080323610266391"
	"819853291160589645614945256684769911320943457402697573094119"
	"430125589389298495428377185239916427991844172165080029177729"
	"625180644077484441695092005844026411665118679537869781924378"
	"377060887769389297625907410934020531742739577183152327119791"
	"567636713426904553654134937766951789571845662564530364234831"
	"655818811851573018210173773037253988893680153247404060131255"
	"432297982534770778617218088583998040670598195597843579610890"
	"315316606725381521608825464438386306376596459107591134507541"
	"153403024199191222328259713530472683187873517955642380703639"
	"029816037096049042094836437281075965243968431839386959736989"
	"889027924230006904683050305965712585804355337311372959487108"
	"794286031594805559334414767793211932142402860019029250966461"
	"933621763149049802791695077716375242516443825235146860078555"
	"453142397983479144560015010889077242726183149587493050950967"
	"941488752366197740591478464591650201477772717579831983405962"
	"171742164889284586217913115136227964861078958766284010901639"
	"781256012341028188155836968476480842715858962105341815444164"
	"696766584018508513610260777540911573496315580383328678958350"
	"148157337222619548467971967434956296433870815461340134721800"
	"205755114983399523323106573720732056659216468891205124203527"
	"449961814733926916757607468806003312492414061695431041238453"
	"023522795690830184799840657478014435335788410588338795921829"
	"674102072285495410088727730494748054715270026371111466557692"
	"092596172401951206117443077191868585496116051853795368595736"
	"003882511620497061598923985774687093334185939744167238203676"
	"453052472980823976562293117120372063945943890666325365061961"
	"022928215929070357135085816756816486043117613837876554929621"
	"856269743752885605649447338817178927896144473776360438797900"
	"366212779802747593450564030114752479071739585723270865632758"
	"495434839556211713523098602573445161475191311400514062427097"
	"780117858230840648695846140902244217544683559565818359212130"
	"972233447491583165728635513802591543441145939539353470970452"
	"5536550715391.999",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	INFINITY),
  TEST ("118973149535723176508575932662800707347995686986910214150118"
	"685272271246896789803961473130416053705672050873552479421805"
	"932646640744124594447361172514341324846716679654551308018400"
	"452551246797021031695590308415421099521962856162050274568841"
	"297915828747574343774874752902176710049525787625138678906010"
	"048638212027057374683542842282633896097240913572043788690878"
	"561421008447838407815393303366617352859876685151925036335142"
	"606462825839541908847139311166770091872983498508632067665424"
	"131663456011801988221011933744533095583591952713287509471572"
	"005635584655570174753698625195967118200265238753375268656404"
	"300638718932246773699829720984119713851462400809295266529707"
	"450603039675996477317034685632764277790214944500590950459817"
	"905458649624723235138950801408157339866516893477731877579183"
	"713595679581558427625325833939652897845282019149923069371763"
	"621014587926698827182969408373803807712292191282429102445352"
	"493434039402290243933941906906661090602900960765874258303002"
	"994639315656152078708796474719793763077934223746582725715380"
	"546621026022818892467551940977566283266498758568504813830755"
	"715585325649227824857891916443381390920079346240984072859876"
	"394789650127468861490822526766717770136680743866932662343305"
	"821821344306240809967537078707691232937387041140557168161956"
	"672595323950666742010786584275766171661791973302251394804664"
	"351065107886557299707326005651230394674710597929211000345040"
	"748992483614253006562424867893567074606589931788062200063807"
	"336740036940230215831403322125165368742446805152078682411506"
	"081843753974005583111391605547148303480887461773984314393817"
	"233328426227146997925421743280885595916487699461777590949432"
	"536021389649845214065322016198143547250143861460313408300535"
	"800647014276175548485543791298383644643679669618879907720347"
	"361578030001247419574448359597988425487829219851305162204925"
	"876422580754230478244492592334149461342828532046897137732862"
	"560405101567370570895662663174689131741739602970845694214086"
	"383402465037069569640956912385125748139813888875258203003486"
	"978747055202810394072908580324008598756993885667142200558137"
	"216665049755676940757442911860295559656788759871904662758651"
	"106796978788783386988295123326864580419821595430891867179378"
	"372968821128698879468814267529461494723425453808822356093436"
	"114567635804621183162768389034017821036515461700163537265334"
	"837042272659885702600247792917728828912373907035369136531164"
	"551871575024551077026080114197652598224677403885378544255851"
	"452142889211152237506343909351748731538683443195842912801950"
	"740929058503113127929421291089844021925400931905939216271347"
	"501989193058654389516377770771439860033940981826669939750630"
	"966060749188986231404992238674933998516958950824840538996637"
	"227947236848099456610159878061379742621311380927234118601003"
	"068752002060437285024623575047782086630607224900910789188204"
	"422115342157245494745974521832782208601602710639261482504706"
	"793704189474198047840288064399210243702202724597107455534275"
	"321401119382263147115748905050195256886082040192083380490209"
	"648570353905656303876661710430922155024620842080323610266391"
	"819853291160589645614945256684769911320943457402697573094119"
	"430125589389298495428377185239916427991844172165080029177729"
	"625180644077484441695092005844026411665118679537869781924378"
	"377060887769389297625907410934020531742739577183152327119791"
	"567636713426904553654134937766951789571845662564530364234831"
	"655818811851573018210173773037253988893680153247404060131255"
	"432297982534770778617218088583998040670598195597843579610890"
	"315316606725381521608825464438386306376596459107591134507541"
	"153403024199191222328259713530472683187873517955642380703639"
	"029816037096049042094836437281075965243968431839386959736989"
	"889027924230006904683050305965712585804355337311372959487108"
	"794286031594805559334414767793211932142402860019029250966461"
	"933621763149049802791695077716375242516443825235146860078555"
	"453142397983479144560015010889077242726183149587493050950967"
	"941488752366197740591478464591650201477772717579831983405962"
	"171742164889284586217913115136227964861078958766284010901639"
	"781256012341028188155836968476480842715858962105341815444164"
	"696766584018508513610260777540911573496315580383328678958350"
	"148157337222619548467971967434956296433870815461340134721800"
	"205755114983399523323106573720732056659216468891205124203527"
	"449961814733926916757607468806003312492414061695431041238453"
	"023522795690830184799840657478014435335788410588338795921829"
	"674102072285495410088727730494748054715270026371111466557692"
	"092596172401951206117443077191868585496116051853795368595736"
	"003882511620497061598923985774687093334185939744167238203676"
	"453052472980823976562293117120372063945943890666325365061961"
	"022928215929070357135085816756816486043117613837876554929621"
	"856269743752885605649447338817178927896144473776360438797900"
	"366212779802747593450564030114752479071739585723270865632758"
	"495434839556211713523098602573445161475191311400514062427097"
	"780117858230840648695846140902244217544683559565818359212130"
	"972233447491583165728635513802591543441145939539353470970452"
	"5536550715392",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	INFINITY,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	INFINITY),
  TEST ("118973149535723176508575932662800707347995686986910214150118"
	"685272271246896789803961473130416053705672050873552479421805"
	"932646640744124594447361172514341324846716679654551308018400"
	"452551246797021031695590308415421099521962856162050274568841"
	"297915828747574343774874752902176710049525787625138678906010"
	"048638212027057374683542842282633896097240913572043788690878"
	"561421008447838407815393303366617352859876685151925036335142"
	"606462825839541908847139311166770091872983498508632067665424"
	"131663456011801988221011933744533095583591952713287509471572"
	"005635584655570174753698625195967118200265238753375268656404"
	"300638718932246773699829720984119713851462400809295266529707"
	"450603039675996477317034685632764277790214944500590950459817"
	"905458649624723235138950801408157339866516893477731877579183"
	"713595679581558427625325833939652897845282019149923069371763"
	"621014587926698827182969408373803807712292191282429102445352"
	"493434039402290243933941906906661090602900960765874258303002"
	"994639315656152078708796474719793763077934223746582725715380"
	"546621026022818892467551940977566283266498758568504813830755"
	"715585325649227824857891916443381390920079346240984072859876"
	"394789650127468861490822526766717770136680743866932662343305"
	"821821344306240809967537078707691232937387041140557168161956"
	"672595323950666742010786584275766171661791973302251394804664"
	"351065107886557299707326005651230394674710597929211000345040"
	"748992483614253006562424867893567074606589931788062200063807"
	"336740036940230215831403322125165368742446805152078682411506"
	"081843753974005583111391605547148303480887461773984314393817"
	"233328426227146997925421743280885595916487699461777590949432"
	"536021389649845214065322016198143547250143861460313408300535"
	"800647014276175548485543791298383644643679669618879907720347"
	"361578030001247419574448359597988425487829219851305162204925"
	"876422580754230478244492592334149461342828532046897137732862"
	"560405101567370570895662663174689131741739602970845694214086"
	"383402465037069569640956912385125748139813888875258203003486"
	"978747055202810394072908580324008598756993885667142200558137"
	"216665049755676940757442911860295559656788759871904662758651"
	"106796978788783386988295123326864580419821595430891867179378"
	"372968821128698879468814267529461494723425453808822356093436"
	"114567635804621183162768389034017821036515461700163537265334"
	"837042272659885702600247792917728828912373907035369136531164"
	"551871575024551077026080114197652598224677403885378544255851"
	"452142889211152237506343909351748731538683443195842912801950"
	"740929058503113127929421291089844021925400931905939216271347"
	"501989193058654389516377770771439860033940981826669939750630"
	"966060749188986231404992238674933998516958950824840538996637"
	"227947236848099456610159878061379742621311380927234118601003"
	"068752002060437285024623575047782086630607224900910789188204"
	"422115342157245494745974521832782208601602710639261482504706"
	"793704189474198047840288064399210243702202724597107455534275"
	"321401119382263147115748905050195256886082040192083380490209"
	"648570353905656303876661710430922155024620842080323610266391"
	"819853291160589645614945256684769911320943457402697573094119"
	"430125589389298495428377185239916427991844172165080029177729"
	"625180644077484441695092005844026411665118679537869781924378"
	"377060887769389297625907410934020531742739577183152327119791"
	"567636713426904553654134937766951789571845662564530364234831"
	"655818811851573018210173773037253988893680153247404060131255"
	"432297982534770778617218088583998040670598195597843579610890"
	"315316606725381521608825464438386306376596459107591134507541"
	"153403024199191222328259713530472683187873517955642380703639"
	"029816037096049042094836437281075965243968431839386959736989"
	"889027924230006904683050305965712585804355337311372959487108"
	"794286031594805559334414767793211932142402860019029250966461"
	"933621763149049802791695077716375242516443825235146860078555"
	"453142397983479144560015010889077242726183149587493050950967"
	"941488752366197740591478464591650201477772717579831983405962"
	"171742164889284586217913115136227964861078958766284010901639"
	"781256012341028188155836968476480842715858962105341815444164"
	"696766584018508513610260777540911573496315580383328678958350"
	"148157337222619548467971967434956296433870815461340134721800"
	"205755114983399523323106573720732056659216468891205124203527"
	"449961814733926916757607468806003312492414061695431041238453"
	"023522795690830184799840657478014435335788410588338795921829"
	"674102072285495410088727730494748054715270026371111466557692"
	"092596172401951206117443077191868585496116051853795368595736"
	"003882511620497061598923985774687093334185939744167238203676"
	"453052472980823976562293117120372063945943890666325365061961"
	"022928215929070357135085816756816486043117613837876554929621"
	"856269743752885605649447338817178927896144473776360438797900"
	"366212779802747593450564030114752479071739585723270865632758"
	"495434839556211713523098602573445161475191311400514062427097"
	"780117858230840648695846140902244217544683559565818359212130"
	"972233447491583165728635513802591543441145939539353470970452"
	"5536550715392.001",
	0xf.fffffp+124f,
	INFINITY,
	0xf.fffffp+124f,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.ffffffffffff8p+1020L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	0xf.fffffffffffffffp+16380L,
	INFINITY,
	false,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffcp+1020L,
	INFINITY,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	INFINITY,
	0xf.fffffffffffffffffffffffffff8p+16380L,
	INFINITY),
  TEST ("-11897314953572317650857593266280070734799568698691021415011"
	"868527227124689678980396147313041605370567205087355247942180"
	"593264664074412459444736117251434132484671667965455130801840"
	"045255124679702103169559030841542109952196285616205027456884"
	"129791582874757434377487475290217671004952578762513867890601"
	"004863821202705737468354284228263389609724091357204378869087"
	"856142100844783840781539330336661735285987668515192503633514"
	"260646282583954190884713931116677009187298349850863206766542"
	"413166345601180198822101193374453309558359195271328750947157"
	"200563558465557017475369862519596711820026523875337526865640"
	"430063871893224677369982972098411971385146240080929526652970"
	"745060303967599647731703468563276427779021494450059095045981"
	"790545864962472323513895080140815733986651689347773187757918"
	"371359567958155842762532583393965289784528201914992306937176"
	"362101458792669882718296940837380380771229219128242910244535"
	"249343403940229024393394190690666109060290096076587425830300"
	"299463931565615207870879647471979376307793422374658272571538"
	"054662102602281889246755194097756628326649875856850481383075"
	"571558532564922782485789191644338139092007934624098407285987"
	"639478965012746886149082252676671777013668074386693266234330"
	"582182134430624080996753707870769123293738704114055716816195"
	"667259532395066674201078658427576617166179197330225139480466"
	"435106510788655729970732600565123039467471059792921100034504"
	"074899248361425300656242486789356707460658993178806220006380"
	"733674003694023021583140332212516536874244680515207868241150"
	"608184375397400558311139160554714830348088746177398431439381"
	"723332842622714699792542174328088559591648769946177759094943"
	"253602138964984521406532201619814354725014386146031340830053"
	"580064701427617554848554379129838364464367966961887990772034"
	"736157803000124741957444835959798842548782921985130516220492"
	"587642258075423047824449259233414946134282853204689713773286"
	"256040510156737057089566266317468913174173960297084569421408"
	"638340246503706956964095691238512574813981388887525820300348"
	"697874705520281039407290858032400859875699388566714220055813"
	"721666504975567694075744291186029555965678875987190466275865"
	"110679697878878338698829512332686458041982159543089186717937"
	"837296882112869887946881426752946149472342545380882235609343"
	"611456763580462118316276838903401782103651546170016353726533"
	"483704227265988570260024779291772882891237390703536913653116"
	"455187157502455107702608011419765259822467740388537854425585"
	"145214288921115223750634390935174873153868344319584291280195"
	"074092905850311312792942129108984402192540093190593921627134"
	"750198919305865438951637777077143986003394098182666993975063"
	"096606074918898623140499223867493399851695895082484053899663"
	"722794723684809945661015987806137974262131138092723411860100"
	"306875200206043728502462357504778208663060722490091078918820"
	"442211534215724549474597452183278220860160271063926148250470"
	"679370418947419804784028806439921024370220272459710745553427"
	"532140111938226314711574890505019525688608204019208338049020"
	"964857035390565630387666171043092215502462084208032361026639"
	"181985329116058964561494525668476991132094345740269757309411"
	"943012558938929849542837718523991642799184417216508002917772"
	"962518064407748444169509200584402641166511867953786978192437"
	"837706088776938929762590741093402053174273957718315232711979"
	"156763671342690455365413493776695178957184566256453036423483"
	"165581881185157301821017377303725398889368015324740406013125"
	"543229798253477077861721808858399804067059819559784357961089"
	"031531660672538152160882546443838630637659645910759113450754"
	"115340302419919122232825971353047268318787351795564238070363"
	"902981603709604904209483643728107596524396843183938695973698"
	"988902792423000690468305030596571258580435533731137295948710"
	"879428603159480555933441476779321193214240286001902925096646"
	"193362176314904980279169507771637524251644382523514686007855"
	"545314239798347914456001501088907724272618314958749305095096"
	"794148875236619774059147846459165020147777271757983198340596"
	"217174216488928458621791311513622796486107895876628401090163"
	"978125601234102818815583696847648084271585896210534181544416"
	"469676658401850851361026077754091157349631558038332867895835"
	"014815733722261954846797196743495629643387081546134013472180"
	"020575511498339952332310657372073205665921646889120512420352"
	"744996181473392691675760746880600331249241406169543104123845"
	"302352279569083018479984065747801443533578841058833879592182"
	"967410207228549541008872773049474805471527002637111146655769"
	"209259617240195120611744307719186858549611605185379536859573"
	"600388251162049706159892398577468709333418593974416723820367"
	"645305247298082397656229311712037206394594389066632536506196"
	"102292821592907035713508581675681648604311761383787655492962"
	"185626974375288560564944733881717892789614447377636043879790"
	"036621277980274759345056403011475247907173958572327086563275"
	"849543483955621171352309860257344516147519131140051406242709"
	"778011785823084064869584614090224421754468355956581835921213"
	"097223344749158316572863551380259154344114593953935347097045"
	"25536550715391.999",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffff8p+16380L,
	-0xf.fffffffffffffffffffffffffff8p+16380L,
	-0xf.fffffffffffffffffffffffffff8p+16380L),
  TEST ("-11897314953572317650857593266280070734799568698691021415011"
	"868527227124689678980396147313041605370567205087355247942180"
	"593264664074412459444736117251434132484671667965455130801840"
	"045255124679702103169559030841542109952196285616205027456884"
	"129791582874757434377487475290217671004952578762513867890601"
	"004863821202705737468354284228263389609724091357204378869087"
	"856142100844783840781539330336661735285987668515192503633514"
	"260646282583954190884713931116677009187298349850863206766542"
	"413166345601180198822101193374453309558359195271328750947157"
	"200563558465557017475369862519596711820026523875337526865640"
	"430063871893224677369982972098411971385146240080929526652970"
	"745060303967599647731703468563276427779021494450059095045981"
	"790545864962472323513895080140815733986651689347773187757918"
	"371359567958155842762532583393965289784528201914992306937176"
	"362101458792669882718296940837380380771229219128242910244535"
	"249343403940229024393394190690666109060290096076587425830300"
	"299463931565615207870879647471979376307793422374658272571538"
	"054662102602281889246755194097756628326649875856850481383075"
	"571558532564922782485789191644338139092007934624098407285987"
	"639478965012746886149082252676671777013668074386693266234330"
	"582182134430624080996753707870769123293738704114055716816195"
	"667259532395066674201078658427576617166179197330225139480466"
	"435106510788655729970732600565123039467471059792921100034504"
	"074899248361425300656242486789356707460658993178806220006380"
	"733674003694023021583140332212516536874244680515207868241150"
	"608184375397400558311139160554714830348088746177398431439381"
	"723332842622714699792542174328088559591648769946177759094943"
	"253602138964984521406532201619814354725014386146031340830053"
	"580064701427617554848554379129838364464367966961887990772034"
	"736157803000124741957444835959798842548782921985130516220492"
	"587642258075423047824449259233414946134282853204689713773286"
	"256040510156737057089566266317468913174173960297084569421408"
	"638340246503706956964095691238512574813981388887525820300348"
	"697874705520281039407290858032400859875699388566714220055813"
	"721666504975567694075744291186029555965678875987190466275865"
	"110679697878878338698829512332686458041982159543089186717937"
	"837296882112869887946881426752946149472342545380882235609343"
	"611456763580462118316276838903401782103651546170016353726533"
	"483704227265988570260024779291772882891237390703536913653116"
	"455187157502455107702608011419765259822467740388537854425585"
	"145214288921115223750634390935174873153868344319584291280195"
	"074092905850311312792942129108984402192540093190593921627134"
	"750198919305865438951637777077143986003394098182666993975063"
	"096606074918898623140499223867493399851695895082484053899663"
	"722794723684809945661015987806137974262131138092723411860100"
	"306875200206043728502462357504778208663060722490091078918820"
	"442211534215724549474597452183278220860160271063926148250470"
	"679370418947419804784028806439921024370220272459710745553427"
	"532140111938226314711574890505019525688608204019208338049020"
	"964857035390565630387666171043092215502462084208032361026639"
	"181985329116058964561494525668476991132094345740269757309411"
	"943012558938929849542837718523991642799184417216508002917772"
	"962518064407748444169509200584402641166511867953786978192437"
	"837706088776938929762590741093402053174273957718315232711979"
	"156763671342690455365413493776695178957184566256453036423483"
	"165581881185157301821017377303725398889368015324740406013125"
	"543229798253477077861721808858399804067059819559784357961089"
	"031531660672538152160882546443838630637659645910759113450754"
	"115340302419919122232825971353047268318787351795564238070363"
	"902981603709604904209483643728107596524396843183938695973698"
	"988902792423000690468305030596571258580435533731137295948710"
	"879428603159480555933441476779321193214240286001902925096646"
	"193362176314904980279169507771637524251644382523514686007855"
	"545314239798347914456001501088907724272618314958749305095096"
	"794148875236619774059147846459165020147777271757983198340596"
	"217174216488928458621791311513622796486107895876628401090163"
	"978125601234102818815583696847648084271585896210534181544416"
	"469676658401850851361026077754091157349631558038332867895835"
	"014815733722261954846797196743495629643387081546134013472180"
	"020575511498339952332310657372073205665921646889120512420352"
	"744996181473392691675760746880600331249241406169543104123845"
	"302352279569083018479984065747801443533578841058833879592182"
	"967410207228549541008872773049474805471527002637111146655769"
	"209259617240195120611744307719186858549611605185379536859573"
	"600388251162049706159892398577468709333418593974416723820367"
	"645305247298082397656229311712037206394594389066632536506196"
	"102292821592907035713508581675681648604311761383787655492962"
	"185626974375288560564944733881717892789614447377636043879790"
	"036621277980274759345056403011475247907173958572327086563275"
	"849543483955621171352309860257344516147519131140051406242709"
	"778011785823084064869584614090224421754468355956581835921213"
	"097223344749158316572863551380259154344114593953935347097045"
	"25536550715392",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffff8p+16380L,
	-0xf.fffffffffffffffffffffffffff8p+16380L),
  TEST ("-11897314953572317650857593266280070734799568698691021415011"
	"868527227124689678980396147313041605370567205087355247942180"
	"593264664074412459444736117251434132484671667965455130801840"
	"045255124679702103169559030841542109952196285616205027456884"
	"129791582874757434377487475290217671004952578762513867890601"
	"004863821202705737468354284228263389609724091357204378869087"
	"856142100844783840781539330336661735285987668515192503633514"
	"260646282583954190884713931116677009187298349850863206766542"
	"413166345601180198822101193374453309558359195271328750947157"
	"200563558465557017475369862519596711820026523875337526865640"
	"430063871893224677369982972098411971385146240080929526652970"
	"745060303967599647731703468563276427779021494450059095045981"
	"790545864962472323513895080140815733986651689347773187757918"
	"371359567958155842762532583393965289784528201914992306937176"
	"362101458792669882718296940837380380771229219128242910244535"
	"249343403940229024393394190690666109060290096076587425830300"
	"299463931565615207870879647471979376307793422374658272571538"
	"054662102602281889246755194097756628326649875856850481383075"
	"571558532564922782485789191644338139092007934624098407285987"
	"639478965012746886149082252676671777013668074386693266234330"
	"582182134430624080996753707870769123293738704114055716816195"
	"667259532395066674201078658427576617166179197330225139480466"
	"435106510788655729970732600565123039467471059792921100034504"
	"074899248361425300656242486789356707460658993178806220006380"
	"733674003694023021583140332212516536874244680515207868241150"
	"608184375397400558311139160554714830348088746177398431439381"
	"723332842622714699792542174328088559591648769946177759094943"
	"253602138964984521406532201619814354725014386146031340830053"
	"580064701427617554848554379129838364464367966961887990772034"
	"736157803000124741957444835959798842548782921985130516220492"
	"587642258075423047824449259233414946134282853204689713773286"
	"256040510156737057089566266317468913174173960297084569421408"
	"638340246503706956964095691238512574813981388887525820300348"
	"697874705520281039407290858032400859875699388566714220055813"
	"721666504975567694075744291186029555965678875987190466275865"
	"110679697878878338698829512332686458041982159543089186717937"
	"837296882112869887946881426752946149472342545380882235609343"
	"611456763580462118316276838903401782103651546170016353726533"
	"483704227265988570260024779291772882891237390703536913653116"
	"455187157502455107702608011419765259822467740388537854425585"
	"145214288921115223750634390935174873153868344319584291280195"
	"074092905850311312792942129108984402192540093190593921627134"
	"750198919305865438951637777077143986003394098182666993975063"
	"096606074918898623140499223867493399851695895082484053899663"
	"722794723684809945661015987806137974262131138092723411860100"
	"306875200206043728502462357504778208663060722490091078918820"
	"442211534215724549474597452183278220860160271063926148250470"
	"679370418947419804784028806439921024370220272459710745553427"
	"532140111938226314711574890505019525688608204019208338049020"
	"964857035390565630387666171043092215502462084208032361026639"
	"181985329116058964561494525668476991132094345740269757309411"
	"943012558938929849542837718523991642799184417216508002917772"
	"962518064407748444169509200584402641166511867953786978192437"
	"837706088776938929762590741093402053174273957718315232711979"
	"156763671342690455365413493776695178957184566256453036423483"
	"165581881185157301821017377303725398889368015324740406013125"
	"543229798253477077861721808858399804067059819559784357961089"
	"031531660672538152160882546443838630637659645910759113450754"
	"115340302419919122232825971353047268318787351795564238070363"
	"902981603709604904209483643728107596524396843183938695973698"
	"988902792423000690468305030596571258580435533731137295948710"
	"879428603159480555933441476779321193214240286001902925096646"
	"193362176314904980279169507771637524251644382523514686007855"
	"545314239798347914456001501088907724272618314958749305095096"
	"794148875236619774059147846459165020147777271757983198340596"
	"217174216488928458621791311513622796486107895876628401090163"
	"978125601234102818815583696847648084271585896210534181544416"
	"469676658401850851361026077754091157349631558038332867895835"
	"014815733722261954846797196743495629643387081546134013472180"
	"020575511498339952332310657372073205665921646889120512420352"
	"744996181473392691675760746880600331249241406169543104123845"
	"302352279569083018479984065747801443533578841058833879592182"
	"967410207228549541008872773049474805471527002637111146655769"
	"209259617240195120611744307719186858549611605185379536859573"
	"600388251162049706159892398577468709333418593974416723820367"
	"645305247298082397656229311712037206394594389066632536506196"
	"102292821592907035713508581675681648604311761383787655492962"
	"185626974375288560564944733881717892789614447377636043879790"
	"036621277980274759345056403011475247907173958572327086563275"
	"849543483955621171352309860257344516147519131140051406242709"
	"778011785823084064869584614090224421754468355956581835921213"
	"097223344749158316572863551380259154344114593953935347097045"
	"25536550715392.001",
	-INFINITY,
	-INFINITY,
	-0xf.fffffp+124f,
	-0xf.fffffp+124f,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020,
	-0xf.ffffffffffff8p+1020,
	-INFINITY,
	-INFINITY,
	-0xf.ffffffffffff8p+1020L,
	-0xf.ffffffffffff8p+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffp+16380L,
	-0xf.fffffffffffffffp+16380L,
	false,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-0xf.fffffffffffffffffffffffffcp+1020L,
	-INFINITY,
	-INFINITY,
	-0xf.fffffffffffffffffffffffffff8p+16380L,
	-0xf.fffffffffffffffffffffffffff8p+16380L),
  TEST ("2.1019476964872256063855943749348741969203929128147736576356"
	"0242583468662402879090222995728254318237304687499e-45",
	0x8p-152f,
	0x8p-152f,
	0x8p-152f,
	0x1p-148f,
	0xb.ffffffffffff8p-152,
	0xcp-152,
	0xb.ffffffffffff8p-152,
	0xcp-152,
	0xb.ffffffffffff8p-152L,
	0xcp-152L,
	0xb.ffffffffffff8p-152L,
	0xcp-152L,
	0xb.fffffffffffffffp-152L,
	0xcp-152L,
	0xb.fffffffffffffffp-152L,
	0xcp-152L,
	0xb.fffffffffffffffp-152L,
	0xcp-152L,
	0xb.fffffffffffffffp-152L,
	0xcp-152L,
	false,
	0xb.fffffffffffffffffffffffffcp-152L,
	0xcp-152L,
	0xb.fffffffffffffffffffffffffcp-152L,
	0xcp-152L,
	0xb.fffffffffffffffffffffffffff8p-152L,
	0xcp-152L,
	0xb.fffffffffffffffffffffffffff8p-152L,
	0xcp-152L),
  TEST ("2.1019476964872256063855943749348741969203929128147736576356"
	"02425834686624028790902229957282543182373046875e-45",
	0x8p-152f,
	0x1p-148f,
	0x8p-152f,
	0x1p-148f,
	0xcp-152,
	0xcp-152,
	0xcp-152,
	0xcp-152,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	true,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L),
  TEST ("2.1019476964872256063855943749348741969203929128147736576356"
	"0242583468662402879090222995728254318237304687501e-45",
	0x8p-152f,
	0x1p-148f,
	0x8p-152f,
	0x1p-148f,
	0xcp-152,
	0xcp-152,
	0xcp-152,
	0xc.0000000000008p-152,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xc.0000000000008p-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xc.000000000000001p-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xc.000000000000001p-152L,
	false,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xc.00000000000000000000000004p-152L,
	0xcp-152L,
	0xcp-152L,
	0xcp-152L,
	0xc.0000000000000000000000000008p-152L),
  TEST ("-2.101947696487225606385594374934874196920392912814773657635"
	"60242583468662402879090222995728254318237304687499e-45",
	-0x1p-148f,
	-0x8p-152f,
	-0x8p-152f,
	-0x8p-152f,
	-0xcp-152,
	-0xcp-152,
	-0xb.ffffffffffff8p-152,
	-0xb.ffffffffffff8p-152,
	-0xcp-152L,
	-0xcp-152L,
	-0xb.ffffffffffff8p-152L,
	-0xb.ffffffffffff8p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xb.fffffffffffffffp-152L,
	-0xb.fffffffffffffffp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xb.fffffffffffffffp-152L,
	-0xb.fffffffffffffffp-152L,
	false,
	-0xcp-152L,
	-0xcp-152L,
	-0xb.fffffffffffffffffffffffffcp-152L,
	-0xb.fffffffffffffffffffffffffcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xb.fffffffffffffffffffffffffff8p-152L,
	-0xb.fffffffffffffffffffffffffff8p-152L),
  TEST ("-2.101947696487225606385594374934874196920392912814773657635"
	"602425834686624028790902229957282543182373046875e-45",
	-0x1p-148f,
	-0x1p-148f,
	-0x8p-152f,
	-0x8p-152f,
	-0xcp-152,
	-0xcp-152,
	-0xcp-152,
	-0xcp-152,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	true,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L),
  TEST ("-2.101947696487225606385594374934874196920392912814773657635"
	"60242583468662402879090222995728254318237304687501e-45",
	-0x1p-148f,
	-0x1p-148f,
	-0x8p-152f,
	-0x8p-152f,
	-0xc.0000000000008p-152,
	-0xcp-152,
	-0xcp-152,
	-0xcp-152,
	-0xc.0000000000008p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xc.000000000000001p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xc.000000000000001p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	false,
	-0xc.00000000000000000000000004p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xc.0000000000000000000000000008p-152L,
	-0xcp-152L,
	-0xcp-152L,
	-0xcp-152L),
  TEST ("3.5032461608120426773093239582247903282006548546912894293926"
	"7070972447770671465150371659547090530395507812499e-45",
	0x1p-148f,
	0x1p-148f,
	0x1p-148f,
	0x1.8p-148f,
	0x1.3ffffffffffffp-148,
	0x1.4p-148,
	0x1.3ffffffffffffp-148,
	0x1.4p-148,
	0x1.3ffffffffffffp-148L,
	0x1.4p-148L,
	0x1.3ffffffffffffp-148L,
	0x1.4p-148L,
	0x1.3ffffffffffffffep-148L,
	0x1.4p-148L,
	0x1.3ffffffffffffffep-148L,
	0x1.4p-148L,
	0x1.3ffffffffffffffep-148L,
	0x1.4p-148L,
	0x1.3ffffffffffffffep-148L,
	0x1.4p-148L,
	false,
	0x1.3fffffffffffffffffffffffff8p-148L,
	0x1.4p-148L,
	0x1.3fffffffffffffffffffffffff8p-148L,
	0x1.4p-148L,
	0x1.3fffffffffffffffffffffffffffp-148L,
	0x1.4p-148L,
	0x1.3fffffffffffffffffffffffffffp-148L,
	0x1.4p-148L),
  TEST ("3.5032461608120426773093239582247903282006548546912894293926"
	"70709724477706714651503716595470905303955078125e-45",
	0x1p-148f,
	0x1p-148f,
	0x1p-148f,
	0x1.8p-148f,
	0x1.4p-148,
	0x1.4p-148,
	0x1.4p-148,
	0x1.4p-148,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	true,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L),
  TEST ("3.5032461608120426773093239582247903282006548546912894293926"
	"7070972447770671465150371659547090530395507812501e-45",
	0x1p-148f,
	0x1.8p-148f,
	0x1p-148f,
	0x1.8p-148f,
	0x1.4p-148,
	0x1.4p-148,
	0x1.4p-148,
	0x1.4000000000001p-148,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4000000000001p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4000000000000002p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4000000000000002p-148L,
	false,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.400000000000000000000000008p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4p-148L,
	0x1.4000000000000000000000000001p-148L),
  TEST ("-3.503246160812042677309323958224790328200654854691289429392"
	"67070972447770671465150371659547090530395507812499e-45",
	-0x1.8p-148f,
	-0x1p-148f,
	-0x1p-148f,
	-0x1p-148f,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.3ffffffffffffp-148,
	-0x1.3ffffffffffffp-148,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.3ffffffffffffp-148L,
	-0x1.3ffffffffffffp-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.3ffffffffffffffep-148L,
	-0x1.3ffffffffffffffep-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.3ffffffffffffffep-148L,
	-0x1.3ffffffffffffffep-148L,
	false,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.3fffffffffffffffffffffffff8p-148L,
	-0x1.3fffffffffffffffffffffffff8p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.3fffffffffffffffffffffffffffp-148L,
	-0x1.3fffffffffffffffffffffffffffp-148L),
  TEST ("-3.503246160812042677309323958224790328200654854691289429392"
	"670709724477706714651503716595470905303955078125e-45",
	-0x1.8p-148f,
	-0x1p-148f,
	-0x1p-148f,
	-0x1p-148f,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	true,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L),
  TEST ("-3.503246160812042677309323958224790328200654854691289429392"
	"67070972447770671465150371659547090530395507812501e-45",
	-0x1.8p-148f,
	-0x1.8p-148f,
	-0x1p-148f,
	-0x1p-148f,
	-0x1.4000000000001p-148,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.4p-148,
	-0x1.4000000000001p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4000000000000002p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4000000000000002p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	false,
	-0x1.400000000000000000000000008p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4000000000000000000000000001p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L,
	-0x1.4p-148L),
  TEST ("7.4109846876186981626485318930233205854758970392148714663837"
	"852375101326090531312779794975454245398856969484704316857659"
	"638998506553390969459816219401617281718945106978546710679176"
	"872575177347315553307795408549809608457500958111373034747658"
	"096871009590975442271004757307809711118935784838675653998783"
	"503015228055934046593739791790738723868299395818481660169122"
	"019456499931289798411362062484498678713572180352209017023903"
	"285791732520220528974020802906854021606612375549983402671300"
	"035812486479041385743401875520901590172592547146296175134159"
	"774938718574737870961645638908718119841271673056017045493004"
	"705269590165763776884908267986972573366521765567941072508764"
	"337560846003984904972149117463085539556354188641513168478436"
	"31308023759629577398300170898437499e-324",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x4p-1076,
	0x4p-1076,
	0x4p-1076,
	0x8p-1076,
	0x4p-1076L,
	0x4p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x5.fffffffffffffff8p-1076L,
	0x6p-1076L,
	0x5.fffffffffffffff8p-1076L,
	0x6p-1076L,
	0x5.fffffffffffffff8p-1076L,
	0x6p-1076L,
	0x5.fffffffffffffff8p-1076L,
	0x6p-1076L,
	false,
	0x4p-1076L,
	0x4p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x5.fffffffffffffffffffffffffffcp-1076L,
	0x6p-1076L,
	0x5.fffffffffffffffffffffffffffcp-1076L,
	0x6p-1076L),
  TEST ("7.4109846876186981626485318930233205854758970392148714663837"
	"852375101326090531312779794975454245398856969484704316857659"
	"638998506553390969459816219401617281718945106978546710679176"
	"872575177347315553307795408549809608457500958111373034747658"
	"096871009590975442271004757307809711118935784838675653998783"
	"503015228055934046593739791790738723868299395818481660169122"
	"019456499931289798411362062484498678713572180352209017023903"
	"285791732520220528974020802906854021606612375549983402671300"
	"035812486479041385743401875520901590172592547146296175134159"
	"774938718574737870961645638908718119841271673056017045493004"
	"705269590165763776884908267986972573366521765567941072508764"
	"337560846003984904972149117463085539556354188641513168478436"
	"313080237596295773983001708984375e-324",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x4p-1076,
	0x8p-1076,
	0x4p-1076,
	0x8p-1076,
	0x4p-1076L,
	0x8p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	true,
	0x4p-1076L,
	0x8p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L),
  TEST ("7.4109846876186981626485318930233205854758970392148714663837"
	"852375101326090531312779794975454245398856969484704316857659"
	"638998506553390969459816219401617281718945106978546710679176"
	"872575177347315553307795408549809608457500958111373034747658"
	"096871009590975442271004757307809711118935784838675653998783"
	"503015228055934046593739791790738723868299395818481660169122"
	"019456499931289798411362062484498678713572180352209017023903"
	"285791732520220528974020802906854021606612375549983402671300"
	"035812486479041385743401875520901590172592547146296175134159"
	"774938718574737870961645638908718119841271673056017045493004"
	"705269590165763776884908267986972573366521765567941072508764"
	"337560846003984904972149117463085539556354188641513168478436"
	"31308023759629577398300170898437501e-324",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x4p-1076,
	0x8p-1076,
	0x4p-1076,
	0x8p-1076,
	0x4p-1076L,
	0x8p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6.0000000000000008p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6.0000000000000008p-1076L,
	false,
	0x4p-1076L,
	0x8p-1076L,
	0x4p-1076L,
	0x8p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6p-1076L,
	0x6.0000000000000000000000000004p-1076L),
  TEST ("-7.410984687618698162648531893023320585475897039214871466383"
	"785237510132609053131277979497545424539885696948470431685765"
	"963899850655339096945981621940161728171894510697854671067917"
	"687257517734731555330779540854980960845750095811137303474765"
	"809687100959097544227100475730780971111893578483867565399878"
	"350301522805593404659373979179073872386829939581848166016912"
	"201945649993128979841136206248449867871357218035220901702390"
	"328579173252022052897402080290685402160661237554998340267130"
	"003581248647904138574340187552090159017259254714629617513415"
	"977493871857473787096164563890871811984127167305601704549300"
	"470526959016576377688490826798697257336652176556794107250876"
	"433756084600398490497214911746308553955635418864151316847843"
	"631308023759629577398300170898437499e-324",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x8p-1076,
	-0x4p-1076,
	-0x4p-1076,
	-0x4p-1076,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x5.fffffffffffffff8p-1076L,
	-0x5.fffffffffffffff8p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x5.fffffffffffffff8p-1076L,
	-0x5.fffffffffffffff8p-1076L,
	false,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x5.fffffffffffffffffffffffffffcp-1076L,
	-0x5.fffffffffffffffffffffffffffcp-1076L),
  TEST ("-7.410984687618698162648531893023320585475897039214871466383"
	"785237510132609053131277979497545424539885696948470431685765"
	"963899850655339096945981621940161728171894510697854671067917"
	"687257517734731555330779540854980960845750095811137303474765"
	"809687100959097544227100475730780971111893578483867565399878"
	"350301522805593404659373979179073872386829939581848166016912"
	"201945649993128979841136206248449867871357218035220901702390"
	"328579173252022052897402080290685402160661237554998340267130"
	"003581248647904138574340187552090159017259254714629617513415"
	"977493871857473787096164563890871811984127167305601704549300"
	"470526959016576377688490826798697257336652176556794107250876"
	"433756084600398490497214911746308553955635418864151316847843"
	"6313080237596295773983001708984375e-324",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x8p-1076,
	-0x8p-1076,
	-0x4p-1076,
	-0x4p-1076,
	-0x8p-1076L,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	true,
	-0x8p-1076L,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L),
  TEST ("-7.410984687618698162648531893023320585475897039214871466383"
	"785237510132609053131277979497545424539885696948470431685765"
	"963899850655339096945981621940161728171894510697854671067917"
	"687257517734731555330779540854980960845750095811137303474765"
	"809687100959097544227100475730780971111893578483867565399878"
	"350301522805593404659373979179073872386829939581848166016912"
	"201945649993128979841136206248449867871357218035220901702390"
	"328579173252022052897402080290685402160661237554998340267130"
	"003581248647904138574340187552090159017259254714629617513415"
	"977493871857473787096164563890871811984127167305601704549300"
	"470526959016576377688490826798697257336652176556794107250876"
	"433756084600398490497214911746308553955635418864151316847843"
	"631308023759629577398300170898437501e-324",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x8p-1076,
	-0x8p-1076,
	-0x4p-1076,
	-0x4p-1076,
	-0x8p-1076L,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6.0000000000000008p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6.0000000000000008p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	false,
	-0x8p-1076L,
	-0x8p-1076L,
	-0x4p-1076L,
	-0x4p-1076L,
	-0x6.0000000000000000000000000004p-1076L,
	-0x6p-1076L,
	-0x6p-1076L,
	-0x6p-1076L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"683343374046671669930219650268554687499e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x8p-16448L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0xcp-16448L,
	0x8p-16448L,
	0xcp-16448L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xb.fffffffffffcp-16448L,
	0xcp-16448L,
	0xb.fffffffffffcp-16448L,
	0xcp-16448L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"6833433740466716699302196502685546875e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0x1p-16444L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"683343374046671669930219650268554687501e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0x1p-16444L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0x1p-16444L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xc.000000000004p-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"2683343374046671669930219650268554687499e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0x8p-16448L,
	-0x8p-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xb.fffffffffffcp-16448L,
	-0xb.fffffffffffcp-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"26833433740466716699302196502685546875e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"2683343374046671669930219650268554687501e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0x1p-16444L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xc.000000000004p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"683343374046671669930219650268554687499e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x8p-16448L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0xcp-16448L,
	0x8p-16448L,
	0xcp-16448L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xb.fffffffffffcp-16448L,
	0xcp-16448L,
	0xb.fffffffffffcp-16448L,
	0xcp-16448L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"6833433740466716699302196502685546875e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0x1p-16444L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L),
  TEST ("5.4677992978237119037926089004291297245985762235403450155814"
	"707305425575329500966052143410629387408077958710210208052966"
	"529504784489330482549602621133847135082257338717668975178538"
	"378957084503396349323438489751160934104796903302909028868611"
	"999312592165232778075745690821530731336739429587895774023213"
	"939331012985331912661021188896306095323395084578542200319963"
	"179359407180003251440084380484161504585462684082946932782829"
	"488183829817567452314437076943950532707791252404699268678810"
	"198502871250235796855577909830559749628817599194837522029036"
	"891995648803056846354520653635957919882905363521007017169741"
	"463296044392266269433408052686419017699718627761948763856040"
	"592690841721239300491445991666051031755802326720329666454066"
	"568630314348735511753639418257984253319063825247065727664852"
	"328745422305642626091617823968872438962470092440688372515677"
	"832232712866924800106797113478024083516199991991274936894113"
	"006233377518471389394984262004503058455485659100090665241525"
	"454803628182902241401701783637353179296850056973639305945938"
	"813428953287892593620291195986011128990061888798763718548789"
	"025717537674780281005583347165047846045925077914824515331335"
	"131286063574407181821236377907693209224423490663289916878620"
	"725507793163931390372011875799729330162278748985052557432333"
	"005334989519381566364065326138465761456173231416844807264090"
	"741841972247545424908843928136253653308813487994328446248389"
	"608261444391573619177442907290731163188581917588219420107047"
	"265367485141413919810885909689112244064797106324295291545892"
	"937991321479061743491490060940946128274533657682130125169586"
	"930571899403551122506297763180795732325134340989331155893724"
	"289358918212707392997768032299997207208451112971425779939507"
	"837165263255764268971211819536322993221774123134726665579460"
	"265871378186589562858761835613344584269098062275786969729830"
	"545786485401407774313414954958161677096004701941411411592755"
	"485864471870515173326244464631295701572087440183178339987662"
	"926763241220698078822661709054601073523477544653542795020468"
	"256078409306409100874886828781860529824879343987945751252081"
	"314345990313550683792348814627862441324030155730592166581251"
	"009922787324590431548734575328663628650380722603024383412564"
	"651446272117561042207738413114131099731016728935023152239431"
	"311619533848376583687509108453086730196255111695352464186678"
	"221927564757730319825223049341618853631333478241227227268084"
	"583396688436229936266854011427192767039363517491659523133852"
	"472534104124441112346615696891097070121463652258681270378076"
	"538381697594264658479637863087159293838880752928175545408262"
	"813403793568695416998388572304528748824756265665683890518422"
	"696169422338806137532304784682662448207928681740476188343739"
	"117833525916386815135793034906806117413105008719197882837614"
	"738262050320291539494104952056471606645482046176634075459021"
	"552555959590354956262127809953013679512507451424271839221946"
	"794056861055980558363033732905772356986051180966474116423192"
	"194741572438649215204229781279620370445373851348786918527399"
	"785630808242657122705381806661616271132182017797793661244078"
	"445747547535623384548769818529655539279036503234072455810991"
	"588075181817695975173110136482659854557506203058080551018873"
	"203138260451109855100526720073566126209666125604482413705611"
	"996796777927332827103568863352291499261312290355143742018042"
	"254470707107847293593205234049774839191754781030496978091006"
	"099559675240966730110167624903610656473267105556155633783594"
	"089546261107653110531808279445757724399186120387548675148632"
	"176049190701680305210224388072261974806791922636412897526952"
	"793677946622674149577084803568051242934076450942927092705684"
	"547042915490323112457971853658760725588190377666477106903106"
	"693847278847646032201293023329503348730723947218797410452333"
	"910847913892827195814551858335519518939031446093385329182820"
	"714173657946661746005901866885589732922652604573972842197231"
	"187365263381958925227970038358064987248233271706462687651143"
	"350472018043321314534759819524203308490914358596886150053406"
	"629512434788155355109100540319857813535695923273426256911552"
	"977539394209918630668466632881929661971212772444625151371953"
	"428875491139683919687008724010475217255347915698820960215217"
	"257390308560235323463096946442080548018754166369706161589705"
	"215873687166365628787796501470056870127729464714362172216802"
	"441045276911597009443281135389729130222603185665646434661947"
	"627628077723219376892727386120519287577405410510114936151502"
	"752997122750262781911372625997223415283516995479265631485799"
	"456782561734766648462849641064097181818204279498552827825384"
	"186202065516999362573388136163077477126602169410435905014077"
	"049808497409025369325795765272066650278004200357878990911374"
	"982857977108488482528354406313893864211497105765030504600982"
	"253488805474531798742143374465080240030582370086699167937651"
	"038307909706139327119325418854546478285735654541635477790346"
	"964782617354265050767878335230272194896680141986745074630225"
	"893106573559558843545841186025169531604151588481389164948914"
	"823593944287133336263680358191369540321930649824471425485137"
	"777984823525402115151171093313613251350685343824859052220126"
	"891551966018355920872775724807128769003243129486808733796350"
	"497668255116485157191011858830643898323628223472099280243583"
	"164434348347014910398004439821970508280440872759395827943270"
	"985008769143562351938091476215083548164137333541883808870019"
	"116234099013452929807950151652297436436006149684939775781234"
	"660954156154478642694176038524277810483833149798681345708089"
	"152179193979463169402340611793486272301808073267534612685593"
	"859596787866884211031341417903391749825320454663508370385251"
	"831778477311017089729361152161928815389818579983544490982891"
	"734081131312309744330960666031291451740885503458543884956367"
	"654943799264600314531815427932691107874782328654759293575803"
	"481929361961781073958502075438499070633193799699311694287183"
	"299423475339817655608058724723221867087563064557636112380829"
	"514501382073257737022472866608244164310385205213523702910787"
	"182472517125030106491031844871593141759729773907719510044049"
	"352857426592936763727969496103940591601975078602859660478614"
	"119405428212830134490731706220583788265344728818766885126977"
	"588151111984290444321648931907188080336064713873288834096229"
	"203276676119810521851726133377700616341304257822975788967472"
	"152742255041912584197045423031298506219011800240120182445838"
	"590696647416285334515631019799007515682004250060857020904012"
	"215375170479800482680554499806010766109655061507421747722461"
	"180617361402575082294678925605271083587897845390768226405648"
	"508518103525778638618195775128516073959272990148239415346263"
	"486966573934577450787243667063244378381883115827207605856174"
	"876350045086885320626669331311880593775916269643646395423220"
	"549940790476989709243027420158390806135690975149384714684219"
	"964938182719962913931464979458639185519531490009437619838306"
	"362365453754807654884704163490469296444427144778593725687358"
	"437087390151990694667516279202024332494828210657618261952038"
	"597230263799412584275851667403910657370879707181053365818502"
	"680037431560091209982641738995652793235851569372314130107647"
	"166085235615697257094269133100914135783178856280392139325001"
	"352841718610484616627448189556913621837791650699820323059708"
	"766420810133584841826718631681683381743511974264126250984214"
	"812397119978273917903889865891718836792263377888052458189238"
	"746074986456016681098722869419588274020181430652732817858728"
	"473849369539367463917171317324882099804999043054467247785592"
	"038464723442276239896066431580123756428540074945472427752568"
	"981171400621705853374875885943072600692576914790467205905272"
	"372594740187988081900317493185005142913607163380720069786786"
	"782095331840893694073778325119471833528492917081008547303414"
	"509381563617864195257751546539575461435803625993888325647883"
	"541039192368366987400263049681218831477776345118518503709588"
	"840859023379762456561030683928115349942393963185677123055324"
	"771693784214924931737043793679546051454845624150270955450608"
	"318747395755728950832754611277041359602301205138509175543313"
	"522772786504141007552691902249572375175731740923618769197304"
	"652898352694386665448260033458575323252814233868098279476166"
	"764258284911434288072243178941698347365985427696983129579496"
	"059032032841281149923518087084876885114369033227736521245740"
	"554711771423492719899982357711910225545480424688322195336240"
	"492253136281857837808491795993788199125205555222116581071134"
	"476787468430539307909617442106685159519071053844987343666452"
	"494280317720153567054364117244775141336558406098548803924509"
	"496052261825198043140272655303625315605326569530252885854991"
	"822289219201218313590745412010446642247111703901991591338062"
	"693320157180618736569439969283245279430312651192668788340033"
	"626825194260296262959884258597703584888770801961209652822982"
	"322376122303586169861685106043820510444293432856251210395693"
	"261264867823980172683352796141772210301725997652373804152525"
	"037162852291403804455997331367378463632437773242905518075065"
	"414724295857460288225400061608664961649196400079359622673770"
	"607898395269075056596627116148289491042491764170924014885106"
	"158235482774778418134123293974436877051995673618683751115353"
	"808771434984204447736174758316063096245047311279841579995578"
	"186609402864244042751443128536278453430633423118662852688374"
	"229600894418958824842459450540826176452145829389286103522774"
	"101195556029650753254244433565937938526828990893149766298997"
	"738359913887178888607190765709867052470880785937935110091424"
	"743449966353497865681753841380246075612094033617488674676296"
	"822570077027076266879557913673839341012099558043806442348798"
	"053951239274913334631522409564461770434875790402230022872647"
	"568436177018658068697071731879399180374560963492726714528729"
	"224208938589940272515747888379118461617702271694075087419634"
	"147298076764775745707026934442908236664400557265527951453482"
	"191684597674273691978253678690951178777239573925410438679099"
	"374700609973920128201422381329108236575369403675960765238333"
	"778127017096574296148321075566959285042221837159799800133563"
	"239963969638610872680393210300180152020613051613414547163713"
	"772512617757277955979895866367571776456268564191092477027650"
	"135832200376440239783726540552694851717269598489288851529660"
	"975027775639565229734596726205832668434979354541943345062977"
	"891187146561050118118108223323735210843681128615413601091222"
	"007912350536959777114306541514511332368936078560929788143798"
	"814391221507522370648646767364209132147312407014953113532379"
	"838195728491128536978285918066991040993153064356179903885952"
	"027952713749653604502053512355449916680887234238773855581636"
	"172479594866871765094513940103284167914110196720261110812716"
	"776424260154507395050380575452850420730818412994731079307343"
	"538376880280124019321040198038723558784544408584344466090982"
	"802067326529000931562048932875469079874956595180595395347093"
	"285140279165467965596318365749701535812384333240968283640721"
	"344003442002691613772056762099098025739332715913970186225176"
	"459563484134139746647940170537900275350480490468851439300771"
	"949915194703080576611022590670399844931867609777417528903454"
	"731922206378932141464755402629420074293816349270038351339419"
	"146768473851353171629153912238797141905920143036064131705230"
	"421762305232861503856799511155936565169005916711845389135580"
	"928162511912438531204156138447775120789548666143600293412065"
	"767167106888509172568003530668539460588248316513392652567856"
	"224602697296203328920073354425994044956624831346979458846837"
	"597950064151867164583749203433942592178528868981311575331848"
	"941597492470436782387502687532649093096498315347403977436001"
	"399982102030846763698994785054617523241463186980898394504211"
	"430763617825306895065661536045431497903759118007934839122881"
	"885863091769469883539876840543521295706315919855784493235603"
	"866268925981702690270202829595794350800918257913991744455922"
	"683343374046671669930219650268554687501e-4951",
	0x0p+0f,
	0x0p+0f,
	0x0p+0f,
	0x8p-152f,
	0x0p+0,
	0x0p+0,
	0x0p+0,
	0x4p-1076,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0x8p-16448L,
	0x1p-16444L,
	0x8p-16448L,
	0x1p-16444L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0x1p-16444L,
	false,
	0x0p+0L,
	0x0p+0L,
	0x0p+0L,
	0x4p-1076L,
	0xcp-16448L,
	0xcp-16448L,
	0xcp-16448L,
	0xc.000000000004p-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"2683343374046671669930219650268554687499e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0x8p-16448L,
	-0x8p-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xb.fffffffffffcp-16448L,
	-0xb.fffffffffffcp-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"26833433740466716699302196502685546875e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L),
  TEST ("-5.467799297823711903792608900429129724598576223540345015581"
	"470730542557532950096605214341062938740807795871021020805296"
	"652950478448933048254960262113384713508225733871766897517853"
	"837895708450339634932343848975116093410479690330290902886861"
	"199931259216523277807574569082153073133673942958789577402321"
	"393933101298533191266102118889630609532339508457854220031996"
	"317935940718000325144008438048416150458546268408294693278282"
	"948818382981756745231443707694395053270779125240469926867881"
	"019850287125023579685557790983055974962881759919483752202903"
	"689199564880305684635452065363595791988290536352100701716974"
	"146329604439226626943340805268641901769971862776194876385604"
	"059269084172123930049144599166605103175580232672032966645406"
	"656863031434873551175363941825798425331906382524706572766485"
	"232874542230564262609161782396887243896247009244068837251567"
	"783223271286692480010679711347802408351619999199127493689411"
	"300623337751847138939498426200450305845548565910009066524152"
	"545480362818290224140170178363735317929685005697363930594593"
	"881342895328789259362029119598601112899006188879876371854878"
	"902571753767478028100558334716504784604592507791482451533133"
	"513128606357440718182123637790769320922442349066328991687862"
	"072550779316393139037201187579972933016227874898505255743233"
	"300533498951938156636406532613846576145617323141684480726409"
	"074184197224754542490884392813625365330881348799432844624838"
	"960826144439157361917744290729073116318858191758821942010704"
	"726536748514141391981088590968911224406479710632429529154589"
	"293799132147906174349149006094094612827453365768213012516958"
	"693057189940355112250629776318079573232513434098933115589372"
	"428935891821270739299776803229999720720845111297142577993950"
	"783716526325576426897121181953632299322177412313472666557946"
	"026587137818658956285876183561334458426909806227578696972983"
	"054578648540140777431341495495816167709600470194141141159275"
	"548586447187051517332624446463129570157208744018317833998766"
	"292676324122069807882266170905460107352347754465354279502046"
	"825607840930640910087488682878186052982487934398794575125208"
	"131434599031355068379234881462786244132403015573059216658125"
	"100992278732459043154873457532866362865038072260302438341256"
	"465144627211756104220773841311413109973101672893502315223943"
	"131161953384837658368750910845308673019625511169535246418667"
	"822192756475773031982522304934161885363133347824122722726808"
	"458339668843622993626685401142719276703936351749165952313385"
	"247253410412444111234661569689109707012146365225868127037807"
	"653838169759426465847963786308715929383888075292817554540826"
	"281340379356869541699838857230452874882475626566568389051842"
	"269616942233880613753230478468266244820792868174047618834373"
	"911783352591638681513579303490680611741310500871919788283761"
	"473826205032029153949410495205647160664548204617663407545902"
	"155255595959035495626212780995301367951250745142427183922194"
	"679405686105598055836303373290577235698605118096647411642319"
	"219474157243864921520422978127962037044537385134878691852739"
	"978563080824265712270538180666161627113218201779779366124407"
	"844574754753562338454876981852965553927903650323407245581099"
	"158807518181769597517311013648265985455750620305808055101887"
	"320313826045110985510052672007356612620966612560448241370561"
	"199679677792733282710356886335229149926131229035514374201804"
	"225447070710784729359320523404977483919175478103049697809100"
	"609955967524096673011016762490361065647326710555615563378359"
	"408954626110765311053180827944575772439918612038754867514863"
	"217604919070168030521022438807226197480679192263641289752695"
	"279367794662267414957708480356805124293407645094292709270568"
	"454704291549032311245797185365876072558819037766647710690310"
	"669384727884764603220129302332950334873072394721879741045233"
	"391084791389282719581455185833551951893903144609338532918282"
	"071417365794666174600590186688558973292265260457397284219723"
	"118736526338195892522797003835806498724823327170646268765114"
	"335047201804332131453475981952420330849091435859688615005340"
	"662951243478815535510910054031985781353569592327342625691155"
	"297753939420991863066846663288192966197121277244462515137195"
	"342887549113968391968700872401047521725534791569882096021521"
	"725739030856023532346309694644208054801875416636970616158970"
	"521587368716636562878779650147005687012772946471436217221680"
	"244104527691159700944328113538972913022260318566564643466194"
	"762762807772321937689272738612051928757740541051011493615150"
	"275299712275026278191137262599722341528351699547926563148579"
	"945678256173476664846284964106409718181820427949855282782538"
	"418620206551699936257338813616307747712660216941043590501407"
	"704980849740902536932579576527206665027800420035787899091137"
	"498285797710848848252835440631389386421149710576503050460098"
	"225348880547453179874214337446508024003058237008669916793765"
	"103830790970613932711932541885454647828573565454163547779034"
	"696478261735426505076787833523027219489668014198674507463022"
	"589310657355955884354584118602516953160415158848138916494891"
	"482359394428713333626368035819136954032193064982447142548513"
	"777798482352540211515117109331361325135068534382485905222012"
	"689155196601835592087277572480712876900324312948680873379635"
	"049766825511648515719101185883064389832362822347209928024358"
	"316443434834701491039800443982197050828044087275939582794327"
	"098500876914356235193809147621508354816413733354188380887001"
	"911623409901345292980795015165229743643600614968493977578123"
	"466095415615447864269417603852427781048383314979868134570808"
	"915217919397946316940234061179348627230180807326753461268559"
	"385959678786688421103134141790339174982532045466350837038525"
	"183177847731101708972936115216192881538981857998354449098289"
	"173408113131230974433096066603129145174088550345854388495636"
	"765494379926460031453181542793269110787478232865475929357580"
	"348192936196178107395850207543849907063319379969931169428718"
	"329942347533981765560805872472322186708756306455763611238082"
	"951450138207325773702247286660824416431038520521352370291078"
	"718247251712503010649103184487159314175972977390771951004404"
	"935285742659293676372796949610394059160197507860285966047861"
	"411940542821283013449073170622058378826534472881876688512697"
	"758815111198429044432164893190718808033606471387328883409622"
	"920327667611981052185172613337770061634130425782297578896747"
	"215274225504191258419704542303129850621901180024012018244583"
	"859069664741628533451563101979900751568200425006085702090401"
	"221537517047980048268055449980601076610965506150742174772246"
	"118061736140257508229467892560527108358789784539076822640564"
	"850851810352577863861819577512851607395927299014823941534626"
	"348696657393457745078724366706324437838188311582720760585617"
	"487635004508688532062666933131188059377591626964364639542322"
	"054994079047698970924302742015839080613569097514938471468421"
	"996493818271996291393146497945863918551953149000943761983830"
	"636236545375480765488470416349046929644442714477859372568735"
	"843708739015199069466751627920202433249482821065761826195203"
	"859723026379941258427585166740391065737087970718105336581850"
	"268003743156009120998264173899565279323585156937231413010764"
	"716608523561569725709426913310091413578317885628039213932500"
	"135284171861048461662744818955691362183779165069982032305970"
	"876642081013358484182671863168168338174351197426412625098421"
	"481239711997827391790388986589171883679226337788805245818923"
	"874607498645601668109872286941958827402018143065273281785872"
	"847384936953936746391717131732488209980499904305446724778559"
	"203846472344227623989606643158012375642854007494547242775256"
	"898117140062170585337487588594307260069257691479046720590527"
	"237259474018798808190031749318500514291360716338072006978678"
	"678209533184089369407377832511947183352849291708100854730341"
	"450938156361786419525775154653957546143580362599388832564788"
	"354103919236836698740026304968121883147777634511851850370958"
	"884085902337976245656103068392811534994239396318567712305532"
	"477169378421492493173704379367954605145484562415027095545060"
	"831874739575572895083275461127704135960230120513850917554331"
	"352277278650414100755269190224957237517573174092361876919730"
	"465289835269438666544826003345857532325281423386809827947616"
	"676425828491143428807224317894169834736598542769698312957949"
	"605903203284128114992351808708487688511436903322773652124574"
	"055471177142349271989998235771191022554548042468832219533624"
	"049225313628185783780849179599378819912520555522211658107113"
	"447678746843053930790961744210668515951907105384498734366645"
	"249428031772015356705436411724477514133655840609854880392450"
	"949605226182519804314027265530362531560532656953025288585499"
	"182228921920121831359074541201044664224711170390199159133806"
	"269332015718061873656943996928324527943031265119266878834003"
	"362682519426029626295988425859770358488877080196120965282298"
	"232237612230358616986168510604382051044429343285625121039569"
	"326126486782398017268335279614177221030172599765237380415252"
	"503716285229140380445599733136737846363243777324290551807506"
	"541472429585746028822540006160866496164919640007935962267377"
	"060789839526907505659662711614828949104249176417092401488510"
	"615823548277477841813412329397443687705199567361868375111535"
	"380877143498420444773617475831606309624504731127984157999557"
	"818660940286424404275144312853627845343063342311866285268837"
	"422960089441895882484245945054082617645214582938928610352277"
	"410119555602965075325424443356593793852682899089314976629899"
	"773835991388717888860719076570986705247088078593793511009142"
	"474344996635349786568175384138024607561209403361748867467629"
	"682257007702707626687955791367383934101209955804380644234879"
	"805395123927491333463152240956446177043487579040223002287264"
	"756843617701865806869707173187939918037456096349272671452872"
	"922420893858994027251574788837911846161770227169407508741963"
	"414729807676477574570702693444290823666440055726552795145348"
	"219168459767427369197825367869095117877723957392541043867909"
	"937470060997392012820142238132910823657536940367596076523833"
	"377812701709657429614832107556695928504222183715979980013356"
	"323996396963861087268039321030018015202061305161341454716371"
	"377251261775727795597989586636757177645626856419109247702765"
	"013583220037644023978372654055269485171726959848928885152966"
	"097502777563956522973459672620583266843497935454194334506297"
	"789118714656105011811810822332373521084368112861541360109122"
	"200791235053695977711430654151451133236893607856092978814379"
	"881439122150752237064864676736420913214731240701495311353237"
	"983819572849112853697828591806699104099315306435617990388595"
	"202795271374965360450205351235544991668088723423877385558163"
	"617247959486687176509451394010328416791411019672026111081271"
	"677642426015450739505038057545285042073081841299473107930734"
	"353837688028012401932104019803872355878454440858434446609098"
	"280206732652900093156204893287546907987495659518059539534709"
	"328514027916546796559631836574970153581238433324096828364072"
	"134400344200269161377205676209909802573933271591397018622517"
	"645956348413413974664794017053790027535048049046885143930077"
	"194991519470308057661102259067039984493186760977741752890345"
	"473192220637893214146475540262942007429381634927003835133941"
	"914676847385135317162915391223879714190592014303606413170523"
	"042176230523286150385679951115593656516900591671184538913558"
	"092816251191243853120415613844777512078954866614360029341206"
	"576716710688850917256800353066853946058824831651339265256785"
	"622460269729620332892007335442599404495662483134697945884683"
	"759795006415186716458374920343394259217852886898131157533184"
	"894159749247043678238750268753264909309649831534740397743600"
	"139998210203084676369899478505461752324146318698089839450421"
	"143076361782530689506566153604543149790375911800793483912288"
	"188586309176946988353987684054352129570631591985578449323560"
	"386626892598170269027020282959579435080091825791399174445592"
	"2683343374046671669930219650268554687501e-4951",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1p-16444L,
	-0x1p-16444L,
	-0x8p-16448L,
	-0x8p-16448L,
	-0x1p-16444L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0xc.000000000004p-16448L,
	-0xcp-16448L,
	-0xcp-16448L,
	-0xcp-16448L),
  TEST ("-0x0.7p-149",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x3.8p-152,
	-0x3.8p-152,
	-0x3.8p-152,
	-0x3.8p-152,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	true,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L,
	-0x3.8p-152L),
  TEST ("-0x0.7p-1074",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L,
	-0x1.cp-1076L),
  TEST ("-0x0.7p-16445",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x8p-16448L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x4p-16448L,
	-0x4p-16448L,
	-0x0p+0L,
	-0x0p+0L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x3.8p-16448L,
	-0x3.8p-16448L,
	-0x3.8p-16448L,
	-0x3.8p-16448L),
  TEST ("-0x0.7p-16494",
	-0x8p-152f,
	-0x0p+0f,
	-0x0p+0f,
	-0x0p+0f,
	-0x4p-1076,
	-0x0p+0,
	-0x0p+0,
	-0x0p+0,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x8p-16448L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x4p-16448L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	false,
	-0x4p-1076L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L,
	-0x4p-16496L,
	-0x0p+0L,
	-0x0p+0L,
	-0x0p+0L),
};

static int
test_in_one_mode (const char *s, const struct test_results *expected,
		  bool ld_ok, const char *mode_name)
{
  int result = 0;
  float f = strtof (s, NULL);
  double d = strtod (s, NULL);
  long double ld = strtold (s, NULL);
  if (f != expected->f
      || copysignf (1.0f, f) != copysignf (1.0f, expected->f))
    {
      printf ("strtof (%s) returned %a not %a (%s)\n", s, f,
	      expected->f, mode_name);
      result = 1;
    }
  if (d != expected->d
      || copysign (1.0, d) != copysign (1.0, expected->d))
    {
      printf ("strtod (%s) returned %a not %a (%s)\n", s, d,
	      expected->d, mode_name);
      result = 1;
    }
  if (ld != expected->ld
      || copysignl (1.0L, ld) != copysignl (1.0L, expected->ld))
    {
      printf ("strtold (%s) returned %La not %La (%s)\n", s, ld,
	      expected->ld, mode_name);
      if (ld_ok)
	result = 1;
      else
	printf ("ignoring this inexact long double result\n");
    }
  return result;
}

static int
do_test (void)
{
  int save_round_mode = fegetround ();
  int result = 0;
  for (size_t i = 0; i < sizeof (tests) / sizeof (tests[0]); i++)
    {
      result |= test_in_one_mode (tests[i].s, &tests[i].rn, tests[i].ld_ok,
				  "default rounding mode");
#ifdef FE_DOWNWARD
      if (!fesetround (FE_DOWNWARD))
	{
	  result |= test_in_one_mode (tests[i].s, &tests[i].rd, tests[i].ld_ok,
				      "FE_DOWNWARD");
	  fesetround (save_round_mode);
	}
#endif
#ifdef FE_TOWARDZERO
      if (!fesetround (FE_TOWARDZERO))
	{
	  result |= test_in_one_mode (tests[i].s, &tests[i].rz, tests[i].ld_ok,
				      "FE_TOWARDZERO");
	  fesetround (save_round_mode);
	}
#endif
#ifdef FE_UPWARD
      if (!fesetround (FE_UPWARD))
	{
	  result |= test_in_one_mode (tests[i].s, &tests[i].ru, tests[i].ld_ok,
				      "FE_UPWARD");
	  fesetround (save_round_mode);
	}
#endif
    }
  return result;
}

#define TEST_FUNCTION do_test ()
#include "../test-skeleton.c"
