/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Character;
import com.sun.electric.util.acl2.ACL2Complex;
import com.sun.electric.util.acl2.ACL2Cons;
import com.sun.electric.util.acl2.ACL2Integer;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Rational;
import com.sun.electric.util.acl2.ACL2String;
import com.sun.electric.util.acl2.ACL2Symbol;
import com.sun.electric.util.acl2.Rational;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ACL2Writer {
    private final ACL2Object top;
    private final Map<ACL2Symbol, Integer> seenSym = new HashMap<ACL2Symbol, Integer>();
    private final Map<ACL2Object, Integer> seenEql = new HashMap<ACL2Object, Integer>();
    private final Map<ACL2String, Integer> seenStr = new IdentityHashMap<ACL2String, Integer>();
    private final Map<ACL2Cons, Integer> seenCons = new IdentityHashMap<ACL2Cons, Integer>();
    private final List<ACL2Integer> naturals = new ArrayList<ACL2Integer>();
    private final List<ACL2Object> rationals = new ArrayList<ACL2Object>();
    private final List<ACL2Complex> complexes = new ArrayList<ACL2Complex>();
    private final List<ACL2Character> chars = new ArrayList<ACL2Character>();
    private final List<ACL2String> strings = new ArrayList<ACL2String>();
    private final Map<String, List<ACL2Symbol>> symbols = new LinkedHashMap<String, List<ACL2Symbol>>();
    private int freeIndex;
    private DataOutputStream out;

    private ACL2Writer(ACL2Object top) {
        this.top = top;
        this.gatherAtoms(top);
        this.makeAtomMap();
    }

    private void encode(DataOutputStream out) throws IOException {
        this.out = out;
        this.encodeMagic();
        this.encodeNat(this.top.equals(ACL2Symbol.NIL) ? 0 : Math.addExact(this.freeIndex, this.seenCons.size()) - 1);
        this.encodeAtoms();
        this.encodeNat(this.seenCons.size());
        this.encodeConses(this.top);
        this.encodeFals();
        this.encodeMagic();
    }

    public static void write(ACL2Object top, File outName) throws IOException {
        ACL2Writer writer = new ACL2Writer(top);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outName)));){
            writer.encode(out);
        }
    }

    private void gatherAtoms(ACL2Object top) {
        while (top instanceof ACL2Cons) {
            ACL2Cons cons = (ACL2Cons)top;
            if (this.seenCons.containsKey(cons)) {
                return;
            }
            this.seenCons.put(cons, null);
            this.gatherAtoms(cons.car);
            top = cons.cdr;
        }
        if (top instanceof ACL2Symbol) {
            ACL2Symbol sym = (ACL2Symbol)top;
            if (!(sym.equals(ACL2Symbol.NIL) || sym.equals(ACL2Symbol.T) || this.seenSym.containsKey(sym))) {
                this.seenSym.put(sym, null);
                List<ACL2Symbol> pkgSymbols = this.symbols.get(sym.pkg.name);
                if (pkgSymbols == null) {
                    pkgSymbols = new ArrayList<ACL2Symbol>();
                    this.symbols.put(sym.pkg.name, pkgSymbols);
                }
                pkgSymbols.add(sym);
            }
        } else if (top instanceof ACL2String) {
            ACL2String str = (ACL2String)top;
            if (!this.seenStr.containsKey(str)) {
                this.seenStr.put(str, null);
                this.strings.add(str);
            }
        } else if (!this.seenEql.containsKey(top)) {
            this.seenEql.put(top, null);
            if (top instanceof ACL2Character) {
                this.chars.add((ACL2Character)top);
            } else if (top instanceof ACL2Integer) {
                ACL2Integer integer = (ACL2Integer)top;
                if (integer.v.signum() >= 0) {
                    this.naturals.add(integer);
                } else {
                    this.rationals.add(integer);
                }
            } else if (top instanceof ACL2Rational) {
                this.rationals.add((ACL2Rational)top);
            } else if (top instanceof ACL2Complex) {
                this.complexes.add((ACL2Complex)top);
            } else {
                throw new AssertionError();
            }
        }
    }

    private void makeAtomMap() {
        this.freeIndex = 2;
        for (ACL2Integer aCL2Integer : this.naturals) {
            this.seenEql.put(aCL2Integer, this.freeIndex++);
        }
        for (ACL2Object aCL2Object : this.rationals) {
            this.seenEql.put(aCL2Object, this.freeIndex++);
        }
        for (ACL2Complex aCL2Complex : this.complexes) {
            this.seenEql.put(aCL2Complex, this.freeIndex++);
        }
        for (ACL2Character aCL2Character : this.chars) {
            this.seenEql.put(aCL2Character, this.freeIndex++);
        }
        for (ACL2String aCL2String : this.strings) {
            this.seenStr.put(aCL2String, this.freeIndex++);
        }
        for (List list : this.symbols.values()) {
            for (ACL2Symbol sym : list) {
                this.seenSym.put(sym, this.freeIndex++);
            }
        }
        this.seenSym.put(ACL2Symbol.NIL, 0);
        this.seenSym.put(ACL2Symbol.T, 1);
    }

    private void encodeMagic() throws IOException {
        this.out.writeInt(-1408103479);
    }

    private void encodeNat(BigInteger n) throws IOException {
        if (n.signum() < 0) {
            throw new IllegalArgumentException();
        }
        while (n.bitLength() > 7) {
            this.out.writeByte(n.byteValue() | 0x80);
            n = n.shiftRight(7);
        }
        this.out.writeByte(n.byteValueExact());
    }

    private void encodeNat(int n) throws IOException {
        this.encodeNat(BigInteger.valueOf(n));
    }

    private void encodeRat(BigInteger numerator, BigInteger denominator) throws IOException {
        this.encodeNat(numerator.signum() < 0 ? 1 : 0);
        this.encodeNat(numerator.abs());
        this.encodeNat(denominator);
    }

    private void encodeRat(Rational x) throws IOException {
        this.encodeRat(x.n, x.d);
    }

    private void encodeNats() throws IOException {
        this.encodeNat(this.naturals.size());
        for (ACL2Integer x : this.naturals) {
            this.encodeNat(x.v);
        }
    }

    private void encodeRats() throws IOException {
        this.encodeNat(this.rationals.size());
        for (ACL2Object x : this.rationals) {
            BigInteger numerator = ACL2.numerator(x).bigIntegerValueExact();
            BigInteger denominator = ACL2.denominator(x).bigIntegerValueExact();
            this.encodeRat(numerator, denominator);
        }
    }

    private void encodeComplexes() throws IOException {
        this.encodeNat(this.complexes.size());
        for (ACL2Complex x : this.complexes) {
            this.encodeRat(x.v.re);
            this.encodeRat(x.v.im);
        }
    }

    private void encodeChars() throws IOException {
        this.encodeNat(this.chars.size());
        for (ACL2Character x : this.chars) {
            this.out.writeByte(x.c);
        }
    }

    private void encodeStr(boolean normed, String s) throws IOException {
        int len = s.length();
        int header = len << 1 | (normed ? 1 : 0);
        this.encodeNat(header);
        for (int i = 0; i < len; ++i) {
            this.out.writeByte(s.charAt(i));
        }
    }

    private void encodeStr(ACL2String x) throws IOException {
        this.encodeStr(x.isNormed(), x.s);
    }

    private void encodeStrs() throws IOException {
        this.encodeNat(this.strings.size());
        for (ACL2String x : this.strings) {
            this.encodeStr(x);
        }
    }

    private void encodePackages() throws IOException {
        this.encodeNat(this.symbols.size());
        for (Map.Entry<String, List<ACL2Symbol>> e : this.symbols.entrySet()) {
            this.encodeStr(true, e.getKey());
            List<ACL2Symbol> syms = e.getValue();
            this.encodeNat(syms.size());
            for (ACL2Symbol sym : syms) {
                this.encodeStr(true, sym.nm);
            }
        }
    }

    private void encodeAtoms() throws IOException {
        this.encodeNats();
        this.encodeRats();
        this.encodeComplexes();
        this.encodeChars();
        this.encodeStrs();
        this.encodePackages();
    }

    private int encodeConses(ACL2Object x) throws IOException {
        ACL2Cons cons;
        ArrayList<ACL2Cons> consStack = new ArrayList<ACL2Cons>();
        Integer idx = null;
        while (x instanceof ACL2Cons && (idx = this.seenCons.get(cons = (ACL2Cons)x)) == null) {
            consStack.add(cons);
            x = cons.cdr;
        }
        int endIdx = x instanceof ACL2Cons ? idx : (x instanceof ACL2Symbol ? this.seenSym.get((ACL2Symbol)x) : (x instanceof ACL2String ? this.seenStr.get((ACL2String)x).intValue() : this.seenEql.get(x).intValue()));
        while (!consStack.isEmpty()) {
            ACL2Cons cons2 = (ACL2Cons)consStack.remove(consStack.size() - 1);
            int carIndex = this.encodeConses(cons2.car);
            int cdrIndex = endIdx;
            boolean normed = cons2.isNormed();
            int v2CarIndex = carIndex << 1 | (normed ? 1 : 0);
            ++this.freeIndex;
            this.seenCons.put(cons2, endIdx);
            this.encodeNat(v2CarIndex);
            this.encodeNat(cdrIndex);
        }
        return endIdx;
    }

    private void encodeFals() throws IOException {
        this.encodeNat(0);
    }
}

