/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.ExportBar;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplanFlex;
import com.sun.electric.tool.generator.layout.fill.MetalLayer;
import java.util.ArrayList;

class MetalLayerFlex
extends MetalLayer {
    public MetalLayerFlex(TechType t, EditingPreferences ep, int layerNum, Floorplan plan, Cell cell) {
        super(t, ep, layerNum, plan, cell);
    }

    @Override
    public boolean addExtraArc() {
        return false;
    }

    @Override
    protected void buildGndAndVdd(Cell cell) {
        double limit = 0.0;
        MetalFloorplanFlex plan = (MetalFloorplanFlex)this.plan;
        limit = plan.horizontal ? plan.cellHeight / 2.0 : plan.cellWidth / 2.0;
        double position = 0.0;
        int i = 0;
        while (position < limit) {
            double pinX;
            double pinY;
            boolean even = i % 2 == 0;
            double maxDelta = 0.0;
            double pos = 0.0;
            if (even) {
                maxDelta = plan.vddReserve / 2.0 + plan.vddWidth;
                pos = plan.vddReserve / 2.0 + plan.vddWidth / 2.0 + position;
            } else {
                maxDelta = plan.gndReserve / 2.0 + plan.gndWidth;
                pos = plan.gndReserve / 2.0 + plan.gndWidth / 2.0 + position;
            }
            if (position + maxDelta > limit) {
                return;
            }
            if (plan.horizontal) {
                pinY = pos;
                pinX = plan.cellWidth / 2.0;
            } else {
                pinX = pos;
                pinY = plan.cellHeight / 2.0;
            }
            if (!even) {
                this.addBars(cell, pinX, pinY, plan.gndWidth, this.gndBars);
            } else {
                this.addBars(cell, pinX, pinY, plan.vddWidth, this.vddBars);
            }
            if (even) {
                maxDelta = plan.vddReserve / 2.0 + plan.vddWidth + plan.space + plan.gndWidth;
                pos = plan.vddReserve / 2.0 + plan.vddWidth + plan.space + plan.gndWidth / 2.0 + position;
            } else {
                maxDelta = plan.gndReserve / 2.0 + plan.gndWidth + plan.space + plan.vddWidth;
                pos = plan.gndReserve / 2.0 + plan.gndWidth + plan.space + plan.vddWidth / 2.0 + position;
            }
            if (position + maxDelta > limit) {
                return;
            }
            if (plan.horizontal) {
                pinY = pos;
            } else {
                pinX = pos;
            }
            if (!even) {
                this.addBars(cell, pinX, pinY, plan.vddWidth, this.vddBars);
                position = (plan.horizontal ? pinY : pinX) + plan.vddWidth / 2.0 + plan.vddReserve / 2.0;
            } else {
                this.addBars(cell, pinX, pinY, plan.gndWidth, this.gndBars);
                position = (plan.horizontal ? pinY : pinX) + plan.gndWidth / 2.0 + plan.gndReserve / 2.0;
            }
            ++i;
        }
    }

    private void addBars(Cell cell, double pinX, double pinY, double width, ArrayList<ExportBar> bars) {
        PortInst tl = LayoutLib.newNodeInst(this.pin, this.ep, -pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst tr = LayoutLib.newNodeInst(this.pin, this.ep, pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst bl = LayoutLib.newNodeInst(this.pin, this.ep, -pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst br = LayoutLib.newNodeInst(this.pin, this.ep, pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        double center = 0.0;
        if (this.plan.horizontal) {
            G.noExtendArc(this.metal, this.ep, width, tl, tr);
            G.noExtendArc(this.metal, this.ep, width, bl, br);
            center = pinY;
            bars.add(new ExportBar(bl, br, -center));
            bars.add(new ExportBar(tl, tr, center));
        } else {
            G.noExtendArc(this.metal, this.ep, width, bl, tl);
            G.noExtendArc(this.metal, this.ep, width, br, tr);
            center = pinX;
            bars.add(new ExportBar(bl, tl, -center));
            bars.add(new ExportBar(br, tr, center));
        }
    }
}

